/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.completion;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.DataLoadersBridge;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.html.editor.HtmlPreferences;
import org.netbeans.modules.html.editor.api.completion.HtmlCompletionItem;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.netbeans.spi.palette.PaletteController;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.windows.TopComponent;

public class HtmlPaletteCompletionProvider
implements CompletionProvider {
    public CompletionTask createTask(int queryType, JTextComponent component) {
        if (HtmlPreferences.isPaletteCompletionEnabled() && (queryType & 1 & 9) != 0) {
            return new AsyncCompletionTask((AsyncCompletionQuery)new CCQuery(), component);
        }
        return null;
    }

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        return 0;
    }

    private static boolean startsWithIgnoreCase(String text, String prefix) {
        return text.toLowerCase(Locale.ENGLISH).startsWith(prefix.toLowerCase(Locale.ENGLISH));
    }

    static final class CCQuery
    extends AsyncCompletionQuery {
        private int completionExpressionStartOffset = -1;
        private JTextComponent component;
        private Collection<PaletteCompletionItem> items;

        CCQuery() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void query(final CompletionResultSet resultSet, final Document doc, final int offset) {
            try {
                doc.render(new Runnable(){

                    @Override
                    public void run() {
                        int i;
                        TokenId id;
                        ArrayList<PaletteCompletionItem> newItems = new ArrayList<PaletteCompletionItem>();
                        TokenSequence htmlTs = this.getTokenSequence(doc, offset);
                        if (htmlTs == null) {
                            return;
                        }
                        int diff = htmlTs.move(offset);
                        if (!htmlTs.moveNext()) {
                            return;
                        }
                        Token current = htmlTs.token();
                        if (current.id() != HTMLTokenId.TEXT) {
                            return;
                        }
                        if (diff == 0 && htmlTs.movePrevious() && ((id = htmlTs.token().id()) == HTMLTokenId.TAG_CLOSE_SYMBOL || id == HTMLTokenId.TAG_OPEN_SYMBOL || id == HTMLTokenId.CHARACTER)) {
                            return;
                        }
                        String prefix = current.text().subSequence(0, diff).toString();
                        for (i = prefix.length() - 1; i >= 0; --i) {
                            char ch = prefix.charAt(i);
                            if (!Character.isWhitespace(ch)) continue;
                            ++i;
                            break;
                        }
                        if (i > 0) {
                            prefix = prefix.substring(i);
                        }
                        completionExpressionStartOffset = offset - prefix.length();
                        TopComponent tc = NbEditorUtilities.getTopComponent((JTextComponent)component);
                        if (tc == null) {
                            return;
                        }
                        PaletteController pc = (PaletteController)tc.getLookup().lookup(PaletteController.class);
                        if (pc == null) {
                            FileObject file = DataLoadersBridge.getDefault().getFileObject(doc);
                            String mimeType = file.getMIMEType();
                            pc = (PaletteController)MimeLookup.getLookup((String)mimeType).lookup(PaletteController.class);
                        }
                        if (pc != null) {
                            Node rootNode = (Node)pc.getRoot().lookup(Node.class);
                            Children children = rootNode.getChildren();
                            for (Node categoryNode : children.getNodes()) {
                                for (Node itemNode : categoryNode.getChildren().getNodes()) {
                                    Action insertAction = itemNode.getPreferredAction();
                                    String itemName = itemNode.getDisplayName();
                                    if (!HtmlPaletteCompletionProvider.startsWithIgnoreCase(itemName, prefix)) continue;
                                    newItems.add(new PaletteCompletionItem(insertAction, completionExpressionStartOffset, categoryNode.getDisplayName(), itemName, itemNode.getIcon(1)));
                                }
                            }
                        }
                        resultSet.addAllItems(newItems);
                        items = newItems;
                    }
                });
            }
            finally {
                resultSet.finish();
            }
        }

        protected boolean canFilter(final JTextComponent component) {
            final Collection<PaletteCompletionItem> currentItems = this.items;
            if (currentItems == null) {
                return false;
            }
            final Document doc = component.getDocument();
            final AtomicBoolean retval = new AtomicBoolean();
            doc.render(new Runnable(){

                @Override
                public void run() {
                    try {
                        int offset = component.getCaretPosition();
                        if (completionExpressionStartOffset < 0 || offset < completionExpressionStartOffset) {
                            retval.set(false);
                            return;
                        }
                        String prefix = doc.getText(completionExpressionStartOffset, offset - completionExpressionStartOffset);
                        for (PaletteCompletionItem item : currentItems) {
                            if (!HtmlPaletteCompletionProvider.startsWithIgnoreCase(item.getItemName(), prefix)) continue;
                            retval.set(true);
                            return;
                        }
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
            return retval.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void filter(final CompletionResultSet resultSet) {
            try {
                final Collection<PaletteCompletionItem> currentItems = this.items;
                if (currentItems == null) {
                    return;
                }
                final Document doc = this.component.getDocument();
                doc.render(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            int offset = component.getCaretPosition();
                            String prefix = doc.getText(completionExpressionStartOffset, offset - completionExpressionStartOffset);
                            for (PaletteCompletionItem item : currentItems) {
                                if (!HtmlPaletteCompletionProvider.startsWithIgnoreCase(item.getItemName(), prefix)) continue;
                                resultSet.addItem((CompletionItem)item);
                            }
                        }
                        catch (BadLocationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
            }
            finally {
                resultSet.finish();
            }
        }

        protected void prepareQuery(JTextComponent component) {
            this.component = component;
        }

        private TokenSequence getTokenSequence(Document doc, int offset) {
            TokenHierarchy th = TokenHierarchy.get((Document)doc);
            List sequences = th.embeddedTokenSequences(offset, true);
            TokenSequence htmlTs = null;
            for (TokenSequence ts : sequences) {
                if (!ts.language().mimeType().equals("text/html")) continue;
                htmlTs = ts;
                break;
            }
            return htmlTs;
        }
    }

    private static class PaletteCompletionItem
    implements CompletionItem {
        protected Action action;
        protected String category;
        protected String item;
        protected ImageIcon icon;
        protected int completionExpressionStartOffset;

        public PaletteCompletionItem(Action action, int completionExpressionStartOffset, String category, String item, Image icon) {
            this.action = action;
            this.category = category;
            this.item = item;
            this.icon = ImageUtilities.icon2ImageIcon((Icon)ImageUtilities.image2Icon((Image)icon));
            this.completionExpressionStartOffset = completionExpressionStartOffset;
        }

        public String getItemName() {
            return this.item;
        }

        public String getLeftHtmlText() {
            return this.getItemName();
        }

        public String getRightHtmlText() {
            return "<font color='" + HtmlCompletionItem.hexColorCode(Color.GRAY) + "'>" + this.category + "</font>";
        }

        public ImageIcon getIcon() {
            return this.icon;
        }

        public void defaultAction(JTextComponent component) {
            try {
                Document doc = component.getDocument();
                int currentCaretPosition = component.getCaretPosition();
                doc.remove(this.completionExpressionStartOffset, currentCaretPosition - this.completionExpressionStartOffset);
                Completion.get().hideAll();
                this.action.actionPerformed(null);
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public int getPreferredWidth(Graphics g, Font defaultFont) {
            return CompletionUtilities.getPreferredWidth((String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)g, (Font)defaultFont);
        }

        public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
            CompletionUtilities.renderHtml((ImageIcon)this.getIcon(), (String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)g, (Font)defaultFont, (Color)defaultColor, (int)width, (int)height, (boolean)selected);
        }

        public void processKeyEvent(KeyEvent evt) {
        }

        public CompletionTask createDocumentationTask() {
            return null;
        }

        public CompletionTask createToolTipTask() {
            return null;
        }

        public boolean instantSubstitution(JTextComponent component) {
            return false;
        }

        public int getSortPriority() {
            return 1;
        }

        public CharSequence getSortText() {
            return this.category + this.item;
        }

        public CharSequence getInsertPrefix() {
            return this.getSortText();
        }
    }
}

