/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.wizard;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.ui.wizard.common.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.common.CreatedModifiedFiles;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;

final class DataModel
extends BasicWizardIterator.BasicDataModel {
    private CreatedModifiedFiles cmf;
    private boolean branching;
    private TemplateType fileTemplateType = this.isHTMLUIPossible() ? TemplateType.HTML4J : TemplateType.FILE;
    private int nOfSteps;
    private String prefix;
    private String displayName;
    private String category;
    private File origIconPath;

    DataModel(WizardDescriptor wiz) {
        super(wiz);
    }

    final boolean isHTMLUIPossible() {
        try {
            SpecificationVersion templates = this.getModuleInfo().getDependencyVersion("org.netbeans.api.templates");
            return templates != null;
        }
        catch (IOException ex) {
            return false;
        }
    }

    CreatedModifiedFiles getCreatedModifiedFiles() {
        if (this.cmf == null) {
            switch (this.getFileTemplateType()) {
                case CUSTOM: 
                case FILE: {
                    this.regenerate();
                    break;
                }
                case HTML: 
                case HTML4J: {
                    this.regenerateHTML();
                }
            }
        }
        return this.cmf;
    }

    private void regenerate() {
        FileObject template;
        this.cmf = new CreatedModifiedFiles(this.getProject());
        HashMap<String, String> basicTokens = new HashMap<String, String>();
        basicTokens.put("PACKAGE_NAME", this.getPackageName());
        basicTokens.put("WIZARD_PREFIX", this.prefix);
        ArrayList<String> panelClassNames = new ArrayList<String>();
        for (int stepNumber = 1; stepNumber < this.nOfSteps + 1; ++stepNumber) {
            String visualPanelClass = this.prefix + "VisualPanel" + stepNumber;
            String wizardPanelClass = this.prefix + "WizardPanel" + stepNumber;
            HashMap<String, String> replaceTokens = new HashMap<String, String>(basicTokens);
            replaceTokens.put("VISUAL_PANEL_CLASS", visualPanelClass);
            replaceTokens.put("WIZARD_PANEL_CLASS", wizardPanelClass);
            replaceTokens.put("STEP_NAME", "Step #" + stepNumber);
            String path = this.getDefaultPackagePath(visualPanelClass + ".java", false);
            FileObject template2 = CreatedModifiedFiles.getTemplate("visualPanel.java");
            this.cmf.add(this.cmf.createFileWithSubstitutions(path, template2, replaceTokens));
            path = this.getDefaultPackagePath(visualPanelClass + ".form", false);
            template2 = CreatedModifiedFiles.getTemplate("visualPanel.form");
            this.cmf.add(this.cmf.createFile(path, template2));
            path = this.getDefaultPackagePath(wizardPanelClass + ".java", false);
            template2 = CreatedModifiedFiles.getTemplate("wizardPanel.java");
            this.cmf.add(this.cmf.createFileWithSubstitutions(path, template2, replaceTokens));
            panelClassNames.add(wizardPanelClass);
        }
        this.cmf.add(this.cmf.addModuleDependency("org.netbeans.api.templates"));
        this.cmf.add(this.cmf.addModuleDependency("org.openide.util"));
        this.cmf.add(this.cmf.addModuleDependency("org.openide.util.ui"));
        this.cmf.add(this.cmf.addModuleDependency("org.openide.dialogs"));
        this.cmf.add(this.cmf.addModuleDependency("org.openide.awt"));
        HashMap<String, Object> replaceTokens = new HashMap<String, Object>(basicTokens);
        replaceTokens.put("panelClassNames", panelClassNames);
        if (this.fileTemplateType == TemplateType.FILE || this.branching) {
            String iteratorClass = this.prefix + "WizardIterator";
            replaceTokens.put("ITERATOR_CLASS", iteratorClass);
            if (this.fileTemplateType == TemplateType.FILE) {
                FileObject origIcon;
                String lowerCasedPrefix = this.prefix.substring(0, 1).toLowerCase(Locale.ENGLISH) + this.prefix.substring(1);
                this.cmf.add(this.cmf.createFileWithSubstitutions(this.getDefaultPackagePath(lowerCasedPrefix, true) + ".html", CreatedModifiedFiles.getTemplate("wizardDescription.html"), Collections.emptyMap()));
                boolean useTR = false;
                NbModuleProvider nbmp = this.getModuleInfo();
                if (nbmp != null) {
                    try {
                        SpecificationVersion v = nbmp.getDependencyVersion("org.openide.loaders");
                        if (v != null && v.compareTo(new SpecificationVersion("7.29")) >= 0) {
                            useTR = true;
                        }
                    }
                    catch (IOException x) {
                        Exceptions.printStackTrace((Throwable)x);
                    }
                }
                String instanceFullPath = this.category + '/' + lowerCasedPrefix;
                if (useTR) {
                    this.cmf.add(this.cmf.addModuleDependency("org.openide.loaders"));
                    replaceTokens.put("TR_folder", this.category.replaceFirst("^Templates/", ""));
                    replaceTokens.put("TR_displayName", this.displayName);
                    replaceTokens.put("TR_description", lowerCasedPrefix + ".html");
                } else {
                    this.cmf.add(this.cmf.createLayerEntry(instanceFullPath, null, null, this.displayName, null));
                    this.cmf.add(this.cmf.createLayerAttribute(instanceFullPath, "template", Boolean.TRUE));
                    String fqIteratorClass = this.getPackageName() + '.' + iteratorClass;
                    this.cmf.add(this.cmf.createLayerAttribute(instanceFullPath, "instantiatingIterator", "newvalue:" + fqIteratorClass));
                    try {
                        URL url = new URL("nbresloc:/" + this.getPackageName().replace('.', '/') + '/' + lowerCasedPrefix + ".html");
                        this.cmf.add(this.cmf.createLayerAttribute(instanceFullPath, "templateWizardURL", url));
                    }
                    catch (MalformedURLException ex) {
                        Util.err.notify((Throwable)ex);
                    }
                }
                FileObject fileObject = origIcon = this.origIconPath != null ? FileUtil.toFileObject((File)this.origIconPath) : null;
                if (origIcon != null) {
                    String relToSrcDir = this.addCreateIconOperation(this.cmf, origIcon);
                    if (useTR) {
                        replaceTokens.put("TR_iconBase", relToSrcDir);
                    } else {
                        this.cmf.add(this.cmf.createLayerAttribute(instanceFullPath, "iconBase", relToSrcDir));
                    }
                }
            }
            template = CreatedModifiedFiles.getTemplate(this.fileTemplateType == TemplateType.FILE ? "instantiatingIterator.java" : "wizardIterator.java");
            String path = this.getDefaultPackagePath(iteratorClass + ".java", false);
            this.cmf.add(this.cmf.createFileWithSubstitutions(path, template, replaceTokens));
        } else {
            String path = this.getDefaultPackagePath(this.prefix + "WizardAction.java", false);
            template = CreatedModifiedFiles.getTemplate("sampleAction.java");
            this.cmf.add(this.cmf.createFileWithSubstitutions(path, template, replaceTokens));
        }
    }

    private void regenerateHTML() {
        FileObject origIcon;
        boolean isJava = this.fileTemplateType == TemplateType.HTML4J;
        this.cmf = new CreatedModifiedFiles(this.getProject());
        HashMap<String, Object> basicTokens = new HashMap<String, Object>();
        basicTokens.put("PACKAGE_NAME", this.getPackageName());
        basicTokens.put("WIZARD_PREFIX", this.prefix);
        this.cmf.add(this.cmf.addModuleDependency("org.netbeans.api.templates"));
        this.cmf.add(this.cmf.addModuleDependency("org.openide.util"));
        if (isJava) {
            this.cmf.add(this.cmf.addModuleDependency("net.java.html"));
            this.cmf.add(this.cmf.addModuleDependency("net.java.html.json"));
        }
        this.cmf.add(this.cmf.addManifestToken("OpenIDE-Module-Needs", "org.netbeans.api.templates.wizard"));
        this.cmf.add(this.cmf.addManifestToken("OpenIDE-Module-Needs", "javax.script.ScriptEngine.freemarker"));
        basicTokens.put("HTML4J", isJava);
        String lowerCasedPrefix = this.prefix.substring(0, 1).toLowerCase(Locale.ENGLISH) + this.prefix.substring(1);
        this.cmf.add(this.cmf.createFileWithSubstitutions(this.getDefaultPackagePath(lowerCasedPrefix, true) + "Descr.html", CreatedModifiedFiles.getTemplate("wizardDescription.html"), Collections.emptyMap()));
        this.cmf.add(this.cmf.createFileWithSubstitutions(this.getDefaultPackagePath(lowerCasedPrefix, true) + ".html", CreatedModifiedFiles.getTemplate("wizardHTML.html"), basicTokens));
        this.cmf.add(this.cmf.createFileWithSubstitutions(this.getDefaultPackagePath(lowerCasedPrefix, true) + ".fmk", CreatedModifiedFiles.getTemplate("wizardHTML.fmk"), basicTokens));
        String instanceFullPath = this.category + '/' + lowerCasedPrefix;
        basicTokens.put("TR_folder", this.category.replaceFirst("^Templates/", ""));
        basicTokens.put("TR_displayName", this.displayName);
        basicTokens.put("TR_description", lowerCasedPrefix + "Descr.html");
        basicTokens.put("TR_page", lowerCasedPrefix + ".html");
        basicTokens.put("TR_content", lowerCasedPrefix + ".fmk");
        FileObject fileObject = origIcon = this.origIconPath != null ? FileUtil.toFileObject((File)this.origIconPath) : null;
        if (origIcon != null) {
            String relToSrcDir = this.addCreateIconOperation(this.cmf, origIcon);
            basicTokens.put("TR_iconBase", relToSrcDir);
        }
        FileObject template = CreatedModifiedFiles.getTemplate("wizardHTML.java");
        String path = this.getDefaultPackagePath(this.prefix + ".java", false);
        this.cmf.add(this.cmf.createFileWithSubstitutions(path, template, basicTokens));
    }

    private void reset() {
        this.cmf = null;
    }

    void setBranching(boolean branching) {
        this.branching = branching;
    }

    boolean isBranching() {
        return this.branching;
    }

    void setFileTemplateType(TemplateType fileTemplateType) {
        this.fileTemplateType = fileTemplateType;
    }

    TemplateType getFileTemplateType() {
        return this.fileTemplateType;
    }

    void setNumberOfSteps(int nOfSteps) {
        this.nOfSteps = nOfSteps;
    }

    void setClassNamePrefix(String prefix) {
        this.reset();
        this.prefix = prefix;
    }

    void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    void setCategory(String category) {
        this.category = category;
    }

    void setIcon(File origIconPath) {
        this.reset();
        this.origIconPath = origIconPath;
    }

    @Override
    public void setPackageName(String packageName) {
        super.setPackageName(packageName);
        this.reset();
    }

    static enum TemplateType {
        HTML4J,
        HTML,
        CUSTOM,
        FILE;

    }
}

