/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.common.api.ValidationException;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.j2ee.Bundle;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class J2eeActions {
    public static ContextAwareAction verifyAction() {
        return new VerifyAction();
    }

    private static class VerifyAction
    extends AbstractAction
    implements ContextAwareAction {
        private Project project;
        private J2eeModuleProvider jmp;
        private NbMavenProject mp;

        public VerifyAction() {
            this.setEnabled(false);
            this.putValue("hideWhenDisabled", true);
        }

        private VerifyAction(Project project, NbMavenProject mp, J2eeModuleProvider jmp) {
            this.project = project;
            this.jmp = jmp;
            this.mp = mp;
            this.putValue("Name", Bundle.VerifyAction_Name());
        }

        public final Action createContextAwareInstance(Lookup actionContext) {
            Collection projects = actionContext.lookupAll(Project.class);
            if (projects.size() != 1) {
                return this;
            }
            Project prj = (Project)((Project)projects.iterator().next()).getLookup().lookup(Project.class);
            if (prj == null) {
                return this;
            }
            J2eeModuleProvider prov = (J2eeModuleProvider)prj.getLookup().lookup(J2eeModuleProvider.class);
            if (prov == null) {
                return this;
            }
            NbMavenProject mProj = (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class);
            if (mProj == null) {
                return this;
            }
            if (!prov.hasVerifierSupport()) {
                return this;
            }
            return new VerifyAction(prj, mProj, prov);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RunConfig cfg = RunUtils.createRunConfig((File)FileUtil.toFile((FileObject)this.project.getProjectDirectory()), (Project)this.project, (String)"build", Collections.singletonList("install"));
            RunUtils.executeMaven((RunConfig)cfg).addTaskListener(new TaskListener(){

                public void taskFinished(Task task) {
                    FileObject fo;
                    try {
                        fo = jmp.getJ2eeModule().getArchive();
                    }
                    catch (IOException ex) {
                        return;
                    }
                    if (fo == null) {
                        return;
                    }
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                jmp.verify(fo, null);
                            }
                            catch (ValidationException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    });
                }
            });
        }
    }
}

