/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Subnet
extends ExplicitlySetBmcModel {
    @JsonProperty(value="availabilityDomain")
    private final String availabilityDomain;
    @JsonProperty(value="cidrBlock")
    private final String cidrBlock;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="dhcpOptionsId")
    private final String dhcpOptionsId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="dnsLabel")
    private final String dnsLabel;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="ipv6CidrBlock")
    private final String ipv6CidrBlock;
    @JsonProperty(value="ipv6CidrBlocks")
    private final List<String> ipv6CidrBlocks;
    @JsonProperty(value="ipv6VirtualRouterIp")
    private final String ipv6VirtualRouterIp;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="prohibitInternetIngress")
    private final Boolean prohibitInternetIngress;
    @JsonProperty(value="prohibitPublicIpOnVnic")
    private final Boolean prohibitPublicIpOnVnic;
    @JsonProperty(value="routeTableId")
    private final String routeTableId;
    @JsonProperty(value="securityListIds")
    private final List<String> securityListIds;
    @JsonProperty(value="subnetDomainName")
    private final String subnetDomainName;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="vcnId")
    private final String vcnId;
    @JsonProperty(value="virtualRouterIp")
    private final String virtualRouterIp;
    @JsonProperty(value="virtualRouterMac")
    private final String virtualRouterMac;

    @Deprecated
    @ConstructorProperties(value={"availabilityDomain", "cidrBlock", "compartmentId", "definedTags", "dhcpOptionsId", "displayName", "dnsLabel", "freeformTags", "id", "ipv6CidrBlock", "ipv6CidrBlocks", "ipv6VirtualRouterIp", "lifecycleState", "prohibitInternetIngress", "prohibitPublicIpOnVnic", "routeTableId", "securityListIds", "subnetDomainName", "timeCreated", "vcnId", "virtualRouterIp", "virtualRouterMac"})
    public Subnet(String availabilityDomain, String cidrBlock, String compartmentId, Map<String, Map<String, Object>> definedTags, String dhcpOptionsId, String displayName, String dnsLabel, Map<String, String> freeformTags, String id, String ipv6CidrBlock, List<String> ipv6CidrBlocks, String ipv6VirtualRouterIp, LifecycleState lifecycleState, Boolean prohibitInternetIngress, Boolean prohibitPublicIpOnVnic, String routeTableId, List<String> securityListIds, String subnetDomainName, Date timeCreated, String vcnId, String virtualRouterIp, String virtualRouterMac) {
        this.availabilityDomain = availabilityDomain;
        this.cidrBlock = cidrBlock;
        this.compartmentId = compartmentId;
        this.definedTags = definedTags;
        this.dhcpOptionsId = dhcpOptionsId;
        this.displayName = displayName;
        this.dnsLabel = dnsLabel;
        this.freeformTags = freeformTags;
        this.id = id;
        this.ipv6CidrBlock = ipv6CidrBlock;
        this.ipv6CidrBlocks = ipv6CidrBlocks;
        this.ipv6VirtualRouterIp = ipv6VirtualRouterIp;
        this.lifecycleState = lifecycleState;
        this.prohibitInternetIngress = prohibitInternetIngress;
        this.prohibitPublicIpOnVnic = prohibitPublicIpOnVnic;
        this.routeTableId = routeTableId;
        this.securityListIds = securityListIds;
        this.subnetDomainName = subnetDomainName;
        this.timeCreated = timeCreated;
        this.vcnId = vcnId;
        this.virtualRouterIp = virtualRouterIp;
        this.virtualRouterMac = virtualRouterMac;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public String getCidrBlock() {
        return this.cidrBlock;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String getDhcpOptionsId() {
        return this.dhcpOptionsId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDnsLabel() {
        return this.dnsLabel;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public String getId() {
        return this.id;
    }

    public String getIpv6CidrBlock() {
        return this.ipv6CidrBlock;
    }

    public List<String> getIpv6CidrBlocks() {
        return this.ipv6CidrBlocks;
    }

    public String getIpv6VirtualRouterIp() {
        return this.ipv6VirtualRouterIp;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Boolean getProhibitInternetIngress() {
        return this.prohibitInternetIngress;
    }

    public Boolean getProhibitPublicIpOnVnic() {
        return this.prohibitPublicIpOnVnic;
    }

    public String getRouteTableId() {
        return this.routeTableId;
    }

    public List<String> getSecurityListIds() {
        return this.securityListIds;
    }

    public String getSubnetDomainName() {
        return this.subnetDomainName;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String getVcnId() {
        return this.vcnId;
    }

    public String getVirtualRouterIp() {
        return this.virtualRouterIp;
    }

    public String getVirtualRouterMac() {
        return this.virtualRouterMac;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Subnet(");
        sb.append("super=").append(super.toString());
        sb.append("availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(", cidrBlock=").append(String.valueOf(this.cidrBlock));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", dhcpOptionsId=").append(String.valueOf(this.dhcpOptionsId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", dnsLabel=").append(String.valueOf(this.dnsLabel));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", ipv6CidrBlock=").append(String.valueOf(this.ipv6CidrBlock));
        sb.append(", ipv6CidrBlocks=").append(String.valueOf(this.ipv6CidrBlocks));
        sb.append(", ipv6VirtualRouterIp=").append(String.valueOf(this.ipv6VirtualRouterIp));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", prohibitInternetIngress=").append(String.valueOf(this.prohibitInternetIngress));
        sb.append(", prohibitPublicIpOnVnic=").append(String.valueOf(this.prohibitPublicIpOnVnic));
        sb.append(", routeTableId=").append(String.valueOf(this.routeTableId));
        sb.append(", securityListIds=").append(String.valueOf(this.securityListIds));
        sb.append(", subnetDomainName=").append(String.valueOf(this.subnetDomainName));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", vcnId=").append(String.valueOf(this.vcnId));
        sb.append(", virtualRouterIp=").append(String.valueOf(this.virtualRouterIp));
        sb.append(", virtualRouterMac=").append(String.valueOf(this.virtualRouterMac));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Subnet)) {
            return false;
        }
        Subnet other = (Subnet)((Object)o);
        return Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals(this.cidrBlock, other.cidrBlock) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.dhcpOptionsId, other.dhcpOptionsId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.dnsLabel, other.dnsLabel) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.id, other.id) && Objects.equals(this.ipv6CidrBlock, other.ipv6CidrBlock) && Objects.equals(this.ipv6CidrBlocks, other.ipv6CidrBlocks) && Objects.equals(this.ipv6VirtualRouterIp, other.ipv6VirtualRouterIp) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.prohibitInternetIngress, other.prohibitInternetIngress) && Objects.equals(this.prohibitPublicIpOnVnic, other.prohibitPublicIpOnVnic) && Objects.equals(this.routeTableId, other.routeTableId) && Objects.equals(this.securityListIds, other.securityListIds) && Objects.equals(this.subnetDomainName, other.subnetDomainName) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.vcnId, other.vcnId) && Objects.equals(this.virtualRouterIp, other.virtualRouterIp) && Objects.equals(this.virtualRouterMac, other.virtualRouterMac) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.cidrBlock == null ? 43 : this.cidrBlock.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.dhcpOptionsId == null ? 43 : this.dhcpOptionsId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.dnsLabel == null ? 43 : this.dnsLabel.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.ipv6CidrBlock == null ? 43 : this.ipv6CidrBlock.hashCode());
        result = result * 59 + (this.ipv6CidrBlocks == null ? 43 : this.ipv6CidrBlocks.hashCode());
        result = result * 59 + (this.ipv6VirtualRouterIp == null ? 43 : this.ipv6VirtualRouterIp.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.prohibitInternetIngress == null ? 43 : this.prohibitInternetIngress.hashCode());
        result = result * 59 + (this.prohibitPublicIpOnVnic == null ? 43 : this.prohibitPublicIpOnVnic.hashCode());
        result = result * 59 + (this.routeTableId == null ? 43 : this.routeTableId.hashCode());
        result = result * 59 + (this.securityListIds == null ? 43 : this.securityListIds.hashCode());
        result = result * 59 + (this.subnetDomainName == null ? 43 : this.subnetDomainName.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.vcnId == null ? 43 : this.vcnId.hashCode());
        result = result * 59 + (this.virtualRouterIp == null ? 43 : this.virtualRouterIp.hashCode());
        result = result * 59 + (this.virtualRouterMac == null ? 43 : this.virtualRouterMac.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Provisioning("PROVISIONING"),
        Available("AVAILABLE"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED"),
        Updating("UPDATING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="availabilityDomain")
        private String availabilityDomain;
        @JsonProperty(value="cidrBlock")
        private String cidrBlock;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="dhcpOptionsId")
        private String dhcpOptionsId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="dnsLabel")
        private String dnsLabel;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="ipv6CidrBlock")
        private String ipv6CidrBlock;
        @JsonProperty(value="ipv6CidrBlocks")
        private List<String> ipv6CidrBlocks;
        @JsonProperty(value="ipv6VirtualRouterIp")
        private String ipv6VirtualRouterIp;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="prohibitInternetIngress")
        private Boolean prohibitInternetIngress;
        @JsonProperty(value="prohibitPublicIpOnVnic")
        private Boolean prohibitPublicIpOnVnic;
        @JsonProperty(value="routeTableId")
        private String routeTableId;
        @JsonProperty(value="securityListIds")
        private List<String> securityListIds;
        @JsonProperty(value="subnetDomainName")
        private String subnetDomainName;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="vcnId")
        private String vcnId;
        @JsonProperty(value="virtualRouterIp")
        private String virtualRouterIp;
        @JsonProperty(value="virtualRouterMac")
        private String virtualRouterMac;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            this.__explicitlySet__.add("availabilityDomain");
            return this;
        }

        public Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            this.__explicitlySet__.add("cidrBlock");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder dhcpOptionsId(String dhcpOptionsId) {
            this.dhcpOptionsId = dhcpOptionsId;
            this.__explicitlySet__.add("dhcpOptionsId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder dnsLabel(String dnsLabel) {
            this.dnsLabel = dnsLabel;
            this.__explicitlySet__.add("dnsLabel");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder ipv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
            this.__explicitlySet__.add("ipv6CidrBlock");
            return this;
        }

        public Builder ipv6CidrBlocks(List<String> ipv6CidrBlocks) {
            this.ipv6CidrBlocks = ipv6CidrBlocks;
            this.__explicitlySet__.add("ipv6CidrBlocks");
            return this;
        }

        public Builder ipv6VirtualRouterIp(String ipv6VirtualRouterIp) {
            this.ipv6VirtualRouterIp = ipv6VirtualRouterIp;
            this.__explicitlySet__.add("ipv6VirtualRouterIp");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder prohibitInternetIngress(Boolean prohibitInternetIngress) {
            this.prohibitInternetIngress = prohibitInternetIngress;
            this.__explicitlySet__.add("prohibitInternetIngress");
            return this;
        }

        public Builder prohibitPublicIpOnVnic(Boolean prohibitPublicIpOnVnic) {
            this.prohibitPublicIpOnVnic = prohibitPublicIpOnVnic;
            this.__explicitlySet__.add("prohibitPublicIpOnVnic");
            return this;
        }

        public Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            this.__explicitlySet__.add("routeTableId");
            return this;
        }

        public Builder securityListIds(List<String> securityListIds) {
            this.securityListIds = securityListIds;
            this.__explicitlySet__.add("securityListIds");
            return this;
        }

        public Builder subnetDomainName(String subnetDomainName) {
            this.subnetDomainName = subnetDomainName;
            this.__explicitlySet__.add("subnetDomainName");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder vcnId(String vcnId) {
            this.vcnId = vcnId;
            this.__explicitlySet__.add("vcnId");
            return this;
        }

        public Builder virtualRouterIp(String virtualRouterIp) {
            this.virtualRouterIp = virtualRouterIp;
            this.__explicitlySet__.add("virtualRouterIp");
            return this;
        }

        public Builder virtualRouterMac(String virtualRouterMac) {
            this.virtualRouterMac = virtualRouterMac;
            this.__explicitlySet__.add("virtualRouterMac");
            return this;
        }

        public Subnet build() {
            Subnet model = new Subnet(this.availabilityDomain, this.cidrBlock, this.compartmentId, this.definedTags, this.dhcpOptionsId, this.displayName, this.dnsLabel, this.freeformTags, this.id, this.ipv6CidrBlock, this.ipv6CidrBlocks, this.ipv6VirtualRouterIp, this.lifecycleState, this.prohibitInternetIngress, this.prohibitPublicIpOnVnic, this.routeTableId, this.securityListIds, this.subnetDomainName, this.timeCreated, this.vcnId, this.virtualRouterIp, this.virtualRouterMac);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Subnet model) {
            if (model.wasPropertyExplicitlySet("availabilityDomain")) {
                this.availabilityDomain(model.getAvailabilityDomain());
            }
            if (model.wasPropertyExplicitlySet("cidrBlock")) {
                this.cidrBlock(model.getCidrBlock());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("dhcpOptionsId")) {
                this.dhcpOptionsId(model.getDhcpOptionsId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("dnsLabel")) {
                this.dnsLabel(model.getDnsLabel());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("ipv6CidrBlock")) {
                this.ipv6CidrBlock(model.getIpv6CidrBlock());
            }
            if (model.wasPropertyExplicitlySet("ipv6CidrBlocks")) {
                this.ipv6CidrBlocks(model.getIpv6CidrBlocks());
            }
            if (model.wasPropertyExplicitlySet("ipv6VirtualRouterIp")) {
                this.ipv6VirtualRouterIp(model.getIpv6VirtualRouterIp());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("prohibitInternetIngress")) {
                this.prohibitInternetIngress(model.getProhibitInternetIngress());
            }
            if (model.wasPropertyExplicitlySet("prohibitPublicIpOnVnic")) {
                this.prohibitPublicIpOnVnic(model.getProhibitPublicIpOnVnic());
            }
            if (model.wasPropertyExplicitlySet("routeTableId")) {
                this.routeTableId(model.getRouteTableId());
            }
            if (model.wasPropertyExplicitlySet("securityListIds")) {
                this.securityListIds(model.getSecurityListIds());
            }
            if (model.wasPropertyExplicitlySet("subnetDomainName")) {
                this.subnetDomainName(model.getSubnetDomainName());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("vcnId")) {
                this.vcnId(model.getVcnId());
            }
            if (model.wasPropertyExplicitlySet("virtualRouterIp")) {
                this.virtualRouterIp(model.getVirtualRouterIp());
            }
            if (model.wasPropertyExplicitlySet("virtualRouterMac")) {
                this.virtualRouterMac(model.getVirtualRouterMac());
            }
            return this;
        }
    }
}

