/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.newproject;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.netbeans.modules.micronaut.newproject.FeatureTogglePanel;
import org.netbeans.modules.micronaut.newproject.FeaturesWizardPanel;
import org.netbeans.modules.micronaut.newproject.MicronautLaunchService;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.AsyncGUIJob;
import org.openide.util.RequestProcessor;

public class FeaturesVisual
extends JPanel
implements AsyncGUIJob {
    private final FeaturesWizardPanel panel;
    private boolean initialized = false;
    private boolean failed = false;
    private Map<String, List<FeatureTogglePanel>> featuresMap;
    private JPanel nestedPanel;
    private JScrollPane scrollPane;

    public FeaturesVisual(FeaturesWizardPanel panel) {
        this.panel = panel;
        this.initComponents();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.nestedPanel.requestFocus();
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.nestedPanel = new JPanel();
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.nestedPanel.setLayout(new GridBagLayout());
        this.scrollPane.setViewportView(this.nestedPanel);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, 556, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, 298, Short.MAX_VALUE));
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        if (this.failed) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"Problems in contacting service!");
            return false;
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
        return this.initialized;
    }

    void store(WizardDescriptor wd) {
        LinkedHashSet<MicronautLaunchService.Feature> selectedFeatures = new LinkedHashSet<MicronautLaunchService.Feature>();
        for (List<FeatureTogglePanel> toggles : this.featuresMap.values()) {
            for (FeatureTogglePanel toggle : toggles) {
                if (!toggle.isSelected()) continue;
                selectedFeatures.add(toggle.getFeature());
            }
        }
        wd.putProperty("features", selectedFeatures);
    }

    void read(WizardDescriptor wd) {
        Set selectedFeatures = (Set)wd.getProperty("features");
        if (selectedFeatures != null && !selectedFeatures.isEmpty()) {
            for (List<FeatureTogglePanel> toggles : this.featuresMap.values()) {
                for (FeatureTogglePanel toggle : toggles) {
                    toggle.setSelected(selectedFeatures.contains(toggle.getFeature()));
                }
            }
        }
    }

    void validate(WizardDescriptor d) throws WizardValidationException {
    }

    public void construct() {
        this.init();
        this.panel.wizardDescriptor.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName() == "service.url" || evt.getPropertyName() == "application.type") {
                this.refresh();
            }
        });
    }

    private void init() {
        try {
            this.featuresMap = new LinkedHashMap<String, List<FeatureTogglePanel>>();
            this.panel.wizardDescriptor.putProperty("WizardPanel_infoMessage", (Object)"Contacting service...");
            String serviceUrl = (String)this.panel.wizardDescriptor.getProperty("service.url");
            MicronautLaunchService.ApplicationType appType = (MicronautLaunchService.ApplicationType)this.panel.wizardDescriptor.getProperty("application.type");
            for (MicronautLaunchService.Feature feature : MicronautLaunchService.getInstance().getFeatures(serviceUrl, appType)) {
                List toggles = this.featuresMap.computeIfAbsent(feature.getCategory(), c -> new ArrayList());
                toggles.add(new FeatureTogglePanel(feature));
            }
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(4, 8, 0, 0);
            int i = 0;
            for (Map.Entry<String, List<FeatureTogglePanel>> entry : this.featuresMap.entrySet()) {
                gridBagConstraints.gridy = i++;
                JLabel label = new JLabel(entry.getKey());
                label.setFont(label.getFont().deriveFont(1));
                this.nestedPanel.add((Component)label, gridBagConstraints);
                for (FeatureTogglePanel toggle : entry.getValue()) {
                    gridBagConstraints.gridy = i++;
                    this.nestedPanel.add((Component)toggle, gridBagConstraints);
                }
            }
            this.nestedPanel.revalidate();
            this.initialized = true;
        }
        catch (Exception ex) {
            this.panel.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"Could not query Micronaut Launch service");
            this.failed = true;
        }
    }

    public void finished() {
        this.panel.fireChangeEvent();
    }

    private void refresh() {
        this.initialized = false;
        this.failed = false;
        this.nestedPanel.removeAll();
        RequestProcessor.getDefault().post(() -> {
            this.init();
            SwingUtilities.invokeLater(() -> this.finished());
        });
    }
}

