/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.nodes.actions;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.javaee.wildfly.nodes.actions.OpenURLActionCookie;
import org.netbeans.modules.javaee.wildfly.nodes.actions.UndeployModuleCookie;
import org.openide.awt.HtmlBrowser;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class OpenURLAction
extends NodeAction {
    protected void performAction(Node[] nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            OpenURLActionCookie oCookie = (OpenURLActionCookie)nodes[i].getCookie(OpenURLActionCookie.class);
            if (oCookie == null) continue;
            try {
                HtmlBrowser.URLDisplayer.getDefault().showURL(new URL(oCookie.getWebURL()));
                continue;
            }
            catch (MalformedURLException e) {
                Logger.getLogger("global").log(Level.INFO, null, e);
            }
        }
    }

    protected boolean enable(Node[] nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            OpenURLActionCookie oCookie = (OpenURLActionCookie)nodes[i].getCookie(OpenURLActionCookie.class);
            UndeployModuleCookie uCookie = (UndeployModuleCookie)nodes[i].getCookie(UndeployModuleCookie.class);
            UndeployModuleCookie upCookie = (UndeployModuleCookie)nodes[i].getParentNode().getCookie(UndeployModuleCookie.class);
            if (uCookie != null && uCookie.isRunning()) {
                return false;
            }
            if (upCookie != null && upCookie.isRunning()) {
                return false;
            }
            if (oCookie == null) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return NbBundle.getMessage(OpenURLAction.class, (String)"LBL_OpenInBrowserAction");
    }

    protected boolean asynchronous() {
        return false;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

