/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dashboard;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.netbeans.modules.dashboard.WidgetPanel;
import org.netbeans.spi.dashboard.DashboardDisplayer;

final class DashboardPanel
extends JPanel {
    private static final int WIDGET_WIDTH = 240;
    private static final int WIDGET_HEIGHT = 260;
    private static final int WIDGET_GAP = 20;
    private static final int MAX_COLUMNS = 3;
    private final List<WidgetPanel> widgetPanels;
    private final GridLayout layout;
    private boolean showing;

    DashboardPanel(DashboardDisplayer displayer, List<DashboardDisplayer.WidgetReference> widgetRefs) {
        this.widgetPanels = new ArrayList<WidgetPanel>(widgetRefs.size());
        this.layout = new GridLayout(0, 3, 20, 20);
        this.setLayout(this.layout);
        this.setOpaque(false);
        for (DashboardDisplayer.WidgetReference ref : widgetRefs) {
            WidgetPanel w = WidgetPanel.create(displayer, ref);
            w.setPreferredSize(new Dimension(240, 260));
            this.add(w);
            this.widgetPanels.add(w);
        }
        this.addHierarchyBoundsListener(new HierarchyBoundsAdapter(){

            @Override
            public void ancestorResized(HierarchyEvent e) {
                DashboardPanel.this.reflowGrid();
            }
        });
    }

    void notifyShowing() {
        if (!this.showing) {
            this.showing = true;
            this.widgetPanels.forEach(WidgetPanel::notifyShowing);
        }
    }

    void notifyHidden() {
        if (this.showing) {
            this.showing = false;
            this.widgetPanels.forEach(WidgetPanel::notifyHidden);
        }
    }

    private void reflowGrid() {
        Container parent = SwingUtilities.getAncestorOfClass(JViewport.class, this);
        if (parent == null) {
            parent = this.getParent();
        }
        if (parent instanceof JComponent) {
            JComponent jparent = (JComponent)parent;
            int currentColumns = this.layout.getColumns();
            int currentWidth = jparent.getVisibleRect().width;
            int widgetSpace = 280;
            int requiredColumns = currentWidth > 1 ? Math.min(3, Math.max(1, currentWidth / widgetSpace)) : 3;
            if (requiredColumns != currentColumns) {
                this.layout.setColumns(requiredColumns);
                this.revalidate();
            }
        }
    }
}

