/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetStandardTagTemplateRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String standardTagNamespaceName;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getStandardTagNamespaceName() {
        return this.standardTagNamespaceName;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).standardTagNamespaceName(this.standardTagNamespaceName);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",standardTagNamespaceName=").append(String.valueOf(this.standardTagNamespaceName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetStandardTagTemplateRequest)) {
            return false;
        }
        GetStandardTagTemplateRequest other = (GetStandardTagTemplateRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.standardTagNamespaceName, other.standardTagNamespaceName);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.standardTagNamespaceName == null ? 43 : this.standardTagNamespaceName.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetStandardTagTemplateRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String standardTagNamespaceName = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder standardTagNamespaceName(String standardTagNamespaceName) {
            this.standardTagNamespaceName = standardTagNamespaceName;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetStandardTagTemplateRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.standardTagNamespaceName(o.getStandardTagNamespaceName());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetStandardTagTemplateRequest build() {
            GetStandardTagTemplateRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetStandardTagTemplateRequest buildWithoutInvocationCallback() {
            GetStandardTagTemplateRequest request = new GetStandardTagTemplateRequest();
            request.compartmentId = this.compartmentId;
            request.standardTagNamespaceName = this.standardTagNamespaceName;
            return request;
        }
    }
}

