/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.SingleCopyRefactoring;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.plugins.CopyTransformer;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.text.PositionBounds;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class CopyClassRefactoringPlugin
extends JavaRefactoringPlugin {
    private final SingleCopyRefactoring refactoring;

    CopyClassRefactoringPlugin(SingleCopyRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase p) {
        return JavaSource.forFileObject((FileObject)((FileObject)this.refactoring.getRefactoringSource().lookup(FileObject.class)));
    }

    @Override
    public Problem fastCheckParameters() {
        FileObject fo;
        if (!Utilities.isJavaIdentifier((String)this.refactoring.getNewName()) && !"package-info".equals(this.refactoring.getNewName())) {
            String msg = new MessageFormat(NbBundle.getMessage(CopyClassRefactoringPlugin.class, (String)"ERR_InvalidIdentifier")).format(new Object[]{this.refactoring.getNewName()});
            return CopyClassRefactoringPlugin.createProblem(null, true, msg);
        }
        URL target = (URL)this.refactoring.getTarget().lookup(URL.class);
        if (target != null) {
            try {
                target.toURI();
            }
            catch (URISyntaxException ex) {
                return CopyClassRefactoringPlugin.createProblem(null, true, NbBundle.getMessage(CopyClassRefactoringPlugin.class, (String)"ERR_InvalidPackage", (Object)target));
            }
        }
        FileObject fileObject = fo = target != null ? URLMapper.findFileObject((URL)target) : null;
        if (fo == null) {
            return CopyClassRefactoringPlugin.createProblem(null, true, NbBundle.getMessage(CopyClassRefactoringPlugin.class, (String)"ERR_TargetFolderNotSet"));
        }
        if (!JavaRefactoringUtils.isOnSourceClasspath(fo)) {
            return CopyClassRefactoringPlugin.createProblem(null, true, NbBundle.getMessage(CopyClassRefactoringPlugin.class, (String)"ERR_TargetFolderNotJavaPackage"));
        }
        String targetPackageName = RefactoringUtils.getPackageName(target);
        if (!RefactoringUtils.isValidPackageName(targetPackageName)) {
            String msg = new MessageFormat(NbBundle.getMessage(CopyClassRefactoringPlugin.class, (String)"ERR_InvalidPackage")).format(new Object[]{targetPackageName});
            return CopyClassRefactoringPlugin.createProblem(null, true, msg);
        }
        if (fo.getFileObject(this.refactoring.getNewName(), ((FileObject)this.refactoring.getRefactoringSource().lookup(FileObject.class)).getExt()) != null) {
            return CopyClassRefactoringPlugin.createProblem(null, true, new MessageFormat(NbBundle.getMessage(CopyClassRefactoringPlugin.class, (String)"ERR_ClassToMoveClashes")).format(new Object[]{this.refactoring.getNewName()}));
        }
        return null;
    }

    @Override
    public Problem checkParameters() {
        return null;
    }

    @Override
    public Problem preCheck() {
        this.cancelRequest = false;
        this.cancelRequested.set(false);
        return null;
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        refactoringElements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)new CopyClass());
        return null;
    }

    private class CopyClass
    extends SimpleRefactoringElementImplementation
    implements RefactoringElementImplementation {
        public String getText() {
            return this.getDisplayText();
        }

        public String getDisplayText() {
            return new MessageFormat(NbBundle.getMessage(CopyClassRefactoringPlugin.class, (String)"TXT_CopyClassToPackage")).format(new Object[]{CopyClassRefactoringPlugin.this.refactoring.getNewName(), this.getTargetPackageName(), this.getParentFile().getName()});
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public PositionBounds getPosition() {
            return null;
        }

        public String getTargetPackageName() {
            return RefactoringUtils.getPackageName((URL)CopyClassRefactoringPlugin.this.refactoring.getTarget().lookup(URL.class));
        }

        public void performChange() {
            try {
                FileObject fo = RefactoringUtils.getOrCreateFolder((URL)CopyClassRefactoringPlugin.this.refactoring.getTarget().lookup(URL.class));
                FileObject source = (FileObject)CopyClassRefactoringPlugin.this.refactoring.getRefactoringSource().lookup(FileObject.class);
                String oldPackage = RefactoringUtils.getPackageName(source.getParent());
                FileObject newOne = (FileObject)CopyClassRefactoringPlugin.this.refactoring.getContext().lookup(FileObject.class);
                if (newOne == null) {
                    return;
                }
                Collection results = CopyClassRefactoringPlugin.this.processFiles(Collections.singleton(newOne), (CancellableTask<WorkingCopy>)new UpdateReferences(!fo.equals(source.getParent()) && FileOwnerQuery.getOwner((FileObject)fo).equals(FileOwnerQuery.getOwner((FileObject)source)), oldPackage, source.getName()));
                for (ModificationResult result : results) {
                    result.commit();
                }
                DataObject dobj = DataObject.find((FileObject)newOne);
                EditorCookie editor = (EditorCookie)dobj.getLookup().lookup(EditorCookie.class);
                if (editor != null) {
                    editor.open();
                }
            }
            catch (Exception ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
            }
        }

        public FileObject getParentFile() {
            return (FileObject)CopyClassRefactoringPlugin.this.refactoring.getRefactoringSource().lookup(FileObject.class);
        }
    }

    private class UpdateReferences
    implements CancellableTask<WorkingCopy> {
        private boolean insertImport;
        private String oldPackage;
        private String oldName;

        public UpdateReferences(boolean insertImport, String oldPackage, String oldName) {
            this.insertImport = insertImport;
            this.oldPackage = oldPackage;
            this.oldName = oldName;
        }

        public void cancel() {
        }

        public void run(WorkingCopy compiler) throws IOException {
            compiler.toPhase(JavaSource.Phase.RESOLVED);
            CompilationUnitTree cu = compiler.getCompilationUnit();
            if (cu == null) {
                ErrorManager.getDefault().log(65536, "compiler.getCompilationUnit() is null " + compiler);
                return;
            }
            CopyTransformer findVisitor = new CopyTransformer(compiler, this.oldName, CopyClassRefactoringPlugin.this.refactoring.getNewName(), this.insertImport, this.oldPackage);
            findVisitor.scan((Tree)compiler.getCompilationUnit(), null);
        }
    }
}

