/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.java.lsp.server.LspGsonSetup;
import org.netbeans.modules.java.lsp.server.Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class NbGsonAdapter
implements LspGsonSetup {
    private static final Logger LOG = Logger.getLogger(NbGsonAdapter.class.getName());
    private static final Set<String> EXCEPTION_BLOCK_FIELDS = new HashSet<String>(Arrays.asList("backtrace", "depth", "stackTrace", "suppressedExceptions"));

    private static FileObject deserializeFile(String s) {
        if (s == null || "".equals(s.trim())) {
            return null;
        }
        FileObject fo = FileUtil.toFileObject((File)Paths.get(s, new String[0]).toFile());
        if (fo == null) {
            try {
                fo = Utils.fromUri(s);
            }
            catch (IllegalArgumentException | MalformedURLException | FileSystemNotFoundException exception) {
                // empty catch block
            }
        }
        if (fo == null) {
            LOG.log(Level.FINE, "Could not deserialize path {0} to a file");
        }
        return fo;
    }

    @Override
    public void configureBuilder(GsonBuilder b) {
        b.addSerializationExclusionStrategy(new ExclusionStrategy(){

            public boolean shouldSkipField(FieldAttributes fa) {
                if (Throwable.class.isAssignableFrom(fa.getDeclaredClass())) {
                    return EXCEPTION_BLOCK_FIELDS.contains(fa.getName());
                }
                return false;
            }

            public boolean shouldSkipClass(Class<?> type) {
                return false;
            }
        }).registerTypeAdapterFactory(new TypeAdapterFactory(){

            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> tt) {
                if (FileObject.class.isAssignableFrom(tt.getRawType())) {
                    return new TypeAdapter<T>(){

                        public void write(JsonWriter writer, T t) throws IOException {
                            FileObject f = (FileObject)t;
                            writer.value(f == null ? null : f.getPath());
                        }

                        public T read(JsonReader reader) throws IOException {
                            if (reader.peek() == JsonToken.NULL) {
                                reader.nextNull();
                                return null;
                            }
                            return NbGsonAdapter.deserializeFile(reader.nextString());
                        }
                    };
                }
                if (Project.class.isAssignableFrom(tt.getRawType())) {
                    return new TypeAdapter<T>(){

                        public void write(JsonWriter writer, T t) throws IOException {
                            Project p = (Project)t;
                            if (p == null) {
                                writer.nullValue();
                            } else {
                                writer.beginObject();
                                writer.name("path").value(p.getProjectDirectory().getPath());
                                writer.name("name").value(ProjectUtils.getInformation((Project)p).getDisplayName());
                                writer.endObject();
                            }
                        }

                        public T read(JsonReader reader) throws IOException {
                            if (reader.peek() == JsonToken.NULL) {
                                reader.nextNull();
                                return null;
                            }
                            if (reader.peek() == JsonToken.BEGIN_OBJECT) {
                                reader.beginObject();
                                Project p = null;
                                while (reader.hasNext()) {
                                    FileObject fo;
                                    String n = reader.nextName();
                                    if (n == null) continue;
                                    String s = reader.nextString();
                                    if (!"path".equals(n) && !"uri".equals(n) || (fo = NbGsonAdapter.deserializeFile(s)) == null) continue;
                                    p = ProjectManager.getDefault().findProject(fo);
                                }
                                reader.endObject();
                                return p;
                            }
                            if (reader.peek() == JsonToken.STRING) {
                                String s = reader.nextString();
                                if (s == null || s.isEmpty()) {
                                    return null;
                                }
                                FileObject fo = NbGsonAdapter.deserializeFile(s);
                                return fo == null ? null : ProjectManager.getDefault().findProject(fo);
                            }
                            return null;
                        }
                    };
                }
                return null;
            }
        });
        b.registerTypeAdapter(EnumSet.class, (Object)new EnumSetDeserializer());
    }

    private static final class EnumSetDeserializer
    implements JsonDeserializer<EnumSet> {
        private EnumSetDeserializer() {
        }

        public EnumSet deserialize(JsonElement je, Type type, JsonDeserializationContext jdc) throws JsonParseException {
            ParameterizedType pt = (ParameterizedType)type;
            Type itemType = pt.getActualTypeArguments()[0];
            if (je.isJsonPrimitive()) {
                Enum e = (Enum)jdc.deserialize(je, itemType);
                if (e != null) {
                    return EnumSet.of(e);
                }
            } else if (!je.isJsonArray()) {
                throw new JsonParseException("Primitive or array expected");
            }
            JsonArray arr = je.getAsJsonArray();
            EnumSet<Enum> raw = EnumSet.noneOf((Class)itemType);
            for (JsonElement el : arr) {
                if (!el.isJsonPrimitive()) {
                    throw new JsonParseException("Primitive item expected");
                }
                raw.add((Enum)jdc.deserialize(el, itemType));
            }
            return raw;
        }
    }
}

