/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.netbeans.modules.form.EditorSupport;
import org.netbeans.modules.form.FormDataLoader;
import org.netbeans.modules.form.FormServices;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.SaveAsCapable;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class FormDataObject
extends MultiDataObject {
    private transient EditorSupport formEditor;
    private transient OpenEdit openEdit;
    FileEntry formEntry;
    static final long serialVersionUID = -975322003627854168L;

    public FormDataObject(FileObject ffo, FileObject jfo, FormDataLoader loader) throws DataObjectExistsException {
        super(jfo, (MultiFileLoader)loader);
        this.formEntry = (FileEntry)this.registerEntry(ffo);
        this.getCookieSet().assign(SaveAsCapable.class, (Object[])new SaveAsCapable[]{new SaveAsCapable(){

            public void saveAs(FileObject folder, String fileName) throws IOException {
                FormDataObject.this.getFormEditorSupport().saveAs(folder, fileName);
            }
        }});
    }

    public <T extends Node.Cookie> T getCookie(Class<T> type) {
        Node.Cookie retValue;
        if (OpenCookie.class.equals(type) || EditCookie.class.equals(type)) {
            if (this.openEdit == null) {
                this.openEdit = new OpenEdit();
            }
            retValue = (Node.Cookie)type.cast(this.openEdit);
        } else {
            retValue = !type.equals(Node.Cookie.class) && type.isAssignableFrom(this.getFormEditorSupportClass()) ? this.getFormEditorSupport() : super.getCookie(type);
        }
        return (T)retValue;
    }

    public Lookup getLookup() {
        return this.isValid() ? this.getNodeDelegate().getLookup() : Lookup.EMPTY;
    }

    public FileObject getFormFile() {
        return this.formEntry.getFile();
    }

    public boolean isReadOnly() {
        FileObject javaFO = this.getPrimaryFile();
        FileObject formFO = this.formEntry.getFile();
        return !javaFO.canWrite() || !formFO.canWrite();
    }

    public boolean formFileReadOnly() {
        return !this.formEntry.getFile().canWrite();
    }

    public final CookieSet getCookies() {
        return this.getCookieSet();
    }

    private Class getFormEditorSupportClass() {
        return ((FormServices)Lookup.getDefault().lookup(FormServices.class)).getEditorSupportClass(this);
    }

    public synchronized EditorSupport getFormEditorSupport() {
        if (this.formEditor == null) {
            FormServices services = (FormServices)Lookup.getDefault().lookup(FormServices.class);
            this.formEditor = services.createEditorSupport(this);
        }
        return this.formEditor;
    }

    FileEntry getFormEntry() {
        return this.formEntry;
    }

    protected Node createNodeDelegate() {
        FormServices services = (FormServices)Lookup.getDefault().lookup(FormServices.class);
        return services.createFormDataNode(this);
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        is.defaultReadObject();
    }

    protected DataObject handleCopyRename(DataFolder df, String name, String ext) throws IOException {
        FileObject fo = this.getPrimaryEntry().copyRename(df.getPrimaryFile(), name, ext);
        return DataObject.find((FileObject)fo);
    }

    private class OpenEdit
    implements OpenCookie,
    EditCookie {
        private OpenEdit() {
        }

        public void open() {
            FormDataObject.this.getFormEditorSupport().openDesign();
        }

        public void edit() {
            FormDataObject.this.getFormEditorSupport().openSource();
        }
    }
}

