/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.api.facesmodel;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.common.ClasspathUtil;
import org.netbeans.modules.j2ee.common.ProjectUtil;
import org.netbeans.modules.j2ee.deployment.common.api.Version;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerLibrary;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.JSFUtils;
import org.netbeans.modules.web.jsfapi.api.JsfVersion;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

public final class JsfVersionUtils {
    private static final LinkedHashMap<JsfVersion, String> SPECIFIC_CLASS_NAMES = new LinkedHashMap();
    private static final Logger LOG;
    private static final Map<WebModule, JsfVersion> projectVersionCache;
    private static final Map<WebModule, PropertyChangeListener> projectListenerCache;

    private JsfVersionUtils() {
    }

    @CheckForNull
    public static synchronized JsfVersion forWebModule(final @NonNull WebModule webModule) {
        Parameters.notNull((CharSequence)"webModule", (Object)webModule);
        JsfVersion version = projectVersionCache.get(webModule);
        if (version == null) {
            version = JsfVersionUtils.get(webModule, true);
            ClassPath compileCP = JsfVersionUtils.getCompileClasspath(webModule);
            if (compileCP == null) {
                return version;
            }
            PropertyChangeListener listener = WeakListeners.propertyChange((PropertyChangeListener)new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("roots".equals(evt.getPropertyName())) {
                        projectVersionCache.put(webModule, JsfVersionUtils.get(webModule, true));
                    }
                }
            }, (Object)compileCP);
            compileCP.addPropertyChangeListener(listener);
            projectListenerCache.put(webModule, listener);
            projectVersionCache.put(webModule, JsfVersionUtils.get(webModule, true));
        }
        return version;
    }

    @CheckForNull
    public static synchronized JsfVersion forProject(@NonNull Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        WebModule webModule = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        if (webModule != null) {
            return JsfVersionUtils.forWebModule(webModule);
        }
        ClassPathProvider cpp = (ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class);
        Sources sources = ProjectUtils.getSources((Project)project);
        if (sources == null) {
            return null;
        }
        SourceGroup[] sourceGroups = sources.getSourceGroups("java");
        if (sourceGroups.length > 0) {
            ClassPath compileClasspath = cpp.findClassPath(sourceGroups[0].getRootFolder(), "classpath/compile");
            ArrayList<URL> cpUrls = new ArrayList<URL>();
            for (ClassPath.Entry entry : compileClasspath.entries()) {
                cpUrls.add(entry.getURL());
            }
            return JsfVersionUtils.forClasspath(cpUrls);
        }
        return null;
    }

    @CheckForNull
    public static synchronized JsfVersion forClasspath(@NonNull Collection<File> classpath) {
        Parameters.notNull((CharSequence)"classpath", classpath);
        try {
            return (JsfVersion)ClasspathUtil.containsClass(classpath, SPECIFIC_CLASS_NAMES);
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, null, ex);
            return null;
        }
    }

    @CheckForNull
    public static JsfVersion forClasspath(@NonNull List<URL> classpath) {
        Parameters.notNull((CharSequence)"classpath", classpath);
        try {
            return (JsfVersion)ClasspathUtil.containsClass(classpath, SPECIFIC_CLASS_NAMES);
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, null, ex);
            return null;
        }
    }

    @CheckForNull
    public static JsfVersion forServerLibrary(@NonNull ServerLibrary lib) {
        Parameters.notNull((CharSequence)"serverLibrary", (Object)lib);
        if ("JavaServer Faces".equals(lib.getSpecificationTitle())) {
            if (Version.fromJsr277NotationWithFallback((String)"4.1").equals((Object)lib.getSpecificationVersion())) {
                return JsfVersion.JSF_4_1;
            }
            if (Version.fromJsr277NotationWithFallback((String)"4.0").equals((Object)lib.getSpecificationVersion())) {
                return JsfVersion.JSF_4_0;
            }
            if (Version.fromJsr277NotationWithFallback((String)"3.0").equals((Object)lib.getSpecificationVersion())) {
                return JsfVersion.JSF_3_0;
            }
            if (Version.fromJsr277NotationWithFallback((String)"2.3").equals((Object)lib.getSpecificationVersion())) {
                return JsfVersion.JSF_2_3;
            }
            if (Version.fromJsr277NotationWithFallback((String)"2.2").equals((Object)lib.getSpecificationVersion())) {
                return JsfVersion.JSF_2_2;
            }
            if (Version.fromJsr277NotationWithFallback((String)"2.1").equals((Object)lib.getSpecificationVersion())) {
                return JsfVersion.JSF_2_1;
            }
            if (Version.fromJsr277NotationWithFallback((String)"2.0").equals((Object)lib.getSpecificationVersion())) {
                return JsfVersion.JSF_2_0;
            }
            if (Version.fromJsr277NotationWithFallback((String)"1.2").equals((Object)lib.getSpecificationVersion())) {
                return JsfVersion.JSF_1_2;
            }
            if (Version.fromJsr277NotationWithFallback((String)"1.1").equals((Object)lib.getSpecificationVersion())) {
                return JsfVersion.JSF_1_1;
            }
            LOG.log(Level.INFO, "Unknown JSF version {0}", lib.getSpecificationVersion());
        }
        return null;
    }

    @CheckForNull
    public static JsfVersion get(@NonNull WebModule webModule, boolean includingPlatformCP) {
        Parameters.notNull((CharSequence)"webModule", (Object)webModule);
        if (webModule.getDocumentBase() == null) {
            return null;
        }
        ClassPath compileCP = ClassPath.getClassPath((FileObject)webModule.getDocumentBase(), (String)"classpath/compile");
        if (compileCP == null) {
            return null;
        }
        if (includingPlatformCP) {
            for (Map.Entry<JsfVersion, String> entry : SPECIFIC_CLASS_NAMES.entrySet()) {
                String className = entry.getValue();
                if (compileCP.findResource(className.replace('.', '/') + ".class") == null) continue;
                return entry.getKey();
            }
            return null;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)JSFUtils.getFileObject(webModule));
        if (project == null) {
            return null;
        }
        List<File> platformClasspath = Arrays.asList(ClasspathUtil.getJ2eePlatformClasspathEntries((Project)project, (J2eePlatform)ProjectUtil.getPlatform((Project)project)));
        ArrayList<URL> projectDeps = new ArrayList<URL>();
        for (ClassPath.Entry entry : compileCP.entries()) {
            File archiveOrDir = FileUtil.archiveOrDirForURL((URL)entry.getURL());
            if (archiveOrDir != null && platformClasspath.contains(archiveOrDir)) continue;
            projectDeps.add(entry.getURL());
        }
        try {
            return (JsfVersion)ClasspathUtil.containsClass(projectDeps, SPECIFIC_CLASS_NAMES);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private static ClassPath getCompileClasspath(WebModule webModule) {
        FileObject projectFile = JSFUtils.getFileObject(webModule);
        if (projectFile == null) {
            return null;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)projectFile);
        if (project == null) {
            return null;
        }
        ClassPathProvider cpp = (ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class);
        if (webModule.getDocumentBase() != null) {
            return cpp.findClassPath(webModule.getDocumentBase(), "classpath/compile");
        }
        Sources sources = ProjectUtils.getSources((Project)project);
        if (sources == null) {
            return null;
        }
        SourceGroup[] sourceGroups = sources.getSourceGroups("java");
        if (sourceGroups.length > 0) {
            return cpp.findClassPath(sourceGroups[0].getRootFolder(), "classpath/compile");
        }
        return null;
    }

    static {
        SPECIFIC_CLASS_NAMES.put(JsfVersion.JSF_4_1, "jakarta.faces.convert.UUIDConverter");
        SPECIFIC_CLASS_NAMES.put(JsfVersion.JSF_4_0, "jakarta.faces.lifecycle.ClientWindowScoped");
        SPECIFIC_CLASS_NAMES.put(JsfVersion.JSF_3_0, "jakarta.faces.push.PushContext");
        SPECIFIC_CLASS_NAMES.put(JsfVersion.JSF_2_3, "javax.faces.push.PushContext");
        SPECIFIC_CLASS_NAMES.put(JsfVersion.JSF_2_2, "javax.faces.flow.Flow");
        SPECIFIC_CLASS_NAMES.put(JsfVersion.JSF_2_1, "javax.faces.component.TransientStateHelper");
        SPECIFIC_CLASS_NAMES.put(JsfVersion.JSF_2_0, "javax.faces.application.ProjectStage");
        SPECIFIC_CLASS_NAMES.put(JsfVersion.JSF_1_2, "javax.faces.application.StateManagerWrapper");
        SPECIFIC_CLASS_NAMES.put(JsfVersion.JSF_1_1, "javax.faces.FacesException");
        LOG = Logger.getLogger(JsfVersion.class.getName());
        projectVersionCache = new WeakHashMap<WebModule, JsfVersion>();
        projectListenerCache = new WeakHashMap<WebModule, PropertyChangeListener>();
    }
}

