/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.video.StdVideoEncodeH265SliceSegmentHeaderFlags;

public class StdVideoEncodeH265SliceSegmentHeader
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SLICE_TYPE;
    public static final int SLICE_PIC_PARAMETER_SET_ID;
    public static final int NUM_SHORT_TERM_REF_PIC_SETS;
    public static final int SLICE_SEGMENT_ADDRESS;
    public static final int SHORT_TERM_REF_PIC_SET_IDX;
    public static final int NUM_LONG_TERM_SPS;
    public static final int NUM_LONG_TERM_PICS;
    public static final int COLLOCATED_REF_IDX;
    public static final int NUM_REF_IDX_L0_ACTIVE_MINUS1;
    public static final int NUM_REF_IDX_L1_ACTIVE_MINUS1;
    public static final int LUMA_LOG2_WEIGHT_DENOM;
    public static final int DELTA_CHROMA_LOG2_WEIGHT_DENOM;
    public static final int DELTA_LUMA_WEIGHT_L0;
    public static final int LUMA_OFFSET_L0;
    public static final int DELTA_CHROMA_WEIGHT_L0;
    public static final int DELTA_CHROMA_OFFSET_L0;
    public static final int DELTA_LUMA_WEIGHT_L1;
    public static final int LUMA_OFFSET_L1;
    public static final int DELTA_CHROMA_WEIGHT_L1;
    public static final int DELTA_CHROMA_OFFSET_L1;
    public static final int MAXNUMMERGECAND;
    public static final int SLICE_CB_QP_OFFSET;
    public static final int SLICE_CR_QP_OFFSET;
    public static final int SLICE_BETA_OFFSET_DIV2;
    public static final int SLICE_TC_OFFSET_DIV2;
    public static final int SLICE_ACT_Y_QP_OFFSET;
    public static final int SLICE_ACT_CB_QP_OFFSET;
    public static final int SLICE_ACT_CR_QP_OFFSET;
    public static final int FLAGS;

    public StdVideoEncodeH265SliceSegmentHeader(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), StdVideoEncodeH265SliceSegmentHeader.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="StdVideoH265SliceType")
    public int slice_type() {
        return StdVideoEncodeH265SliceSegmentHeader.nslice_type(this.address());
    }

    @NativeType(value="uint8_t")
    public byte slice_pic_parameter_set_id() {
        return StdVideoEncodeH265SliceSegmentHeader.nslice_pic_parameter_set_id(this.address());
    }

    @NativeType(value="uint8_t")
    public byte num_short_term_ref_pic_sets() {
        return StdVideoEncodeH265SliceSegmentHeader.nnum_short_term_ref_pic_sets(this.address());
    }

    @NativeType(value="uint32_t")
    public int slice_segment_address() {
        return StdVideoEncodeH265SliceSegmentHeader.nslice_segment_address(this.address());
    }

    @NativeType(value="uint8_t")
    public byte short_term_ref_pic_set_idx() {
        return StdVideoEncodeH265SliceSegmentHeader.nshort_term_ref_pic_set_idx(this.address());
    }

    @NativeType(value="uint8_t")
    public byte num_long_term_sps() {
        return StdVideoEncodeH265SliceSegmentHeader.nnum_long_term_sps(this.address());
    }

    @NativeType(value="uint8_t")
    public byte num_long_term_pics() {
        return StdVideoEncodeH265SliceSegmentHeader.nnum_long_term_pics(this.address());
    }

    @NativeType(value="uint8_t")
    public byte collocated_ref_idx() {
        return StdVideoEncodeH265SliceSegmentHeader.ncollocated_ref_idx(this.address());
    }

    @NativeType(value="uint8_t")
    public byte num_ref_idx_l0_active_minus1() {
        return StdVideoEncodeH265SliceSegmentHeader.nnum_ref_idx_l0_active_minus1(this.address());
    }

    @NativeType(value="uint8_t")
    public byte num_ref_idx_l1_active_minus1() {
        return StdVideoEncodeH265SliceSegmentHeader.nnum_ref_idx_l1_active_minus1(this.address());
    }

    @NativeType(value="uint8_t")
    public byte luma_log2_weight_denom() {
        return StdVideoEncodeH265SliceSegmentHeader.nluma_log2_weight_denom(this.address());
    }

    @NativeType(value="int8_t")
    public byte delta_chroma_log2_weight_denom() {
        return StdVideoEncodeH265SliceSegmentHeader.ndelta_chroma_log2_weight_denom(this.address());
    }

    @NativeType(value="int8_t[STD_VIDEO_ENCODE_H265_LUMA_LIST_SIZE]")
    public ByteBuffer delta_luma_weight_l0() {
        return StdVideoEncodeH265SliceSegmentHeader.ndelta_luma_weight_l0(this.address());
    }

    @NativeType(value="int8_t")
    public byte delta_luma_weight_l0(int index) {
        return StdVideoEncodeH265SliceSegmentHeader.ndelta_luma_weight_l0(this.address(), index);
    }

    @NativeType(value="int8_t[STD_VIDEO_ENCODE_H265_LUMA_LIST_SIZE]")
    public ByteBuffer luma_offset_l0() {
        return StdVideoEncodeH265SliceSegmentHeader.nluma_offset_l0(this.address());
    }

    @NativeType(value="int8_t")
    public byte luma_offset_l0(int index) {
        return StdVideoEncodeH265SliceSegmentHeader.nluma_offset_l0(this.address(), index);
    }

    @NativeType(value="int8_t[STD_VIDEO_ENCODE_H265_CHROMA_LISTS_NUM]")
    public ByteBuffer delta_chroma_weight_l0() {
        return StdVideoEncodeH265SliceSegmentHeader.ndelta_chroma_weight_l0(this.address());
    }

    @NativeType(value="int8_t")
    public byte delta_chroma_weight_l0(int index) {
        return StdVideoEncodeH265SliceSegmentHeader.ndelta_chroma_weight_l0(this.address(), index);
    }

    @NativeType(value="int8_t[STD_VIDEO_ENCODE_H265_CHROMA_LISTS_NUM]")
    public ByteBuffer delta_chroma_offset_l0() {
        return StdVideoEncodeH265SliceSegmentHeader.ndelta_chroma_offset_l0(this.address());
    }

    @NativeType(value="int8_t")
    public byte delta_chroma_offset_l0(int index) {
        return StdVideoEncodeH265SliceSegmentHeader.ndelta_chroma_offset_l0(this.address(), index);
    }

    @NativeType(value="int8_t[STD_VIDEO_ENCODE_H265_LUMA_LIST_SIZE]")
    public ByteBuffer delta_luma_weight_l1() {
        return StdVideoEncodeH265SliceSegmentHeader.ndelta_luma_weight_l1(this.address());
    }

    @NativeType(value="int8_t")
    public byte delta_luma_weight_l1(int index) {
        return StdVideoEncodeH265SliceSegmentHeader.ndelta_luma_weight_l1(this.address(), index);
    }

    @NativeType(value="int8_t[STD_VIDEO_ENCODE_H265_LUMA_LIST_SIZE]")
    public ByteBuffer luma_offset_l1() {
        return StdVideoEncodeH265SliceSegmentHeader.nluma_offset_l1(this.address());
    }

    @NativeType(value="int8_t")
    public byte luma_offset_l1(int index) {
        return StdVideoEncodeH265SliceSegmentHeader.nluma_offset_l1(this.address(), index);
    }

    @NativeType(value="int8_t[STD_VIDEO_ENCODE_H265_CHROMA_LISTS_NUM]")
    public ByteBuffer delta_chroma_weight_l1() {
        return StdVideoEncodeH265SliceSegmentHeader.ndelta_chroma_weight_l1(this.address());
    }

    @NativeType(value="int8_t")
    public byte delta_chroma_weight_l1(int index) {
        return StdVideoEncodeH265SliceSegmentHeader.ndelta_chroma_weight_l1(this.address(), index);
    }

    @NativeType(value="int8_t[STD_VIDEO_ENCODE_H265_CHROMA_LISTS_NUM]")
    public ByteBuffer delta_chroma_offset_l1() {
        return StdVideoEncodeH265SliceSegmentHeader.ndelta_chroma_offset_l1(this.address());
    }

    @NativeType(value="int8_t")
    public byte delta_chroma_offset_l1(int index) {
        return StdVideoEncodeH265SliceSegmentHeader.ndelta_chroma_offset_l1(this.address(), index);
    }

    @NativeType(value="uint8_t")
    public byte MaxNumMergeCand() {
        return StdVideoEncodeH265SliceSegmentHeader.nMaxNumMergeCand(this.address());
    }

    @NativeType(value="int8_t")
    public byte slice_cb_qp_offset() {
        return StdVideoEncodeH265SliceSegmentHeader.nslice_cb_qp_offset(this.address());
    }

    @NativeType(value="int8_t")
    public byte slice_cr_qp_offset() {
        return StdVideoEncodeH265SliceSegmentHeader.nslice_cr_qp_offset(this.address());
    }

    @NativeType(value="int8_t")
    public byte slice_beta_offset_div2() {
        return StdVideoEncodeH265SliceSegmentHeader.nslice_beta_offset_div2(this.address());
    }

    @NativeType(value="int8_t")
    public byte slice_tc_offset_div2() {
        return StdVideoEncodeH265SliceSegmentHeader.nslice_tc_offset_div2(this.address());
    }

    @NativeType(value="int8_t")
    public byte slice_act_y_qp_offset() {
        return StdVideoEncodeH265SliceSegmentHeader.nslice_act_y_qp_offset(this.address());
    }

    @NativeType(value="int8_t")
    public byte slice_act_cb_qp_offset() {
        return StdVideoEncodeH265SliceSegmentHeader.nslice_act_cb_qp_offset(this.address());
    }

    @NativeType(value="int8_t")
    public byte slice_act_cr_qp_offset() {
        return StdVideoEncodeH265SliceSegmentHeader.nslice_act_cr_qp_offset(this.address());
    }

    public StdVideoEncodeH265SliceSegmentHeaderFlags flags() {
        return StdVideoEncodeH265SliceSegmentHeader.nflags(this.address());
    }

    public StdVideoEncodeH265SliceSegmentHeader slice_type(@NativeType(value="StdVideoH265SliceType") int value) {
        StdVideoEncodeH265SliceSegmentHeader.nslice_type(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader slice_pic_parameter_set_id(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH265SliceSegmentHeader.nslice_pic_parameter_set_id(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader num_short_term_ref_pic_sets(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH265SliceSegmentHeader.nnum_short_term_ref_pic_sets(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader slice_segment_address(@NativeType(value="uint32_t") int value) {
        StdVideoEncodeH265SliceSegmentHeader.nslice_segment_address(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader short_term_ref_pic_set_idx(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH265SliceSegmentHeader.nshort_term_ref_pic_set_idx(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader num_long_term_sps(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH265SliceSegmentHeader.nnum_long_term_sps(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader num_long_term_pics(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH265SliceSegmentHeader.nnum_long_term_pics(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader collocated_ref_idx(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH265SliceSegmentHeader.ncollocated_ref_idx(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader num_ref_idx_l0_active_minus1(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH265SliceSegmentHeader.nnum_ref_idx_l0_active_minus1(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader num_ref_idx_l1_active_minus1(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH265SliceSegmentHeader.nnum_ref_idx_l1_active_minus1(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader luma_log2_weight_denom(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH265SliceSegmentHeader.nluma_log2_weight_denom(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader delta_chroma_log2_weight_denom(@NativeType(value="int8_t") byte value) {
        StdVideoEncodeH265SliceSegmentHeader.ndelta_chroma_log2_weight_denom(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader delta_luma_weight_l0(@NativeType(value="int8_t[STD_VIDEO_ENCODE_H265_LUMA_LIST_SIZE]") ByteBuffer value) {
        StdVideoEncodeH265SliceSegmentHeader.ndelta_luma_weight_l0(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader delta_luma_weight_l0(int index, @NativeType(value="int8_t") byte value) {
        StdVideoEncodeH265SliceSegmentHeader.ndelta_luma_weight_l0(this.address(), index, value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader luma_offset_l0(@NativeType(value="int8_t[STD_VIDEO_ENCODE_H265_LUMA_LIST_SIZE]") ByteBuffer value) {
        StdVideoEncodeH265SliceSegmentHeader.nluma_offset_l0(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader luma_offset_l0(int index, @NativeType(value="int8_t") byte value) {
        StdVideoEncodeH265SliceSegmentHeader.nluma_offset_l0(this.address(), index, value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader delta_chroma_weight_l0(@NativeType(value="int8_t[STD_VIDEO_ENCODE_H265_CHROMA_LISTS_NUM]") ByteBuffer value) {
        StdVideoEncodeH265SliceSegmentHeader.ndelta_chroma_weight_l0(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader delta_chroma_weight_l0(int index, @NativeType(value="int8_t") byte value) {
        StdVideoEncodeH265SliceSegmentHeader.ndelta_chroma_weight_l0(this.address(), index, value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader delta_chroma_offset_l0(@NativeType(value="int8_t[STD_VIDEO_ENCODE_H265_CHROMA_LISTS_NUM]") ByteBuffer value) {
        StdVideoEncodeH265SliceSegmentHeader.ndelta_chroma_offset_l0(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader delta_chroma_offset_l0(int index, @NativeType(value="int8_t") byte value) {
        StdVideoEncodeH265SliceSegmentHeader.ndelta_chroma_offset_l0(this.address(), index, value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader delta_luma_weight_l1(@NativeType(value="int8_t[STD_VIDEO_ENCODE_H265_LUMA_LIST_SIZE]") ByteBuffer value) {
        StdVideoEncodeH265SliceSegmentHeader.ndelta_luma_weight_l1(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader delta_luma_weight_l1(int index, @NativeType(value="int8_t") byte value) {
        StdVideoEncodeH265SliceSegmentHeader.ndelta_luma_weight_l1(this.address(), index, value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader luma_offset_l1(@NativeType(value="int8_t[STD_VIDEO_ENCODE_H265_LUMA_LIST_SIZE]") ByteBuffer value) {
        StdVideoEncodeH265SliceSegmentHeader.nluma_offset_l1(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader luma_offset_l1(int index, @NativeType(value="int8_t") byte value) {
        StdVideoEncodeH265SliceSegmentHeader.nluma_offset_l1(this.address(), index, value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader delta_chroma_weight_l1(@NativeType(value="int8_t[STD_VIDEO_ENCODE_H265_CHROMA_LISTS_NUM]") ByteBuffer value) {
        StdVideoEncodeH265SliceSegmentHeader.ndelta_chroma_weight_l1(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader delta_chroma_weight_l1(int index, @NativeType(value="int8_t") byte value) {
        StdVideoEncodeH265SliceSegmentHeader.ndelta_chroma_weight_l1(this.address(), index, value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader delta_chroma_offset_l1(@NativeType(value="int8_t[STD_VIDEO_ENCODE_H265_CHROMA_LISTS_NUM]") ByteBuffer value) {
        StdVideoEncodeH265SliceSegmentHeader.ndelta_chroma_offset_l1(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader delta_chroma_offset_l1(int index, @NativeType(value="int8_t") byte value) {
        StdVideoEncodeH265SliceSegmentHeader.ndelta_chroma_offset_l1(this.address(), index, value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader MaxNumMergeCand(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH265SliceSegmentHeader.nMaxNumMergeCand(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader slice_cb_qp_offset(@NativeType(value="int8_t") byte value) {
        StdVideoEncodeH265SliceSegmentHeader.nslice_cb_qp_offset(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader slice_cr_qp_offset(@NativeType(value="int8_t") byte value) {
        StdVideoEncodeH265SliceSegmentHeader.nslice_cr_qp_offset(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader slice_beta_offset_div2(@NativeType(value="int8_t") byte value) {
        StdVideoEncodeH265SliceSegmentHeader.nslice_beta_offset_div2(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader slice_tc_offset_div2(@NativeType(value="int8_t") byte value) {
        StdVideoEncodeH265SliceSegmentHeader.nslice_tc_offset_div2(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader slice_act_y_qp_offset(@NativeType(value="int8_t") byte value) {
        StdVideoEncodeH265SliceSegmentHeader.nslice_act_y_qp_offset(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader slice_act_cb_qp_offset(@NativeType(value="int8_t") byte value) {
        StdVideoEncodeH265SliceSegmentHeader.nslice_act_cb_qp_offset(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader slice_act_cr_qp_offset(@NativeType(value="int8_t") byte value) {
        StdVideoEncodeH265SliceSegmentHeader.nslice_act_cr_qp_offset(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader flags(StdVideoEncodeH265SliceSegmentHeaderFlags value) {
        StdVideoEncodeH265SliceSegmentHeader.nflags(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader flags(Consumer<StdVideoEncodeH265SliceSegmentHeaderFlags> consumer) {
        consumer.accept(this.flags());
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader set(int slice_type, byte slice_pic_parameter_set_id, byte num_short_term_ref_pic_sets, int slice_segment_address, byte short_term_ref_pic_set_idx, byte num_long_term_sps, byte num_long_term_pics, byte collocated_ref_idx, byte num_ref_idx_l0_active_minus1, byte num_ref_idx_l1_active_minus1, byte luma_log2_weight_denom, byte delta_chroma_log2_weight_denom, ByteBuffer delta_luma_weight_l0, ByteBuffer luma_offset_l0, ByteBuffer delta_chroma_weight_l0, ByteBuffer delta_chroma_offset_l0, ByteBuffer delta_luma_weight_l1, ByteBuffer luma_offset_l1, ByteBuffer delta_chroma_weight_l1, ByteBuffer delta_chroma_offset_l1, byte MaxNumMergeCand, byte slice_cb_qp_offset, byte slice_cr_qp_offset, byte slice_beta_offset_div2, byte slice_tc_offset_div2, byte slice_act_y_qp_offset, byte slice_act_cb_qp_offset, byte slice_act_cr_qp_offset, StdVideoEncodeH265SliceSegmentHeaderFlags flags) {
        this.slice_type(slice_type);
        this.slice_pic_parameter_set_id(slice_pic_parameter_set_id);
        this.num_short_term_ref_pic_sets(num_short_term_ref_pic_sets);
        this.slice_segment_address(slice_segment_address);
        this.short_term_ref_pic_set_idx(short_term_ref_pic_set_idx);
        this.num_long_term_sps(num_long_term_sps);
        this.num_long_term_pics(num_long_term_pics);
        this.collocated_ref_idx(collocated_ref_idx);
        this.num_ref_idx_l0_active_minus1(num_ref_idx_l0_active_minus1);
        this.num_ref_idx_l1_active_minus1(num_ref_idx_l1_active_minus1);
        this.luma_log2_weight_denom(luma_log2_weight_denom);
        this.delta_chroma_log2_weight_denom(delta_chroma_log2_weight_denom);
        this.delta_luma_weight_l0(delta_luma_weight_l0);
        this.luma_offset_l0(luma_offset_l0);
        this.delta_chroma_weight_l0(delta_chroma_weight_l0);
        this.delta_chroma_offset_l0(delta_chroma_offset_l0);
        this.delta_luma_weight_l1(delta_luma_weight_l1);
        this.luma_offset_l1(luma_offset_l1);
        this.delta_chroma_weight_l1(delta_chroma_weight_l1);
        this.delta_chroma_offset_l1(delta_chroma_offset_l1);
        this.MaxNumMergeCand(MaxNumMergeCand);
        this.slice_cb_qp_offset(slice_cb_qp_offset);
        this.slice_cr_qp_offset(slice_cr_qp_offset);
        this.slice_beta_offset_div2(slice_beta_offset_div2);
        this.slice_tc_offset_div2(slice_tc_offset_div2);
        this.slice_act_y_qp_offset(slice_act_y_qp_offset);
        this.slice_act_cb_qp_offset(slice_act_cb_qp_offset);
        this.slice_act_cr_qp_offset(slice_act_cr_qp_offset);
        this.flags(flags);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader set(StdVideoEncodeH265SliceSegmentHeader src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static StdVideoEncodeH265SliceSegmentHeader malloc() {
        return (StdVideoEncodeH265SliceSegmentHeader)StdVideoEncodeH265SliceSegmentHeader.wrap(StdVideoEncodeH265SliceSegmentHeader.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static StdVideoEncodeH265SliceSegmentHeader calloc() {
        return (StdVideoEncodeH265SliceSegmentHeader)StdVideoEncodeH265SliceSegmentHeader.wrap(StdVideoEncodeH265SliceSegmentHeader.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static StdVideoEncodeH265SliceSegmentHeader create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (StdVideoEncodeH265SliceSegmentHeader)StdVideoEncodeH265SliceSegmentHeader.wrap(StdVideoEncodeH265SliceSegmentHeader.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static StdVideoEncodeH265SliceSegmentHeader create(long address) {
        return (StdVideoEncodeH265SliceSegmentHeader)StdVideoEncodeH265SliceSegmentHeader.wrap(StdVideoEncodeH265SliceSegmentHeader.class, (long)address);
    }

    @Nullable
    public static StdVideoEncodeH265SliceSegmentHeader createSafe(long address) {
        return address == 0L ? null : (StdVideoEncodeH265SliceSegmentHeader)StdVideoEncodeH265SliceSegmentHeader.wrap(StdVideoEncodeH265SliceSegmentHeader.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)StdVideoEncodeH265SliceSegmentHeader.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)StdVideoEncodeH265SliceSegmentHeader.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)StdVideoEncodeH265SliceSegmentHeader.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoEncodeH265SliceSegmentHeader.__create((int)capacity, (int)SIZEOF);
        return (Buffer)StdVideoEncodeH265SliceSegmentHeader.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)StdVideoEncodeH265SliceSegmentHeader.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)StdVideoEncodeH265SliceSegmentHeader.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static StdVideoEncodeH265SliceSegmentHeader malloc(MemoryStack stack) {
        return (StdVideoEncodeH265SliceSegmentHeader)StdVideoEncodeH265SliceSegmentHeader.wrap(StdVideoEncodeH265SliceSegmentHeader.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static StdVideoEncodeH265SliceSegmentHeader calloc(MemoryStack stack) {
        return (StdVideoEncodeH265SliceSegmentHeader)StdVideoEncodeH265SliceSegmentHeader.wrap(StdVideoEncodeH265SliceSegmentHeader.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)StdVideoEncodeH265SliceSegmentHeader.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)StdVideoEncodeH265SliceSegmentHeader.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nslice_type(long struct) {
        return UNSAFE.getInt(null, struct + (long)SLICE_TYPE);
    }

    public static byte nslice_pic_parameter_set_id(long struct) {
        return UNSAFE.getByte(null, struct + (long)SLICE_PIC_PARAMETER_SET_ID);
    }

    public static byte nnum_short_term_ref_pic_sets(long struct) {
        return UNSAFE.getByte(null, struct + (long)NUM_SHORT_TERM_REF_PIC_SETS);
    }

    public static int nslice_segment_address(long struct) {
        return UNSAFE.getInt(null, struct + (long)SLICE_SEGMENT_ADDRESS);
    }

    public static byte nshort_term_ref_pic_set_idx(long struct) {
        return UNSAFE.getByte(null, struct + (long)SHORT_TERM_REF_PIC_SET_IDX);
    }

    public static byte nnum_long_term_sps(long struct) {
        return UNSAFE.getByte(null, struct + (long)NUM_LONG_TERM_SPS);
    }

    public static byte nnum_long_term_pics(long struct) {
        return UNSAFE.getByte(null, struct + (long)NUM_LONG_TERM_PICS);
    }

    public static byte ncollocated_ref_idx(long struct) {
        return UNSAFE.getByte(null, struct + (long)COLLOCATED_REF_IDX);
    }

    public static byte nnum_ref_idx_l0_active_minus1(long struct) {
        return UNSAFE.getByte(null, struct + (long)NUM_REF_IDX_L0_ACTIVE_MINUS1);
    }

    public static byte nnum_ref_idx_l1_active_minus1(long struct) {
        return UNSAFE.getByte(null, struct + (long)NUM_REF_IDX_L1_ACTIVE_MINUS1);
    }

    public static byte nluma_log2_weight_denom(long struct) {
        return UNSAFE.getByte(null, struct + (long)LUMA_LOG2_WEIGHT_DENOM);
    }

    public static byte ndelta_chroma_log2_weight_denom(long struct) {
        return UNSAFE.getByte(null, struct + (long)DELTA_CHROMA_LOG2_WEIGHT_DENOM);
    }

    public static ByteBuffer ndelta_luma_weight_l0(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)DELTA_LUMA_WEIGHT_L0), (int)15);
    }

    public static byte ndelta_luma_weight_l0(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)DELTA_LUMA_WEIGHT_L0 + Checks.check((int)index, (int)15) * 1L);
    }

    public static ByteBuffer nluma_offset_l0(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)LUMA_OFFSET_L0), (int)15);
    }

    public static byte nluma_offset_l0(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)LUMA_OFFSET_L0 + Checks.check((int)index, (int)15) * 1L);
    }

    public static ByteBuffer ndelta_chroma_weight_l0(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)DELTA_CHROMA_WEIGHT_L0), (int)2);
    }

    public static byte ndelta_chroma_weight_l0(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)DELTA_CHROMA_WEIGHT_L0 + Checks.check((int)index, (int)2) * 1L);
    }

    public static ByteBuffer ndelta_chroma_offset_l0(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)DELTA_CHROMA_OFFSET_L0), (int)2);
    }

    public static byte ndelta_chroma_offset_l0(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)DELTA_CHROMA_OFFSET_L0 + Checks.check((int)index, (int)2) * 1L);
    }

    public static ByteBuffer ndelta_luma_weight_l1(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)DELTA_LUMA_WEIGHT_L1), (int)15);
    }

    public static byte ndelta_luma_weight_l1(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)DELTA_LUMA_WEIGHT_L1 + Checks.check((int)index, (int)15) * 1L);
    }

    public static ByteBuffer nluma_offset_l1(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)LUMA_OFFSET_L1), (int)15);
    }

    public static byte nluma_offset_l1(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)LUMA_OFFSET_L1 + Checks.check((int)index, (int)15) * 1L);
    }

    public static ByteBuffer ndelta_chroma_weight_l1(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)DELTA_CHROMA_WEIGHT_L1), (int)2);
    }

    public static byte ndelta_chroma_weight_l1(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)DELTA_CHROMA_WEIGHT_L1 + Checks.check((int)index, (int)2) * 1L);
    }

    public static ByteBuffer ndelta_chroma_offset_l1(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)DELTA_CHROMA_OFFSET_L1), (int)2);
    }

    public static byte ndelta_chroma_offset_l1(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)DELTA_CHROMA_OFFSET_L1 + Checks.check((int)index, (int)2) * 1L);
    }

    public static byte nMaxNumMergeCand(long struct) {
        return UNSAFE.getByte(null, struct + (long)MAXNUMMERGECAND);
    }

    public static byte nslice_cb_qp_offset(long struct) {
        return UNSAFE.getByte(null, struct + (long)SLICE_CB_QP_OFFSET);
    }

    public static byte nslice_cr_qp_offset(long struct) {
        return UNSAFE.getByte(null, struct + (long)SLICE_CR_QP_OFFSET);
    }

    public static byte nslice_beta_offset_div2(long struct) {
        return UNSAFE.getByte(null, struct + (long)SLICE_BETA_OFFSET_DIV2);
    }

    public static byte nslice_tc_offset_div2(long struct) {
        return UNSAFE.getByte(null, struct + (long)SLICE_TC_OFFSET_DIV2);
    }

    public static byte nslice_act_y_qp_offset(long struct) {
        return UNSAFE.getByte(null, struct + (long)SLICE_ACT_Y_QP_OFFSET);
    }

    public static byte nslice_act_cb_qp_offset(long struct) {
        return UNSAFE.getByte(null, struct + (long)SLICE_ACT_CB_QP_OFFSET);
    }

    public static byte nslice_act_cr_qp_offset(long struct) {
        return UNSAFE.getByte(null, struct + (long)SLICE_ACT_CR_QP_OFFSET);
    }

    public static StdVideoEncodeH265SliceSegmentHeaderFlags nflags(long struct) {
        return StdVideoEncodeH265SliceSegmentHeaderFlags.create(struct + (long)FLAGS);
    }

    public static void nslice_type(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SLICE_TYPE, value);
    }

    public static void nslice_pic_parameter_set_id(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)SLICE_PIC_PARAMETER_SET_ID, value);
    }

    public static void nnum_short_term_ref_pic_sets(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)NUM_SHORT_TERM_REF_PIC_SETS, value);
    }

    public static void nslice_segment_address(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SLICE_SEGMENT_ADDRESS, value);
    }

    public static void nshort_term_ref_pic_set_idx(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)SHORT_TERM_REF_PIC_SET_IDX, value);
    }

    public static void nnum_long_term_sps(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)NUM_LONG_TERM_SPS, value);
    }

    public static void nnum_long_term_pics(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)NUM_LONG_TERM_PICS, value);
    }

    public static void ncollocated_ref_idx(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)COLLOCATED_REF_IDX, value);
    }

    public static void nnum_ref_idx_l0_active_minus1(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)NUM_REF_IDX_L0_ACTIVE_MINUS1, value);
    }

    public static void nnum_ref_idx_l1_active_minus1(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)NUM_REF_IDX_L1_ACTIVE_MINUS1, value);
    }

    public static void nluma_log2_weight_denom(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)LUMA_LOG2_WEIGHT_DENOM, value);
    }

    public static void ndelta_chroma_log2_weight_denom(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)DELTA_CHROMA_LOG2_WEIGHT_DENOM, value);
    }

    public static void ndelta_luma_weight_l0(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)15);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)DELTA_LUMA_WEIGHT_L0), (long)(value.remaining() * 1));
    }

    public static void ndelta_luma_weight_l0(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)DELTA_LUMA_WEIGHT_L0 + Checks.check((int)index, (int)15) * 1L, value);
    }

    public static void nluma_offset_l0(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)15);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)LUMA_OFFSET_L0), (long)(value.remaining() * 1));
    }

    public static void nluma_offset_l0(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)LUMA_OFFSET_L0 + Checks.check((int)index, (int)15) * 1L, value);
    }

    public static void ndelta_chroma_weight_l0(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)2);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)DELTA_CHROMA_WEIGHT_L0), (long)(value.remaining() * 1));
    }

    public static void ndelta_chroma_weight_l0(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)DELTA_CHROMA_WEIGHT_L0 + Checks.check((int)index, (int)2) * 1L, value);
    }

    public static void ndelta_chroma_offset_l0(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)2);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)DELTA_CHROMA_OFFSET_L0), (long)(value.remaining() * 1));
    }

    public static void ndelta_chroma_offset_l0(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)DELTA_CHROMA_OFFSET_L0 + Checks.check((int)index, (int)2) * 1L, value);
    }

    public static void ndelta_luma_weight_l1(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)15);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)DELTA_LUMA_WEIGHT_L1), (long)(value.remaining() * 1));
    }

    public static void ndelta_luma_weight_l1(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)DELTA_LUMA_WEIGHT_L1 + Checks.check((int)index, (int)15) * 1L, value);
    }

    public static void nluma_offset_l1(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)15);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)LUMA_OFFSET_L1), (long)(value.remaining() * 1));
    }

    public static void nluma_offset_l1(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)LUMA_OFFSET_L1 + Checks.check((int)index, (int)15) * 1L, value);
    }

    public static void ndelta_chroma_weight_l1(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)2);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)DELTA_CHROMA_WEIGHT_L1), (long)(value.remaining() * 1));
    }

    public static void ndelta_chroma_weight_l1(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)DELTA_CHROMA_WEIGHT_L1 + Checks.check((int)index, (int)2) * 1L, value);
    }

    public static void ndelta_chroma_offset_l1(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)2);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)DELTA_CHROMA_OFFSET_L1), (long)(value.remaining() * 1));
    }

    public static void ndelta_chroma_offset_l1(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)DELTA_CHROMA_OFFSET_L1 + Checks.check((int)index, (int)2) * 1L, value);
    }

    public static void nMaxNumMergeCand(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)MAXNUMMERGECAND, value);
    }

    public static void nslice_cb_qp_offset(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)SLICE_CB_QP_OFFSET, value);
    }

    public static void nslice_cr_qp_offset(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)SLICE_CR_QP_OFFSET, value);
    }

    public static void nslice_beta_offset_div2(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)SLICE_BETA_OFFSET_DIV2, value);
    }

    public static void nslice_tc_offset_div2(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)SLICE_TC_OFFSET_DIV2, value);
    }

    public static void nslice_act_y_qp_offset(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)SLICE_ACT_Y_QP_OFFSET, value);
    }

    public static void nslice_act_cb_qp_offset(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)SLICE_ACT_CB_QP_OFFSET, value);
    }

    public static void nslice_act_cr_qp_offset(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)SLICE_ACT_CR_QP_OFFSET, value);
    }

    public static void nflags(long struct, StdVideoEncodeH265SliceSegmentHeaderFlags value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)FLAGS), (long)StdVideoEncodeH265SliceSegmentHeaderFlags.SIZEOF);
    }

    static {
        Struct.Layout layout = StdVideoEncodeH265SliceSegmentHeader.__struct((Struct.Member[])new Struct.Member[]{StdVideoEncodeH265SliceSegmentHeader.__member((int)4), StdVideoEncodeH265SliceSegmentHeader.__member((int)1), StdVideoEncodeH265SliceSegmentHeader.__member((int)1), StdVideoEncodeH265SliceSegmentHeader.__member((int)4), StdVideoEncodeH265SliceSegmentHeader.__member((int)1), StdVideoEncodeH265SliceSegmentHeader.__member((int)1), StdVideoEncodeH265SliceSegmentHeader.__member((int)1), StdVideoEncodeH265SliceSegmentHeader.__member((int)1), StdVideoEncodeH265SliceSegmentHeader.__member((int)1), StdVideoEncodeH265SliceSegmentHeader.__member((int)1), StdVideoEncodeH265SliceSegmentHeader.__member((int)1), StdVideoEncodeH265SliceSegmentHeader.__member((int)1), StdVideoEncodeH265SliceSegmentHeader.__array((int)1, (int)15), StdVideoEncodeH265SliceSegmentHeader.__array((int)1, (int)15), StdVideoEncodeH265SliceSegmentHeader.__array((int)1, (int)2), StdVideoEncodeH265SliceSegmentHeader.__array((int)1, (int)2), StdVideoEncodeH265SliceSegmentHeader.__array((int)1, (int)15), StdVideoEncodeH265SliceSegmentHeader.__array((int)1, (int)15), StdVideoEncodeH265SliceSegmentHeader.__array((int)1, (int)2), StdVideoEncodeH265SliceSegmentHeader.__array((int)1, (int)2), StdVideoEncodeH265SliceSegmentHeader.__member((int)1), StdVideoEncodeH265SliceSegmentHeader.__member((int)1), StdVideoEncodeH265SliceSegmentHeader.__member((int)1), StdVideoEncodeH265SliceSegmentHeader.__member((int)1), StdVideoEncodeH265SliceSegmentHeader.__member((int)1), StdVideoEncodeH265SliceSegmentHeader.__member((int)1), StdVideoEncodeH265SliceSegmentHeader.__member((int)1), StdVideoEncodeH265SliceSegmentHeader.__member((int)1), StdVideoEncodeH265SliceSegmentHeader.__member((int)StdVideoEncodeH265SliceSegmentHeaderFlags.SIZEOF, (int)StdVideoEncodeH265SliceSegmentHeaderFlags.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SLICE_TYPE = layout.offsetof(0);
        SLICE_PIC_PARAMETER_SET_ID = layout.offsetof(1);
        NUM_SHORT_TERM_REF_PIC_SETS = layout.offsetof(2);
        SLICE_SEGMENT_ADDRESS = layout.offsetof(3);
        SHORT_TERM_REF_PIC_SET_IDX = layout.offsetof(4);
        NUM_LONG_TERM_SPS = layout.offsetof(5);
        NUM_LONG_TERM_PICS = layout.offsetof(6);
        COLLOCATED_REF_IDX = layout.offsetof(7);
        NUM_REF_IDX_L0_ACTIVE_MINUS1 = layout.offsetof(8);
        NUM_REF_IDX_L1_ACTIVE_MINUS1 = layout.offsetof(9);
        LUMA_LOG2_WEIGHT_DENOM = layout.offsetof(10);
        DELTA_CHROMA_LOG2_WEIGHT_DENOM = layout.offsetof(11);
        DELTA_LUMA_WEIGHT_L0 = layout.offsetof(12);
        LUMA_OFFSET_L0 = layout.offsetof(13);
        DELTA_CHROMA_WEIGHT_L0 = layout.offsetof(14);
        DELTA_CHROMA_OFFSET_L0 = layout.offsetof(15);
        DELTA_LUMA_WEIGHT_L1 = layout.offsetof(16);
        LUMA_OFFSET_L1 = layout.offsetof(17);
        DELTA_CHROMA_WEIGHT_L1 = layout.offsetof(18);
        DELTA_CHROMA_OFFSET_L1 = layout.offsetof(19);
        MAXNUMMERGECAND = layout.offsetof(20);
        SLICE_CB_QP_OFFSET = layout.offsetof(21);
        SLICE_CR_QP_OFFSET = layout.offsetof(22);
        SLICE_BETA_OFFSET_DIV2 = layout.offsetof(23);
        SLICE_TC_OFFSET_DIV2 = layout.offsetof(24);
        SLICE_ACT_Y_QP_OFFSET = layout.offsetof(25);
        SLICE_ACT_CB_QP_OFFSET = layout.offsetof(26);
        SLICE_ACT_CR_QP_OFFSET = layout.offsetof(27);
        FLAGS = layout.offsetof(28);
    }

    public static class Buffer
    extends StructBuffer<StdVideoEncodeH265SliceSegmentHeader, Buffer>
    implements NativeResource {
        private static final StdVideoEncodeH265SliceSegmentHeader ELEMENT_FACTORY = StdVideoEncodeH265SliceSegmentHeader.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected StdVideoEncodeH265SliceSegmentHeader getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="StdVideoH265SliceType")
        public int slice_type() {
            return StdVideoEncodeH265SliceSegmentHeader.nslice_type(this.address());
        }

        @NativeType(value="uint8_t")
        public byte slice_pic_parameter_set_id() {
            return StdVideoEncodeH265SliceSegmentHeader.nslice_pic_parameter_set_id(this.address());
        }

        @NativeType(value="uint8_t")
        public byte num_short_term_ref_pic_sets() {
            return StdVideoEncodeH265SliceSegmentHeader.nnum_short_term_ref_pic_sets(this.address());
        }

        @NativeType(value="uint32_t")
        public int slice_segment_address() {
            return StdVideoEncodeH265SliceSegmentHeader.nslice_segment_address(this.address());
        }

        @NativeType(value="uint8_t")
        public byte short_term_ref_pic_set_idx() {
            return StdVideoEncodeH265SliceSegmentHeader.nshort_term_ref_pic_set_idx(this.address());
        }

        @NativeType(value="uint8_t")
        public byte num_long_term_sps() {
            return StdVideoEncodeH265SliceSegmentHeader.nnum_long_term_sps(this.address());
        }

        @NativeType(value="uint8_t")
        public byte num_long_term_pics() {
            return StdVideoEncodeH265SliceSegmentHeader.nnum_long_term_pics(this.address());
        }

        @NativeType(value="uint8_t")
        public byte collocated_ref_idx() {
            return StdVideoEncodeH265SliceSegmentHeader.ncollocated_ref_idx(this.address());
        }

        @NativeType(value="uint8_t")
        public byte num_ref_idx_l0_active_minus1() {
            return StdVideoEncodeH265SliceSegmentHeader.nnum_ref_idx_l0_active_minus1(this.address());
        }

        @NativeType(value="uint8_t")
        public byte num_ref_idx_l1_active_minus1() {
            return StdVideoEncodeH265SliceSegmentHeader.nnum_ref_idx_l1_active_minus1(this.address());
        }

        @NativeType(value="uint8_t")
        public byte luma_log2_weight_denom() {
            return StdVideoEncodeH265SliceSegmentHeader.nluma_log2_weight_denom(this.address());
        }

        @NativeType(value="int8_t")
        public byte delta_chroma_log2_weight_denom() {
            return StdVideoEncodeH265SliceSegmentHeader.ndelta_chroma_log2_weight_denom(this.address());
        }

        @NativeType(value="int8_t[STD_VIDEO_ENCODE_H265_LUMA_LIST_SIZE]")
        public ByteBuffer delta_luma_weight_l0() {
            return StdVideoEncodeH265SliceSegmentHeader.ndelta_luma_weight_l0(this.address());
        }

        @NativeType(value="int8_t")
        public byte delta_luma_weight_l0(int index) {
            return StdVideoEncodeH265SliceSegmentHeader.ndelta_luma_weight_l0(this.address(), index);
        }

        @NativeType(value="int8_t[STD_VIDEO_ENCODE_H265_LUMA_LIST_SIZE]")
        public ByteBuffer luma_offset_l0() {
            return StdVideoEncodeH265SliceSegmentHeader.nluma_offset_l0(this.address());
        }

        @NativeType(value="int8_t")
        public byte luma_offset_l0(int index) {
            return StdVideoEncodeH265SliceSegmentHeader.nluma_offset_l0(this.address(), index);
        }

        @NativeType(value="int8_t[STD_VIDEO_ENCODE_H265_CHROMA_LISTS_NUM]")
        public ByteBuffer delta_chroma_weight_l0() {
            return StdVideoEncodeH265SliceSegmentHeader.ndelta_chroma_weight_l0(this.address());
        }

        @NativeType(value="int8_t")
        public byte delta_chroma_weight_l0(int index) {
            return StdVideoEncodeH265SliceSegmentHeader.ndelta_chroma_weight_l0(this.address(), index);
        }

        @NativeType(value="int8_t[STD_VIDEO_ENCODE_H265_CHROMA_LISTS_NUM]")
        public ByteBuffer delta_chroma_offset_l0() {
            return StdVideoEncodeH265SliceSegmentHeader.ndelta_chroma_offset_l0(this.address());
        }

        @NativeType(value="int8_t")
        public byte delta_chroma_offset_l0(int index) {
            return StdVideoEncodeH265SliceSegmentHeader.ndelta_chroma_offset_l0(this.address(), index);
        }

        @NativeType(value="int8_t[STD_VIDEO_ENCODE_H265_LUMA_LIST_SIZE]")
        public ByteBuffer delta_luma_weight_l1() {
            return StdVideoEncodeH265SliceSegmentHeader.ndelta_luma_weight_l1(this.address());
        }

        @NativeType(value="int8_t")
        public byte delta_luma_weight_l1(int index) {
            return StdVideoEncodeH265SliceSegmentHeader.ndelta_luma_weight_l1(this.address(), index);
        }

        @NativeType(value="int8_t[STD_VIDEO_ENCODE_H265_LUMA_LIST_SIZE]")
        public ByteBuffer luma_offset_l1() {
            return StdVideoEncodeH265SliceSegmentHeader.nluma_offset_l1(this.address());
        }

        @NativeType(value="int8_t")
        public byte luma_offset_l1(int index) {
            return StdVideoEncodeH265SliceSegmentHeader.nluma_offset_l1(this.address(), index);
        }

        @NativeType(value="int8_t[STD_VIDEO_ENCODE_H265_CHROMA_LISTS_NUM]")
        public ByteBuffer delta_chroma_weight_l1() {
            return StdVideoEncodeH265SliceSegmentHeader.ndelta_chroma_weight_l1(this.address());
        }

        @NativeType(value="int8_t")
        public byte delta_chroma_weight_l1(int index) {
            return StdVideoEncodeH265SliceSegmentHeader.ndelta_chroma_weight_l1(this.address(), index);
        }

        @NativeType(value="int8_t[STD_VIDEO_ENCODE_H265_CHROMA_LISTS_NUM]")
        public ByteBuffer delta_chroma_offset_l1() {
            return StdVideoEncodeH265SliceSegmentHeader.ndelta_chroma_offset_l1(this.address());
        }

        @NativeType(value="int8_t")
        public byte delta_chroma_offset_l1(int index) {
            return StdVideoEncodeH265SliceSegmentHeader.ndelta_chroma_offset_l1(this.address(), index);
        }

        @NativeType(value="uint8_t")
        public byte MaxNumMergeCand() {
            return StdVideoEncodeH265SliceSegmentHeader.nMaxNumMergeCand(this.address());
        }

        @NativeType(value="int8_t")
        public byte slice_cb_qp_offset() {
            return StdVideoEncodeH265SliceSegmentHeader.nslice_cb_qp_offset(this.address());
        }

        @NativeType(value="int8_t")
        public byte slice_cr_qp_offset() {
            return StdVideoEncodeH265SliceSegmentHeader.nslice_cr_qp_offset(this.address());
        }

        @NativeType(value="int8_t")
        public byte slice_beta_offset_div2() {
            return StdVideoEncodeH265SliceSegmentHeader.nslice_beta_offset_div2(this.address());
        }

        @NativeType(value="int8_t")
        public byte slice_tc_offset_div2() {
            return StdVideoEncodeH265SliceSegmentHeader.nslice_tc_offset_div2(this.address());
        }

        @NativeType(value="int8_t")
        public byte slice_act_y_qp_offset() {
            return StdVideoEncodeH265SliceSegmentHeader.nslice_act_y_qp_offset(this.address());
        }

        @NativeType(value="int8_t")
        public byte slice_act_cb_qp_offset() {
            return StdVideoEncodeH265SliceSegmentHeader.nslice_act_cb_qp_offset(this.address());
        }

        @NativeType(value="int8_t")
        public byte slice_act_cr_qp_offset() {
            return StdVideoEncodeH265SliceSegmentHeader.nslice_act_cr_qp_offset(this.address());
        }

        public StdVideoEncodeH265SliceSegmentHeaderFlags flags() {
            return StdVideoEncodeH265SliceSegmentHeader.nflags(this.address());
        }

        public Buffer slice_type(@NativeType(value="StdVideoH265SliceType") int value) {
            StdVideoEncodeH265SliceSegmentHeader.nslice_type(this.address(), value);
            return this;
        }

        public Buffer slice_pic_parameter_set_id(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH265SliceSegmentHeader.nslice_pic_parameter_set_id(this.address(), value);
            return this;
        }

        public Buffer num_short_term_ref_pic_sets(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH265SliceSegmentHeader.nnum_short_term_ref_pic_sets(this.address(), value);
            return this;
        }

        public Buffer slice_segment_address(@NativeType(value="uint32_t") int value) {
            StdVideoEncodeH265SliceSegmentHeader.nslice_segment_address(this.address(), value);
            return this;
        }

        public Buffer short_term_ref_pic_set_idx(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH265SliceSegmentHeader.nshort_term_ref_pic_set_idx(this.address(), value);
            return this;
        }

        public Buffer num_long_term_sps(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH265SliceSegmentHeader.nnum_long_term_sps(this.address(), value);
            return this;
        }

        public Buffer num_long_term_pics(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH265SliceSegmentHeader.nnum_long_term_pics(this.address(), value);
            return this;
        }

        public Buffer collocated_ref_idx(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH265SliceSegmentHeader.ncollocated_ref_idx(this.address(), value);
            return this;
        }

        public Buffer num_ref_idx_l0_active_minus1(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH265SliceSegmentHeader.nnum_ref_idx_l0_active_minus1(this.address(), value);
            return this;
        }

        public Buffer num_ref_idx_l1_active_minus1(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH265SliceSegmentHeader.nnum_ref_idx_l1_active_minus1(this.address(), value);
            return this;
        }

        public Buffer luma_log2_weight_denom(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH265SliceSegmentHeader.nluma_log2_weight_denom(this.address(), value);
            return this;
        }

        public Buffer delta_chroma_log2_weight_denom(@NativeType(value="int8_t") byte value) {
            StdVideoEncodeH265SliceSegmentHeader.ndelta_chroma_log2_weight_denom(this.address(), value);
            return this;
        }

        public Buffer delta_luma_weight_l0(@NativeType(value="int8_t[STD_VIDEO_ENCODE_H265_LUMA_LIST_SIZE]") ByteBuffer value) {
            StdVideoEncodeH265SliceSegmentHeader.ndelta_luma_weight_l0(this.address(), value);
            return this;
        }

        public Buffer delta_luma_weight_l0(int index, @NativeType(value="int8_t") byte value) {
            StdVideoEncodeH265SliceSegmentHeader.ndelta_luma_weight_l0(this.address(), index, value);
            return this;
        }

        public Buffer luma_offset_l0(@NativeType(value="int8_t[STD_VIDEO_ENCODE_H265_LUMA_LIST_SIZE]") ByteBuffer value) {
            StdVideoEncodeH265SliceSegmentHeader.nluma_offset_l0(this.address(), value);
            return this;
        }

        public Buffer luma_offset_l0(int index, @NativeType(value="int8_t") byte value) {
            StdVideoEncodeH265SliceSegmentHeader.nluma_offset_l0(this.address(), index, value);
            return this;
        }

        public Buffer delta_chroma_weight_l0(@NativeType(value="int8_t[STD_VIDEO_ENCODE_H265_CHROMA_LISTS_NUM]") ByteBuffer value) {
            StdVideoEncodeH265SliceSegmentHeader.ndelta_chroma_weight_l0(this.address(), value);
            return this;
        }

        public Buffer delta_chroma_weight_l0(int index, @NativeType(value="int8_t") byte value) {
            StdVideoEncodeH265SliceSegmentHeader.ndelta_chroma_weight_l0(this.address(), index, value);
            return this;
        }

        public Buffer delta_chroma_offset_l0(@NativeType(value="int8_t[STD_VIDEO_ENCODE_H265_CHROMA_LISTS_NUM]") ByteBuffer value) {
            StdVideoEncodeH265SliceSegmentHeader.ndelta_chroma_offset_l0(this.address(), value);
            return this;
        }

        public Buffer delta_chroma_offset_l0(int index, @NativeType(value="int8_t") byte value) {
            StdVideoEncodeH265SliceSegmentHeader.ndelta_chroma_offset_l0(this.address(), index, value);
            return this;
        }

        public Buffer delta_luma_weight_l1(@NativeType(value="int8_t[STD_VIDEO_ENCODE_H265_LUMA_LIST_SIZE]") ByteBuffer value) {
            StdVideoEncodeH265SliceSegmentHeader.ndelta_luma_weight_l1(this.address(), value);
            return this;
        }

        public Buffer delta_luma_weight_l1(int index, @NativeType(value="int8_t") byte value) {
            StdVideoEncodeH265SliceSegmentHeader.ndelta_luma_weight_l1(this.address(), index, value);
            return this;
        }

        public Buffer luma_offset_l1(@NativeType(value="int8_t[STD_VIDEO_ENCODE_H265_LUMA_LIST_SIZE]") ByteBuffer value) {
            StdVideoEncodeH265SliceSegmentHeader.nluma_offset_l1(this.address(), value);
            return this;
        }

        public Buffer luma_offset_l1(int index, @NativeType(value="int8_t") byte value) {
            StdVideoEncodeH265SliceSegmentHeader.nluma_offset_l1(this.address(), index, value);
            return this;
        }

        public Buffer delta_chroma_weight_l1(@NativeType(value="int8_t[STD_VIDEO_ENCODE_H265_CHROMA_LISTS_NUM]") ByteBuffer value) {
            StdVideoEncodeH265SliceSegmentHeader.ndelta_chroma_weight_l1(this.address(), value);
            return this;
        }

        public Buffer delta_chroma_weight_l1(int index, @NativeType(value="int8_t") byte value) {
            StdVideoEncodeH265SliceSegmentHeader.ndelta_chroma_weight_l1(this.address(), index, value);
            return this;
        }

        public Buffer delta_chroma_offset_l1(@NativeType(value="int8_t[STD_VIDEO_ENCODE_H265_CHROMA_LISTS_NUM]") ByteBuffer value) {
            StdVideoEncodeH265SliceSegmentHeader.ndelta_chroma_offset_l1(this.address(), value);
            return this;
        }

        public Buffer delta_chroma_offset_l1(int index, @NativeType(value="int8_t") byte value) {
            StdVideoEncodeH265SliceSegmentHeader.ndelta_chroma_offset_l1(this.address(), index, value);
            return this;
        }

        public Buffer MaxNumMergeCand(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH265SliceSegmentHeader.nMaxNumMergeCand(this.address(), value);
            return this;
        }

        public Buffer slice_cb_qp_offset(@NativeType(value="int8_t") byte value) {
            StdVideoEncodeH265SliceSegmentHeader.nslice_cb_qp_offset(this.address(), value);
            return this;
        }

        public Buffer slice_cr_qp_offset(@NativeType(value="int8_t") byte value) {
            StdVideoEncodeH265SliceSegmentHeader.nslice_cr_qp_offset(this.address(), value);
            return this;
        }

        public Buffer slice_beta_offset_div2(@NativeType(value="int8_t") byte value) {
            StdVideoEncodeH265SliceSegmentHeader.nslice_beta_offset_div2(this.address(), value);
            return this;
        }

        public Buffer slice_tc_offset_div2(@NativeType(value="int8_t") byte value) {
            StdVideoEncodeH265SliceSegmentHeader.nslice_tc_offset_div2(this.address(), value);
            return this;
        }

        public Buffer slice_act_y_qp_offset(@NativeType(value="int8_t") byte value) {
            StdVideoEncodeH265SliceSegmentHeader.nslice_act_y_qp_offset(this.address(), value);
            return this;
        }

        public Buffer slice_act_cb_qp_offset(@NativeType(value="int8_t") byte value) {
            StdVideoEncodeH265SliceSegmentHeader.nslice_act_cb_qp_offset(this.address(), value);
            return this;
        }

        public Buffer slice_act_cr_qp_offset(@NativeType(value="int8_t") byte value) {
            StdVideoEncodeH265SliceSegmentHeader.nslice_act_cr_qp_offset(this.address(), value);
            return this;
        }

        public Buffer flags(StdVideoEncodeH265SliceSegmentHeaderFlags value) {
            StdVideoEncodeH265SliceSegmentHeader.nflags(this.address(), value);
            return this;
        }

        public Buffer flags(Consumer<StdVideoEncodeH265SliceSegmentHeaderFlags> consumer) {
            consumer.accept(this.flags());
            return this;
        }
    }
}

