/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkCommandBuffer;
import org.lwjgl.vulkan.VkRect2D;
import org.lwjgl.vulkan.VkViewport;

public class EXTExtendedDynamicState {
    public static final int VK_EXT_EXTENDED_DYNAMIC_STATE_SPEC_VERSION = 1;
    public static final String VK_EXT_EXTENDED_DYNAMIC_STATE_EXTENSION_NAME = "VK_EXT_extended_dynamic_state";
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT = 1000267000;
    public static final int VK_DYNAMIC_STATE_CULL_MODE_EXT = 1000267000;
    public static final int VK_DYNAMIC_STATE_FRONT_FACE_EXT = 1000267001;
    public static final int VK_DYNAMIC_STATE_PRIMITIVE_TOPOLOGY_EXT = 1000267002;
    public static final int VK_DYNAMIC_STATE_VIEWPORT_WITH_COUNT_EXT = 1000267003;
    public static final int VK_DYNAMIC_STATE_SCISSOR_WITH_COUNT_EXT = 1000267004;
    public static final int VK_DYNAMIC_STATE_VERTEX_INPUT_BINDING_STRIDE_EXT = 1000267005;
    public static final int VK_DYNAMIC_STATE_DEPTH_TEST_ENABLE_EXT = 1000267006;
    public static final int VK_DYNAMIC_STATE_DEPTH_WRITE_ENABLE_EXT = 1000267007;
    public static final int VK_DYNAMIC_STATE_DEPTH_COMPARE_OP_EXT = 1000267008;
    public static final int VK_DYNAMIC_STATE_DEPTH_BOUNDS_TEST_ENABLE_EXT = 1000267009;
    public static final int VK_DYNAMIC_STATE_STENCIL_TEST_ENABLE_EXT = 1000267010;
    public static final int VK_DYNAMIC_STATE_STENCIL_OP_EXT = 1000267011;

    protected EXTExtendedDynamicState() {
        throw new UnsupportedOperationException();
    }

    public static void vkCmdSetCullModeEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkCullModeFlags") int cullMode) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetCullModeEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)commandBuffer.address(), (int)cullMode, (long)__functionAddress);
    }

    public static void vkCmdSetFrontFaceEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkFrontFace") int frontFace) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetFrontFaceEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)commandBuffer.address(), (int)frontFace, (long)__functionAddress);
    }

    public static void vkCmdSetPrimitiveTopologyEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkPrimitiveTopology") int primitiveTopology) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetPrimitiveTopologyEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)commandBuffer.address(), (int)primitiveTopology, (long)__functionAddress);
    }

    public static void nvkCmdSetViewportWithCountEXT(VkCommandBuffer commandBuffer, int viewportCount, long pViewports) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetViewportWithCountEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPV((long)commandBuffer.address(), (int)viewportCount, (long)pViewports, (long)__functionAddress);
    }

    public static void vkCmdSetViewportWithCountEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkViewport const *") VkViewport.Buffer pViewports) {
        EXTExtendedDynamicState.nvkCmdSetViewportWithCountEXT(commandBuffer, pViewports.remaining(), pViewports.address());
    }

    public static void nvkCmdSetScissorWithCountEXT(VkCommandBuffer commandBuffer, int scissorCount, long pScissors) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetScissorWithCountEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPV((long)commandBuffer.address(), (int)scissorCount, (long)pScissors, (long)__functionAddress);
    }

    public static void vkCmdSetScissorWithCountEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkRect2D const *") VkRect2D.Buffer pScissors) {
        EXTExtendedDynamicState.nvkCmdSetScissorWithCountEXT(commandBuffer, pScissors.remaining(), pScissors.address());
    }

    public static void nvkCmdBindVertexBuffers2EXT(VkCommandBuffer commandBuffer, int firstBinding, int bindingCount, long pBuffers, long pOffsets, long pSizes, long pStrides) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdBindVertexBuffers2EXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPPPPPV((long)commandBuffer.address(), (int)firstBinding, (int)bindingCount, (long)pBuffers, (long)pOffsets, (long)pSizes, (long)pStrides, (long)__functionAddress);
    }

    public static void vkCmdBindVertexBuffers2EXT(VkCommandBuffer commandBuffer, @NativeType(value="uint32_t") int firstBinding, @NativeType(value="VkBuffer const *") LongBuffer pBuffers, @NativeType(value="VkDeviceSize const *") LongBuffer pOffsets, @Nullable @NativeType(value="VkDeviceSize const *") LongBuffer pSizes, @Nullable @NativeType(value="VkDeviceSize const *") LongBuffer pStrides) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pOffsets, (int)pBuffers.remaining());
            Checks.checkSafe((Buffer)pSizes, (int)pBuffers.remaining());
            Checks.checkSafe((Buffer)pStrides, (int)pBuffers.remaining());
        }
        EXTExtendedDynamicState.nvkCmdBindVertexBuffers2EXT(commandBuffer, firstBinding, pBuffers.remaining(), MemoryUtil.memAddress((LongBuffer)pBuffers), MemoryUtil.memAddress((LongBuffer)pOffsets), MemoryUtil.memAddressSafe((LongBuffer)pSizes), MemoryUtil.memAddressSafe((LongBuffer)pStrides));
    }

    public static void vkCmdSetDepthTestEnableEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkBool32") boolean depthTestEnable) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetDepthTestEnableEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)commandBuffer.address(), (int)(depthTestEnable ? 1 : 0), (long)__functionAddress);
    }

    public static void vkCmdSetDepthWriteEnableEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkBool32") boolean depthWriteEnable) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetDepthWriteEnableEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)commandBuffer.address(), (int)(depthWriteEnable ? 1 : 0), (long)__functionAddress);
    }

    public static void vkCmdSetDepthCompareOpEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkCompareOp") int depthCompareOp) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetDepthCompareOpEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)commandBuffer.address(), (int)depthCompareOp, (long)__functionAddress);
    }

    public static void vkCmdSetDepthBoundsTestEnableEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkBool32") boolean depthBoundsTestEnable) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetDepthBoundsTestEnableEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)commandBuffer.address(), (int)(depthBoundsTestEnable ? 1 : 0), (long)__functionAddress);
    }

    public static void vkCmdSetStencilTestEnableEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkBool32") boolean stencilTestEnable) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetStencilTestEnableEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)commandBuffer.address(), (int)(stencilTestEnable ? 1 : 0), (long)__functionAddress);
    }

    public static void vkCmdSetStencilOpEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkStencilFaceFlags") int faceMask, @NativeType(value="VkStencilOp") int failOp, @NativeType(value="VkStencilOp") int passOp, @NativeType(value="VkStencilOp") int depthFailOp, @NativeType(value="VkCompareOp") int compareOp) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdSetStencilOpEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)commandBuffer.address(), (int)faceMask, (int)failOp, (int)passOp, (int)depthFailOp, (int)compareOp, (long)__functionAddress);
    }

    public static void vkCmdBindVertexBuffers2EXT(VkCommandBuffer commandBuffer, @NativeType(value="uint32_t") int firstBinding, @NativeType(value="VkBuffer const *") long[] pBuffers, @NativeType(value="VkDeviceSize const *") long[] pOffsets, @Nullable @NativeType(value="VkDeviceSize const *") long[] pSizes, @Nullable @NativeType(value="VkDeviceSize const *") long[] pStrides) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdBindVertexBuffers2EXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long[])pOffsets, (int)pBuffers.length);
            Checks.checkSafe((long[])pSizes, (int)pBuffers.length);
            Checks.checkSafe((long[])pStrides, (int)pBuffers.length);
        }
        JNI.callPPPPPV((long)commandBuffer.address(), (int)firstBinding, (int)pBuffers.length, (long[])pBuffers, (long[])pOffsets, (long[])pSizes, (long[])pStrides, (long)__functionAddress);
    }
}

