/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrColor4f
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int R;
    public static final int G;
    public static final int B;
    public static final int A;

    public XrColor4f(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrColor4f.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float r() {
        return XrColor4f.nr(this.address());
    }

    public float g() {
        return XrColor4f.ng(this.address());
    }

    public float b() {
        return XrColor4f.nb(this.address());
    }

    public float a() {
        return XrColor4f.na(this.address());
    }

    public XrColor4f r(float value) {
        XrColor4f.nr(this.address(), value);
        return this;
    }

    public XrColor4f g(float value) {
        XrColor4f.ng(this.address(), value);
        return this;
    }

    public XrColor4f b(float value) {
        XrColor4f.nb(this.address(), value);
        return this;
    }

    public XrColor4f a(float value) {
        XrColor4f.na(this.address(), value);
        return this;
    }

    public XrColor4f set(float r, float g, float b, float a) {
        this.r(r);
        this.g(g);
        this.b(b);
        this.a(a);
        return this;
    }

    public XrColor4f set(XrColor4f src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrColor4f malloc() {
        return (XrColor4f)XrColor4f.wrap(XrColor4f.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrColor4f calloc() {
        return (XrColor4f)XrColor4f.wrap(XrColor4f.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrColor4f create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrColor4f)XrColor4f.wrap(XrColor4f.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrColor4f create(long address) {
        return (XrColor4f)XrColor4f.wrap(XrColor4f.class, (long)address);
    }

    @Nullable
    public static XrColor4f createSafe(long address) {
        return address == 0L ? null : (XrColor4f)XrColor4f.wrap(XrColor4f.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrColor4f.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrColor4f.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrColor4f.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrColor4f.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrColor4f.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrColor4f.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrColor4f.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrColor4f malloc(MemoryStack stack) {
        return (XrColor4f)XrColor4f.wrap(XrColor4f.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrColor4f calloc(MemoryStack stack) {
        return (XrColor4f)XrColor4f.wrap(XrColor4f.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrColor4f.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrColor4f.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static float nr(long struct) {
        return UNSAFE.getFloat(null, struct + (long)R);
    }

    public static float ng(long struct) {
        return UNSAFE.getFloat(null, struct + (long)G);
    }

    public static float nb(long struct) {
        return UNSAFE.getFloat(null, struct + (long)B);
    }

    public static float na(long struct) {
        return UNSAFE.getFloat(null, struct + (long)A);
    }

    public static void nr(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)R, value);
    }

    public static void ng(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)G, value);
    }

    public static void nb(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)B, value);
    }

    public static void na(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)A, value);
    }

    static {
        Struct.Layout layout = XrColor4f.__struct((Struct.Member[])new Struct.Member[]{XrColor4f.__member((int)4), XrColor4f.__member((int)4), XrColor4f.__member((int)4), XrColor4f.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        R = layout.offsetof(0);
        G = layout.offsetof(1);
        B = layout.offsetof(2);
        A = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrColor4f, Buffer>
    implements NativeResource {
        private static final XrColor4f ELEMENT_FACTORY = XrColor4f.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrColor4f getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float r() {
            return XrColor4f.nr(this.address());
        }

        public float g() {
            return XrColor4f.ng(this.address());
        }

        public float b() {
            return XrColor4f.nb(this.address());
        }

        public float a() {
            return XrColor4f.na(this.address());
        }

        public Buffer r(float value) {
            XrColor4f.nr(this.address(), value);
            return this;
        }

        public Buffer g(float value) {
            XrColor4f.ng(this.address(), value);
            return this;
        }

        public Buffer b(float value) {
            XrColor4f.nb(this.address(), value);
            return this;
        }

        public Buffer a(float value) {
            XrColor4f.na(this.address(), value);
            return this;
        }
    }
}

