/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.openal;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;
import org.lwjgl.test.openal.BasicTest;
import org.lwjgl.util.WaveData;

public class PlayTest
extends BasicTest {
    private boolean usingVorbis;

    protected void execute(String[] args) {
        if (args.length < 1) {
            System.out.println("no argument supplied, assuming Footsteps.wav");
            args = new String[]{"Footsteps.wav"};
        }
        if (args[0].endsWith(".ogg")) {
            System.out.print("Attempting to load Ogg Vorbis file, checking for extension...");
            if (AL10.alIsExtensionPresent((String)"AL_EXT_vorbis")) {
                System.out.println("found");
                this.usingVorbis = true;
            } else {
                System.out.println("not supported");
                this.alExit();
                System.exit(-1);
            }
        }
        IntBuffer buffers = BufferUtils.createIntBuffer((int)1);
        IntBuffer sources = BufferUtils.createIntBuffer((int)1);
        buffers.position(0).limit(1);
        AL10.alGenBuffers((IntBuffer)buffers);
        int lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        sources.position(0).limit(1);
        AL10.alGenSources((IntBuffer)sources);
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        if (this.usingVorbis) {
            ByteBuffer filebuffer = this.getData(args[0]);
            AL10.alBufferData((int)buffers.get(0), (int)65539, (ByteBuffer)filebuffer, (int)-1);
            filebuffer.clear();
        } else {
            WaveData wavefile = WaveData.create((String)args[0]);
            AL10.alBufferData((int)buffers.get(0), (int)wavefile.format, (ByteBuffer)wavefile.data, (int)wavefile.samplerate);
            wavefile.dispose();
        }
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        AL10.alSourcei((int)sources.get(0), (int)4105, (int)buffers.get(0));
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        AL10.alSourcei((int)sources.get(0), (int)4103, (int)1);
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        AL10.alSourcePlay((int)sources.get(0));
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        try {
            System.out.println("Waiting 5 seconds for sound to complete");
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        AL10.alSourceStop((int)sources.get(0));
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        sources.position(0).limit(1);
        AL10.alDeleteSources((IntBuffer)sources);
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        buffers.position(0).limit(1);
        AL10.alDeleteBuffers((IntBuffer)buffers);
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        this.alExit();
    }

    protected ByteBuffer getData(String filename) {
        ByteBuffer buffer = null;
        System.out.println("Attempting to load: " + filename);
        try {
            BufferedInputStream bis = new BufferedInputStream(WaveData.class.getClassLoader().getResourceAsStream(filename));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int bufferLength = 4096;
            byte[] readBuffer = new byte[bufferLength];
            int read = -1;
            while ((read = bis.read(readBuffer, 0, bufferLength)) != -1) {
                baos.write(readBuffer, 0, read);
            }
            bis.close();
            buffer = ByteBuffer.allocateDirect(baos.size());
            buffer.order(ByteOrder.nativeOrder());
            buffer.put(baos.toByteArray());
            buffer.rewind();
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
        }
        return buffer;
    }

    public static void main(String[] args) {
        PlayTest playTest = new PlayTest();
        playTest.execute(args);
        System.exit(0);
    }
}

