/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.CallTemplate;
import net.sf.saxon.expr.instruct.LocalParam;
import net.sf.saxon.expr.instruct.Template;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public class XSLCallTemplate
extends StyleElement {
    private static StructuredQName ERROR_TEMPLATE_NAME = new StructuredQName("saxon", "http://saxon.sf.net/", "error-template");
    private StructuredQName calledTemplateName;
    private Template template = null;
    private boolean useTailRecursion = false;
    private boolean gettingReturnedItemType = false;

    public boolean isInstruction() {
        return true;
    }

    protected ItemType getReturnedItemType() {
        if (this.template == null || this.gettingReturnedItemType) {
            return AnyItemType.getInstance();
        }
        this.gettingReturnedItemType = true;
        ItemType result = this.template.getRequiredType().getPrimaryType();
        this.gettingReturnedItemType = false;
        return result;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String nameAttribute = null;
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("name")) {
                nameAttribute = Whitespace.trim(atts.getValue(a));
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (nameAttribute == null) {
            this.calledTemplateName = ERROR_TEMPLATE_NAME;
            this.reportAbsence("name");
            return;
        }
        try {
            this.calledTemplateName = this.makeQName(nameAttribute);
        }
        catch (NamespaceException err) {
            this.calledTemplateName = ERROR_TEMPLATE_NAME;
            this.compileError(err.getMessage(), "XTSE0280");
        }
        catch (XPathException err) {
            this.calledTemplateName = ERROR_TEMPLATE_NAME;
            this.compileError(err.getMessage(), err.getErrorCodeQName());
        }
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        NodeInfo child;
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = kids.next()) != null) {
            if (child instanceof XSLWithParam || child instanceof XSLFallback && this.mayContainFallback()) continue;
            if (child.getNodeKind() == 3) {
                if (Whitespace.isWhite(child.getStringValueCS())) continue;
                this.compileError("No character data is allowed within xsl:call-template", "XTSE0010");
                continue;
            }
            this.compileError("Child element " + Err.wrap(child.getDisplayName(), 1) + " is not allowed as a child of xsl:call-template", "XTSE0010");
        }
        if (!this.calledTemplateName.equals(ERROR_TEMPLATE_NAME)) {
            this.template = this.findTemplate(this.calledTemplateName);
        }
    }

    public void postValidate() throws XPathException {
        if (this.template != null && this.template.getBody() != null) {
            this.checkParams();
        } else {
            final XSLCallTemplate call = this;
            this.getContainingPackage().addCompletionAction(new StylesheetPackage.Action(){

                public void doAction() throws XPathException {
                    call.checkParams();
                }
            });
        }
    }

    private void checkParams() throws XPathException {
        NodeInfo w;
        boolean ok;
        List<LocalParam> declaredParams = this.template.getLocalParams();
        for (LocalParam param : declaredParams) {
            NodeInfo withParam;
            if (!param.isRequiredParam() || param.isTunnelParam()) continue;
            AxisIterator actualParams = this.iterateAxis((byte)3);
            ok = false;
            while ((withParam = actualParams.next()) != null) {
                if (!(withParam instanceof XSLWithParam) || !((XSLWithParam)withParam).getVariableQName().equals(param.getVariableQName())) continue;
                ok = true;
                break;
            }
            if (ok) continue;
            this.compileError("No value supplied for required parameter " + Err.wrap(param.getVariableQName().getDisplayName(), 5), "XTSE0690");
        }
        AxisIterator actualParams = this.iterateAxis((byte)3);
        while ((w = actualParams.next()) != null) {
            if (!(w instanceof XSLWithParam) || ((XSLWithParam)w).isTunnelParam()) continue;
            XSLWithParam withParam = (XSLWithParam)w;
            ok = false;
            for (LocalParam param : declaredParams) {
                if (!param.getVariableQName().equals(withParam.getVariableQName()) || param.isTunnelParam()) continue;
                ok = true;
                SequenceType required = param.getRequiredType();
                withParam.checkAgainstRequiredType(required);
                break;
            }
            if (ok || this.xPath10ModeIsEnabled()) continue;
            this.compileError("Parameter " + withParam.getVariableQName().getDisplayName() + " is not declared in the called template", "XTSE0680");
        }
    }

    private Template findTemplate(StructuredQName templateName) throws XPathException {
        StylesheetPackage pack = this.getContainingPackage();
        Template template = pack.getNamedTemplate(templateName);
        if (template == null) {
            this.compileError("No template exists named " + this.calledTemplateName, "XTSE0650");
        }
        return template;
    }

    public boolean markTailCalls() {
        this.useTailRecursion = true;
        return true;
    }

    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        if (this.template == null) {
            return null;
        }
        CallTemplate call = new CallTemplate(this.template, this.useTailRecursion);
        call.setActualParameters(this.getWithParamInstructions(exec, decl, false), this.getWithParamInstructions(exec, decl, true));
        return call;
    }
}

