/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.common.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Comparator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.common.io.RecordHeader;

class DeadLetterQueueUtils {
    private static final Logger logger = LogManager.getLogger(DeadLetterQueueUtils.class);

    DeadLetterQueueUtils() {
    }

    static int extractSegmentId(Path p) {
        return Integer.parseInt(p.getFileName().toString().split("\\.log")[0]);
    }

    static Stream<Path> listFiles(Path path, String suffix) throws IOException {
        try (Stream<Path> files = Files.list(path);){
            Stream<Path> stream = files.filter(p -> p.toString().endsWith(suffix)).collect(Collectors.toList()).stream();
            return stream;
        }
    }

    static Stream<Path> listSegmentPaths(Path path) throws IOException {
        return DeadLetterQueueUtils.listFiles(path, ".log");
    }

    static Stream<Path> listSegmentPathsSortedBySegmentId(Path path) throws IOException {
        return DeadLetterQueueUtils.listSegmentPaths(path).sorted(Comparator.comparingInt(DeadLetterQueueUtils::extractSegmentId));
    }

    static long countEventsInSegment(Path segment) throws IOException {
        try (FileChannel channel = FileChannel.open(segment, StandardOpenOption.READ);){
            if (channel.size() < 14L) {
                long l = 0L;
                return l;
            }
            channel.position(1L);
            int posInBlock = 0;
            int currentBlockIdx = 0;
            long countedEvents = 0L;
            do {
                ByteBuffer headerBuffer = ByteBuffer.allocate(13);
                long startPosition = channel.position();
                if (posInBlock + 13 + 1 > 32768) {
                    channel.position(++currentBlockIdx * 32768 + 1);
                    posInBlock = 0;
                }
                channel.read(headerBuffer);
                headerBuffer.flip();
                RecordHeader recordHeader = RecordHeader.get(headerBuffer);
                if (recordHeader == null) {
                    logger.error("Can't decode record header, position {} current post {} current events count {}", (Object)startPosition, (Object)channel.position(), (Object)countedEvents);
                    continue;
                }
                switch (recordHeader.getType()) {
                    case START: 
                    case COMPLETE: {
                        ++countedEvents;
                    }
                    case MIDDLE: 
                    case END: {
                        channel.position(channel.position() + (long)recordHeader.getSize());
                        posInBlock += 13 + recordHeader.getSize();
                    }
                }
            } while (channel.position() < channel.size());
            long l = countedEvents;
            return l;
        }
    }
}

