/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.ExpressionLocation;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.serialize.charcode.XMLCharacterData;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public class XML10ContentChecker
extends ProxyReceiver {
    public XML10ContentChecker(Receiver next) {
        super(next);
    }

    public void startElement(NodeName elemName, SchemaType typeCode, int locationId, int properties) throws XPathException {
        this.nextReceiver.startElement(elemName, typeCode, locationId, properties);
    }

    public void attribute(NodeName attName, SimpleType typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        this.checkString(value, locationId);
        this.nextReceiver.attribute(attName, typeCode, value, locationId, properties);
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        this.checkString(chars, locationId);
        this.nextReceiver.characters(chars, locationId, properties);
    }

    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
        this.checkString(chars, locationId);
        this.nextReceiver.comment(chars, locationId, properties);
    }

    public void processingInstruction(String target, CharSequence data, int locationId, int properties) throws XPathException {
        this.checkString(data, locationId);
        this.nextReceiver.processingInstruction(target, data, locationId, properties);
    }

    private void checkString(CharSequence in, int locationId) throws XPathException {
        int len = in.length();
        for (int c = 0; c < len; ++c) {
            int ch32 = in.charAt(c);
            if (UTF16CharacterSet.isHighSurrogate(ch32)) {
                char low = in.charAt(++c);
                ch32 = UTF16CharacterSet.combinePair((char)ch32, low);
            }
            if (XMLCharacterData.isValid10(ch32)) continue;
            XPathException err = new XPathException("The result tree contains a character not allowed by XML 1.0 (hex " + Integer.toHexString(ch32) + ')');
            err.setErrorCode("SERE0006");
            err.setLocator(new ExpressionLocation(this.getPipelineConfiguration().getLocationProvider(), locationId));
            throw err;
        }
    }
}

