/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.xmlns.common;

import java.util.logging.Logger;
import org.pentaho.reporting.libraries.xmlns.LibXmlBoot;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class ParserUtil {
    private static final Logger logger = Logger.getLogger(ParserUtil.class.getName());
    private static boolean strictParsing = "true".equals(LibXmlBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.libraries.xmlns.StrictParseMode"));

    private ParserUtil() {
    }

    public static int parseInt(String text, String message, Locator locator) throws SAXException {
        if (text == null) {
            throw new SAXException(message);
        }
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("NumberFormatError: " + message, locator);
        }
    }

    public static int parseInt(String text, String message) throws SAXException {
        if (text == null) {
            throw new SAXException(message);
        }
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException nfe) {
            throw new SAXException("NumberFormatError: " + message);
        }
    }

    public static int parseInt(String text, int defaultVal) {
        if (text == null) {
            return defaultVal;
        }
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException nfe) {
            return defaultVal;
        }
    }

    public static float parseFloat(String text, String message, Locator locator) throws ParseException {
        if (text == null) {
            throw new ParseException(message, locator);
        }
        try {
            return Float.parseFloat(text);
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("NumberFormatError: " + message, locator);
        }
    }

    public static float parseFloat(String text, String message) throws SAXException {
        if (text == null) {
            throw new SAXException(message);
        }
        try {
            return Float.parseFloat(text);
        }
        catch (NumberFormatException nfe) {
            throw new SAXException("NumberFormatError: " + message);
        }
    }

    public static float parseFloat(String text, float defaultVal) {
        if (text == null) {
            return defaultVal;
        }
        try {
            return Float.parseFloat(text);
        }
        catch (NumberFormatException nfe) {
            return defaultVal;
        }
    }

    public static boolean parseBoolean(String text, boolean defaultVal) {
        if (text == null) {
            return defaultVal;
        }
        if (strictParsing) {
            return "true".equals(text);
        }
        if (text.equals("true")) {
            return true;
        }
        if (text.equals("false")) {
            return false;
        }
        logger.warning("Invalid value encountered: Expected 'true' or 'false', but got '" + text + "'");
        return "true".equalsIgnoreCase(text);
    }

    public static Boolean parseBoolean(String value, Locator locator) throws ParseException {
        if (value == null) {
            return null;
        }
        if ("true".equals(value)) {
            return Boolean.TRUE;
        }
        if ("false".equals(value)) {
            return Boolean.FALSE;
        }
        if (strictParsing) {
            throw new ParseException("Failed to parse: Expected 'true' or 'false'", locator);
        }
        if (locator == null) {
            logger.warning("Invalid value encountered for boolean attribute.");
        } else {
            logger.warning("Invalid value encountered for boolean attribute. [Line: " + locator.getLineNumber() + " Column: " + locator.getColumnNumber() + "]");
        }
        return Boolean.FALSE;
    }

    public static String parseString(String text, String defaultVal) {
        if (text == null) {
            return defaultVal;
        }
        return text;
    }
}

