/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage;

import io.opentelemetry.api.trace.StatusCode;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.Profile;
import org.keycloak.common.util.reflections.Types;
import org.keycloak.component.ComponentFactory;
import org.keycloak.component.ComponentModel;
import org.keycloak.credential.CredentialAuthentication;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.CredentialProviderFactory;
import org.keycloak.models.AbstractKeycloakTransaction;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.CredentialValidationOutput;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.ModelException;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserCredentialManager;
import org.keycloak.models.UserManager;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.cache.CachedUserModel;
import org.keycloak.models.cache.OnUserCache;
import org.keycloak.models.cache.UserCache;
import org.keycloak.models.utils.ComponentUtil;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.ReadOnlyUserModelDelegate;
import org.keycloak.organization.OrganizationProvider;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.storage.AbstractStorageManager;
import org.keycloak.storage.CacheableStorageProviderModel;
import org.keycloak.storage.DatastoreProvider;
import org.keycloak.storage.OnCreateComponent;
import org.keycloak.storage.OnUpdateComponent;
import org.keycloak.storage.ReadOnlyException;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.StorageUnavailableException;
import org.keycloak.storage.StoreSyncEvent;
import org.keycloak.storage.UserStoragePrivateUtil;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.UserStorageProviderFactory;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.storage.UserStorageUtil;
import org.keycloak.storage.client.ClientStorageProvider;
import org.keycloak.storage.datastore.DefaultDatastoreProvider;
import org.keycloak.storage.federated.UserFederatedStorageProvider;
import org.keycloak.storage.user.ImportedUserValidation;
import org.keycloak.storage.user.UserBulkUpdateProvider;
import org.keycloak.storage.user.UserCountMethodsProvider;
import org.keycloak.storage.user.UserLookupProvider;
import org.keycloak.storage.user.UserQueryMethodsProvider;
import org.keycloak.storage.user.UserRegistrationProvider;
import org.keycloak.tracing.TracingProvider;
import org.keycloak.userprofile.AttributeMetadata;
import org.keycloak.userprofile.UserProfileDecorator;
import org.keycloak.userprofile.UserProfileMetadata;
import org.keycloak.utils.StreamsUtil;
import org.keycloak.utils.StringUtil;

public class UserStorageManager
extends AbstractStorageManager<UserStorageProvider, UserStorageProviderModel>
implements UserProvider,
OnUserCache,
OnCreateComponent,
OnUpdateComponent,
UserProfileDecorator {
    private static final Logger logger = Logger.getLogger(UserStorageManager.class);

    public UserStorageManager(KeycloakSession session) {
        super(session, UserStorageProviderFactory.class, UserStorageProvider.class, UserStorageProviderModel::new, "user");
    }

    protected UserProvider localStorage() {
        return ((DefaultDatastoreProvider)this.session.getProvider(DatastoreProvider.class)).userLocalStorage();
    }

    private UserFederatedStorageProvider getFederatedStorage() {
        return UserStorageUtil.userFederatedStorage((KeycloakSession)this.session);
    }

    protected UserModel validateUser(RealmModel realm, UserModel user) {
        if (user == null) {
            return null;
        }
        if (user.isFederated()) {
            user = this.validateFederatedUser(realm, user);
        }
        if (this.isReadOnlyOrganizationMember(user)) {
            if (user instanceof CachedUserModel) {
                CachedUserModel cachedUserModel = (CachedUserModel)user;
                cachedUserModel.invalidate();
            }
            return new ReadOnlyUserModelDelegate(user, false);
        }
        return user;
    }

    private UserModel validateFederatedUser(RealmModel realm, UserModel user) {
        if (!user.isFederated()) {
            return user;
        }
        UserStorageProviderModel model = this.getUserStorageProviderModel(realm, user);
        if (model == null) {
            return null;
        }
        if (!model.isEnabled()) {
            if (user instanceof CachedUserModel) {
                CachedUserModel cachedUserModel = (CachedUserModel)user;
                cachedUserModel.invalidate();
            }
            return new ReadOnlyUserModelDelegate(user, false);
        }
        if (user instanceof CachedUserModel) {
            return user;
        }
        ImportedUserValidation validator = (ImportedUserValidation)this.getStorageProviderInstance((CacheableStorageProviderModel)model, ImportedUserValidation.class, true);
        if (validator == null) {
            return user;
        }
        try {
            UserModel validated = validator.validate(realm, user);
            if (validated == null) {
                return this.deleteFederatedUser(realm, user);
            }
            return validated;
        }
        catch (Exception e) {
            logger.warnf((Throwable)e, "User storage provider %s failed during federated user validation", (Object)model.getName());
            return new ReadOnlyUserModelDelegate(user, false, ignore -> new ReadOnlyException("The user is read-only. The user storage provider '" + model.getName() + "' is currently unavailable. Check the server logs for more details."));
        }
    }

    private ReadOnlyUserModelDelegate deleteFederatedUser(RealmModel realm, UserModel user) {
        if (!user.isFederated()) {
            return null;
        }
        UserStorageProviderModel model = this.getUserStorageProviderModel(realm, user);
        if (model == null) {
            return null;
        }
        this.deleteInvalidUserCache(realm, user);
        if (model.isRemoveInvalidUsersEnabled()) {
            this.deleteInvalidUser(realm, user);
            return null;
        }
        return new ReadOnlyUserModelDelegate(user, false);
    }

    private UserStorageProviderModel getUserStorageProviderModel(RealmModel realm, UserModel user) {
        if (user.isFederated()) {
            UserStorageProviderModel model = (UserStorageProviderModel)this.getStorageProviderModel(realm, user.getFederationLink());
            if (model == null) {
                logger.debugf("Removed user with federation link of unknown storage provider '%s'", (Object)user.getUsername());
                this.deleteInvalidUserCache(realm, user);
                this.deleteInvalidUser(realm, user);
            }
            return model;
        }
        return null;
    }

    private static <T> Stream<T> getCredentialProviders(KeycloakSession session, Class<T> type) {
        return session.getKeycloakSessionFactory().getProviderFactoriesStream(CredentialProvider.class).filter(f -> Types.supports((Class)type, (Object)f, CredentialProviderFactory.class)).map(f -> (CredentialProvider)session.getProvider(CredentialProvider.class, f.getId())).map(type::cast);
    }

    public CredentialValidationOutput getUserByCredential(RealmModel realm, CredentialInput input) {
        Stream<CredentialAuthentication> credentialAuthenticationStream = this.getEnabledStorageProviders(realm, CredentialAuthentication.class);
        credentialAuthenticationStream = Stream.concat(credentialAuthenticationStream, UserStorageManager.getCredentialProviders(this.session, CredentialAuthentication.class));
        CredentialValidationOutput result = null;
        for (CredentialAuthentication credentialAuthentication2 : credentialAuthenticationStream.filter(credentialAuthentication -> credentialAuthentication.supportsCredentialAuthenticationFor(input.getType())).toList()) {
            CredentialValidationOutput.Status status;
            CredentialValidationOutput validationOutput = (CredentialValidationOutput)((TracingProvider)this.session.getProvider(TracingProvider.class)).trace(credentialAuthentication2.getClass(), "authenticate", span -> {
                CredentialValidationOutput output = credentialAuthentication2.authenticate(realm, input);
                if (span.isRecording() && output != null) {
                    CredentialValidationOutput.Status status = output.getAuthStatus();
                    span.setAttribute("kc.validationStatus", status.name());
                    if (status == CredentialValidationOutput.Status.FAILED) {
                        span.setStatus(StatusCode.ERROR);
                    }
                }
                return output;
            });
            if (Objects.nonNull(validationOutput) && ((status = validationOutput.getAuthStatus()) == CredentialValidationOutput.Status.AUTHENTICATED || status == CredentialValidationOutput.Status.CONTINUE || status == CredentialValidationOutput.Status.FAILED)) {
                logger.tracef("Attempt to authenticate credential '%s' with provider '%s' finished with '%s'.", (Object)input.getType(), (Object)credentialAuthentication2, (Object)status);
                if (status == CredentialValidationOutput.Status.AUTHENTICATED) {
                    logger.tracef("Authenticated user is '%s'", (Object)validationOutput.getAuthenticatedUser().getUsername());
                }
                result = validationOutput;
                break;
            }
            logger.tracef("Did not authenticate user by provider '%s' with the credential type '%s'. Will try to fallback to other user storage providers", (Object)credentialAuthentication2, (Object)input.getType());
        }
        return result;
    }

    protected void deleteInvalidUserCache(RealmModel realm, UserModel user) {
        UserCache userCache = UserStorageUtil.userCache((KeycloakSession)this.session);
        if (userCache != null) {
            userCache.evict(realm, user);
        }
    }

    protected void deleteInvalidUser(RealmModel realm, UserModel user) {
        String userId = user.getId();
        String userName = user.getUsername();
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.session.getKeycloakSessionFactory(), session -> {
            RealmModel realmModel = session.realms().getRealm(realm.getId());
            if (realmModel == null) {
                return;
            }
            session.getContext().setRealm(realm);
            UserModel deletedUser = UserStoragePrivateUtil.userLocalStorage(session).getUserById(realmModel, userId);
            if (deletedUser != null) {
                try {
                    new UserManager(session).removeUser(realmModel, deletedUser, UserStoragePrivateUtil.userLocalStorage(session));
                    logger.debugf("Removed invalid user '%s'", (Object)userName);
                }
                catch (ModelException ex) {
                    logger.debugf((Throwable)ex, "ModelException thrown during deleteInvalidUser with username '%s'", (Object)userName);
                }
            }
        });
    }

    protected Stream<UserModel> importValidation(RealmModel realm, Stream<UserModel> users) {
        return users.map(user -> this.validateUser(realm, (UserModel)user)).filter(Objects::nonNull);
    }

    protected Stream<UserModel> query(PaginatedQuery pagedQuery, RealmModel realm, Integer firstResult, Integer maxResults) {
        return this.query(pagedQuery, (provider, first, max) -> (int)pagedQuery.query(provider, first, max).count(), realm, firstResult, maxResults, true);
    }

    protected Stream<UserModel> query(PaginatedQuery pagedQuery, CountQuery countQuery, RealmModel realm, Integer firstResult, Integer maxResults, boolean requiresFederatedStorage) {
        int startIdx;
        if (maxResults != null && maxResults == 0) {
            return Stream.empty();
        }
        List storageProviders = this.getEnabledStorageProviders(realm, UserQueryMethodsProvider.class).toList();
        if (firstResult == null || firstResult <= 0) {
            Stream<UserProvider> providers = Stream.concat(Stream.of(this.localStorage()), this.concatExternalWithFederated(storageProviders, 0, requiresFederatedStorage));
            return UserStorageManager.queryProviders(providers, pagedQuery, 0, maxResults, false);
        }
        if (storageProviders.isEmpty()) {
            if (requiresFederatedStorage) {
                return this.queryLocalAndFederatedStorage(pagedQuery, countQuery, firstResult, maxResults);
            }
            return this.queryLocalStorage(pagedQuery, firstResult, maxResults);
        }
        UserProvider localStorage = this.localStorage();
        int count = this.countQueryWithGracefulDegradation(localStorage, countQuery, 0, firstResult + 1);
        if (count > firstResult) {
            Stream<UserProvider> providers = Stream.concat(Stream.of(this.localStorage()), this.concatExternalWithFederated(storageProviders, 0, requiresFederatedStorage));
            return UserStorageManager.queryProviders(providers, pagedQuery, firstResult, maxResults, false);
        }
        if (count == firstResult) {
            Stream<?> providers = this.concatExternalWithFederated(storageProviders, 0, requiresFederatedStorage);
            return UserStorageManager.queryProviders(providers, pagedQuery, 0, maxResults, false);
        }
        firstResult = firstResult - count;
        int lastProviderToCount = requiresFederatedStorage ? storageProviders.size() : storageProviders.size() - 1;
        for (startIdx = 0; startIdx < lastProviderToCount; ++startIdx) {
            UserQueryMethodsProvider provider = (UserQueryMethodsProvider)storageProviders.get(startIdx);
            if (!(provider instanceof UserCountMethodsProvider)) {
                assert (firstResult > 0);
                Stream<?> providers = this.concatExternalWithFederated(storageProviders, startIdx, requiresFederatedStorage);
                return UserStorageManager.queryProviders(providers, pagedQuery, firstResult, maxResults, true);
            }
            count = this.countQueryWithGracefulDegradation(storageProviders.get(startIdx), countQuery, 0, firstResult + 1);
            if (count > firstResult) break;
            if (count == firstResult) {
                ++startIdx;
                firstResult = 0;
                break;
            }
            firstResult = firstResult - count;
        }
        Stream<?> providers = this.concatExternalWithFederated(storageProviders, startIdx, requiresFederatedStorage);
        return UserStorageManager.queryProviders(providers, pagedQuery, firstResult, maxResults, false);
    }

    private Stream<UserModel> queryLocalAndFederatedStorage(PaginatedQuery pagedQuery, CountQuery countQuery, int firstResult, Integer maxResults) {
        assert (firstResult > 0);
        UserProvider localStorage = this.localStorage();
        int count = this.countQueryWithGracefulDegradation(localStorage, countQuery, 0, firstResult + 1);
        if (count <= firstResult) {
            return UserStorageManager.queryProviders(Stream.of(this.getFederatedStorage()), pagedQuery, firstResult - count, maxResults, false);
        }
        return UserStorageManager.queryProviders(Stream.of(localStorage, this.getFederatedStorage()), pagedQuery, firstResult, maxResults, false);
    }

    private Stream<UserModel> queryLocalStorage(PaginatedQuery pagedQuery, int firstResult, Integer maxResults) {
        assert (firstResult > 0);
        return UserStorageManager.queryWithGracefulDegradation(this.localStorage(), pagedQuery, firstResult, maxResults);
    }

    private static Stream<UserModel> queryProviders(Stream<?> providersStream, PaginatedQuery pagedQuery, int offset, Integer maxResults, boolean useStreamSkip) {
        AtomicInteger firstResults;
        AtomicInteger atomicInteger = firstResults = useStreamSkip ? new AtomicInteger(0) : new AtomicInteger(offset);
        if (maxResults == null || maxResults < 0) {
            Stream<UserModel> users = providersStream.flatMap(provider -> UserStorageManager.queryWithGracefulDegradation(provider, pagedQuery, firstResults.getAndSet(0), null));
            return useStreamSkip ? users.skip(offset) : users;
        }
        AtomicInteger currentMax = useStreamSkip ? new AtomicInteger(offset + maxResults) : new AtomicInteger(maxResults);
        Stream<UserModel> users = providersStream.filter(provider -> currentMax.get() != 0).flatMap(provider -> UserStorageManager.queryWithGracefulDegradation(provider, pagedQuery, firstResults.getAndSet(0), currentMax.get())).peek(userModel -> currentMax.updateAndGet(i -> i > 0 ? i - 1 : i));
        return useStreamSkip ? users.skip(offset).limit(maxResults.intValue()) : users.limit(maxResults.intValue());
    }

    private Stream<?> concatExternalWithFederated(List<?> externalStorage, int startIdx, boolean requiresFederatedStorage) {
        Stream providers = externalStorage.subList(startIdx, externalStorage.size()).stream();
        return requiresFederatedStorage ? Stream.concat(providers, Stream.of(this.getFederatedStorage())) : providers;
    }

    private static Stream<UserModel> queryWithGracefulDegradation(Object provider, PaginatedQuery pagedQuery, Integer firstResult, Integer maxResults) {
        try {
            return pagedQuery.query(provider, firstResult, maxResults);
        }
        catch (Exception e) {
            logger.warnf((Throwable)e, "User storage provider %s failed during query operation. Continuing with other providers for graceful degradation. This may indicate an issue with external user store connectivity (e.g., LDAP server down).", (Object)provider.getClass().getSimpleName());
            return Stream.empty();
        }
    }

    private int countQueryWithGracefulDegradation(Object provider, CountQuery countQuery, Integer firstResult, Integer maxResults) {
        try {
            return countQuery.query(provider, firstResult, maxResults);
        }
        catch (Exception e) {
            logger.warnf((Throwable)e, "User storage provider %s failed during count operation. Continuing with other providers for graceful degradation. This may indicate an issue with external user store connectivity (e.g., LDAP server down).", (Object)provider.getClass().getSimpleName());
            return 0;
        }
    }

    private int getTotalUserCountWithGracefulDegradation(RealmModel realm, Function<Object, Integer> countFunction) {
        int localCount = countFunction.apply(this.localStorage());
        Stream providers = this.getEnabledStorageProviders(realm, Object.class);
        int federatedCount = providers.mapToInt(provider -> this.countQueryWithGracefulDegradation(provider, (p, firstResult, maxResults) -> (Integer)countFunction.apply(p), null, null)).sum();
        return localCount + federatedCount;
    }

    private static Stream<UserModel> removeDuplicates(Stream<UserModel> withDuplicates) {
        return withDuplicates.filter(StreamsUtil.distinctByKey(UserModel::getId));
    }

    public UserModel addUser(RealmModel realm, String username) {
        if (username.startsWith("service-account-")) {
            return this.localStorage().addUser(realm, username);
        }
        return this.getEnabledStorageProviders(realm, UserRegistrationProvider.class).map(provider -> provider.addUser(realm, username)).filter(Objects::nonNull).findFirst().orElseGet(() -> this.localStorage().addUser(realm, username.toLowerCase()));
    }

    public boolean removeUser(RealmModel realm, UserModel user) {
        if (this.getFederatedStorage() != null && user.getServiceAccountClientLink() == null) {
            this.getFederatedStorage().preRemove(realm, user);
        }
        this.publishUserPreRemovedEvent(realm, user);
        StorageId storageId = new StorageId(user.getId());
        if (storageId.getProviderId() == null) {
            boolean linkRemoved = !user.isFederated() || Optional.ofNullable((UserRegistrationProvider)this.getStorageProviderInstance(realm, user.getFederationLink(), UserRegistrationProvider.class)).map(provider -> provider.removeUser(realm, user)).orElse(false) != false;
            return this.localStorage().removeUser(realm, user) && linkRemoved;
        }
        UserRegistrationProvider registry = (UserRegistrationProvider)this.getStorageProviderInstance(realm, storageId.getProviderId(), UserRegistrationProvider.class);
        if (registry == null) {
            throw new ModelException("Could not resolve UserRegistrationProvider: " + storageId.getProviderId());
        }
        return registry.removeUser(realm, user);
    }

    public UserModel getUserById(RealmModel realm, String id) {
        StorageId storageId = new StorageId(id);
        if (storageId.getProviderId() == null) {
            UserModel user = this.localStorage().getUserById(realm, id);
            return this.validateUser(realm, user);
        }
        UserLookupProvider provider = (UserLookupProvider)this.getStorageProviderInstance(realm, storageId.getProviderId(), UserLookupProvider.class);
        if (provider == null) {
            return null;
        }
        return provider.getUserById(realm, id);
    }

    public UserModel getUserByUsername(RealmModel realm, String username) {
        return this.getUserByAttribute(realm, provider -> provider.getUserByUsername(realm, username), u -> username.equalsIgnoreCase(u.getUsername()));
    }

    public UserModel getUserByEmail(RealmModel realm, String email) {
        return this.getUserByAttribute(realm, provider -> provider.getUserByEmail(realm, email), u -> email.equalsIgnoreCase(u.getEmail()));
    }

    public Stream<UserModel> getGroupMembersStream(RealmModel realm, GroupModel group, Integer firstResult, Integer maxResults) {
        Stream<UserModel> results = this.query((provider, firstResultInQuery, maxResultsInQuery) -> {
            if (provider instanceof UserQueryMethodsProvider) {
                return ((UserQueryMethodsProvider)provider).getGroupMembersStream(realm, group, firstResultInQuery, maxResultsInQuery);
            }
            if (provider instanceof UserFederatedStorageProvider) {
                return ((UserFederatedStorageProvider)provider).getMembershipStream(realm, group, firstResultInQuery, maxResultsInQuery).map(id -> this.getUserById(realm, (String)id));
            }
            return Stream.empty();
        }, (provider, firstResultInQuery, maxResultsInQuery) -> {
            if (provider instanceof UserCountMethodsProvider) {
                return ((UserCountMethodsProvider)provider).getUsersCount(realm, Set.of(group.getId()));
            }
            return 0;
        }, realm, firstResult, maxResults, true);
        return this.importValidation(realm, results);
    }

    public Stream<UserModel> getGroupMembersStream(RealmModel realm, GroupModel group, String search, Boolean exact, Integer firstResult, Integer maxResults) {
        Stream<UserModel> results = this.query((provider, firstResultInQuery, maxResultsInQuery) -> {
            if (provider instanceof UserQueryMethodsProvider) {
                return ((UserQueryMethodsProvider)provider).getGroupMembersStream(realm, group, search, exact, firstResultInQuery, maxResultsInQuery);
            }
            if (provider instanceof UserFederatedStorageProvider) {
                return StreamsUtil.paginatedStream(((UserFederatedStorageProvider)provider).getMembershipStream(realm, group, null, null).map(id -> this.getUserById(realm, (String)id)).filter(user -> {
                    if (StringUtil.isBlank((String)search)) {
                        return true;
                    }
                    if (Boolean.TRUE.equals(exact)) {
                        return search.equals(user.getUsername()) || search.equals(user.getEmail()) || search.equals(user.getFirstName()) || search.equals(user.getLastName());
                    }
                    return Optional.ofNullable(user.getUsername()).orElse("").toLowerCase().contains(search.toLowerCase()) || Optional.ofNullable(user.getEmail()).orElse("").toLowerCase().contains(search.toLowerCase()) || Optional.ofNullable(user.getFirstName()).orElse("").toLowerCase().contains(search.toLowerCase()) || Optional.ofNullable(user.getLastName()).orElse("").toLowerCase().contains(search.toLowerCase());
                }), (Integer)firstResultInQuery, (Integer)maxResultsInQuery);
            }
            return Stream.empty();
        }, realm, firstResult, maxResults);
        return this.importValidation(realm, results);
    }

    public Stream<UserModel> getRoleMembersStream(RealmModel realm, RoleModel role, Integer firstResult, Integer maxResults) {
        Stream<UserModel> results = this.query((provider, firstResultInQuery, maxResultsInQuery) -> {
            if (provider instanceof UserQueryMethodsProvider) {
                return ((UserQueryMethodsProvider)provider).getRoleMembersStream(realm, role, firstResultInQuery, maxResultsInQuery);
            }
            if (provider instanceof UserFederatedStorageProvider) {
                return ((UserFederatedStorageProvider)provider).getRoleMembersStream(realm, role, firstResultInQuery, maxResultsInQuery).map(id -> this.getUserById(realm, (String)id));
            }
            return Stream.empty();
        }, realm, firstResult, maxResults);
        return this.importValidation(realm, results);
    }

    public int getUsersCount(RealmModel realm, boolean includeServiceAccount) {
        int localStorageUsersCount = this.localStorage().getUsersCount(realm, includeServiceAccount);
        int storageProvidersUsersCount = this.mapEnabledStorageProvidersWithTimeout(realm, UserCountMethodsProvider.class, userQueryProvider -> userQueryProvider.getUsersCount(realm)).reduce(0, Integer::sum);
        return localStorageUsersCount + storageProvidersUsersCount;
    }

    public int getUsersCount(RealmModel realm) {
        return this.getUsersCount(realm, false);
    }

    public int getUsersCount(RealmModel realm, Set<String> groupIds) {
        return this.getTotalUserCountWithGracefulDegradation(realm, provider -> {
            if (provider instanceof UserCountMethodsProvider) {
                return ((UserCountMethodsProvider)provider).getUsersCount(realm, groupIds);
            }
            return 0;
        });
    }

    public int getUsersCount(RealmModel realm, String search) {
        return this.getTotalUserCountWithGracefulDegradation(realm, provider -> {
            if (provider instanceof UserCountMethodsProvider) {
                return ((UserCountMethodsProvider)provider).getUsersCount(realm, search);
            }
            return 0;
        });
    }

    public int getUsersCount(RealmModel realm, String search, Set<String> groupIds) {
        return this.getTotalUserCountWithGracefulDegradation(realm, provider -> {
            if (provider instanceof UserCountMethodsProvider) {
                return ((UserCountMethodsProvider)provider).getUsersCount(realm, search, groupIds);
            }
            return 0;
        });
    }

    public int getUsersCount(RealmModel realm, Map<String, String> params) {
        return this.getTotalUserCountWithGracefulDegradation(realm, provider -> {
            if (provider instanceof UserCountMethodsProvider) {
                return ((UserCountMethodsProvider)provider).getUsersCount(realm, params);
            }
            return 0;
        });
    }

    public int getUsersCount(RealmModel realm, Map<String, String> params, Set<String> groupIds) {
        return this.getTotalUserCountWithGracefulDegradation(realm, provider -> {
            if (provider instanceof UserCountMethodsProvider) {
                return ((UserCountMethodsProvider)provider).getUsersCount(realm, params, groupIds);
            }
            return 0;
        });
    }

    public Stream<UserModel> searchForUserStream(RealmModel realm, Map<String, String> attributes, Integer firstResult, Integer maxResults) {
        Stream<UserModel> results = this.query((provider, firstResultInQuery, maxResultsInQuery) -> {
            if (provider instanceof UserQueryMethodsProvider) {
                return ((UserQueryMethodsProvider)provider).searchForUserStream(realm, attributes, firstResultInQuery, maxResultsInQuery);
            }
            return Stream.empty();
        }, (provider, firstResultInQuery, maxResultsInQuery) -> {
            if (provider instanceof UserCountMethodsProvider) {
                return ((UserCountMethodsProvider)provider).getUsersCount(realm, attributes);
            }
            return 0;
        }, realm, firstResult, maxResults, false);
        return this.importValidation(realm, results);
    }

    public Stream<UserModel> searchForUserByUserAttributeStream(RealmModel realm, String attrName, String attrValue) {
        Stream<UserModel> results = this.query((provider, firstResultInQuery, maxResultsInQuery) -> {
            if (provider instanceof UserQueryMethodsProvider) {
                return StreamsUtil.paginatedStream((Stream)((UserQueryMethodsProvider)provider).searchForUserByUserAttributeStream(realm, attrName, attrValue), (Integer)firstResultInQuery, (Integer)maxResultsInQuery);
            }
            if (provider instanceof UserFederatedStorageProvider) {
                return StreamsUtil.paginatedStream(((UserFederatedStorageProvider)provider).getUsersByUserAttributeStream(realm, attrName, attrValue).map(id -> this.getUserById(realm, (String)id)).filter(Objects::nonNull), (Integer)firstResultInQuery, (Integer)maxResultsInQuery);
            }
            return Stream.empty();
        }, realm, null, null);
        results = UserStorageManager.removeDuplicates(results);
        return this.importValidation(realm, results);
    }

    public void grantToAllUsers(RealmModel realm, RoleModel role) {
        this.localStorage().grantToAllUsers(realm, role);
        this.consumeEnabledStorageProvidersWithTimeout(realm, UserBulkUpdateProvider.class, provider -> provider.grantToAllUsers(realm, role));
    }

    public void preRemove(RealmModel realm) {
        this.localStorage().preRemove(realm);
        if (this.getFederatedStorage() != null) {
            this.getFederatedStorage().preRemove(realm);
        }
        this.consumeEnabledStorageProvidersWithTimeout(realm, UserStorageProvider.class, provider -> provider.preRemove(realm));
    }

    public void preRemove(RealmModel realm, GroupModel group) {
        this.localStorage().preRemove(realm, group);
        if (this.getFederatedStorage() != null) {
            this.getFederatedStorage().preRemove(realm, group);
        }
        this.consumeEnabledStorageProvidersWithTimeout(realm, UserStorageProvider.class, provider -> provider.preRemove(realm, group));
    }

    public void preRemove(RealmModel realm, RoleModel role) {
        this.localStorage().preRemove(realm, role);
        if (this.getFederatedStorage() != null) {
            this.getFederatedStorage().preRemove(realm, role);
        }
        this.consumeEnabledStorageProvidersWithTimeout(realm, UserStorageProvider.class, provider -> provider.preRemove(realm, role));
    }

    public UserModel addUser(RealmModel realm, String id, String username, boolean addDefaultRoles, boolean addDefaultRequiredActions) {
        return this.localStorage().addUser(realm, id, username.toLowerCase(), addDefaultRoles, addDefaultRequiredActions);
    }

    public void addFederatedIdentity(final RealmModel realm, final UserModel user, final FederatedIdentityModel socialLink) {
        if (StorageId.isLocalStorage((String)user.getId())) {
            this.localStorage().addFederatedIdentity(realm, user, socialLink);
        } else {
            this.getFederatedStorage().addFederatedIdentity(realm, user.getId(), socialLink);
        }
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new FederatedIdentityModel.FederatedIdentityCreatedEvent(){

            public KeycloakSession getKeycloakSession() {
                return UserStorageManager.this.session;
            }

            public RealmModel getRealm() {
                return realm;
            }

            public UserModel getUser() {
                return user;
            }

            public FederatedIdentityModel getFederatedIdentity() {
                return socialLink;
            }
        });
    }

    public void updateFederatedIdentity(RealmModel realm, UserModel federatedUser, FederatedIdentityModel federatedIdentityModel) {
        if (StorageId.isLocalStorage((String)federatedUser.getId())) {
            this.localStorage().updateFederatedIdentity(realm, federatedUser, federatedIdentityModel);
        } else {
            this.getFederatedStorage().updateFederatedIdentity(realm, federatedUser.getId(), federatedIdentityModel);
        }
    }

    public boolean removeFederatedIdentity(final RealmModel realm, final UserModel user, String socialProvider) {
        FederatedIdentityModel federatedIdentityModel;
        if (StorageId.isLocalStorage((String)user.getId())) {
            UserProvider localStorage = this.localStorage();
            federatedIdentityModel = localStorage.getFederatedIdentity(realm, user, socialProvider);
            localStorage.removeFederatedIdentity(realm, user, socialProvider);
        } else {
            UserFederatedStorageProvider federatedStorage = this.getFederatedStorage();
            federatedIdentityModel = federatedStorage.getFederatedIdentity(user.getId(), socialProvider, realm);
            federatedStorage.removeFederatedIdentity(realm, user.getId(), socialProvider);
        }
        if (federatedIdentityModel == null) {
            return false;
        }
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new FederatedIdentityModel.FederatedIdentityRemovedEvent(){

            public KeycloakSession getKeycloakSession() {
                return UserStorageManager.this.session;
            }

            public RealmModel getRealm() {
                return realm;
            }

            public UserModel getUser() {
                return user;
            }

            public FederatedIdentityModel getFederatedIdentity() {
                return federatedIdentityModel;
            }
        });
        return true;
    }

    public void preRemove(RealmModel realm, IdentityProviderModel provider) {
        this.localStorage().preRemove(realm, provider);
        this.getFederatedStorage().preRemove(realm, provider);
    }

    public void addConsent(RealmModel realm, String userId, UserConsentModel consent) {
        if (StorageId.isLocalStorage((String)userId)) {
            this.localStorage().addConsent(realm, userId, consent);
        } else {
            this.getFederatedStorage().addConsent(realm, userId, consent);
        }
    }

    public UserConsentModel getConsentByClient(RealmModel realm, String userId, String clientInternalId) {
        if (StorageId.isLocalStorage((String)userId)) {
            return this.localStorage().getConsentByClient(realm, userId, clientInternalId);
        }
        return this.getFederatedStorage().getConsentByClient(realm, userId, clientInternalId);
    }

    public Stream<UserConsentModel> getConsentsStream(RealmModel realm, String userId) {
        if (StorageId.isLocalStorage((String)userId)) {
            return this.localStorage().getConsentsStream(realm, userId);
        }
        return this.getFederatedStorage().getConsentsStream(realm, userId);
    }

    public void updateConsent(RealmModel realm, String userId, UserConsentModel consent) {
        if (StorageId.isLocalStorage((String)userId)) {
            this.localStorage().updateConsent(realm, userId, consent);
        } else {
            this.getFederatedStorage().updateConsent(realm, userId, consent);
        }
    }

    public boolean revokeConsentForClient(RealmModel realm, String userId, String clientInternalId) {
        if (StorageId.isLocalStorage((String)userId)) {
            return this.localStorage().revokeConsentForClient(realm, userId, clientInternalId);
        }
        return this.getFederatedStorage().revokeConsentForClient(realm, userId, clientInternalId);
    }

    public void setNotBeforeForUser(RealmModel realm, UserModel user, int notBefore) {
        if (StorageId.isLocalStorage((String)user.getId())) {
            this.localStorage().setNotBeforeForUser(realm, user, notBefore);
        } else {
            this.getFederatedStorage().setNotBeforeForUser(realm, user.getId(), notBefore);
        }
    }

    public int getNotBeforeOfUser(RealmModel realm, UserModel user) {
        if (StorageId.isLocalStorage((String)user.getId())) {
            return this.localStorage().getNotBeforeOfUser(realm, user);
        }
        return this.getFederatedStorage().getNotBeforeOfUser(realm, user.getId());
    }

    public UserModel getUserByFederatedIdentity(RealmModel realm, FederatedIdentityModel socialLink) {
        UserModel user = this.localStorage().getUserByFederatedIdentity(realm, socialLink);
        if (user != null) {
            return this.validateUser(realm, user);
        }
        if (this.getFederatedStorage() == null) {
            return null;
        }
        String id = this.getFederatedStorage().getUserByFederatedIdentity(socialLink, realm);
        if (id != null) {
            return this.getUserById(realm, id);
        }
        return null;
    }

    public UserModel getServiceAccount(ClientModel client) {
        return this.localStorage().getServiceAccount(client);
    }

    public Stream<FederatedIdentityModel> getFederatedIdentitiesStream(RealmModel realm, UserModel user) {
        Stream stream;
        if (user == null) {
            throw new IllegalStateException("Federated user no longer valid");
        }
        Stream stream2 = stream = StorageId.isLocalStorage((String)user.getId()) ? this.localStorage().getFederatedIdentitiesStream(realm, user) : Stream.empty();
        if (this.getFederatedStorage() != null) {
            stream = Stream.concat(stream, this.getFederatedStorage().getFederatedIdentitiesStream(user.getId(), realm));
        }
        return stream.distinct();
    }

    public FederatedIdentityModel getFederatedIdentity(RealmModel realm, UserModel user, String socialProvider) {
        FederatedIdentityModel model;
        if (user == null) {
            throw new IllegalStateException("Federated user no longer valid");
        }
        if (StorageId.isLocalStorage((String)user.getId()) && (model = this.localStorage().getFederatedIdentity(realm, user, socialProvider)) != null) {
            return model;
        }
        if (this.getFederatedStorage() != null) {
            return this.getFederatedStorage().getFederatedIdentity(user.getId(), socialProvider, realm);
        }
        return null;
    }

    public void preRemove(RealmModel realm, ClientModel client) {
        this.localStorage().preRemove(realm, client);
        if (this.getFederatedStorage() != null) {
            this.getFederatedStorage().preRemove(realm, client);
        }
    }

    public void preRemove(ProtocolMapperModel protocolMapper) {
        this.localStorage().preRemove(protocolMapper);
        if (this.getFederatedStorage() != null) {
            this.getFederatedStorage().preRemove(protocolMapper);
        }
    }

    public void preRemove(ClientScopeModel clientScope) {
        this.localStorage().preRemove(clientScope);
        if (this.getFederatedStorage() != null) {
            this.getFederatedStorage().preRemove(clientScope);
        }
    }

    public void preRemove(RealmModel realm, ComponentModel component) {
        if (component.getProviderType().equals(ClientStorageProvider.class.getName())) {
            this.localStorage().preRemove(realm, component);
            if (this.getFederatedStorage() != null) {
                this.getFederatedStorage().preRemove(realm, component);
            }
            return;
        }
        if (!component.getProviderType().equals(UserStorageProvider.class.getName())) {
            return;
        }
        this.localStorage().preRemove(realm, component);
        if (this.getFederatedStorage() != null) {
            this.getFederatedStorage().preRemove(realm, component);
        }
        StoreSyncEvent.fire((KeycloakSession)this.session, (RealmModel)realm, (ComponentModel)component, (boolean)true);
    }

    public void removeImportedUsers(RealmModel realm, String storageProviderId) {
        this.localStorage().removeImportedUsers(realm, storageProviderId);
    }

    public void unlinkUsers(RealmModel realm, String storageProviderId) {
        this.localStorage().unlinkUsers(realm, storageProviderId);
    }

    public void close() {
    }

    public void onCreate(final KeycloakSession session, final RealmModel realm, final ComponentModel model) {
        ComponentFactory factory = ComponentUtil.getComponentFactory((KeycloakSession)session, (ComponentModel)model);
        if (!(factory instanceof UserStorageProviderFactory)) {
            return;
        }
        session.getTransactionManager().enlistAfterCompletion((KeycloakTransaction)new AbstractKeycloakTransaction(){

            protected void commitImpl() {
                StoreSyncEvent.fire((KeycloakSession)session, (RealmModel)realm, (ComponentModel)model, (boolean)false);
            }

            protected void rollbackImpl() {
            }
        });
    }

    public void onUpdate(KeycloakSession session, RealmModel realm, ComponentModel oldModel, ComponentModel newModel) {
        ComponentFactory factory = ComponentUtil.getComponentFactory((KeycloakSession)session, (ComponentModel)newModel);
        if (!(factory instanceof UserStorageProviderFactory)) {
            return;
        }
        UserStorageProviderModel previous = new UserStorageProviderModel(oldModel);
        UserStorageProviderModel actual = new UserStorageProviderModel(newModel);
        if (this.isSyncSettingsUpdated(previous, actual)) {
            StoreSyncEvent.fire((KeycloakSession)session, (RealmModel)realm, (ComponentModel)actual, (boolean)false);
        }
    }

    public void onCache(RealmModel realm, CachedUserModel user, UserModel delegate) {
        if (StorageId.isLocalStorage((String)user.getId())) {
            if (UserStoragePrivateUtil.userLocalStorage(this.session) instanceof OnUserCache) {
                ((OnUserCache)UserStoragePrivateUtil.userLocalStorage(this.session)).onCache(realm, user, delegate);
            }
        } else {
            OnUserCache provider = (OnUserCache)this.getStorageProviderInstance(realm, StorageId.providerId((String)user.getId()), OnUserCache.class);
            if (provider != null) {
                provider.onCache(realm, user, delegate);
            }
        }
    }

    public List<AttributeMetadata> decorateUserProfile(String providerId, UserProfileMetadata metadata) {
        UserProfileDecorator decorator;
        RealmModel realm = this.session.getContext().getRealm();
        UserStorageProviderModel providerModel = (UserStorageProviderModel)this.getStorageProviderModel(realm, providerId);
        if (providerModel != null && (decorator = (UserProfileDecorator)this.getStorageProviderInstance((CacheableStorageProviderModel)providerModel, UserProfileDecorator.class)) != null) {
            return decorator.decorateUserProfile(providerId, metadata);
        }
        return Collections.emptyList();
    }

    public UserCredentialManager getUserCredentialManager(UserModel user) {
        return new org.keycloak.credential.UserCredentialManager(this.session, this.session.getContext().getRealm(), user);
    }

    private boolean isReadOnlyOrganizationMember(UserModel delegate) {
        if (delegate == null) {
            return false;
        }
        if (!Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ORGANIZATION)) {
            return false;
        }
        OrganizationProvider organizationProvider = (OrganizationProvider)this.session.getProvider(OrganizationProvider.class);
        if (organizationProvider.count() == 0L) {
            return false;
        }
        return organizationProvider.getByMember(delegate).anyMatch(org -> organizationProvider.isEnabled() && org.isManaged(delegate) && !org.isEnabled() || !organizationProvider.isEnabled() && org.isManaged(delegate));
    }

    private void publishUserPreRemovedEvent(final RealmModel realm, final UserModel user) {
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new UserModel.UserPreRemovedEvent(){

            public RealmModel getRealm() {
                return realm;
            }

            public UserModel getUser() {
                return user;
            }

            public KeycloakSession getKeycloakSession() {
                return UserStorageManager.this.session;
            }
        });
    }

    private UserModel getUserByAttribute(RealmModel realm, Function<UserLookupProvider, UserModel> loader, Predicate<UserModel> attributeValidator) {
        UserModel user = loader.apply((UserLookupProvider)this.localStorage());
        if (user != null) {
            UserModel validated = this.validateUser(realm, user);
            if (validated != null && attributeValidator.test(validated)) {
                return validated;
            }
            this.deleteInvalidUserCache(realm, user);
        }
        return this.tryResolveFederatedUser(realm, loader);
    }

    private UserModel tryResolveFederatedUser(RealmModel realm, Function<UserLookupProvider, UserModel> loader) {
        return this.mapEnabledStorageProvidersWithTimeout(realm, UserLookupProvider.class, provider -> {
            try {
                return (UserModel)loader.apply((UserLookupProvider)provider);
            }
            catch (StorageUnavailableException e) {
                logger.warnf((Throwable)e, "User storage provider %s is unavailable. Continuing with other providers for graceful degradation.", (Object)provider.getClass().getSimpleName());
                return null;
            }
        }).findFirst().orElse(null);
    }

    private boolean isSyncSettingsUpdated(UserStorageProviderModel previous, UserStorageProviderModel actual) {
        return previous.getChangedSyncPeriod() != actual.getChangedSyncPeriod() || previous.getFullSyncPeriod() != actual.getFullSyncPeriod() || previous.isImportEnabled() != actual.isImportEnabled() || previous.isEnabled() != actual.isEnabled();
    }

    @FunctionalInterface
    protected static interface PaginatedQuery {
        public Stream<UserModel> query(Object var1, Integer var2, Integer var3);
    }

    @FunctionalInterface
    protected static interface CountQuery {
        public int query(Object var1, Integer var2, Integer var3);
    }
}

