/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query;

import java.util.List;
import org.hibernate.Incubating;
import org.hibernate.query.KeyedPage;
import org.hibernate.query.Order;

@Incubating
public class Page {
    private final int size;
    private final int number;

    public int getSize() {
        return this.size;
    }

    public int getNumber() {
        return this.number;
    }

    public boolean isFirst() {
        return this.number == 0;
    }

    public int getMaxResults() {
        return this.size;
    }

    public int getFirstResult() {
        return this.size * this.number;
    }

    Page(int size, int number) {
        if (size <= 0) {
            throw new IllegalArgumentException("page size must be strictly positive");
        }
        if (number < 0) {
            throw new IllegalArgumentException("page number must be non-negative");
        }
        this.size = size;
        this.number = number;
    }

    public static Page page(int size, int number) {
        return new Page(size, number);
    }

    public static Page first(int size) {
        return new Page(size, 0);
    }

    public Page next() {
        return new Page(this.size, this.number + 1);
    }

    public Page previous() {
        if (this.isFirst()) {
            throw new IllegalStateException("already at first page");
        }
        return new Page(this.size, this.number - 1);
    }

    public Page first() {
        return Page.first(this.size);
    }

    public <R> KeyedPage<R> keyedBy(Order<? super R> keyDefinition) {
        if (keyDefinition == null) {
            throw new IllegalArgumentException("Key definition must not null");
        }
        return new KeyedPage<R>(List.of(keyDefinition), this);
    }

    public <R> KeyedPage<R> keyedBy(List<Order<? super R>> keyDefinition) {
        if (keyDefinition == null || keyDefinition.isEmpty()) {
            throw new IllegalArgumentException("Key definition must not be empty or null");
        }
        return new KeyedPage<R>(keyDefinition, this);
    }
}

