/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicArrowButton;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadParams;
import org.openstreetmap.josm.actions.downloadtasks.PostDownloadHandler;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.preferences.AbstractProperty;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.download.AbstractDownloadSourcePanel;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.download.DownloadSettings;
import org.openstreetmap.josm.gui.download.DownloadSource;
import org.openstreetmap.josm.gui.download.DownloadSourceSizingPolicy;
import org.openstreetmap.josm.gui.download.UserQueryList;
import org.openstreetmap.josm.gui.download.overpass.OverpassWizardRegistration;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.io.OverpassDownloadReader;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class OverpassDownloadSource
implements DownloadSource<OverpassDownloadData> {
    public static final String FULL_DOWNLOAD_QUERY = "[out:xml]; \n(\n    node({{bbox}});\n<;\n);\n(._;>;);out meta;";

    @Override
    public AbstractDownloadSourcePanel<OverpassDownloadData> createPanel(DownloadDialog dialog) {
        return new OverpassDownloadSourcePanel(this);
    }

    @Override
    public void doDownload(OverpassDownloadData data, DownloadSettings settings) {
        Bounds area = settings.getDownloadBounds().orElse(new Bounds(0.0, 0.0, 0.0, 0.0));
        DownloadOsmTask task = new DownloadOsmTask();
        task.setZoomAfterDownload(settings.zoomToData());
        Future<?> future = task.download(new OverpassDownloadReader(area, OverpassDownloadReader.OVERPASS_SERVER.get(), data.getQuery()), new DownloadParams().withNewLayer(settings.asNewLayer()), area, null);
        MainApplication.worker.submit(new PostDownloadHandler(task, future, data.getErrorReporter()));
    }

    @Override
    public String getLabel() {
        return I18n.tr("Download from Overpass API", new Object[0]);
    }

    @Override
    public boolean onlyExpert() {
        return true;
    }

    static class OverpassDownloadData {
        private final String query;
        private final Consumer<Collection<Object>> errorReporter;

        OverpassDownloadData(String query, Consumer<Collection<Object>> errorReporter) {
            this.query = query;
            this.errorReporter = errorReporter;
        }

        String getQuery() {
            return this.query;
        }

        Consumer<Collection<Object>> getErrorReporter() {
            return this.errorReporter;
        }
    }

    public static class OverpassDownloadSourcePanel
    extends AbstractDownloadSourcePanel<OverpassDownloadData>
    implements OverpassWizardRegistration.OverpassWizardCallbacks {
        private static final String SIMPLE_NAME = "overpassdownloadpanel";
        private static final AbstractProperty<Integer> PANEL_SIZE_PROPERTY = new IntegerProperty("download.tabsplit.overpassdownloadpanel", 150).cached();
        private static final BooleanProperty OVERPASS_QUERY_LIST_OPENED = new BooleanProperty("download.overpass.query-list.opened", false);
        private static final String ACTION_IMG_SUBDIR = "dialogs";
        private static final StringProperty DOWNLOAD_QUERY = new StringProperty("download.overpass.query", "/*\n" + I18n.tr("Place your Overpass query below or generate one using the query wizard", new Object[0]) + "\n*/");
        private final JosmTextArea overpassQuery;
        private final UserQueryList overpassQueryList;

        public OverpassDownloadSourcePanel(OverpassDownloadSource ds) {
            super(ds);
            this.setLayout(new BorderLayout());
            this.overpassQuery = new JosmTextArea(DOWNLOAD_QUERY.get(), 8, 80);
            this.overpassQuery.setFont(GuiHelper.getMonospacedFont(this.overpassQuery));
            this.overpassQuery.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    overpassQuery.selectAll();
                }
            });
            this.overpassQueryList = new UserQueryList(this, this.overpassQuery, "download.overpass.queries");
            this.overpassQueryList.setPreferredSize(new Dimension(350, 300));
            EditSnippetAction edit = new EditSnippetAction();
            RemoveSnippetAction remove = new RemoveSnippetAction();
            this.overpassQueryList.addSelectionListener(edit);
            this.overpassQueryList.addSelectionListener(remove);
            JPanel listPanel = new JPanel(new GridBagLayout());
            listPanel.add((Component)new JLabel(I18n.tr("Your saved queries:", new Object[0])), GBC.eol().insets(2).anchor(10));
            listPanel.add((Component)this.overpassQueryList, GBC.eol().fill(1));
            listPanel.add((Component)new JButton(new AddSnippetAction()), GBC.std().fill(2));
            listPanel.add((Component)new JButton(edit), GBC.std().fill(2));
            listPanel.add((Component)new JButton(remove), GBC.std().fill(2));
            listPanel.setVisible(OVERPASS_QUERY_LIST_OPENED.get());
            JScrollPane scrollPane = new JScrollPane(this.overpassQuery);
            BasicArrowButton arrowButton = new BasicArrowButton(listPanel.isVisible() ? 3 : 7);
            arrowButton.setToolTipText(I18n.tr("Show/hide Overpass snippet list", new Object[0]));
            arrowButton.addActionListener(e -> {
                if (listPanel.isVisible()) {
                    listPanel.setVisible(false);
                    arrowButton.setDirection(7);
                    OVERPASS_QUERY_LIST_OPENED.put(Boolean.FALSE);
                } else {
                    listPanel.setVisible(true);
                    arrowButton.setDirection(3);
                    OVERPASS_QUERY_LIST_OPENED.put(Boolean.TRUE);
                }
            });
            JPanel innerPanel = new JPanel(new BorderLayout());
            innerPanel.add((Component)scrollPane, "Center");
            innerPanel.add((Component)arrowButton, "East");
            JPanel leftPanel = new JPanel(new GridBagLayout());
            leftPanel.add((Component)new JLabel(I18n.tr("Overpass query:", new Object[0])), GBC.eol().insets(5, 1, 5, 1).anchor(18));
            leftPanel.add((Component)new JLabel(), GBC.eol().fill(3));
            OverpassWizardRegistration.getWizards(this).stream().map(JButton::new).forEach(button -> leftPanel.add((Component)button, GBC.eol().anchor(10)));
            leftPanel.add((Component)new JLabel(), GBC.eol().fill(3));
            leftPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.add((Component)leftPanel, "West");
            this.add((Component)innerPanel, "Center");
            this.add((Component)listPanel, "East");
            this.setMinimumSize(new Dimension(450, 240));
        }

        @Override
        public OverpassDownloadData getData() {
            String query = this.overpassQuery.getText();
            Consumer<Collection<Object>> errorReporter = errors -> {
                boolean onlyNoDataError;
                boolean bl = onlyNoDataError = errors.size() == 1 && errors.contains("No data found in this area.");
                if (errors.isEmpty() || onlyNoDataError) {
                    this.overpassQueryList.saveHistoricItem(query);
                }
            };
            return new OverpassDownloadData(OverpassDownloadReader.fixQuery(query), errorReporter);
        }

        @Override
        public void rememberSettings() {
            DOWNLOAD_QUERY.put(this.overpassQuery.getText());
        }

        @Override
        public void restoreSettings() {
            this.overpassQuery.setText(DOWNLOAD_QUERY.get());
        }

        @Override
        public boolean checkDownload(DownloadSettings settings) {
            String query = this.getData().getQuery();
            if (!settings.getDownloadBounds().isPresent() && query.contains("{{bbox}}")) {
                JOptionPane.showMessageDialog(this.getParent(), I18n.tr("Please select a download area first.", new Object[0]), I18n.tr("Error", new Object[0]), 0);
                return false;
            }
            if (query.matches("(/\\*(\\*[^/]|[^\\*/])*\\*/|\\s)*")) {
                boolean doFix = ConditionalOptionPaneUtil.showConfirmationDialog("download.overpass.fix.emptytoall", this, I18n.tr("You entered an empty query. Do you want to download all data in this area instead?", new Object[0]), I18n.tr("Download all data?", new Object[0]), 0, 3, 0);
                if (doFix) {
                    this.overpassQuery.setText(OverpassDownloadSource.FULL_DOWNLOAD_QUERY);
                } else {
                    return false;
                }
            }
            return true;
        }

        public void setOverpassQuery(String query) {
            Objects.requireNonNull(query, "query");
            this.overpassQuery.setText(query);
        }

        @Override
        public Icon getIcon() {
            return ImageProvider.get("download-overpass");
        }

        @Override
        public String getSimpleName() {
            return SIMPLE_NAME;
        }

        @Override
        public DownloadSourceSizingPolicy getSizingPolicy() {
            return new DownloadSourceSizingPolicy.AdjustableDownloadSizePolicy(PANEL_SIZE_PROPERTY, () -> 50);
        }

        @Override
        public void submitWizardResult(String resultingQuery) {
            this.setOverpassQuery(resultingQuery);
        }

        private class EditSnippetAction
        extends AbstractAction
        implements ListSelectionListener {
            EditSnippetAction() {
                new ImageProvider(OverpassDownloadSourcePanel.ACTION_IMG_SUBDIR, "edit").getResource().attachImageIcon(this, true);
                this.putValue("ShortDescription", I18n.tr("Edit selected snippet", new Object[0]));
                this.checkEnabled();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                OverpassDownloadSourcePanel.this.overpassQueryList.editSelectedItem();
            }

            void checkEnabled() {
                this.setEnabled(OverpassDownloadSourcePanel.this.overpassQueryList.getSelectedItem().isPresent());
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                this.checkEnabled();
            }
        }

        private class RemoveSnippetAction
        extends AbstractAction
        implements ListSelectionListener {
            RemoveSnippetAction() {
                new ImageProvider(OverpassDownloadSourcePanel.ACTION_IMG_SUBDIR, "delete").getResource().attachImageIcon(this, true);
                this.putValue("ShortDescription", I18n.tr("Delete selected snippet", new Object[0]));
                this.checkEnabled();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                OverpassDownloadSourcePanel.this.overpassQueryList.removeSelectedItem();
            }

            void checkEnabled() {
                this.setEnabled(OverpassDownloadSourcePanel.this.overpassQueryList.getSelectedItem().isPresent());
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                this.checkEnabled();
            }
        }

        private class AddSnippetAction
        extends AbstractAction {
            AddSnippetAction() {
                new ImageProvider(OverpassDownloadSourcePanel.ACTION_IMG_SUBDIR, "add").getResource().attachImageIcon(this, true);
                this.putValue("ShortDescription", I18n.tr("Add new snippet", new Object[0]));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                OverpassDownloadSourcePanel.this.overpassQueryList.createNewItem();
            }
        }
    }
}

