import { jsx as _jsx } from "react/jsx-runtime";
import { Text } from 'ink';
import { theme } from '../semantic-colors.js';
import { useUIState } from '../contexts/UIStateContext.js';
export const ShortcutsHint = () => {
    const { shortcutsHelpVisible } = useUIState();
    const highlightColor = shortcutsHelpVisible
        ? theme.text.accent
        : theme.text.secondary;
    return _jsx(Text, { color: highlightColor, children: " ? for shortcuts " });
};
//# sourceMappingURL=ShortcutsHint.js.map