/**
 * @license
 * Copyright 2026 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import type React from 'react';
import type { Question } from '@google/gemini-cli-core';
/**
 * Props for the AskUserDialog component.
 */
interface AskUserDialogProps {
    /**
     * The list of questions to ask the user.
     */
    questions: Question[];
    /**
     * Callback fired when the user submits their answers.
     * Returns a map of question index to answer string.
     */
    onSubmit: (answers: {
        [questionIndex: string]: string;
    }) => void;
    /**
     * Callback fired when the user cancels the dialog (e.g. via Escape).
     */
    onCancel: () => void;
    /**
     * Optional callback to notify parent when text input is active.
     * Useful for managing global keypress handlers.
     */
    onActiveTextInputChange?: (active: boolean) => void;
    /**
     * Width of the dialog.
     */
    width: number;
    /**
     * Height constraint for scrollable content.
     */
    availableHeight?: number;
}
export declare const AskUserDialog: React.FC<AskUserDialogProps>;
export {};
