/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.datatypes;

import com.hivemq.client.annotations.Immutable;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicFilterImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicFilterImplBuilder;
import com.hivemq.client.internal.util.ByteArrayUtil;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.mqtt.datatypes.MqttSharedTopicFilter;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public class MqttSharedTopicFilterImpl
extends MqttTopicFilterImpl
implements MqttSharedTopicFilter {
    private static final int SHARE_PREFIX_LENGTH = "$share/".length();
    private int filterByteStart;
    private int filterCharStart;

    static boolean isShared(@NotNull String string) {
        return string.startsWith("$share/");
    }

    static boolean isShared(byte @NotNull [] binary) {
        if (binary.length < SHARE_PREFIX_LENGTH) {
            return false;
        }
        for (int i = 0; i < SHARE_PREFIX_LENGTH; ++i) {
            if (binary[i] == "$share/".charAt(i)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    static MqttSharedTopicFilterImpl ofInternal(@NotNull String string) {
        char c;
        int shareNameEnd;
        for (shareNameEnd = SHARE_PREFIX_LENGTH; shareNameEnd < string.length() && (c = string.charAt(shareNameEnd)) != '/'; ++shareNameEnd) {
            if (c == '#') {
                throw new IllegalArgumentException(MqttSharedTopicFilterImpl.shareNameNoMultiLevelWildcard(MqttSharedTopicFilterImpl.getShareName(string), shareNameEnd));
            }
            if (c != '+') continue;
            throw new IllegalArgumentException(MqttSharedTopicFilterImpl.shareNameNoSingleLevelWildcard(MqttSharedTopicFilterImpl.getShareName(string), shareNameEnd));
        }
        if (shareNameEnd == SHARE_PREFIX_LENGTH) {
            throw new IllegalArgumentException("Share name must be at least one character long.");
        }
        if (shareNameEnd >= string.length() - 1) {
            throw new IllegalArgumentException("Topic filter must be at least one character long.");
        }
        int wildcardFlags = MqttSharedTopicFilterImpl.validateWildcards(string, shareNameEnd + 1);
        return new MqttSharedTopicFilterImpl(string, shareNameEnd, wildcardFlags);
    }

    @Nullable
    static MqttSharedTopicFilterImpl ofInternal(byte @NotNull [] binary) {
        byte b;
        int shareNameEnd;
        for (shareNameEnd = SHARE_PREFIX_LENGTH; shareNameEnd < binary.length && (b = binary[shareNameEnd]) != 47; ++shareNameEnd) {
            if (b != 35 && b != 43) continue;
            return null;
        }
        if (shareNameEnd == SHARE_PREFIX_LENGTH || shareNameEnd >= binary.length - 1) {
            return null;
        }
        int wildcardFlags = MqttSharedTopicFilterImpl.validateWildcards(binary, shareNameEnd + 1);
        if (wildcardFlags == -1) {
            return null;
        }
        return new MqttSharedTopicFilterImpl(binary, shareNameEnd, wildcardFlags);
    }

    @Contract(value="null, _ -> fail; _, null -> fail")
    @NotNull
    public static MqttSharedTopicFilterImpl of(@Nullable String shareName, @Nullable String topicFilter) {
        MqttSharedTopicFilterImpl.checkShareName(shareName);
        Checks.notEmpty(topicFilter, "Topic filter");
        MqttSharedTopicFilterImpl.checkWellFormed(topicFilter, "Topic filter");
        String sharedTopicFilter = MqttSharedTopicFilterImpl.sharedTopicFilter(shareName, topicFilter);
        MqttSharedTopicFilterImpl.checkLength(sharedTopicFilter, "Shared topic filter");
        int wildcardFlags = MqttSharedTopicFilterImpl.validateWildcards(topicFilter, 0);
        return new MqttSharedTopicFilterImpl(sharedTopicFilter, MqttSharedTopicFilterImpl.shareNameCharEnd(shareName), wildcardFlags);
    }

    @Contract(value="null, _ -> fail")
    @NotNull
    public static MqttSharedTopicFilterImpl of(@Nullable String shareName, @NotNull MqttTopicFilterImpl topicFilter) {
        MqttSharedTopicFilterImpl.checkShareName(shareName);
        String sharedTopicFilter = MqttSharedTopicFilterImpl.sharedTopicFilter(shareName, topicFilter.getTopicFilterString());
        MqttSharedTopicFilterImpl.checkLength(sharedTopicFilter, "Shared topic filter");
        return new MqttSharedTopicFilterImpl(sharedTopicFilter, MqttSharedTopicFilterImpl.shareNameCharEnd(shareName), topicFilter.wildcardFlags);
    }

    @Contract(value="null -> fail")
    private static void checkShareName(@Nullable String shareName) {
        Checks.notEmpty(shareName, "Share name");
        MqttSharedTopicFilterImpl.checkWellFormed(shareName, "Share name");
        for (int i = 0; i < shareName.length(); ++i) {
            char c = shareName.charAt(i);
            if (c == '#') {
                throw new IllegalArgumentException(MqttSharedTopicFilterImpl.shareNameNoMultiLevelWildcard(shareName, i));
            }
            if (c == '+') {
                throw new IllegalArgumentException(MqttSharedTopicFilterImpl.shareNameNoSingleLevelWildcard(shareName, i));
            }
            if (c != '/') continue;
            throw new IllegalArgumentException("Share name [" + shareName + "] must not contain topic level separator (" + '/' + "), found at index: " + i + ".");
        }
    }

    @NotNull
    private static String getShareName(@NotNull String sharedTopicFilter) {
        int shareNameEnd = sharedTopicFilter.indexOf(47, SHARE_PREFIX_LENGTH);
        return sharedTopicFilter.substring(SHARE_PREFIX_LENGTH, shareNameEnd == -1 ? sharedTopicFilter.length() : shareNameEnd);
    }

    @NotNull
    private static String shareNameNoMultiLevelWildcard(@NotNull String shareName, int index) {
        return "Share name [" + shareName + "] must not contain multi level wildcard (" + '#' + "), found at index " + index + ".";
    }

    @NotNull
    private static String shareNameNoSingleLevelWildcard(@NotNull String shareName, int index) {
        return "Share name [" + shareName + "] must not contain single level wildcard (" + '+' + "), found at index " + index + ".";
    }

    @NotNull
    private static String sharedTopicFilter(@NotNull String shareName, @NotNull String topicFilter) {
        return "$share/" + shareName + '/' + topicFilter;
    }

    private static int shareNameCharEnd(@NotNull String shareName) {
        return SHARE_PREFIX_LENGTH + shareName.length();
    }

    private MqttSharedTopicFilterImpl(byte @NotNull [] binary, int shareNameByteEnd, int wildcardFlags) {
        super(binary, wildcardFlags);
        this.filterByteStart = shareNameByteEnd + 1;
        this.filterCharStart = -1;
    }

    private MqttSharedTopicFilterImpl(@NotNull String string, int shareNameCharEnd, int wildcardFlags) {
        super(string, wildcardFlags);
        this.filterByteStart = -1;
        this.filterCharStart = shareNameCharEnd + 1;
    }

    @Override
    public boolean isShared() {
        return true;
    }

    @Override
    @NotNull
    public String getShareName() {
        return this.toString().substring(SHARE_PREFIX_LENGTH, this.getFilterCharStart() - 1);
    }

    @Override
    @NotNull
    public String getTopicFilterString() {
        return this.toString().substring(this.getFilterCharStart());
    }

    @Override
    @NotNull
    public MqttTopicFilterImpl getTopicFilter() {
        return MqttTopicFilterImpl.of(this);
    }

    @Override
    int getFilterByteStart() {
        if (this.filterByteStart == -1) {
            this.filterByteStart = ByteArrayUtil.indexOf(this.toBinary(), SHARE_PREFIX_LENGTH + 1, (byte)47) + 1;
        }
        return this.filterByteStart;
    }

    private int getFilterCharStart() {
        if (this.filterCharStart == -1) {
            this.filterCharStart = this.toString().indexOf(47, SHARE_PREFIX_LENGTH + 1) + 1;
        }
        return this.filterCharStart;
    }

    @Override
    public  @NotNull MqttTopicFilterImplBuilder.SharedDefault extendShared() {
        return new MqttTopicFilterImplBuilder.SharedDefault(this);
    }
}

