/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.handler.codec.mqtt.MqttPublishMessage;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import org.apache.kafka.common.utils.ByteBufferInputStream;
import org.traccar.BaseMqttProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class PuiProtocolDecoder
extends BaseMqttProtocolDecoder {
    public PuiProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(DeviceSession deviceSession, MqttPublishMessage message) throws Exception {
        String type;
        JsonObject json;
        try (ByteBufferInputStream inputStream = new ByteBufferInputStream(message.payload().nioBuffer());){
            json = Json.createReader((InputStream)inputStream).readObject();
        }
        switch (type = json.getString("rpt")) {
            case "hf": 
            case "loc": {
                Position position = new Position(this.getProtocolName());
                position.setDeviceId(deviceSession.getDeviceId());
                position.setValid(true);
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                position.setTime(dateFormat.parse(json.getString("ts")));
                JsonObject location = json.getJsonObject("location");
                position.setLatitude(location.getJsonNumber("lat").doubleValue());
                position.setLongitude(location.getJsonNumber("lon").doubleValue());
                position.setCourse(json.getInt("bear"));
                position.setSpeed(UnitsConverter.knotsFromCps(json.getInt("spd")));
                position.set("ignition", json.getString("ign").equals("on"));
                return position;
            }
        }
        return null;
    }
}

