/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class GlobalSatProtocolDecoder
extends BaseProtocolDecoder {
    private String format0;
    private String format1;
    private static final Pattern PATTERN = new PatternBuilder().text("$").number("(d+),").number("d+,").number("(d+),").number("(dd)(dd)(dd),").number("(dd)(dd)(dd),").expression("([EW])").number("(ddd)(dd.d+),").expression("([NS])").number("(dd)(dd.d+),").number("(d+.?d*),").number("(d+.?d*),").number("(d+.?d*)?,").number("(d+)[,*]").number("(d+.?d*)").compile();

    public GlobalSatProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected void init() {
        this.format0 = this.getConfig().getString(this.getProtocolName() + ".format0", "TSPRXAB27GHKLMnaicz*U!");
        this.format1 = this.getConfig().getString(this.getProtocolName() + ".format1", "SARY*U!");
    }

    public void setFormat0(String format) {
        this.format0 = format;
    }

    public void setFormat1(String format) {
        this.format1 = format;
    }

    private Double decodeVoltage(String value) {
        if (value.endsWith("mV")) {
            return (double)Integer.parseInt(value.substring(0, value.length() - 2)) / 1000.0;
        }
        if (value.endsWith("V")) {
            return Double.parseDouble(value.substring(0, value.length() - 1));
        }
        return null;
    }

    private String decodeAlarm(int value) {
        if (BitUtil.check(value, 0)) {
            return "sos";
        }
        if (BitUtil.check(value, 3) || BitUtil.check(value, 4)) {
            return "geofence";
        }
        if (BitUtil.check(value, 5)) {
            return "overspeed";
        }
        if (BitUtil.check(value, 6)) {
            return "powerCut";
        }
        if (BitUtil.check(value, 7)) {
            return "lowPower";
        }
        return null;
    }

    private Position decodeOriginal(Channel channel, SocketAddress remoteAddress, String sentence) {
        String format;
        if (channel != null) {
            channel.writeAndFlush((Object)new NetworkMessage("ACK\r", remoteAddress));
        }
        if (sentence.startsWith("GSr") || sentence.startsWith("GSb")) {
            format = this.format0;
        } else if (sentence.startsWith("GSh")) {
            format = this.format1;
        } else {
            return null;
        }
        if (!(format.contains("B") && format.contains("S") && (format.contains("1") || format.contains("2") || format.contains("3")) && (format.contains("6") || format.contains("7") || format.contains("8")))) {
            return null;
        }
        if (format.contains("*")) {
            format = format.substring(0, format.indexOf(42));
            sentence = sentence.substring(0, sentence.indexOf(42));
        }
        String[] values = sentence.split(",");
        Position position = new Position(this.getProtocolName());
        CellTower cellTower = new CellTower();
        int formatIndex = 0;
        block28: for (int valueIndex = 1; formatIndex < format.length() && valueIndex < values.length; ++valueIndex, ++formatIndex) {
            String value = values[valueIndex].replace("\"", "");
            switch (format.charAt(formatIndex)) {
                case 'S': {
                    DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, value);
                    if (deviceSession == null) {
                        return null;
                    }
                    position.setDeviceId(deviceSession.getDeviceId());
                    continue block28;
                }
                case 'A': {
                    if (value.isEmpty()) {
                        position.setValid(false);
                        continue block28;
                    }
                    position.setValid(Integer.parseInt(value) != 1);
                    continue block28;
                }
                case 'B': {
                    DateBuilder dateBuilder = new DateBuilder().setDay(Integer.parseInt(value.substring(0, 2))).setMonth(Integer.parseInt(value.substring(2, 4))).setYear(Integer.parseInt(value.substring(4)));
                    value = values[++valueIndex];
                    dateBuilder.setHour(Integer.parseInt(value.substring(0, 2))).setMinute(Integer.parseInt(value.substring(2, 4))).setSecond(Integer.parseInt(value.substring(4)));
                    position.setTime(dateBuilder.getDate());
                    continue block28;
                }
                case 'C': {
                    ++valueIndex;
                    continue block28;
                }
                case '1': {
                    double longitude = Double.parseDouble(value.substring(1));
                    if (value.charAt(0) == 'W') {
                        longitude = -longitude;
                    }
                    position.setLongitude(longitude);
                    continue block28;
                }
                case '2': {
                    double longitude = Double.parseDouble(value.substring(4)) / 60.0;
                    longitude += (double)Integer.parseInt(value.substring(1, 4));
                    if (value.charAt(0) == 'W') {
                        longitude = -longitude;
                    }
                    position.setLongitude(longitude);
                    continue block28;
                }
                case '3': {
                    position.setLongitude(Double.parseDouble(value) * 1.0E-6);
                    continue block28;
                }
                case '6': {
                    double latitude = Double.parseDouble(value.substring(1));
                    if (value.charAt(0) == 'S') {
                        latitude = -latitude;
                    }
                    position.setLatitude(latitude);
                    continue block28;
                }
                case '7': {
                    double latitude = Double.parseDouble(value.substring(3)) / 60.0;
                    latitude += (double)Integer.parseInt(value.substring(1, 3));
                    if (value.charAt(0) == 'S') {
                        latitude = -latitude;
                    }
                    position.setLatitude(latitude);
                    continue block28;
                }
                case '8': {
                    position.setLatitude(Double.parseDouble(value) * 1.0E-6);
                    continue block28;
                }
                case 'G': {
                    position.setAltitude(Double.parseDouble(value));
                    continue block28;
                }
                case 'H': {
                    position.setSpeed(Double.parseDouble(value));
                    continue block28;
                }
                case 'I': {
                    position.setSpeed(UnitsConverter.knotsFromKph(Double.parseDouble(value)));
                    continue block28;
                }
                case 'J': {
                    position.setSpeed(UnitsConverter.knotsFromMph(Double.parseDouble(value)));
                    continue block28;
                }
                case 'K': {
                    position.setCourse(Double.parseDouble(value));
                    continue block28;
                }
                case 'L': {
                    position.set("sat", Integer.parseInt(value));
                    continue block28;
                }
                case 'P': {
                    if (value.length() != 4) continue block28;
                    position.addAlarm(this.decodeAlarm(Integer.parseInt(value, 16)));
                    continue block28;
                }
                case 'Z': {
                    if (value.isEmpty()) continue block28;
                    position.set("geofence", value);
                    continue block28;
                }
                case 'Y': {
                    int io = Integer.parseInt(value, 16);
                    position.set("in1", BitUtil.check(io, 1));
                    position.set("motion", BitUtil.check(io, 7));
                    position.set("out1", BitUtil.check(io, 9));
                    position.set("ignition", BitUtil.check(io, 13));
                    position.set("charge", BitUtil.check(io, 15));
                    continue block28;
                }
                case 'c': {
                    cellTower.setSignalStrength(Integer.parseInt(value));
                    continue block28;
                }
                case 'm': {
                    position.set("power", this.decodeVoltage(value));
                    continue block28;
                }
                case 'N': 
                case 'n': {
                    position.set("battery", this.decodeVoltage(value));
                    continue block28;
                }
                case 't': {
                    cellTower.setMobileCountryCode(Integer.parseInt(value));
                    continue block28;
                }
                case 'u': {
                    cellTower.setMobileNetworkCode(Integer.parseInt(value));
                    continue block28;
                }
                case 'v': {
                    cellTower.setLocationAreaCode(Integer.parseInt(value, 16));
                    continue block28;
                }
                case 'w': {
                    cellTower.setCellId(Long.parseLong(value, 16));
                    continue block28;
                }
            }
        }
        if (cellTower.getCellId() != null) {
            position.setNetwork(new Network(cellTower));
        }
        return position;
    }

    private Position decodeAlternative(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN, sentence);
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        position.setDeviceId(deviceSession.getDeviceId());
        position.setValid(!parser.next().equals("1"));
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.DMY_HMS));
        position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG_MIN));
        position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG_MIN));
        position.setAltitude(parser.nextDouble(0.0));
        position.setSpeed(parser.nextDouble(0.0));
        position.setCourse(parser.nextDouble(0.0));
        position.set("sat", parser.nextInt(0));
        position.set("hdop", parser.nextDouble());
        return position;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String sentence = (String)msg;
        if (sentence.startsWith("GS")) {
            return this.decodeOriginal(channel, remoteAddress, sentence);
        }
        if (sentence.startsWith("$")) {
            return this.decodeAlternative(channel, remoteAddress, sentence);
        }
        return null;
    }
}

