/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.dialect;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.Error;
import com.networknt.schema.InvalidSchemaException;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.SchemaException;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.SpecificationVersion;
import com.networknt.schema.format.Format;
import com.networknt.schema.keyword.FormatKeyword;
import com.networknt.schema.keyword.Keyword;
import com.networknt.schema.keyword.KeywordFactory;
import com.networknt.schema.keyword.KeywordType;
import com.networknt.schema.keyword.KeywordValidator;
import com.networknt.schema.keyword.UnknownKeywordFactory;
import com.networknt.schema.utils.Strings;
import com.networknt.schema.vocabulary.Vocabularies;
import com.networknt.schema.vocabulary.Vocabulary;
import com.networknt.schema.vocabulary.VocabularyRegistry;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dialect {
    private static final Logger logger = LoggerFactory.getLogger(Dialect.class);
    private final String id;
    private final String idKeyword;
    private final Map<String, Keyword> keywords;
    private final Map<String, Boolean> vocabularies;
    private final SpecificationVersion specificationVersion;
    private final Builder builder;

    Dialect(String dialectId, String idKeyword, Map<String, Keyword> keywords, Map<String, Boolean> vocabularies, SpecificationVersion specification, Builder builder) {
        if (Strings.isBlank(dialectId)) {
            throw new IllegalArgumentException("dialect id must not be null or blank");
        }
        if (Strings.isBlank(idKeyword)) {
            throw new IllegalArgumentException("idKeyword must not be null or blank");
        }
        if (keywords == null) {
            throw new IllegalArgumentException("keywords must not be null ");
        }
        this.id = dialectId;
        this.idKeyword = idKeyword;
        this.keywords = keywords;
        this.specificationVersion = specification;
        this.vocabularies = vocabularies;
        this.builder = builder;
    }

    public static Builder builder(String id) {
        return new Builder(id);
    }

    public static Builder builder(String id, Dialect blueprint) {
        Builder builder = Dialect.builder(blueprint);
        builder.id = id;
        return builder;
    }

    public static Builder builder(Dialect blueprint) {
        HashMap<String, Boolean> vocabularies = new HashMap<String, Boolean>(blueprint.getVocabularies());
        return Dialect.builder(blueprint.getId()).idKeyword(blueprint.idKeyword).keywords(blueprint.builder.keywords.values()).formats(blueprint.builder.formats.values()).specificationVersion(blueprint.getSpecificationVersion()).vocabularies(vocabularies).vocabularyRegistry(blueprint.builder.vocabularyRegistry).formatKeywordFactory(blueprint.builder.formatKeywordFactory).unknownKeywordFactory(blueprint.builder.unknownKeywordFactory);
    }

    public String getIdKeyword() {
        return this.idKeyword;
    }

    public String readId(JsonNode schemaNode) {
        return Dialect.readText(schemaNode, this.idKeyword);
    }

    public String readAnchor(JsonNode schemaNode) {
        boolean supportsAnchor = this.keywords.containsKey("$anchor");
        if (supportsAnchor) {
            return Dialect.readText(schemaNode, "$anchor");
        }
        return null;
    }

    public String readDynamicAnchor(JsonNode schemaNode) {
        boolean supportsDynamicAnchor = this.keywords.containsKey("$dynamicAnchor");
        if (supportsDynamicAnchor) {
            return Dialect.readText(schemaNode, "$dynamicAnchor");
        }
        return null;
    }

    private static String readText(JsonNode node, String field) {
        JsonNode fieldNode = node.get(field);
        return fieldNode == null ? null : fieldNode.textValue();
    }

    public String getId() {
        return this.id;
    }

    public Map<String, Keyword> getKeywords() {
        return this.keywords;
    }

    public Map<String, Boolean> getVocabularies() {
        return this.vocabularies;
    }

    public SpecificationVersion getSpecificationVersion() {
        return this.specificationVersion;
    }

    public KeywordValidator newValidator(SchemaContext schemaContext, SchemaLocation schemaLocation, String keyword, JsonNode schemaNode, Schema parentSchema) {
        try {
            Keyword kw = this.keywords.get(keyword);
            if (kw == null) {
                if (keyword.equals(schemaContext.getSchemaRegistryConfig().getErrorMessageKeyword())) {
                    return null;
                }
                if (schemaContext.isNullableKeywordEnabled() && "nullable".equals(keyword)) {
                    return null;
                }
                if (KeywordType.DISCRIMINATOR.getValue().equals(keyword) && schemaContext.isDiscriminatorKeywordEnabled()) {
                    return KeywordType.DISCRIMINATOR.newValidator(schemaLocation, schemaNode, parentSchema, schemaContext);
                }
                Keyword keyword2 = kw = this.builder.unknownKeywordFactory != null ? this.builder.unknownKeywordFactory.getKeyword(keyword, schemaContext) : UnknownKeywordFactory.getInstance().getKeyword(keyword, schemaContext);
                if (kw == null) {
                    return null;
                }
            }
            return kw.newValidator(schemaLocation, schemaNode, parentSchema, schemaContext);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof SchemaException) {
                logger.error("Error:", (Throwable)e);
                throw (SchemaException)e.getTargetException();
            }
            logger.warn("Could not load validator {}", (Object)keyword);
            throw new SchemaException(e.getTargetException());
        }
        catch (SchemaException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("Could not load validator {}", (Object)keyword);
            throw new SchemaException(e);
        }
    }

    public String toString() {
        return this.id;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Dialect other = (Dialect)obj;
        return Objects.equals(this.id, other.id);
    }

    public static class Builder {
        private String id;
        private String idKeyword = "$id";
        private SpecificationVersion specificationVersion = null;
        private final Map<String, Keyword> keywords = new HashMap<String, Keyword>();
        private final Map<String, Format> formats = new HashMap<String, Format>();
        private final Map<String, Boolean> vocabularies = new HashMap<String, Boolean>();
        private FormatKeywordFactory formatKeywordFactory = null;
        private VocabularyRegistry vocabularyRegistry = null;
        private KeywordFactory unknownKeywordFactory = null;

        public Builder(String id) {
            this.id = id;
        }

        private Map<String, Keyword> createKeywordsMap(Map<String, Keyword> kwords, Map<String, Format> formats) {
            boolean formatKeywordPresent = false;
            HashMap<String, Keyword> map = new HashMap<String, Keyword>();
            for (Map.Entry<String, Keyword> type : kwords.entrySet()) {
                String keywordName = type.getKey();
                Keyword keyword = type.getValue();
                if (KeywordType.FORMAT.getValue().equals(keywordName)) {
                    if (!(keyword instanceof FormatKeyword) && !KeywordType.FORMAT.equals(keyword)) {
                        throw new IllegalArgumentException("Overriding the keyword 'format' is not supported. Use the formatKeywordFactory and extend the FormatKeyword.");
                    }
                    formatKeywordPresent = true;
                    continue;
                }
                map.put(keyword.getValue(), keyword);
            }
            if (formatKeywordPresent) {
                FormatKeyword formatKeyword = this.formatKeywordFactory != null ? this.formatKeywordFactory.newInstance(formats) : new FormatKeyword(formats);
                map.put(formatKeyword.getValue(), formatKeyword);
            }
            return map;
        }

        public Builder formatKeywordFactory(FormatKeywordFactory formatKeywordFactory) {
            this.formatKeywordFactory = formatKeywordFactory;
            return this;
        }

        public Builder vocabularyRegistry(VocabularyRegistry vocabularyRegistry) {
            this.vocabularyRegistry = vocabularyRegistry;
            return this;
        }

        public Builder unknownKeywordFactory(KeywordFactory unknownKeywordFactory) {
            this.unknownKeywordFactory = unknownKeywordFactory;
            return this;
        }

        public Builder formats(Consumer<Map<String, Format>> customizer) {
            customizer.accept(this.formats);
            return this;
        }

        public Builder keywords(Consumer<Map<String, Keyword>> customizer) {
            customizer.accept(this.keywords);
            return this;
        }

        public Builder keyword(Keyword keyword) {
            this.keywords.put(keyword.getValue(), keyword);
            return this;
        }

        public Builder keywords(Collection<? extends Keyword> keywords) {
            for (Keyword keyword : keywords) {
                this.keywords.put(keyword.getValue(), keyword);
            }
            return this;
        }

        public Builder format(Format format) {
            this.formats.put(format.getName(), format);
            return this;
        }

        public Builder formats(Collection<? extends Format> formats) {
            for (Format format : formats) {
                this.format(format);
            }
            return this;
        }

        public Builder vocabulary(String vocabulary) {
            return this.vocabulary(vocabulary, true);
        }

        public Builder vocabulary(String vocabulary, boolean required) {
            this.vocabularies.put(vocabulary, required);
            return this;
        }

        public Builder vocabularies(Map<String, Boolean> vocabularies) {
            this.vocabularies.putAll(vocabularies);
            return this;
        }

        public Builder vocabularies(Consumer<Map<String, Boolean>> customizer) {
            customizer.accept(this.vocabularies);
            return this;
        }

        public Builder specificationVersion(SpecificationVersion specification) {
            this.specificationVersion = specification;
            return this;
        }

        public Builder idKeyword(String idKeyword) {
            this.idKeyword = idKeyword;
            return this;
        }

        public Dialect build() {
            Map<String, Keyword> keywords = this.keywords;
            if (this.specificationVersion != null && this.specificationVersion.getOrder() >= SpecificationVersion.DRAFT_2019_09.getOrder()) {
                keywords = new HashMap<String, Keyword>(this.keywords);
                for (Map.Entry<String, Boolean> entry : this.vocabularies.entrySet()) {
                    Vocabulary vocabulary = null;
                    String id = entry.getKey();
                    if (this.vocabularyRegistry != null) {
                        vocabulary = this.vocabularyRegistry.getVocabulary(id);
                    }
                    if (vocabulary == null) {
                        vocabulary = Vocabularies.getVocabulary(id);
                    }
                    if (vocabulary != null) {
                        for (Keyword keyword : vocabulary.getKeywords()) {
                            keywords.putIfAbsent(keyword.getValue(), keyword);
                        }
                        continue;
                    }
                    if (!Boolean.TRUE.equals(entry.getValue())) continue;
                    Error error = ((Error.Builder)((Error.Builder)Error.builder().message("Meta-schema ''{0}'' has unknown required vocabulary ''{1}''")).arguments(this.id, id)).build();
                    throw new InvalidSchemaException(error);
                }
            }
            Map<String, Keyword> result = this.createKeywordsMap(keywords, this.formats);
            return new Dialect(this.id, this.idKeyword, result, this.vocabularies, this.specificationVersion, this);
        }
    }

    public static interface FormatKeywordFactory {
        public FormatKeyword newInstance(Map<String, Format> var1);
    }
}

