/*
 * Decompiled with CFR 0.152.
 */
package xsbt;

import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.WeakHashMap;

public class CompilerClassLoader
extends URLClassLoader {
    private final ClassLoader sbtLoader;
    private static WeakHashMap<ClassLoader, ClassLoader> fixedLoaderCache = new WeakHashMap();

    public CompilerClassLoader(URL[] uRLArray, ClassLoader classLoader) {
        super(uRLArray, (ClassLoader)null);
        this.sbtLoader = classLoader;
    }

    @Override
    public Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        if (string.startsWith("xsbti.")) {
            Class<?> clazz = this.sbtLoader.loadClass(string);
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        return super.loadClass(string, bl);
    }

    public static synchronized ClassLoader fixBridgeLoader(ClassLoader classLoader2) {
        return fixedLoaderCache.computeIfAbsent(classLoader2, classLoader -> CompilerClassLoader.computeFixedLoader(classLoader));
    }

    private static ClassLoader computeFixedLoader(ClassLoader classLoader) {
        URLClassLoader uRLClassLoader = (URLClassLoader)classLoader;
        ClassLoader classLoader2 = uRLClassLoader.getParent();
        Class<?> clazz = classLoader2.getClass();
        try {
            Field field = clazz.getDeclaredField("parentA");
            field.setAccessible(true);
            Field field2 = clazz.getDeclaredField("parentB");
            field2.setAccessible(true);
            URLClassLoader uRLClassLoader2 = (URLClassLoader)field.get(classLoader2);
            ClassLoader classLoader3 = (ClassLoader)field2.get(classLoader2);
            URL[] uRLArray = uRLClassLoader.getURLs();
            return new URLClassLoader(uRLArray, (ClassLoader)new CompilerClassLoader(uRLClassLoader2.getURLs(), classLoader3));
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }
}

