/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.mpxj.AssignmentField;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.SubProject;
import net.sf.mpxj.Table;
import net.sf.mpxj.TableContainer;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.View;
import net.sf.mpxj.WorkGroup;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.common.RtfHelper;
import net.sf.mpxj.mpp.AvailabilityFactory;
import net.sf.mpxj.mpp.ConstraintFactory;
import net.sf.mpxj.mpp.CostRateTableFactory;
import net.sf.mpxj.mpp.CustomFieldAliasReader;
import net.sf.mpxj.mpp.CustomFieldValueItem;
import net.sf.mpxj.mpp.CustomFieldValueReader12;
import net.sf.mpxj.mpp.DocumentInputStreamFactory;
import net.sf.mpxj.mpp.FieldMap;
import net.sf.mpxj.mpp.FieldMap12;
import net.sf.mpxj.mpp.FilterReader12;
import net.sf.mpxj.mpp.FixedData;
import net.sf.mpxj.mpp.FixedMeta;
import net.sf.mpxj.mpp.FontBase;
import net.sf.mpxj.mpp.GraphicalIndicatorReader;
import net.sf.mpxj.mpp.GroupReader12;
import net.sf.mpxj.mpp.MPP12CalendarFactory;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.MPPVariantReader;
import net.sf.mpxj.mpp.ProjectPropertiesReader;
import net.sf.mpxj.mpp.Props;
import net.sf.mpxj.mpp.Props12;
import net.sf.mpxj.mpp.RecurringTaskReader;
import net.sf.mpxj.mpp.ResourceAssignmentFactory;
import net.sf.mpxj.mpp.TableFactory;
import net.sf.mpxj.mpp.Var2Data;
import net.sf.mpxj.mpp.VarMeta;
import net.sf.mpxj.mpp.VarMeta12;
import net.sf.mpxj.mpp.ViewFactory12;
import net.sf.mpxj.mpp.ViewStateReader12;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;

final class MPP12Reader
implements MPPVariantReader {
    private MPPReader m_reader;
    private ProjectFile m_file;
    private EventManager m_eventManager;
    private DirectoryEntry m_root;
    private HashMap<Integer, ProjectCalendar> m_resourceMap;
    private Var2Data m_outlineCodeVarData;
    private VarMeta m_outlineCodeVarMeta;
    private FixedData m_outlineCodeFixedData;
    private FixedMeta m_outlineCodeFixedMeta;
    private FixedData m_outlineCodeFixedData2;
    private FixedMeta m_outlineCodeFixedMeta2;
    private Props12 m_projectProps;
    private Map<Integer, FontBase> m_fontBases;
    private Map<Integer, SubProject> m_taskSubProjects;
    private DirectoryEntry m_projectDir;
    private DirectoryEntry m_viewDir;
    private Map<Long, Integer> m_taskOrder;
    private Map<Integer, Integer> m_nullTaskOrder;
    private DocumentInputStreamFactory m_inputStreamFactory;
    private static final int SUBPROJECT_TASKUNIQUEID0 = 0;
    private static final int SUBPROJECT_TASKUNIQUEID1 = 187957248;
    private static final int SUBPROJECT_TASKUNIQUEID2 = 0xABB0000;
    private static final int SUBPROJECT_TASKUNIQUEID3 = 94437376;
    private static final int SUBPROJECT_TASKUNIQUEID4 = 198508544;
    private static final int SUBPROJECT_TASKUNIQUEID5 = 64356352;
    private static final int SUBPROJECT_TASKUNIQUEID6 = 0x7010000;
    private static final Integer TABLE_COLUMN_DATA_STANDARD = 6;
    private static final Integer TABLE_COLUMN_DATA_ENTERPRISE = 7;
    private static final Integer TABLE_COLUMN_DATA_BASELINE = 8;
    private static final Integer OUTLINECODE_DATA = 22;
    private static final int VALUE_LIST_MASK = 1792;
    private static final int DURATION_CONFIRMED_MASK = 32;
    private static final int TASK_UNIQUE_ID_FIXED_OFFSET = 0;
    private static final int TASK_ID_FIXED_OFFSET = 4;
    private static final int NULL_TASK_BLOCK_SIZE = 16;
    private static final Integer RESOURCE_FIELD_NAME_ALIASES = 0x4400001;
    private static final Integer TASK_FIELD_NAME_ALIASES = 0x4400001;

    MPP12Reader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(MPPReader mPPReader, ProjectFile projectFile, DirectoryEntry directoryEntry) throws MPXJException, IOException {
        try {
            this.populateMemberData(mPPReader, projectFile, directoryEntry);
            this.processProjectProperties();
            if (!mPPReader.getReadPropertiesOnly()) {
                this.processSubProjectData();
                this.processGraphicalIndicators();
                this.processCustomValueLists();
                this.processCalendarData();
                this.processResourceData();
                this.processTaskData();
                this.processConstraintData();
                this.processAssignmentData();
                this.postProcessTasks();
                if (mPPReader.getReadPresentationData()) {
                    this.processViewPropertyData();
                    this.processTableData();
                    this.processViewData();
                    this.processFilterData();
                    this.processGroupData();
                    this.processSavedViewState();
                }
            }
        }
        finally {
            this.clearMemberData();
        }
    }

    private void populateMemberData(MPPReader mPPReader, ProjectFile projectFile, DirectoryEntry directoryEntry) throws MPXJException, IOException {
        this.m_reader = mPPReader;
        this.m_file = projectFile;
        this.m_eventManager = projectFile.getEventManager();
        this.m_root = directoryEntry;
        Props12 props12 = new Props12(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Props12")));
        projectFile.getProjectProperties().setProjectFilePath(props12.getUnicodeString(Props.PROJECT_FILE_PATH));
        this.m_inputStreamFactory = new DocumentInputStreamFactory(props12);
        if ((props12.getByte(Props.PASSWORD_FLAG) & 1) != 0) {
            throw new MPXJException("File is password protected");
        }
        this.m_resourceMap = new HashMap();
        this.m_projectDir = (DirectoryEntry)directoryEntry.getEntry("   112");
        this.m_viewDir = (DirectoryEntry)directoryEntry.getEntry("   212");
        DirectoryEntry directoryEntry2 = (DirectoryEntry)this.m_projectDir.getEntry("TBkndOutlCode");
        this.m_outlineCodeVarMeta = new VarMeta12(new DocumentInputStream((DocumentEntry)directoryEntry2.getEntry("VarMeta")));
        this.m_outlineCodeVarData = new Var2Data(this.m_outlineCodeVarMeta, new DocumentInputStream((DocumentEntry)directoryEntry2.getEntry("Var2Data")));
        this.m_outlineCodeFixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)directoryEntry2.getEntry("FixedMeta")), 10);
        this.m_outlineCodeFixedData = new FixedData(this.m_outlineCodeFixedMeta, (InputStream)new DocumentInputStream((DocumentEntry)directoryEntry2.getEntry("FixedData")));
        this.m_outlineCodeFixedMeta2 = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)directoryEntry2.getEntry("Fixed2Meta")), 10);
        this.m_outlineCodeFixedData2 = new FixedData(this.m_outlineCodeFixedMeta2, (InputStream)new DocumentInputStream((DocumentEntry)directoryEntry2.getEntry("Fixed2Data")));
        this.m_projectProps = new Props12(this.m_inputStreamFactory.getInstance(this.m_projectDir, "Props"));
        this.m_fontBases = new HashMap<Integer, FontBase>();
        this.m_taskSubProjects = new HashMap<Integer, SubProject>();
        this.m_taskOrder = new TreeMap<Long, Integer>();
        this.m_nullTaskOrder = new TreeMap<Integer, Integer>();
        this.m_file.getProjectProperties().setMppFileType(12);
        this.m_file.getProjectProperties().setAutoFilter(props12.getBoolean(Props.AUTO_FILTER));
    }

    private void clearMemberData() {
        this.m_reader = null;
        this.m_file = null;
        this.m_eventManager = null;
        this.m_root = null;
        this.m_resourceMap = null;
        this.m_projectDir = null;
        this.m_viewDir = null;
        this.m_outlineCodeVarData = null;
        this.m_outlineCodeVarMeta = null;
        this.m_projectProps = null;
        this.m_fontBases = null;
        this.m_taskSubProjects = null;
        this.m_taskOrder = null;
        this.m_nullTaskOrder = null;
        this.m_inputStreamFactory = null;
    }

    private void processCustomValueLists() throws IOException {
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_projectDir.getEntry("TBkndTask");
        Props12 props12 = new Props12(this.m_inputStreamFactory.getInstance(directoryEntry, "Props"));
        CustomFieldValueReader12 customFieldValueReader12 = new CustomFieldValueReader12(this.m_file.getProjectProperties(), this.m_file.getCustomFields(), this.m_outlineCodeVarMeta, this.m_outlineCodeVarData, this.m_outlineCodeFixedData, this.m_outlineCodeFixedData2, props12);
        customFieldValueReader12.process();
    }

    private void processProjectProperties() throws MPXJException {
        ProjectPropertiesReader projectPropertiesReader = new ProjectPropertiesReader();
        projectPropertiesReader.process(this.m_file, this.m_projectProps, this.m_root);
    }

    private void processGraphicalIndicators() {
        GraphicalIndicatorReader graphicalIndicatorReader = new GraphicalIndicatorReader();
        graphicalIndicatorReader.process(this.m_file.getCustomFields(), this.m_file.getProjectProperties(), this.m_projectProps);
    }

    private void processSubProjectData() {
        byte[] byArray = this.m_projectProps.getByteArray(Props.SUBPROJECT_DATA);
        if (byArray != null) {
            int n = 0;
            int n2 = 0;
            byte[] byArray2 = new byte[20];
            n2 += 4;
            int n3 = MPPUtility.getInt(byArray, n2 += 4);
            n2 += 4;
            block16: while (n2 < n3) {
                ++n;
                int n4 = MPPUtility.getInt(byArray, n2) & 0x1FFFF;
                n2 += 4;
                MPPUtility.getByteArray(byArray, n4, byArray2.length, byArray2, 0);
                byte by = byArray2[16];
                switch (by) {
                    case 0: 
                    case 16: {
                        n2 += 8;
                        continue block16;
                    }
                    case -103: 
                    case 9: 
                    case 11: 
                    case 13: {
                        int n5 = MPPUtility.getInt(byArray, n2) & 0x1FFFF;
                        n2 += 4;
                        int n6 = MPPUtility.getInt(byArray, n2 += 4) & 0x1FFFF;
                        int n7 = MPPUtility.getInt(byArray, n2 += 4) & 0x1FFFF;
                        n2 += 4;
                        this.readSubProjects(byArray, n5, n6, n7, n);
                        continue block16;
                    }
                    case -111: 
                    case 3: 
                    case 17: {
                        int n5 = MPPUtility.getInt(byArray, n2) & 0x1FFFF;
                        int n6 = MPPUtility.getInt(byArray, n2 += 4) & 0x1FFFF;
                        int n7 = MPPUtility.getInt(byArray, n2 += 4) & 0x1FFFF;
                        n2 += 4;
                        n2 += 4;
                        this.readSubProjects(byArray, n5, n6, n7, n);
                        continue block16;
                    }
                    case -127: 
                    case -125: 
                    case 65: {
                        int n5 = MPPUtility.getInt(byArray, n2) & 0x1FFFF;
                        int n6 = MPPUtility.getInt(byArray, n2 += 4) & 0x1FFFF;
                        n2 += 4;
                        int n7 = MPPUtility.getInt(byArray, n2 += 4) & 0x1FFFF;
                        n2 += 4;
                        this.readSubProjects(byArray, n5, n6, n7, n);
                        continue block16;
                    }
                    case 1: 
                    case 8: {
                        int n5 = MPPUtility.getInt(byArray, n2) & 0x1FFFF;
                        int n6 = MPPUtility.getInt(byArray, n2 += 4) & 0x1FFFF;
                        int n7 = MPPUtility.getInt(byArray, n2 += 4) & 0x1FFFF;
                        n2 += 4;
                        this.readSubProjects(byArray, n5, n6, n7, n);
                        continue block16;
                    }
                    case -64: {
                        int n5 = n4;
                        int n6 = MPPUtility.getInt(byArray, n2) & 0x1FFFF;
                        int n7 = MPPUtility.getInt(byArray, n2 += 4) & 0x1FFFF;
                        n2 += 4;
                        n2 += 4;
                        this.readSubProjects(byArray, n5, n6, n7, n);
                        continue block16;
                    }
                    case 5: {
                        int n5 = MPPUtility.getInt(byArray, n2) & 0x1FFFF;
                        int n6 = MPPUtility.getInt(byArray, n2 += 4) & 0x1FFFF;
                        int n7 = MPPUtility.getInt(byArray, n2 += 4) & 0x1FFFF;
                        n2 += 4;
                        this.m_file.getSubProjects().setResourceSubProject(this.readSubProject(byArray, n5, n6, n7, n));
                        continue block16;
                    }
                    case 69: {
                        int n5 = MPPUtility.getInt(byArray, n2) & 0x1FFFF;
                        int n6 = MPPUtility.getInt(byArray, n2 += 4) & 0x1FFFF;
                        int n7 = MPPUtility.getInt(byArray, n2 += 4) & 0x1FFFF;
                        n2 += 4;
                        n2 += 4;
                        this.m_file.getSubProjects().setResourceSubProject(this.readSubProject(byArray, n5, n6, n7, n));
                        continue block16;
                    }
                    case 2: {
                        n2 += 4;
                        n2 += 4;
                        continue block16;
                    }
                    case 4: {
                        int n6 = MPPUtility.getInt(byArray, n2) & 0x1FFFF;
                        int n7 = MPPUtility.getInt(byArray, n2 += 4) & 0x1FFFF;
                        n2 += 4;
                        this.m_file.getSubProjects().setResourceSubProject(this.readSubProject(byArray, -1, n6, n7, n));
                        continue block16;
                    }
                    case -115: {
                        int n5 = MPPUtility.getShort(byArray, n2);
                        int n6 = MPPUtility.getShort(byArray, n2 += 8);
                        int n7 = MPPUtility.getShort(byArray, n2 += 8);
                        n2 += 4;
                        this.readSubProjects(byArray, n5, n6, n7, n);
                        continue block16;
                    }
                    case 10: {
                        int n5 = MPPUtility.getShort(byArray, n2);
                        int n6 = MPPUtility.getShort(byArray, n2 += 4);
                        int n7 = MPPUtility.getShort(byArray, n2 += 4);
                        n2 += 4;
                        this.readSubProjects(byArray, n5, n6, n7, n);
                        continue block16;
                    }
                    case 68: {
                        int n6 = MPPUtility.getInt(byArray, n2) & 0x1FFFF;
                        n2 += 4;
                        int n7 = MPPUtility.getInt(byArray, n2 += 4) & 0x1FFFF;
                        n2 += 4;
                        this.readSubProjects(byArray, -1, n6, n7, n);
                        continue block16;
                    }
                    case -128: {
                        n2 += 12;
                        continue block16;
                    }
                }
                n2 += 12;
            }
        }
    }

    private void readSubProjects(byte[] byArray, int n, int n2, int n3, int n4) {
        while (n < n2) {
            this.readSubProject(byArray, n, n2, n3, n4++);
            n += 4;
        }
    }

    private SubProject readSubProject(byte[] byArray, int n, int n2, int n3, int n4) {
        try {
            int n5;
            SubProject subProject = new SubProject();
            int n6 = 0;
            if (n != -1) {
                n5 = MPPUtility.getInt(byArray, n);
                n6 = MPPUtility.getInt(byArray, n + 4);
                switch (n6) {
                    case 0: 
                    case 64356352: 
                    case 94437376: 
                    case 0x7010000: 
                    case 0xABB0000: 
                    case 187957248: 
                    case 198508544: {
                        subProject.setTaskUniqueID(n5);
                        this.m_taskSubProjects.put(subProject.getTaskUniqueID(), subProject);
                        break;
                    }
                    default: {
                        if (n5 == 0) break;
                        subProject.addExternalTaskUniqueID(n5);
                        this.m_taskSubProjects.put(n5, subProject);
                    }
                }
                n5 = 0x800000 + (n4 - 1) * 0x400000;
                subProject.setUniqueIDOffset(n5);
            }
            if (n6 == 198508544) {
                subProject.setFullPath(MPPUtility.getUnicodeString(byArray, n2));
            } else {
                n2 += 18;
                subProject.setDosFullPath(MPPUtility.getString(byArray, n2 += 4));
                n2 += subProject.getDosFullPath().length() + 1;
                n5 = MPPUtility.getInt(byArray, n2 += 24);
                n2 += 4;
                if (n5 == 0) {
                    subProject.setFullPath(subProject.getDosFullPath());
                } else {
                    n5 = MPPUtility.getInt(byArray, n2);
                    n2 += 4;
                    subProject.setFullPath(MPPUtility.getUnicodeString(byArray, n2 += 2, n5));
                }
                n3 += 18;
                subProject.setDosFileName(MPPUtility.getString(byArray, n3 += 4));
                n3 += subProject.getDosFileName().length() + 1;
                n5 = MPPUtility.getInt(byArray, n3 += 24);
                n3 += 4;
                if (n5 == 0) {
                    subProject.setFileName(subProject.getDosFileName());
                } else {
                    n5 = MPPUtility.getInt(byArray, n3);
                    n3 += 4;
                    subProject.setFileName(MPPUtility.getUnicodeString(byArray, n3 += 2, n5));
                }
            }
            this.m_file.getSubProjects().add(subProject);
            return subProject;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    private void processViewPropertyData() throws IOException {
        Props12 props12 = new Props12(this.m_inputStreamFactory.getInstance(this.m_viewDir, "Props"));
        byte[] byArray = props12.getByteArray(Props.FONT_BASES);
        if (byArray != null) {
            this.processBaseFonts(byArray);
        }
        ProjectProperties projectProperties = this.m_file.getProjectProperties();
        projectProperties.setShowProjectSummaryTask(props12.getBoolean(Props.SHOW_PROJECT_SUMMARY_TASK));
    }

    private void processBaseFonts(byte[] byArray) {
        int n = 0;
        int n2 = MPPUtility.getShort(byArray, 0);
        n += 2;
        for (int i = 0; i < n2; ++i) {
            int n3 = MPPUtility.getShort(byArray, n += 2);
            String string = MPPUtility.getUnicodeString(byArray, n += 2);
            n += 64;
            if (string.length() == 0) continue;
            FontBase fontBase = new FontBase(i, string, n3);
            this.m_fontBases.put(fontBase.getIndex(), fontBase);
        }
    }

    private TreeMap<Integer, Integer> createTaskMap(FieldMap fieldMap, FixedMeta fixedMeta, FixedData fixedData, Var2Data var2Data) {
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        int n = fieldMap.getFixedDataOffset(TaskField.UNIQUE_ID);
        Integer n2 = fieldMap.getVarDataKey(TaskField.NAME);
        int n3 = fixedMeta.getAdjustedItemCount();
        for (int i = 3; i < n3; ++i) {
            Integer n4;
            int n5;
            byte[] byArray = fixedData.getByteArrayValue(i);
            if (byArray == null) continue;
            byte[] byArray2 = fixedMeta.getByteArrayValue(i);
            int n6 = MPPUtility.getInt(byArray2, 0);
            if ((n6 & 2) != 0) {
                n5 = MPPUtility.getShort(byArray, 0);
                n4 = n5;
                if (treeMap.containsKey(n4)) continue;
                treeMap.put(n4, null);
                continue;
            }
            if (byArray.length == 16) {
                n5 = MPPUtility.getInt(byArray, 0);
                n4 = n5;
                if (treeMap.containsKey(n4)) continue;
                treeMap.put(n4, i);
                continue;
            }
            int n7 = fieldMap.getMaxFixedDataSize(0);
            if (n7 != 0 && byArray.length * 100 / n7 <= 75 || treeMap.containsKey(n4 = Integer.valueOf(n5 = MPPUtility.getInt(byArray, n))) && var2Data.getUnicodeString(n4, n2) == null) continue;
            treeMap.put(n4, i);
        }
        return treeMap;
    }

    private TreeMap<Integer, Integer> createResourceMap(FieldMap fieldMap, FixedMeta fixedMeta, FixedData fixedData) {
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        int n = fixedMeta.getAdjustedItemCount();
        for (int i = 0; i < n; ++i) {
            Integer n2;
            byte[] byArray = fixedData.getByteArrayValue(i);
            if (byArray == null || byArray.length < fieldMap.getMaxFixedDataSize(0) || treeMap.containsKey(n2 = Integer.valueOf(MPPUtility.getShort(byArray, 0)))) continue;
            treeMap.put(n2, i);
        }
        return treeMap;
    }

    private void processCalendarData() throws IOException {
        MPP12CalendarFactory mPP12CalendarFactory = new MPP12CalendarFactory(this.m_file);
        mPP12CalendarFactory.processCalendarData(this.m_projectDir, this.m_projectProps, this.m_inputStreamFactory, this.m_resourceMap);
    }

    private void processTaskData() throws IOException {
        FieldMap12 fieldMap12 = new FieldMap12(this.m_file.getProjectProperties(), this.m_file.getCustomFields());
        fieldMap12.createTaskFieldMap(this.m_projectProps);
        FieldMap12 fieldMap122 = new FieldMap12(this.m_file.getProjectProperties(), this.m_file.getCustomFields());
        fieldMap122.createEnterpriseCustomFieldMap(this.m_projectProps, TaskField.class);
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_projectDir.getEntry("TBkndTask");
        VarMeta12 varMeta12 = new VarMeta12(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("VarMeta")));
        Var2Data var2Data = new Var2Data(varMeta12, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Var2Data")));
        FixedMeta fixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixedMeta")), 47);
        FixedData fixedData = new FixedData(fixedMeta, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixedData")), 768, fieldMap12.getMaxFixedDataSize(0));
        FixedMeta fixedMeta2 = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Fixed2Meta")), 86);
        FixedData fixedData2 = new FixedData(fixedMeta2, (InputStream)new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Fixed2Data")));
        Props12 props12 = new Props12(this.m_inputStreamFactory.getInstance(directoryEntry, "Props"));
        new CustomFieldAliasReader(this.m_file.getCustomFields(), props12.getByteArray(TASK_FIELD_NAME_ALIASES)).process();
        TreeMap<Integer, Integer> treeMap = this.createTaskMap(fieldMap12, fixedMeta, fixedData, var2Data);
        Object[] objectArray = treeMap.keySet().toArray();
        boolean bl = true;
        LinkedList<Task> linkedList = new LinkedList<Task>();
        RecurringTaskReader recurringTaskReader = null;
        for (int i = 0; i < objectArray.length; ++i) {
            Object object;
            byte[] byArray;
            Task task;
            Integer n = (Integer)objectArray[i];
            Integer n2 = treeMap.get(n);
            if (!fixedData.isValidOffset(n2)) continue;
            byte[] byArray2 = fixedData.getByteArrayValue(n2);
            Integer n3 = MPPUtility.getInt(byArray2, fieldMap12.getFixedDataOffset(TaskField.ID));
            if (byArray2.length == 16) {
                task = this.m_file.addTask();
                task.setNull(true);
                task.setUniqueID(MPPUtility.getShort(byArray2, 0));
                task.setID(MPPUtility.getShort(byArray2, 4));
                this.m_nullTaskOrder.put(task.getID(), task.getUniqueID());
                continue;
            }
            if (byArray2.length < fieldMap12.getMaxFixedDataSize(0)) {
                if (n != 0) continue;
                byArray = new byte[fieldMap12.getMaxFixedDataSize(0) + 8];
                System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
                byArray2 = byArray;
            }
            byte[] byArray3 = fixedMeta.getByteArrayValue(n2);
            byte[] byArray4 = fixedMeta2.getByteArrayValue(n2);
            byArray = fixedData2.getByteArrayValue(n2);
            byte[] byArray5 = var2Data.getByteArray(n, fieldMap12.getVarDataKey(TaskField.RECURRING_DATA));
            Task task2 = this.m_file.getTaskByID(n3);
            if (task2 != null) {
                if (!varMeta12.getUniqueIdentifierSet().contains(n)) continue;
                if (task2.getName() == null) {
                    this.m_file.removeTask(task2);
                }
            }
            task = this.m_file.addTask();
            task.disableEvents();
            fieldMap12.populateContainer(TaskField.class, task, n, new byte[][]{byArray2, byArray}, var2Data);
            fieldMap122.populateContainer(TaskField.class, task, n, null, var2Data);
            task.enableEvents();
            task.setEffortDriven((byArray3[11] & 0x10) != 0);
            task.setEstimated(this.getDurationEstimated(MPPUtility.getShort(byArray2, fieldMap12.getFixedDataOffset(TaskField.ACTUAL_DURATION_UNITS))));
            task.setExpanded((byArray3[12] & 2) == 0);
            Integer n4 = task.getSubprojectTaskID();
            if (n4 != null && n4 != 0) {
                task.setExternalTask(true);
                linkedList.add(task);
            }
            task.setFlag(1, (byArray3[37] & 0x20) != 0);
            task.setFlag(2, (byArray3[37] & 0x40) != 0);
            task.setFlag(3, (byArray3[37] & 0x80) != 0);
            task.setFlag(4, (byArray3[38] & 1) != 0);
            task.setFlag(5, (byArray3[38] & 2) != 0);
            task.setFlag(6, (byArray3[38] & 4) != 0);
            task.setFlag(7, (byArray3[38] & 8) != 0);
            task.setFlag(8, (byArray3[38] & 0x10) != 0);
            task.setFlag(9, (byArray3[38] & 0x20) != 0);
            task.setFlag(10, (byArray3[38] & 0x40) != 0);
            task.setFlag(11, (byArray3[38] & 0x80) != 0);
            task.setFlag(12, (byArray3[39] & 1) != 0);
            task.setFlag(13, (byArray3[39] & 2) != 0);
            task.setFlag(14, (byArray3[39] & 4) != 0);
            task.setFlag(15, (byArray3[39] & 8) != 0);
            task.setFlag(16, (byArray3[39] & 0x10) != 0);
            task.setFlag(17, (byArray3[39] & 0x20) != 0);
            task.setFlag(18, (byArray3[39] & 0x40) != 0);
            task.setFlag(19, (byArray3[39] & 0x80) != 0);
            task.setFlag(20, (byArray3[40] & 1) != 0);
            task.setHideBar((byArray3[10] & 0x80) != 0);
            this.processHyperlinkData(task, var2Data.getByteArray(n, fieldMap12.getVarDataKey(TaskField.HYPERLINK_DATA)));
            task.setID(n3);
            task.setIgnoreResourceCalendar((byArray3[10] & 2) != 0);
            task.setLevelAssignments((byArray3[13] & 4) != 0);
            task.setLevelingCanSplit((byArray3[13] & 2) != 0);
            task.setMarked((byArray3[9] & 0x40) != 0);
            task.setMilestone((byArray3[8] & 0x20) != 0);
            task.setOutlineCode(1, this.getCustomFieldOutlineCodeValue(var2Data, this.m_outlineCodeVarData, n, fieldMap12.getVarDataKey(TaskField.OUTLINE_CODE1_INDEX)));
            task.setOutlineCode(2, this.getCustomFieldOutlineCodeValue(var2Data, this.m_outlineCodeVarData, n, fieldMap12.getVarDataKey(TaskField.OUTLINE_CODE2_INDEX)));
            task.setOutlineCode(3, this.getCustomFieldOutlineCodeValue(var2Data, this.m_outlineCodeVarData, n, fieldMap12.getVarDataKey(TaskField.OUTLINE_CODE3_INDEX)));
            task.setOutlineCode(4, this.getCustomFieldOutlineCodeValue(var2Data, this.m_outlineCodeVarData, n, fieldMap12.getVarDataKey(TaskField.OUTLINE_CODE4_INDEX)));
            task.setOutlineCode(5, this.getCustomFieldOutlineCodeValue(var2Data, this.m_outlineCodeVarData, n, fieldMap12.getVarDataKey(TaskField.OUTLINE_CODE5_INDEX)));
            task.setOutlineCode(6, this.getCustomFieldOutlineCodeValue(var2Data, this.m_outlineCodeVarData, n, fieldMap12.getVarDataKey(TaskField.OUTLINE_CODE6_INDEX)));
            task.setOutlineCode(7, this.getCustomFieldOutlineCodeValue(var2Data, this.m_outlineCodeVarData, n, fieldMap12.getVarDataKey(TaskField.OUTLINE_CODE7_INDEX)));
            task.setOutlineCode(8, this.getCustomFieldOutlineCodeValue(var2Data, this.m_outlineCodeVarData, n, fieldMap12.getVarDataKey(TaskField.OUTLINE_CODE8_INDEX)));
            task.setOutlineCode(9, this.getCustomFieldOutlineCodeValue(var2Data, this.m_outlineCodeVarData, n, fieldMap12.getVarDataKey(TaskField.OUTLINE_CODE9_INDEX)));
            task.setOutlineCode(10, this.getCustomFieldOutlineCodeValue(var2Data, this.m_outlineCodeVarData, n, fieldMap12.getVarDataKey(TaskField.OUTLINE_CODE10_INDEX)));
            task.setRollup((byArray3[10] & 8) != 0);
            task.setUniqueID(n);
            switch (task.getConstraintType()) {
                case AS_LATE_AS_POSSIBLE: {
                    if (DateHelper.compare(task.getStart(), task.getLateStart()) < 0) {
                        task.setStart(task.getLateStart());
                    }
                    if (DateHelper.compare(task.getFinish(), task.getLateFinish()) >= 0) break;
                    task.setFinish(task.getLateFinish());
                    break;
                }
                case START_NO_LATER_THAN: 
                case FINISH_NO_LATER_THAN: {
                    if (DateHelper.compare(task.getFinish(), task.getStart()) >= 0) break;
                    task.setFinish(task.getLateFinish());
                    break;
                }
            }
            if (byArray5 != null) {
                if (recurringTaskReader == null) {
                    recurringTaskReader = new RecurringTaskReader(this.m_file.getProjectProperties());
                }
                recurringTaskReader.processRecurringTask(task, byArray5);
                task.setRecurring(true);
            }
            String string = task.getNotes();
            if (!this.m_reader.getPreserveNoteFormatting()) {
                string = RtfHelper.strip(string);
            }
            task.setNotes(string);
            Integer n5 = (Integer)task.getCachedValue(TaskField.CALENDAR_UNIQUE_ID);
            if (n5 != null && n5 != -1 && (object = this.m_file.getCalendarByUniqueID(n5)) != null) {
                task.setCalendar((ProjectCalendar)object);
            }
            object = this.m_taskSubProjects.get(task.getUniqueID());
            task.setSubProject((SubProject)object);
            if (object != null) {
                task.setExternalTask(((SubProject)object).isExternalTask(task.getUniqueID()));
                if (task.getExternalTask()) {
                    task.setExternalTaskProject(((SubProject)object).getFullPath());
                }
            }
            if (task.getWBS() != null) {
                bl = false;
            }
            if ((byArray3[9] & 0x80) == 0) {
                task.setSplits(new LinkedList<DateRange>());
            }
            this.processTaskEnterpriseColumns(n, task, var2Data, byArray4);
            if (task.getName() == null && (task.getStart() == null || task.getStart().getTime() == MPPUtility.getEpochDate().getTime() || task.getFinish() == null || task.getFinish().getTime() == MPPUtility.getEpochDate().getTime())) {
                this.m_file.removeTask(task);
                task = this.m_file.addTask();
                task.setNull(true);
                task.setUniqueID(n);
                task.setID(n3);
                this.m_nullTaskOrder.put(task.getID(), task.getUniqueID());
                continue;
            }
            if (byArray == null || byArray.length < 24) {
                this.m_nullTaskOrder.put(task.getID(), task.getUniqueID());
            } else {
                Long l = MPPUtility.getLong(byArray, 16);
                this.m_taskOrder.put(l, task.getUniqueID());
            }
            this.m_eventManager.fireTaskReadEvent(task);
        }
        this.m_file.getProjectConfig().setAutoWBS(bl);
        if (!linkedList.isEmpty()) {
            this.processExternalTasks(linkedList);
        }
    }

    private void postProcessTasks() throws MPXJException {
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        int n = 1000;
        int n2 = this.m_file.getTaskByUniqueID(0) == null ? n : 0;
        for (Map.Entry<Long, Integer> iterator : this.m_taskOrder.entrySet()) {
            treeMap.put(n2, iterator.getValue());
            n2 += n;
        }
        int n3 = 0;
        for (Map.Entry<Integer, Integer> entry : this.m_nullTaskOrder.entrySet()) {
            int n4;
            int n5 = entry.getKey();
            int n6 = n4 = (n5 - n3) * n;
            int n7 = 0;
            ++n3;
            while (treeMap.containsKey(n6)) {
                if (++n7 == n) {
                    throw new MPXJException("Unable to fix task order");
                }
                n6 = n4 - (n - n7);
            }
            treeMap.put(n6, entry.getValue());
        }
        n2 = this.m_file.getTaskByUniqueID(0) == null ? 1 : 0;
        for (Map.Entry entry : treeMap.entrySet()) {
            Task task = this.m_file.getTaskByUniqueID((Integer)entry.getValue());
            if (task != null) {
                task.setID(n2);
            }
            ++n2;
        }
    }

    private void processTaskEnterpriseColumns(Integer n, Task task, Var2Data var2Data, byte[] byArray) {
        if (byArray != null) {
            int n2 = MPPUtility.getInt(byArray, 59);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG1, (n2 & 1) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG2, (n2 & 2) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG3, (n2 & 4) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG4, (n2 & 8) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG5, (n2 & 0x10) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG6, (n2 & 0x20) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG7, (n2 & 0x40) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG8, (n2 & 0x80) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG9, (n2 & 0x100) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG10, (n2 & 0x200) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG11, (n2 & 0x400) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG12, (n2 & 0x800) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG13, (n2 & 0x1000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG14, (n2 & 0x2000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG15, (n2 & 0x4000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG16, (n2 & 0x8000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG17, (n2 & 0x10000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG18, (n2 & 0x20000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG19, (n2 & 0x40000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG20, (n2 & 0x80000) != 0 ? 1 : 0);
        }
    }

    private void processResourceEnterpriseColumns(Resource resource, byte[] byArray) {
        if (byArray != null) {
            int n = MPPUtility.getInt(byArray, 16);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG1, (n & 0x10) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG2, (n & 0x20) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG3, (n & 0x40) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG4, (n & 0x80) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG5, (n & 0x100) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG6, (n & 0x200) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG7, (n & 0x400) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG8, (n & 0x800) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG9, (n & 0x1000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG10, (n & 0x2000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG11, (n & 0x4000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG12, (n & 0x8000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG13, (n & 0x10000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG14, (n & 0x20000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG15, (n & 0x40000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG16, (n & 0x80000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG17, (n & 0x100000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG18, (n & 0x200000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG19, (n & 0x400000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG20, (n & 0x800000) != 0 ? 1 : 0);
        }
    }

    private void processExternalTasks(List<Task> list) {
        Collections.sort(list);
        SubProject subProject = null;
        for (Task task : list) {
            SubProject subProject2 = task.getSubProject();
            if (subProject2 == null) {
                task.setSubProject(subProject);
                if (subProject != null) {
                    task.setExternalTaskProject(subProject.getFullPath());
                }
            } else {
                subProject = subProject2;
            }
            if (subProject == null) continue;
            task.setProject(subProject.getFullPath());
        }
    }

    private void processHyperlinkData(Task task, byte[] byArray) {
        if (byArray != null) {
            int n = 12;
            String string = MPPUtility.getUnicodeString(byArray, n += 12);
            n += (string.length() + 1) * 2;
            String string2 = MPPUtility.getUnicodeString(byArray, n += 12);
            n += (string2.length() + 1) * 2;
            String string3 = MPPUtility.getUnicodeString(byArray, n += 12);
            task.setHyperlink(string);
            task.setHyperlinkAddress(string2);
            task.setHyperlinkSubAddress(string3);
        }
    }

    private void processHyperlinkData(Resource resource, byte[] byArray) {
        if (byArray != null) {
            int n = 12;
            String string = MPPUtility.getUnicodeString(byArray, n += 12);
            n += (string.length() + 1) * 2;
            String string2 = MPPUtility.getUnicodeString(byArray, n += 12);
            n += (string2.length() + 1) * 2;
            String string3 = MPPUtility.getUnicodeString(byArray, n += 12);
            resource.setHyperlink(string);
            resource.setHyperlinkAddress(string2);
            resource.setHyperlinkSubAddress(string3);
        }
    }

    private void processConstraintData() throws IOException {
        ConstraintFactory constraintFactory = new ConstraintFactory();
        constraintFactory.process(this.m_projectDir, this.m_file, this.m_inputStreamFactory);
    }

    private void processResourceData() throws IOException {
        FieldMap12 fieldMap12 = new FieldMap12(this.m_file.getProjectProperties(), this.m_file.getCustomFields());
        fieldMap12.createResourceFieldMap(this.m_projectProps);
        FieldMap12 fieldMap122 = new FieldMap12(this.m_file.getProjectProperties(), this.m_file.getCustomFields());
        fieldMap122.createEnterpriseCustomFieldMap(this.m_projectProps, ResourceField.class);
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_projectDir.getEntry("TBkndRsc");
        VarMeta12 varMeta12 = new VarMeta12(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("VarMeta")));
        Var2Data var2Data = new Var2Data(varMeta12, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Var2Data")));
        FixedMeta fixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixedMeta")), 37);
        FixedData fixedData = new FixedData(fixedMeta, this.m_inputStreamFactory.getInstance(directoryEntry, "FixedData"));
        FixedMeta fixedMeta2 = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Fixed2Meta")), 49);
        FixedData fixedData2 = new FixedData(fixedMeta2, this.m_inputStreamFactory.getInstance(directoryEntry, "Fixed2Data"));
        Props12 props12 = new Props12(this.m_inputStreamFactory.getInstance(directoryEntry, "Props"));
        new CustomFieldAliasReader(this.m_file.getCustomFields(), props12.getByteArray(RESOURCE_FIELD_NAME_ALIASES)).process();
        TreeMap<Integer, Integer> treeMap = this.createResourceMap(fieldMap12, fixedMeta, fixedData);
        Integer[] integerArray = varMeta12.getUniqueIdentifierArray();
        for (int i = 0; i < integerArray.length; ++i) {
            Integer n = integerArray[i];
            Integer n2 = treeMap.get(n);
            if (n2 == null) continue;
            byte[] byArray = fixedData.getByteArrayValue(n2);
            byte[] byArray2 = fixedMeta2.getByteArrayValue(n2);
            byte[] byArray3 = fixedData2.getByteArrayValue(n2);
            Resource resource = this.m_file.addResource();
            resource.disableEvents();
            fieldMap12.populateContainer(ResourceField.class, resource, n, new byte[][]{byArray, byArray3}, var2Data);
            fieldMap122.populateContainer(ResourceField.class, resource, n, null, var2Data);
            resource.enableEvents();
            resource.setBudget((byArray2[8] & 0x20) != 0);
            resource.setGUID(MPPUtility.getGUID(byArray3, 0));
            this.processHyperlinkData(resource, var2Data.getByteArray(n, fieldMap12.getVarDataKey(ResourceField.HYPERLINK_DATA)));
            resource.setID(MPPUtility.getInt(byArray, 4));
            resource.setOutlineCode1(this.m_outlineCodeVarData.getUnicodeString(var2Data.getInt(n, 2, fieldMap12.getVarDataKey(ResourceField.OUTLINE_CODE1_INDEX)), OUTLINECODE_DATA));
            resource.setOutlineCode2(this.m_outlineCodeVarData.getUnicodeString(var2Data.getInt(n, 2, fieldMap12.getVarDataKey(ResourceField.OUTLINE_CODE2_INDEX)), OUTLINECODE_DATA));
            resource.setOutlineCode3(this.m_outlineCodeVarData.getUnicodeString(var2Data.getInt(n, 2, fieldMap12.getVarDataKey(ResourceField.OUTLINE_CODE3_INDEX)), OUTLINECODE_DATA));
            resource.setOutlineCode4(this.m_outlineCodeVarData.getUnicodeString(var2Data.getInt(n, 2, fieldMap12.getVarDataKey(ResourceField.OUTLINE_CODE4_INDEX)), OUTLINECODE_DATA));
            resource.setOutlineCode5(this.m_outlineCodeVarData.getUnicodeString(var2Data.getInt(n, 2, fieldMap12.getVarDataKey(ResourceField.OUTLINE_CODE5_INDEX)), OUTLINECODE_DATA));
            resource.setOutlineCode6(this.m_outlineCodeVarData.getUnicodeString(var2Data.getInt(n, 2, fieldMap12.getVarDataKey(ResourceField.OUTLINE_CODE6_INDEX)), OUTLINECODE_DATA));
            resource.setOutlineCode7(this.m_outlineCodeVarData.getUnicodeString(var2Data.getInt(n, 2, fieldMap12.getVarDataKey(ResourceField.OUTLINE_CODE7_INDEX)), OUTLINECODE_DATA));
            resource.setOutlineCode8(this.m_outlineCodeVarData.getUnicodeString(var2Data.getInt(n, 2, fieldMap12.getVarDataKey(ResourceField.OUTLINE_CODE8_INDEX)), OUTLINECODE_DATA));
            resource.setOutlineCode9(this.m_outlineCodeVarData.getUnicodeString(var2Data.getInt(n, 2, fieldMap12.getVarDataKey(ResourceField.OUTLINE_CODE9_INDEX)), OUTLINECODE_DATA));
            resource.setOutlineCode10(this.m_outlineCodeVarData.getUnicodeString(var2Data.getInt(n, 2, fieldMap12.getVarDataKey(ResourceField.OUTLINE_CODE10_INDEX)), OUTLINECODE_DATA));
            resource.setType(resource.getWorkGroup() == WorkGroup.DEFAULT ? ResourceType.WORK : ((byArray2[8] & 0x10) == 0 ? ResourceType.MATERIAL : ResourceType.COST));
            resource.setUniqueID(n);
            byte[] byArray4 = fixedMeta.getByteArrayValue(n2);
            resource.setFlag(1, (byArray4[28] & 0x40) != 0);
            resource.setFlag(2, (byArray4[28] & 0x80) != 0);
            resource.setFlag(3, (byArray4[29] & 1) != 0);
            resource.setFlag(4, (byArray4[29] & 2) != 0);
            resource.setFlag(5, (byArray4[29] & 4) != 0);
            resource.setFlag(6, (byArray4[29] & 8) != 0);
            resource.setFlag(7, (byArray4[29] & 0x10) != 0);
            resource.setFlag(8, (byArray4[29] & 0x20) != 0);
            resource.setFlag(9, (byArray4[29] & 0x40) != 0);
            resource.setFlag(10, (byArray4[28] & 0x20) != 0);
            resource.setFlag(11, (byArray4[29] & 0x80) != 0);
            resource.setFlag(12, (byArray4[30] & 1) != 0);
            resource.setFlag(13, (byArray4[30] & 2) != 0);
            resource.setFlag(14, (byArray4[30] & 4) != 0);
            resource.setFlag(15, (byArray4[30] & 8) != 0);
            resource.setFlag(16, (byArray4[30] & 0x10) != 0);
            resource.setFlag(17, (byArray4[30] & 0x20) != 0);
            resource.setFlag(18, (byArray4[30] & 0x40) != 0);
            resource.setFlag(19, (byArray4[30] & 0x80) != 0);
            resource.setFlag(20, (byArray4[31] & 1) != 0);
            String string = resource.getNotes();
            if (!this.m_reader.getPreserveNoteFormatting()) {
                string = RtfHelper.strip(string);
            }
            resource.setNotes(string);
            resource.setResourceCalendar(this.m_resourceMap.get(n));
            this.processResourceEnterpriseColumns(resource, byArray2);
            CostRateTableFactory costRateTableFactory = new CostRateTableFactory();
            costRateTableFactory.process(resource, 0, var2Data.getByteArray(n, fieldMap12.getVarDataKey(ResourceField.COST_RATE_A)));
            costRateTableFactory.process(resource, 1, var2Data.getByteArray(n, fieldMap12.getVarDataKey(ResourceField.COST_RATE_B)));
            costRateTableFactory.process(resource, 2, var2Data.getByteArray(n, fieldMap12.getVarDataKey(ResourceField.COST_RATE_C)));
            costRateTableFactory.process(resource, 3, var2Data.getByteArray(n, fieldMap12.getVarDataKey(ResourceField.COST_RATE_D)));
            costRateTableFactory.process(resource, 4, var2Data.getByteArray(n, fieldMap12.getVarDataKey(ResourceField.COST_RATE_E)));
            AvailabilityFactory availabilityFactory = new AvailabilityFactory();
            availabilityFactory.process(resource.getAvailability(), var2Data.getByteArray(n, fieldMap12.getVarDataKey(ResourceField.AVAILABILITY_DATA)));
            this.m_eventManager.fireResourceReadEvent(resource);
        }
    }

    private void processAssignmentData() throws IOException {
        FieldMap12 fieldMap12 = new FieldMap12(this.m_file.getProjectProperties(), this.m_file.getCustomFields());
        fieldMap12.createAssignmentFieldMap(this.m_projectProps);
        FieldMap12 fieldMap122 = new FieldMap12(this.m_file.getProjectProperties(), this.m_file.getCustomFields());
        fieldMap122.createEnterpriseCustomFieldMap(this.m_projectProps, AssignmentField.class);
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_projectDir.getEntry("TBkndAssn");
        VarMeta12 varMeta12 = new VarMeta12(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("VarMeta")));
        Var2Data var2Data = new Var2Data(varMeta12, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Var2Data")));
        FixedMeta fixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixedMeta")), 34);
        FixedData fixedData = new FixedData(fixedMeta, this.m_inputStreamFactory.getInstance(directoryEntry, "FixedData"));
        FixedData fixedData2 = new FixedData(48, this.m_inputStreamFactory.getInstance(directoryEntry, "Fixed2Data"));
        ResourceAssignmentFactory resourceAssignmentFactory = new ResourceAssignmentFactory();
        resourceAssignmentFactory.process(this.m_file, fieldMap12, fieldMap122, this.m_reader.getUseRawTimephasedData(), this.m_reader.getPreserveNoteFormatting(), varMeta12, var2Data, fixedMeta, fixedData, fixedData2, fixedMeta.getAdjustedItemCount());
    }

    private boolean getDurationEstimated(int n) {
        return (n & 0x20) != 0;
    }

    private void processViewData() throws IOException {
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_viewDir.getEntry("CV_iew");
        VarMeta12 varMeta12 = new VarMeta12(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("VarMeta")));
        Var2Data var2Data = new Var2Data(varMeta12, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Var2Data")));
        FixedMeta fixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixedMeta")), 10);
        FixedData fixedData = new FixedData(138, this.m_inputStreamFactory.getInstance(directoryEntry, "FixedData"));
        int n = fixedMeta.getAdjustedItemCount();
        ViewFactory12 viewFactory12 = new ViewFactory12();
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            byte[] byArray = fixedMeta.getByteArrayValue(i);
            int n3 = MPPUtility.getShort(byArray, 4);
            if (n3 <= n2) continue;
            byte[] byArray2 = fixedData.getByteArrayValue(fixedData.getIndexFromOffset(n3));
            if (byArray2 != null) {
                View view = viewFactory12.createView(this.m_file, byArray, byArray2, var2Data, this.m_fontBases);
                this.m_file.getViews().add(view);
            }
            n2 = n3;
        }
    }

    private void processTableData() throws IOException {
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_viewDir.getEntry("CTable");
        VarMeta12 varMeta12 = new VarMeta12(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("VarMeta")));
        Var2Data var2Data = new Var2Data(varMeta12, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Var2Data")));
        FixedData fixedData = new FixedData(230, (InputStream)new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixedData")));
        TableContainer tableContainer = this.m_file.getTables();
        TableFactory tableFactory = new TableFactory(TABLE_COLUMN_DATA_STANDARD, TABLE_COLUMN_DATA_ENTERPRISE, TABLE_COLUMN_DATA_BASELINE);
        int n = fixedData.getItemCount();
        for (int i = 0; i < n; ++i) {
            byte[] byArray = fixedData.getByteArrayValue(i);
            Table table = tableFactory.createTable(this.m_file, byArray, varMeta12, var2Data);
            tableContainer.add(table);
        }
    }

    private void processFilterData() throws IOException {
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_viewDir.getEntry("CFilter");
        FixedMeta fixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixedMeta")), 10);
        FixedData fixedData = new FixedData(fixedMeta, this.m_inputStreamFactory.getInstance(directoryEntry, "FixedData"));
        VarMeta12 varMeta12 = new VarMeta12(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("VarMeta")));
        Var2Data var2Data = new Var2Data(varMeta12, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Var2Data")));
        FilterReader12 filterReader12 = new FilterReader12();
        filterReader12.process(this.m_file.getProjectProperties(), this.m_file.getFilters(), fixedData, var2Data);
    }

    private void processSavedViewState() throws IOException {
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_viewDir.getEntry("CEdl");
        VarMeta12 varMeta12 = new VarMeta12(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("VarMeta")));
        Var2Data var2Data = new Var2Data(varMeta12, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Var2Data")));
        DocumentInputStream documentInputStream = new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixedData"));
        byte[] byArray = new byte[((InputStream)documentInputStream).available()];
        ((InputStream)documentInputStream).read(byArray);
        ((InputStream)documentInputStream).close();
        ViewStateReader12 viewStateReader12 = new ViewStateReader12();
        viewStateReader12.process(this.m_file, var2Data, byArray);
    }

    private void processGroupData() throws IOException {
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_viewDir.getEntry("CGrouping");
        FixedMeta fixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixedMeta")), 10);
        FixedData fixedData = new FixedData(fixedMeta, this.m_inputStreamFactory.getInstance(directoryEntry, "FixedData"));
        VarMeta12 varMeta12 = new VarMeta12(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("VarMeta")));
        Var2Data var2Data = new Var2Data(varMeta12, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Var2Data")));
        GroupReader12 groupReader12 = new GroupReader12();
        groupReader12.process(this.m_file, fixedData, var2Data, this.m_fontBases);
    }

    private String getCustomFieldOutlineCodeValue(Var2Data var2Data, Var2Data var2Data2, Integer n, Integer n2) {
        Object object = null;
        int n3 = var2Data.getShort(n, n2);
        if ((n3 & 0xFF00) != 1792) {
            object = var2Data2.getUnicodeString(var2Data.getInt(n, 2, n2), OUTLINECODE_DATA);
        } else {
            int n4 = var2Data.getInt(n, 2, n2);
            CustomFieldValueItem customFieldValueItem = this.m_file.getCustomFields().getCustomFieldValueItemByUniqueID(n4);
            if (customFieldValueItem != null) {
                String string;
                Object object2 = customFieldValueItem.getValue();
                if (object2 instanceof String) {
                    object = (String)object2;
                }
                if ((string = this.getCustomFieldOutlineCodeValue(var2Data, var2Data2, customFieldValueItem.getParent())) != null && !string.isEmpty()) {
                    object = string + "." + (String)object;
                }
            }
        }
        return object;
    }

    private String getCustomFieldOutlineCodeValue(Var2Data var2Data, Var2Data var2Data2, Integer n) {
        Object object = null;
        int n2 = n;
        if (n2 == 0) {
            return "";
        }
        CustomFieldValueItem customFieldValueItem = this.m_file.getCustomFields().getCustomFieldValueItemByUniqueID(n2);
        if (customFieldValueItem != null) {
            String string;
            Object object2 = customFieldValueItem.getValue();
            if (object2 instanceof String) {
                object = (String)object2;
            }
            if (object != null && !NumberHelper.equals(n, customFieldValueItem.getParent()) && (string = this.getCustomFieldOutlineCodeValue(var2Data, var2Data2, customFieldValueItem.getParent())) != null && !string.isEmpty()) {
                object = string + "." + (String)object;
            }
        }
        return object;
    }
}

