/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.task;

import com.projectlibre1.document.Document;
import com.projectlibre1.document.ObjectEvent;
import com.projectlibre1.document.ObjectEventManager;
import com.projectlibre1.document.ObjectSelectionEventManager;
import com.projectlibre1.grouping.core.Node;
import com.projectlibre1.grouping.core.NodeFactory;
import com.projectlibre1.grouping.core.model.NodeModel;
import com.projectlibre1.grouping.core.model.NodeModelDataFactory;
import com.projectlibre1.grouping.core.model.NodeModelFactory;
import com.projectlibre1.grouping.core.summaries.DeepChildSearcher;
import com.projectlibre1.job.Job;
import com.projectlibre1.job.JobRunnable;
import com.projectlibre1.pm.calendar.WorkCalendar;
import com.projectlibre1.pm.calendar.WorkingCalendar;
import com.projectlibre1.pm.task.Project;
import com.projectlibre1.pm.task.ProjectFactory;
import com.projectlibre1.session.SessionFactory;
import com.projectlibre1.strings.Messages;
import com.projectlibre1.undo.DataFactoryUndoController;
import com.projectlibre1.util.Alert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.Predicate;

public class Portfolio
implements Document,
NodeModelDataFactory {
    NodeModel nodeModel;
    ObjectEventManager objectEventManager;
    boolean creating = false;
    private transient boolean dirty;
    ProjectFactory projectFactory = null;
    public static ImplComparator comparator = new ImplComparator();

    public Portfolio(ProjectFactory projectFactory) {
        this.projectFactory = projectFactory;
        this.objectEventManager = new ObjectEventManager();
        this.nodeModel = NodeModelFactory.getInstance().createNodeModel(this);
        this.nodeModel.getHierarchy().setNbEndVoidNodes(0);
    }

    public Project findByUniqueId(long l) {
        return (Project)DeepChildSearcher.searchForUniqueId(this.nodeModel, l);
    }

    public boolean isResourcePoolOpenAndWritable() {
        Project project = (Project)DeepChildSearcher.search(this.nodeModel, new ResourcePoolFinder(this));
        return project != null;
    }

    void addProject(final Project project, boolean bl, boolean bl2) {
        if (!bl2) {
            this._addProject(project);
            return;
        }
        Job job = null;
        if (this.creating) {
            return;
        }
        Node node = this.nodeModel.search(project, comparator);
        if (node != null) {
            if (Alert.confirm(Messages.getString("Message.projectAlreadyExists")) == 1) {
                return;
            }
            job = this.getRemoveProjectJob((Project)node.getImpl(), true);
            if (job != null && !bl) {
                SessionFactory.getInstance().getSession(project.isLocal()).schedule(job);
            }
        }
        if (!bl) {
            this._addProject(project);
            return;
        }
        Job job2 = new Job(SessionFactory.getInstance().getSession(project.isLocal()).getJobQueue(), "addProject", "Adding project...", false);
        job2.addSwingRunnable(new JobRunnable(this, "Local: addProject", 1.0f){
            final /* synthetic */ Portfolio this$0;
            {
                this.this$0 = portfolio;
                super(string, f);
            }

            @Override
            public Object run() throws Exception {
                this.this$0._addProject(project);
                this.setProgress(1.0f);
                return null;
            }
        });
        if (job == null) {
            job = job2;
        } else {
            job.addJob(job2);
        }
        SessionFactory.getInstance().getSession(project.isLocal()).schedule(job);
    }

    private void _addProject(Project project) {
        this.nodeModel.add(NodeFactory.getInstance().createNode(project), 0);
        this.handleExternalTasks(project, true, false);
        this.objectEventManager.fireCreateEvent(this, project);
        project.getResourcePool().addProject(project);
    }

    void handleExternalTasks(final Project project, final boolean bl, final boolean bl2) {
        this.forProjects(new Closure(){

            @Override
            public void execute(Object object) {
                Project project2 = (Project)object;
                if (project2 != project) {
                    project2.handleExternalTasks(project, bl, bl2);
                }
            }
        });
    }

    public void addSubproject(Project project, Project project2, Project project3) {
        Node node = this.nodeModel.search(project);
        boolean bl = false;
        if (node == null) {
            this.addProject(project, false, true);
            node = this.nodeModel.search(project);
        } else {
            bl = true;
            this.objectEventManager.fireCreateEvent(this, project);
        }
        Node node2 = this.nodeModel.search(project3);
        this.nodeModel.getHierarchy().move(node, node2, 0);
        this.objectEventManager.fireCreateEvent(this, project);
    }

    public Job getRemoveProjectJob(Project project, boolean bl) {
        return this.projectFactory.getRemoveProjectJob(project, true, true, bl);
    }

    public Job getRemoveAllProjectsJob(JobRunnable jobRunnable, boolean bl, boolean[] blArray) {
        Object object;
        boolean bl2 = true;
        if (blArray != null && blArray.length > 0) {
            blArray[0] = true;
        }
        Job job = new Job(SessionFactory.getInstance().getLocalSession().getJobQueue(), "removeAllProjects", "Removing projects...", true);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object2 = this.nodeModel.iterator();
        while (object2.hasNext()) {
            object = (Node)object2.next();
            if (object.isRoot()) continue;
            arrayList.add(object);
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            object2 = (Project)((Node)object.next()).getImpl();
            if (((Project)object2).isOpenedAsSubproject()) continue;
            Job job2 = this.getRemoveProjectJob((Project)object2, bl);
            if (job2 == null) {
                if (bl) {
                    bl2 = false;
                }
                if (blArray == null || blArray.length <= 0) continue;
                System.out.println("Close cancelled");
                blArray[0] = false;
                continue;
            }
            job.addJob(job2);
        }
        if (bl2) {
            job.addRunnable(jobRunnable, !bl, false, bl, false);
        }
        return job;
    }

    @Override
    public void addObjectListener(ObjectEvent.Listener listener) {
        this.objectEventManager.addListener(listener);
    }

    @Override
    public void removeObjectListener(ObjectEvent.Listener listener) {
        this.objectEventManager.removeListener(listener);
    }

    @Override
    public ObjectEventManager getObjectEventManager() {
        return this.objectEventManager;
    }

    @Override
    public Object createUnvalidatedObject(NodeModel nodeModel, Object object) {
        this.creating = true;
        Project project = this.projectFactory.createProject();
        this.creating = false;
        return project;
    }

    @Override
    public void addUnvalidatedObject(Object object, NodeModel nodeModel, Object object2) {
    }

    @Override
    public void validateObject(Object object, NodeModel nodeModel, Object object2, Object object3, boolean bl) {
    }

    @Override
    public void remove(Object object, NodeModel nodeModel, boolean bl, boolean bl2, boolean bl3) {
    }

    public NodeModel getNodeModel() {
        return this.nodeModel;
    }

    public void forProjects(Closure closure) {
        Iterator iterator = this.getNodeModel().iterator();
        while (iterator.hasNext()) {
            Object object = ((Node)iterator.next()).getImpl();
            if (!(object instanceof Project)) continue;
            closure.execute(object);
        }
    }

    public Collection getDirtyProjectList() {
        final ArrayList arrayList = new ArrayList();
        this.forProjects(new Closure(){

            @Override
            public void execute(Object object) {
                if (((Project)object).needsSaving()) {
                    arrayList.add(object);
                }
            }
        });
        return arrayList;
    }

    public Collection getWritableProjectList() {
        final ArrayList arrayList = new ArrayList();
        this.forProjects(new Closure(){

            @Override
            public void execute(Object object) {
                if (!((Project)object).isReadOnly()) {
                    arrayList.add(object);
                }
            }
        });
        return arrayList;
    }

    @Override
    public void fireUpdateEvent(Object object, Object object2) {
        this.objectEventManager.fireUpdateEvent(object, object2);
    }

    @Override
    public int fireMultipleTransaction(int n, boolean bl) {
        return 0;
    }

    @Override
    public WorkCalendar getDefaultCalendar() {
        return null;
    }

    @Override
    public final boolean isGroupDirty() {
        return this.dirty;
    }

    @Override
    public final void setGroupDirty(boolean bl) {
        this.dirty = bl;
    }

    public ArrayList extractCalendars() {
        return WorkingCalendar.extractCalendars(this.nodeModel.getHierarchy());
    }

    @Override
    public DataFactoryUndoController getUndoController() {
        return null;
    }

    @Override
    public void rollbackUnvalidated(NodeModel nodeModel, Object object) {
    }

    @Override
    public void initOutline(NodeModel nodeModel) {
    }

    @Override
    public NodeModelDataFactory getFactoryToUseForChildOfParent(Object object) {
        return this;
    }

    @Override
    public void setAllChildrenDirty(boolean bl) {
    }

    @Override
    public boolean containsAssignments() {
        return false;
    }

    public boolean evaluate(Object object) {
        return false;
    }

    @Override
    public ObjectSelectionEventManager getObjectSelectionEventManager() {
        return null;
    }

    private class ResourcePoolFinder
    implements Predicate {
        private ResourcePoolFinder(Portfolio portfolio) {
        }

        @Override
        public boolean evaluate(Object object) {
            Project project = (Project)object;
            return project.isMaster() && !project.isReadOnly();
        }
    }

    public static class ImplComparator
    implements Comparator {
        ImplComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object == null) {
                return object2 == null ? 0 : 1;
            }
            if (((Node)object).getImpl().equals(object2)) {
                return 0;
            }
            return 1;
        }
    }
}

