/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.audio;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.audio.AudioSink;
import org.openhab.core.audio.AudioStream;
import org.openhab.core.audio.FileAudioStream;
import org.openhab.core.audio.UnsupportedAudioFormatException;
import org.openhab.core.audio.UnsupportedAudioStreamException;
import org.openhab.core.common.Disposable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public abstract class AudioSinkAsync
implements AudioSink {
    private final Logger logger = LoggerFactory.getLogger(AudioSinkAsync.class);
    protected final Map<AudioStream, CompletableFuture<@Nullable Void>> runnableByAudioStream = new HashMap<AudioStream, CompletableFuture<Void>>();

    @Override
    public CompletableFuture<@Nullable Void> processAndComplete(@Nullable AudioStream audioStream) {
        CompletableFuture<@Nullable Void> completableFuture = new CompletableFuture<Void>();
        if (audioStream != null) {
            this.runnableByAudioStream.put(audioStream, completableFuture);
        }
        try {
            this.processAsynchronously(audioStream);
        }
        catch (UnsupportedAudioFormatException | UnsupportedAudioStreamException e) {
            completableFuture.completeExceptionally(e);
        }
        if (audioStream == null) {
            completableFuture.complete(null);
        }
        return completableFuture;
    }

    @Override
    public void process(@Nullable AudioStream audioStream) throws UnsupportedAudioFormatException, UnsupportedAudioStreamException {
        this.processAsynchronously(audioStream);
    }

    protected abstract void processAsynchronously(@Nullable AudioStream var1) throws UnsupportedAudioFormatException, UnsupportedAudioStreamException;

    protected void playbackFinished(AudioStream audioStream) {
        CompletableFuture<@Nullable Void> completableFuture = this.runnableByAudioStream.remove(audioStream);
        if (completableFuture != null) {
            completableFuture.complete(null);
        }
        if (audioStream instanceof Disposable) {
            Disposable disposableAudioStream = (Disposable)audioStream;
            try {
                disposableAudioStream.dispose();
            }
            catch (IOException e) {
                String fileName;
                if (audioStream instanceof FileAudioStream) {
                    FileAudioStream file = (FileAudioStream)audioStream;
                    v0 = file.toString();
                } else {
                    v0 = fileName = "unknown";
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Cannot dispose of stream {}", (Object)fileName, (Object)e);
                }
                this.logger.warn("Cannot dispose of stream {}, reason {}", (Object)fileName, (Object)e.getMessage());
            }
        }
    }
}

