/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.persistence.dto;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.openhab.core.library.types.DecimalType;
import org.openhab.core.library.types.QuantityType;
import org.openhab.core.types.State;

public class ItemHistoryDTO {
    public String name;
    public String totalrecords;
    public String datapoints;
    public List<HistoryDataBean> data = new ArrayList<HistoryDataBean>();

    public void addData(long time, State state) {
        HistoryDataBean newVal = new HistoryDataBean();
        newVal.time = time;
        if (state instanceof QuantityType) {
            QuantityType quantityState = (QuantityType)state;
            newVal.state = quantityState.toBigDecimal().toString();
        } else if (state instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)state;
            newVal.state = decimalType.toBigDecimal().toString();
        } else {
            newVal.state = state.toString();
        }
        this.data.add(newVal);
    }

    public void sortData() {
        this.data.sort(Comparator.comparingLong(o -> o.time));
    }

    public static class HistoryDataBean {
        public long time;
        public String state;
    }
}

