/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.AbstractGlobalScopeDelegatingScopeProvider;
import org.eclipse.xtext.scoping.impl.ImportNormalizer;
import org.eclipse.xtext.scoping.impl.ImportScope;
import org.eclipse.xtext.scoping.impl.MapBasedScope;
import org.eclipse.xtext.scoping.impl.MultimapBasedSelectable;
import org.eclipse.xtext.scoping.impl.ScopeBasedSelectable;
import org.eclipse.xtext.scoping.impl.SelectableBasedScope;
import org.eclipse.xtext.util.IResourceScopeCache;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xbase.imports.IImportsConfiguration;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.scoping.AbstractNestedTypeAwareImportNormalizer;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XImportSection;

public class XImportSectionNamespaceScopeProvider
extends AbstractGlobalScopeDelegatingScopeProvider {
    public static final QualifiedName JAVA_LANG = QualifiedName.create((String[])new String[]{"java", "lang"});
    public static final QualifiedName XBASE_LIB = QualifiedName.create((String[])new String[]{"org", "eclipse", "xtext", "xbase", "lib"});
    @Inject
    private IJvmModelAssociations associations;
    @Inject
    private IResourceScopeCache cache;
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private IImportsConfiguration importsConfiguration;

    public IQualifiedNameProvider getQualifiedNameProvider() {
        return this.qualifiedNameProvider;
    }

    public IQualifiedNameConverter getQualifiedNameConverter() {
        return this.qualifiedNameConverter;
    }

    public IScope getScope(EObject context, EReference reference) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        Resource resource = context.eResource();
        if (resource == null) {
            throw new IllegalArgumentException("context must be contained in a resource");
        }
        IScope globalScope = this.getGlobalScope(resource, reference);
        return this.internalGetScope(globalScope, globalScope, context, reference);
    }

    protected IScope getGlobalScope(Resource context, EReference reference) {
        IScope globalScope = this.getGlobalScope(context, reference, null);
        return SelectableBasedScope.createScope((IScope)globalScope, (ISelectable)this.getAllDescriptions(context), (EClass)reference.getEReferenceType(), (boolean)this.isIgnoreCase(reference));
    }

    protected IScope internalGetScope(IScope parent, IScope globalScope, EObject context, EReference reference) {
        if (context instanceof XImportDeclaration) {
            return globalScope;
        }
        IScope result = parent;
        if (context.eContainer() == null) {
            if (parent != globalScope) {
                throw new IllegalStateException("the parent should be the global scope");
            }
            result = this.getResourceScope(globalScope, context.eResource(), reference);
        } else {
            result = this.internalGetScope(parent, globalScope, context.eContainer(), reference);
        }
        return this.getLocalElementsScope(result, globalScope, context, reference);
    }

    protected IScope getLocalElementsScope(IScope parent, IScope globalScope, EObject context, EReference reference) {
        IScope result = parent;
        QualifiedName name = this.getQualifiedNameOfLocalElement(context);
        boolean ignoreCase = this.isIgnoreCase(reference);
        ISelectable resourceOnlySelectable = this.getAllDescriptions(context.eResource());
        ScopeBasedSelectable globalScopeSelectable = new ScopeBasedSelectable(globalScope);
        List<ImportNormalizer> explicitImports = this.getImportedNamespaceResolvers(context, ignoreCase);
        if (!explicitImports.isEmpty()) {
            result = this.createImportScope(result, explicitImports, (ISelectable)globalScopeSelectable, reference.getEReferenceType(), ignoreCase);
        }
        if (name != null) {
            ImportNormalizer localNormalizer = this.doCreateImportNormalizer(name, true, ignoreCase);
            result = this.createImportScope(result, Collections.singletonList(localNormalizer), resourceOnlySelectable, reference.getEReferenceType(), ignoreCase);
        }
        Set<EObject> elements = this.associations.getJvmElements(context);
        for (EObject derivedJvmElement : elements) {
            if (derivedJvmElement instanceof JvmDeclaredType) {
                JvmDeclaredType declaredType = (JvmDeclaredType)derivedJvmElement;
                QualifiedName jvmTypeName = this.getQualifiedNameOfLocalElement((EObject)declaredType);
                if (declaredType.getDeclaringType() == null && !Strings.isEmpty((String)declaredType.getPackageName())) {
                    QualifiedName packageName = this.qualifiedNameConverter.toQualifiedName(declaredType.getPackageName());
                    ImportNormalizer normalizer = this.doCreateImportNormalizer(packageName, true, ignoreCase);
                    result = this.createImportScope(result, Collections.singletonList(normalizer), (ISelectable)globalScopeSelectable, reference.getEReferenceType(), ignoreCase);
                }
                if (jvmTypeName != null && !jvmTypeName.equals((Object)name)) {
                    ImportNormalizer localNormalizer = this.doCreateImportNormalizer(jvmTypeName, true, ignoreCase);
                    result = this.createImportScope(result, Collections.singletonList(localNormalizer), resourceOnlySelectable, reference.getEReferenceType(), ignoreCase);
                }
            }
            if (!(derivedJvmElement instanceof JvmTypeParameterDeclarator)) continue;
            JvmTypeParameterDeclarator parameterDeclarator = (JvmTypeParameterDeclarator)derivedJvmElement;
            List descriptions = null;
            for (JvmTypeParameter param : parameterDeclarator.getTypeParameters()) {
                if (param.getSimpleName() == null) continue;
                if (descriptions == null) {
                    descriptions = Lists.newArrayList();
                }
                QualifiedName paramName = QualifiedName.create((String)param.getSimpleName());
                descriptions.add(EObjectDescription.create((QualifiedName)paramName, (EObject)param));
            }
            if (descriptions == null || descriptions.isEmpty()) continue;
            result = MapBasedScope.createScope((IScope)result, (Collection)descriptions);
        }
        return result;
    }

    protected IScope getResourceScope(IScope globalScope, Resource res, EReference reference) {
        IScope result = globalScope;
        ScopeBasedSelectable globalScopeSelectable = new ScopeBasedSelectable(result);
        List<ImportNormalizer> normalizers = this.getImplicitImports(this.isIgnoreCase(reference));
        if (!normalizers.isEmpty()) {
            result = this.createImportScope(result, normalizers, (ISelectable)globalScopeSelectable, reference.getEReferenceType(), this.isIgnoreCase(reference));
        }
        return result;
    }

    protected List<ImportNormalizer> getImplicitImports(boolean ignoreCase) {
        return Lists.newArrayList((Object[])new ImportNormalizer[]{this.doCreateImportNormalizer(JAVA_LANG, true, false), this.doCreateImportNormalizer(XBASE_LIB, true, false)});
    }

    protected ImportScope createImportScope(IScope parent, List<ImportNormalizer> namespaceResolvers, ISelectable importFrom, EClass type, boolean ignoreCase) {
        if (importFrom == null) {
            throw new NullPointerException("importFrom");
        }
        return new ImportScope(namespaceResolvers, parent, importFrom, type, ignoreCase);
    }

    protected Object getKey(Notifier context, EReference reference) {
        return Tuples.create(XImportSectionNamespaceScopeProvider.class, (Object)context, (Object)reference);
    }

    protected List<ImportNormalizer> getImportedNamespaceResolvers(final EObject context, final boolean ignoreCase) {
        return (List)this.cache.get((Object)Tuples.create((Object)context, (Object)ignoreCase, (Object)"imports"), context.eResource(), (Provider)new Provider<List<ImportNormalizer>>(){

            public List<ImportNormalizer> get() {
                return XImportSectionNamespaceScopeProvider.this.internalGetImportedNamespaceResolvers(context, ignoreCase);
            }
        });
    }

    protected List<ImportNormalizer> internalGetImportedNamespaceResolvers(EObject context, boolean ignoreCase) {
        if (EcoreUtil.getRootContainer((EObject)context) != context) {
            return Collections.emptyList();
        }
        XImportSection importSection = this.importsConfiguration.getImportSection((XtextResource)context.eResource());
        if (importSection != null) {
            return this.getImportedNamespaceResolvers(importSection, ignoreCase);
        }
        return Collections.emptyList();
    }

    protected IImportsConfiguration getImportsConfiguration() {
        return this.importsConfiguration;
    }

    protected List<ImportNormalizer> getImportedNamespaceResolvers(XImportSection importSection, boolean ignoreCase) {
        EList<XImportDeclaration> importDeclarations = importSection.getImportDeclarations();
        ArrayList result = Lists.newArrayListWithExpectedSize((int)importDeclarations.size());
        for (XImportDeclaration imp : importDeclarations) {
            ImportNormalizer resolver;
            if (imp.isStatic()) continue;
            String value = imp.getImportedNamespace();
            if (value == null) {
                value = imp.getImportedTypeName();
            }
            if ((resolver = this.createImportedNamespaceResolver(value, ignoreCase)) == null) continue;
            result.add(resolver);
        }
        return result;
    }

    protected ImportNormalizer createImportedNamespaceResolver(String namespace, boolean ignoreCase) {
        boolean hasWildcard;
        if (Strings.isEmpty((String)namespace)) {
            return null;
        }
        QualifiedName importedNamespace = this.qualifiedNameConverter.toQualifiedName(namespace);
        if (importedNamespace == null || importedNamespace.isEmpty()) {
            return null;
        }
        boolean bl = hasWildcard = ignoreCase ? importedNamespace.getLastSegment().equalsIgnoreCase(this.getWildcard()) : importedNamespace.getLastSegment().equals(this.getWildcard());
        if (hasWildcard) {
            if (importedNamespace.getSegmentCount() <= 1) {
                return null;
            }
            return this.doCreateImportNormalizer(importedNamespace.skipLast(1), true, ignoreCase);
        }
        return this.doCreateImportNormalizer(importedNamespace, false, ignoreCase);
    }

    protected ImportNormalizer doCreateImportNormalizer(QualifiedName importedNamespace, boolean wildcard, boolean ignoreCase) {
        return AbstractNestedTypeAwareImportNormalizer.createNestedTypeAwareImportNormalizer(importedNamespace, wildcard, ignoreCase);
    }

    protected QualifiedName getQualifiedNameOfLocalElement(EObject context) {
        return this.qualifiedNameProvider.getFullyQualifiedName(context);
    }

    protected ISelectable getAllDescriptions(final Resource resource) {
        return (ISelectable)this.cache.get((Object)"internalGetAllDescriptions", resource, (Provider)new Provider<ISelectable>(){

            public ISelectable get() {
                return XImportSectionNamespaceScopeProvider.this.internalGetAllDescriptions(resource);
            }
        });
    }

    protected ISelectable internalGetAllDescriptions(final Resource resource) {
        Iterable<EObject> allContents = new Iterable<EObject>(){

            @Override
            public Iterator<EObject> iterator() {
                return EcoreUtil.getAllContents((Resource)resource, (boolean)false);
            }
        };
        Iterable allDescriptions = Scopes.scopedElementsFor((Iterable)allContents, (Function)this.qualifiedNameProvider);
        return new MultimapBasedSelectable(allDescriptions);
    }

    public String getWildcard() {
        return "*";
    }

    protected IJvmModelAssociations getAssociations() {
        return this.associations;
    }
}

