/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.internal.i18n;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openhab.core.i18n.LocaleProvider;
import org.openhab.core.internal.i18n.LanguageResourceBundleManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.BundleTracker;

public class ResourceBundleTracker
extends BundleTracker {
    private LocaleProvider localeProvider;
    private Map<Bundle, LanguageResourceBundleManager> bundleLanguageResourceMap;
    private PackageAdmin pkgAdmin;

    public ResourceBundleTracker(BundleContext bundleContext, LocaleProvider localeProvider) {
        super(bundleContext, 60, null);
        this.localeProvider = localeProvider;
        this.pkgAdmin = (PackageAdmin)bundleContext.getService(bundleContext.getServiceReference(PackageAdmin.class.getName()));
        this.bundleLanguageResourceMap = new LinkedHashMap<Bundle, LanguageResourceBundleManager>();
    }

    public synchronized void open() {
        super.open();
    }

    public synchronized void close() {
        super.close();
        this.bundleLanguageResourceMap.clear();
    }

    public synchronized Object addingBundle(Bundle bundle, BundleEvent event) {
        if (this.isFragmentBundle(bundle)) {
            List<Bundle> hosts = this.returnHostBundles(bundle);
            for (Bundle host : hosts) {
                this.addResourceBundle(host);
            }
        } else {
            this.addResourceBundle(bundle);
        }
        return bundle;
    }

    public synchronized void removedBundle(Bundle bundle, BundleEvent event, Object object) {
        LanguageResourceBundleManager languageResource = this.bundleLanguageResourceMap.remove(bundle);
        if (languageResource != null) {
            languageResource.clearCache();
        }
        if (this.isFragmentBundle(bundle)) {
            List<Bundle> hosts = this.returnHostBundles(bundle);
            for (Bundle host : hosts) {
                this.bundleLanguageResourceMap.remove(host);
                this.addResourceBundle(host);
            }
        } else {
            this.bundleLanguageResourceMap.remove(bundle);
        }
    }

    public LanguageResourceBundleManager getLanguageResource(Bundle bundle) {
        if (bundle != null) {
            return this.bundleLanguageResourceMap.get(bundle);
        }
        return null;
    }

    public Collection<LanguageResourceBundleManager> getAllLanguageResources() {
        return this.bundleLanguageResourceMap.values();
    }

    private List<Bundle> returnHostBundles(Bundle fragment) {
        ArrayList<Bundle> hosts = new ArrayList<Bundle>();
        Bundle[] bundles = this.pkgAdmin.getHosts(fragment);
        if (bundles != null) {
            hosts.addAll(Arrays.asList(bundles));
        }
        return hosts;
    }

    private boolean isFragmentBundle(Bundle bundle) {
        return this.pkgAdmin.getBundleType(bundle) == 1;
    }

    private void addResourceBundle(Bundle bundle) {
        LanguageResourceBundleManager languageResource;
        if (bundle.getState() != 1 && (languageResource = new LanguageResourceBundleManager(this.localeProvider, bundle)).containsResources()) {
            this.bundleLanguageResourceMap.put(bundle, languageResource);
        }
    }
}

