/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.editor.hints;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.GradleReport;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.project.LookupProvider;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class GradleHintsProvider {
    private static final Logger LOG = Logger.getLogger(GradleHintsProvider.class.getName());
    private static final String LAYER_LOADING = "gradle-processing";
    private final Project gradleProject;
    private final PropertyChangeListener listener;

    public GradleHintsProvider(Project gradleProject) {
        this.gradleProject = gradleProject;
        this.listener = evt -> {
            if ("ProjectInfo".equals(evt.getPropertyName())) {
                this.updateProjectProblems();
            }
        };
        NbGradleProject.addPropertyChangeListener((Project)gradleProject, (PropertyChangeListener)this.listener);
    }

    Map<LineDocument, List<GradleReport>> openReportDocuments(boolean reportNonLocations) {
        GradleBaseProject gbp = GradleBaseProject.get((Project)this.gradleProject);
        if (gbp == null) {
            return null;
        }
        Set reports = gbp.getProblems();
        HashMap<String, LineDocument> openedDocs = new HashMap<String, LineDocument>();
        HashMap<LineDocument, List<GradleReport>> documentReports = new HashMap<LineDocument, List<GradleReport>>();
        NbGradleProject gp = NbGradleProject.get((Project)this.gradleProject);
        File scriptF = gp.getGradleFiles().getBuildScript();
        for (GradleReport r : reports) {
            String l;
            if (r.getLocation() == null || r.getLine() < 1 || scriptF == null) {
                if (!reportNonLocations) continue;
                l = scriptF.getPath();
            } else {
                l = r.getLocation();
                int n = r.getLine();
            }
            LineDocument doc = null;
            if (!openedDocs.containsKey(l)) {
                FileObject f = FileUtil.toFileObject((File)new File(l));
                if (f != null) {
                    EditorCookie cake = (EditorCookie)f.getLookup().lookup(EditorCookie.class);
                    try {
                        StyledDocument d = cake.openDocument();
                        if (d instanceof LineDocument) {
                            doc = (LineDocument)d;
                        }
                    }
                    catch (IOException ex) {
                        LOG.log(Level.INFO, "Could not open project file: {0}", l);
                    }
                }
                openedDocs.put(l, doc);
            } else {
                doc = (LineDocument)openedDocs.get(l);
            }
            if (doc == null) continue;
            documentReports.computeIfAbsent(doc, x -> new ArrayList()).add(r);
        }
        return documentReports;
    }

    void updateProjectProblems() {
        Map<LineDocument, List<GradleReport>> documentReports = this.openReportDocuments(false);
        if (documentReports == null) {
            return;
        }
        ArrayList hints = new ArrayList();
        for (Map.Entry<LineDocument, List<GradleReport>> it : documentReports.entrySet()) {
            LineDocument doc = it.getKey();
            doc.render(() -> {
                for (GradleReport r : (List)it.getValue()) {
                    hints.add(ErrorDescriptionFactory.createErrorDescription((Severity)Severity.ERROR, (String)r.formatReportForHintOrProblem(false, null), (Document)doc, (int)r.getLine()));
                }
            });
            HintsController.setErrors((Document)doc, (String)LAYER_LOADING, hints);
        }
    }

    public static class F
    implements LookupProvider {
        public Lookup createAdditionalLookup(Lookup baseContext) {
            NbGradleProject p = (NbGradleProject)baseContext.lookup(NbGradleProject.class);
            if (p == null) {
                return Lookup.EMPTY;
            }
            return Lookups.fixed((Object[])new Object[]{new GradleHintsProvider((Project)baseContext.lookup(Project.class))});
        }
    }
}

