/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsfapi.api;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum JsfNamespaces {
    JAVA_SUN_COM_NS(JsfNamespaces.entry(Type.TAGLIB, "http://java.sun.com/xml/ns/javaee")),
    XMLNS_JCP_ORG_NS(JsfNamespaces.entry(Type.TAGLIB, "http://xmlns.jcp.org/xml/ns/javaee")),
    JAKARTA_EE_NS(JsfNamespaces.entry(Type.TAGLIB, "https://jakarta.ee/xml/ns/jakartaee"));

    private final Map<Type, String> namespaces;

    private JsfNamespaces(Map.Entry<Type, String> ... entries) {
        this.namespaces = Collections.unmodifiableMap(new EnumMap<Type, String>(JsfNamespaces.ofEntries(entries)));
    }

    public String getNamespace(Type type) {
        return this.namespaces.get((Object)type);
    }

    private static Map.Entry<Type, String> entry(Type type, String value) {
        return new AbstractMap.SimpleEntry<Type, String>(type, value);
    }

    private static Map<Type, String> ofEntries(Map.Entry<Type, String> ... additional) {
        return Stream.of(additional).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static enum Type {
        TAGLIB;

    }
}

