/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.j2ee.dd.api.common.NameAlreadyUsedException;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.api.webservices.ServiceImplBean;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.classpath.ClassPathProviderImpl;
import org.netbeans.modules.websvc.api.webservices.StubDescriptor;
import org.netbeans.modules.websvc.api.webservices.WsCompileEditorSupport;
import org.netbeans.modules.websvc.spi.webservices.WebServicesConstants;
import org.netbeans.modules.websvc.spi.webservices.WebServicesSupportImpl;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.project.classpath.support.ProjectClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WebProjectWebServicesSupport
implements WebServicesSupportImpl {
    private WebProject project;
    private AntProjectHelper helper;
    private ReferenceHelper referenceHelper;
    private ClassPath projectSourcesClassPath;
    private static final String[] WSCOMPILE_SEI_SERVICE_FEATURES = new String[]{"documentliteral", "rpcliteral", "noencodedtypes", "nomultirefs", "serializeinterfaces", "strict", "useonewayoperations", "donotoverride"};
    private static final List<String> allSeiServiceFeatures = Arrays.asList(WSCOMPILE_SEI_SERVICE_FEATURES);
    private static final String[] WSCOMPILE_KEY_SEI_SERVICE_FEATURES = new String[]{"documentliteral", "rpcliteral", "strict", "useonewayoperations", "donotoverride"};
    private static final List<String> importantSeiServiceFeatures = Arrays.asList(WSCOMPILE_KEY_SEI_SERVICE_FEATURES);
    private static final String[] WSCOMPILE_WSDL_SERVICE_FEATURES = new String[]{"datahandleronly", "explicitcontext", "jaxbenumtype", "nodatabinding", "noencodedtypes", "nomultirefs", "norpcstructures", "novalidation", "resolveidref", "searchschema", "serializeinterfaces", "strict", "wsi", "unwrap", "donotoverride", "donotunwrap"};
    private static final List<String> allWsdlServiceFeatures = Arrays.asList(WSCOMPILE_WSDL_SERVICE_FEATURES);
    private static final String[] WSCOMPILE_KEY_WSDL_SERVICE_FEATURES = new String[]{"wsi", "strict", "unwrap", "donotunwrap", "donotoverride", "datahandleronly", "nodatabinding", "novalidation", "searchschema", "explicitcontext"};
    private static final List<String> importantWsdlServiceFeatures = Arrays.asList(WSCOMPILE_KEY_WSDL_SERVICE_FEATURES);
    private ClassPath platformClassPath = null;
    private static final JAXRPCStubDescriptor seiServiceStub = new JAXRPCStubDescriptor("sei_service", NbBundle.getMessage(WebProjectWebServicesSupport.class, (String)"LBL_SEIServiceStub"), new String[]{"documentliteral", "strict", "useonewayoperations"});
    private static final JAXRPCStubDescriptor wsdlServiceStub = new JAXRPCStubDescriptor("wsdl_service", NbBundle.getMessage(WebProjectWebServicesSupport.class, (String)"LBL_WSDLServiceStub"), new String[]{"wsi", "strict"});

    public WebProjectWebServicesSupport(WebProject project, AntProjectHelper helper, ReferenceHelper referenceHelper) {
        this.project = project;
        this.helper = helper;
        this.referenceHelper = referenceHelper;
    }

    public void addServiceImpl(String serviceName, FileObject configFile, boolean fromWSDL) {
        this.addServiceImpl(serviceName, configFile, fromWSDL, null);
    }

    public void addServiceImpl(String serviceName, FileObject configFile, boolean fromWSDL, String[] wscompileFeatures) {
        EditableProperties ep = this.helper.getProperties("nbproject/project.properties");
        String packageName = this.getPackageName(configFile);
        ep.put(serviceName + ".config.name", packageName + (packageName.equals("") ? "" : "/") + configFile.getNameExt());
        ep.put(serviceName + ".mapping", serviceName + "-mapping.xml");
        String featurePropertyName = "wscompile.service." + serviceName + ".features";
        this.getWebservicesDD();
        JAXRPCStubDescriptor stubDesc = null;
        stubDesc = fromWSDL ? (wscompileFeatures != null ? new JAXRPCStubDescriptor("wsdl_service", NbBundle.getMessage(WebProjectWebServicesSupport.class, (String)"LBL_WSDLServiceStub"), wscompileFeatures) : wsdlServiceStub) : seiServiceStub;
        String defaultFeatures = stubDesc.getDefaultFeaturesAsArgument();
        ep.put(featurePropertyName, defaultFeatures);
        this.helper.putProperties("nbproject/project.properties", ep);
        Element data = this.helper.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        NodeList nodes = data.getElementsByTagName("web-services");
        Element webservices = null;
        if (nodes.getLength() == 0) {
            webservices = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", "web-services");
            NodeList insertBefore = data.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", "web-service-clients");
            if (insertBefore.getLength() <= 0) {
                insertBefore = data.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", "source-roots");
                assert (insertBefore.getLength() == 1) : "Invalid project.xml file.";
            }
            data.insertBefore(webservices, insertBefore.item(0));
        } else {
            webservices = (Element)nodes.item(0);
        }
        Element webservice = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", "web-service");
        webservices.appendChild(webservice);
        Element webserviceName = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", "web-service-name");
        webservice.appendChild(webserviceName);
        webserviceName.appendChild(doc.createTextNode(serviceName));
        if (fromWSDL) {
            Element fromWSDLElem = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", "from-wsdl");
            webservice.appendChild(fromWSDLElem);
        }
        this.helper.putPrimaryConfigurationData(data, true);
        this.updateWsCompileProperties(serviceName);
        try {
            ProjectManager.getDefault().saveProject((Project)this.project);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe.getMessage());
        }
    }

    private WebApp getWebApp() {
        try {
            FileObject deploymentDescriptor = this.getDeploymentDescriptor();
            if (deploymentDescriptor != null) {
                return DDProvider.getDefault().getDDRoot(deploymentDescriptor);
            }
        }
        catch (IOException e) {
            Logger.getLogger("global").log(Level.INFO, e.getLocalizedMessage());
        }
        return null;
    }

    public void addServiceEntriesToDD(String serviceName, String serviceEndpointInterface, String servantClassName) {
        String servletName = "WSServlet_" + serviceName;
        WebApp webApp = this.getWebApp();
        if (webApp != null) {
            Servlet servlet = null;
            try {
                servlet = (Servlet)webApp.addBean("Servlet", new String[]{"ServletName", "ServletClass"}, new Object[]{servletName, servantClassName}, "ServletName");
                servlet.setLoadOnStartup(new BigInteger("1"));
                ServletMapping servletMapping = (ServletMapping)webApp.addBean("ServletMapping", new String[]{"ServletName", "UrlPattern"}, new Object[]{servletName, "/" + serviceName}, "ServletName");
                webApp.write(this.getDeploymentDescriptor());
            }
            catch (ClassNotFoundException exc) {
                exc.printStackTrace();
                throw new RuntimeException(exc.getMessage());
            }
            catch (NameAlreadyUsedException exc) {
                exc.printStackTrace();
                throw new RuntimeException(exc.getMessage());
            }
            catch (IOException exc) {
                exc.printStackTrace();
                throw new RuntimeException(exc.getMessage());
            }
        }
    }

    public FileObject getWebservicesDD() {
        FileObject webInfFo = this.getWebInf();
        if (webInfFo == null) {
            if (this.isProjectOpened()) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(WebProjectWebServicesSupport.class, (String)"MSG_WebInfCorrupted"), 0));
            }
            return null;
        }
        return this.getWebInf().getFileObject("webservices", "xml");
    }

    public FileObject getWsDDFolder() {
        return this.getWebInf();
    }

    public String getArchiveDDFolderName() {
        return "WEB-INF";
    }

    public String getImplementationBean(String linkName) {
        WebApp webApp = this.getWebApp();
        Servlet[] servlets = webApp.getServlet();
        for (int i = 0; i < servlets.length; ++i) {
            if (!servlets[i].getServletName().equals(linkName)) continue;
            return servlets[i].getServletClass();
        }
        return null;
    }

    public boolean isFromWSDL(String serviceName) {
        Element data = this.helper.getPrimaryConfigurationData(true);
        NodeList nodes = data.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", "web-services");
        Element webservices = null;
        Element wsNameNode = null;
        if (nodes.getLength() == 1) {
            webservices = (Element)nodes.item(0);
            NodeList wsNodes = webservices.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", "web-service");
            for (int j = 0; j < wsNodes.getLength(); ++j) {
                NodeList fromWSDLNodes;
                Node n;
                NodeList nl;
                Element wsNode = (Element)wsNodes.item(j);
                NodeList wsNameNodes = wsNode.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", "web-service-name");
                if (wsNameNodes.getLength() != 1 || (nl = (wsNameNode = (Element)wsNameNodes.item(0)).getChildNodes()).getLength() != 1 || (n = nl.item(0)).getNodeType() != 3 || !serviceName.equals(n.getNodeValue()) || (fromWSDLNodes = wsNode.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", "from-wsdl")).getLength() != 1) continue;
                return true;
            }
        }
        return false;
    }

    public void removeProjectEntries(String serviceName) {
        String featureProperty;
        boolean needsSave = false;
        EditableProperties ep = this.helper.getProperties("nbproject/project.properties");
        String configProperty = serviceName + ".config.name";
        String mappingProperty = serviceName + ".mapping";
        if (ep.getProperty(configProperty) != null) {
            ep.remove((Object)configProperty);
            needsSave = true;
        }
        if (ep.getProperty(mappingProperty) != null) {
            ep.remove((Object)mappingProperty);
            needsSave = true;
        }
        if (ep.getProperty(featureProperty = "wscompile.service." + serviceName + ".features") != null) {
            ep.remove((Object)featureProperty);
            needsSave = true;
        }
        if (needsSave) {
            this.helper.putProperties("nbproject/project.properties", ep);
        }
        Element data = this.helper.getPrimaryConfigurationData(true);
        NodeList nodes = data.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", "web-services");
        Element webservices = null;
        Element wsNameNode = null;
        if (nodes.getLength() == 1) {
            webservices = (Element)nodes.item(0);
            NodeList wsNodes = webservices.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", "web-service");
            for (int j = 0; j < wsNodes.getLength(); ++j) {
                Node n;
                NodeList nl;
                Element wsNode = (Element)wsNodes.item(j);
                NodeList wsNameNodes = wsNode.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", "web-service-name");
                if (wsNameNodes.getLength() != 1 || (nl = (wsNameNode = (Element)wsNameNodes.item(0)).getChildNodes()).getLength() != 1 || (n = nl.item(0)).getNodeType() != 3 || !serviceName.equals(n.getNodeValue())) continue;
                webservices.removeChild(wsNode);
                NodeList children = webservices.getChildNodes();
                if (children.getLength() == 0) {
                    data.removeChild(webservices);
                }
                needsSave = true;
                break;
            }
        }
        if (needsSave) {
            this.helper.putPrimaryConfigurationData(data, true);
            try {
                ProjectManager.getDefault().saveProject((Project)this.project);
            }
            catch (IOException ex) {
                String mes = NbBundle.getMessage(this.getClass(), (String)"MSG_ErrorSavingOnWSRemove") + serviceName + "'\r\n" + ex.getMessage();
                NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            }
        }
    }

    public void removeServiceEntry(String linkName) {
        WebApp webApp = this.getWebApp();
        Servlet[] servlets = webApp.getServlet();
        for (int i = 0; i < servlets.length; ++i) {
            Servlet servlet = servlets[i];
            if (!servlet.getServletName().equals(linkName)) continue;
            webApp.removeServlet(servlet);
            break;
        }
        ServletMapping[] mappings = webApp.getServletMapping();
        for (int j = 0; j < mappings.length; ++j) {
            ServletMapping mapping = mappings[j];
            if (!mapping.getServletName().equals(linkName)) continue;
            webApp.removeServletMapping(mapping);
        }
        try {
            webApp.write(this.getDeploymentDescriptor());
        }
        catch (IOException e) {
            NotifyDescriptor.Message ndd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(this.getClass(), (String)"MSG_Unable_WRITE_WS_DD"), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)ndd);
        }
    }

    public AntProjectHelper getAntProjectHelper() {
        return this.helper;
    }

    public String generateImplementationBean(String wsName, FileObject pkg, Project project, String delegateData) throws IOException {
        return null;
    }

    public void addServiceImplLinkEntry(ServiceImplBean serviceImplBean, String wsName) {
        serviceImplBean.setServletLink("WSServlet_" + wsName);
    }

    public ReferenceHelper getReferenceHelper() {
        return this.referenceHelper;
    }

    public List<WsCompileEditorSupport.ServiceSettings> getServices() {
        ArrayList<WsCompileEditorSupport.ServiceSettings> serviceList = new ArrayList<WsCompileEditorSupport.ServiceSettings>();
        Element data = this.helper.getPrimaryConfigurationData(true);
        NodeList nodes = data.getElementsByTagName("web-services");
        EditableProperties projectProperties = this.helper.getProperties("nbproject/project.properties");
        if (nodes.getLength() != 0) {
            Element serviceElements = (Element)nodes.item(0);
            NodeList serviceNameList = serviceElements.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", "web-service-name");
            for (int i = 0; i < serviceNameList.getLength(); ++i) {
                WsCompileEditorSupport.ServiceSettings settings;
                Node n;
                Element serviceNameElement = (Element)serviceNameList.item(i);
                NodeList nl = serviceNameElement.getChildNodes();
                if (nl.getLength() != 1 || (n = nl.item(0)).getNodeType() != 3) continue;
                String serviceName = n.getNodeValue();
                String currentFeatures = projectProperties.getProperty("wscompile.service." + serviceName + ".features");
                StubDescriptor stubType = this.getServiceStubDescriptor(serviceNameElement.getParentNode());
                if (seiServiceStub == stubType) {
                    if (currentFeatures == null) {
                        currentFeatures = seiServiceStub.getDefaultFeaturesAsArgument();
                    }
                    settings = new WsCompileEditorSupport.ServiceSettings(serviceName, stubType, currentFeatures, allSeiServiceFeatures, importantSeiServiceFeatures);
                } else {
                    if (currentFeatures == null) {
                        currentFeatures = wsdlServiceStub.getDefaultFeaturesAsArgument();
                    }
                    settings = new WsCompileEditorSupport.ServiceSettings(serviceName, stubType, currentFeatures, allWsdlServiceFeatures, importantWsdlServiceFeatures);
                }
                serviceList.add(settings);
            }
        }
        return serviceList;
    }

    private StubDescriptor getServiceStubDescriptor(Node parentNode) {
        JAXRPCStubDescriptor result = null;
        if (parentNode instanceof Element) {
            Element parentElement = (Element)parentNode;
            NodeList fromWsdlList = parentElement.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", "from-wsdl");
            result = fromWsdlList.getLength() == 1 ? wsdlServiceStub : seiServiceStub;
        }
        return result;
    }

    private String getPackageName(FileObject file) {
        FileObject parent = file.getParent();
        Sources sources = ProjectUtils.getSources((Project)this.project);
        SourceGroup[] groups = sources.getSourceGroups("java");
        String packageName = null;
        for (int i = 0; i < groups.length && packageName == null; ++i) {
            packageName = FileUtil.getRelativePath((FileObject)groups[i].getRootFolder(), (FileObject)parent);
            if (packageName == null) continue;
            packageName = groups[i].getName() + "/" + packageName;
        }
        return packageName + "";
    }

    public void addInfrastructure(String implBeanClass, FileObject pkg) {
    }

    public FileObject getDeploymentDescriptor() {
        FileObject webInfFo = this.getWebInf();
        if (webInfFo == null) {
            if (this.isProjectOpened()) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(WebProjectWebServicesSupport.class, (String)"MSG_WebInfCorrupted"), 0));
            }
            return null;
        }
        return this.getWebInf().getFileObject("web.xml");
    }

    public FileObject getWebInf() {
        return this.getFileObject("webinf.dir");
    }

    public FileObject getDocumentBase() {
        return this.getFileObject("web.docbase.dir");
    }

    private FileObject getFileObject(String propname) {
        String prop = this.helper.getStandardPropertyEvaluator().getProperty(propname);
        if (prop != null) {
            return this.helper.resolveFileObject(prop);
        }
        return null;
    }

    private boolean updateWsCompileProperties(String serviceName) {
        boolean globalPropertiesChanged = false;
        EditableProperties globalProperties = PropertyUtils.getGlobalProperties();
        if (globalProperties.getProperty("wscompile.tools.classpath") == null) {
            globalProperties.setProperty("wscompile.tools.classpath", "${java.home}\\..\\lib\\tools.jar");
            try {
                PropertyUtils.putGlobalProperties((EditableProperties)globalProperties);
            }
            catch (IOException ex) {
                NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)NbBundle.getMessage(WebProjectWebServicesSupport.class, (String)"MSG_ErrorSavingGlobalProperties", (Object)serviceName, (Object)ex.getMessage()), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            }
            globalPropertiesChanged = true;
        }
        boolean projectPropertiesChanged = false;
        EditableProperties projectProperties = this.helper.getProperties("nbproject/project.properties");
        HashSet<String> wscJars = new HashSet<String>();
        boolean newWscJars = false;
        String wscClientClasspath = projectProperties.getProperty("wscompile.classpath");
        if (wscClientClasspath != null) {
            String[] libs = PropertyUtils.tokenizePath((String)wscClientClasspath);
            for (int i = 0; i < libs.length; ++i) {
                wscJars.add(libs[i]);
            }
        }
        for (int i = 0; i < WebServicesConstants.WSCOMPILE_JARS.length; ++i) {
            if (wscJars.contains(WebServicesConstants.WSCOMPILE_JARS[i])) continue;
            wscJars.add(WebServicesConstants.WSCOMPILE_JARS[i]);
            newWscJars = true;
        }
        if (newWscJars) {
            StringBuffer newClasspathBuf = new StringBuffer(256);
            Iterator iter = wscJars.iterator();
            while (iter.hasNext()) {
                newClasspathBuf.append(iter.next());
                if (!iter.hasNext()) continue;
                newClasspathBuf.append(':');
            }
            projectProperties.put("wscompile.classpath", newClasspathBuf.toString());
            projectPropertiesChanged = true;
        }
        if (projectProperties.getProperty("wscompile.tools.classpath") == null) {
            projectProperties.setProperty("wscompile.tools.classpath", "${java.home}\\..\\lib\\tools.jar");
            projectPropertiesChanged = true;
        }
        if (projectPropertiesChanged) {
            this.helper.putProperties("nbproject/project.properties", projectProperties);
        }
        return globalPropertiesChanged || projectPropertiesChanged;
    }

    public FileObject getWsdlFolder(boolean create) throws IOException {
        FileObject wsdlFolder = null;
        FileObject webInf = this.getWebInf();
        if (webInf != null) {
            wsdlFolder = webInf.getFileObject("wsdl");
            if (wsdlFolder == null && create) {
                wsdlFolder = webInf.createFolder("wsdl");
            }
        } else if (create) {
            Logger.getLogger("global").log(Level.INFO, NbBundle.getMessage(WebProjectWebServicesSupport.class, (String)"MSG_WebInfNotFoundForWsdlFolder"));
        }
        return wsdlFolder;
    }

    private boolean isProjectOpened() {
        if (OpenProjects.getDefault() == null) {
            return true;
        }
        Project[] projects = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projects.length; ++i) {
            if (!projects[i].equals(this.project)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassPath getClassPath() {
        WebProjectWebServicesSupport webProjectWebServicesSupport = this;
        synchronized (webProjectWebServicesSupport) {
            if (this.projectSourcesClassPath == null) {
                ClassPathProviderImpl cpProvider = this.project.getClassPathProvider();
                this.projectSourcesClassPath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{cpProvider.getProjectSourcesClassPath("classpath/source"), this.getJ2eePlatformClassPath()});
            }
            return this.projectSourcesClassPath;
        }
    }

    public synchronized ClassPath getJ2eePlatformClassPath() {
        if (this.platformClassPath == null) {
            this.platformClassPath = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)FileUtil.toFile((FileObject)this.project.getProjectDirectory()), (PropertyEvaluator)this.project.evaluator(), (String[])new String[]{"j2ee.platform.classpath"}));
        }
        return this.platformClassPath;
    }

    private static class JAXRPCStubDescriptor
    extends StubDescriptor {
        private String[] defaultFeatures;

        public JAXRPCStubDescriptor(String name, String displayName, String[] defaultFeatures) {
            super(name, displayName);
            this.defaultFeatures = defaultFeatures;
        }

        public String[] getDefaultFeatures() {
            return this.defaultFeatures;
        }

        public String getDefaultFeaturesAsArgument() {
            StringBuffer buf = new StringBuffer(this.defaultFeatures.length * 32);
            for (int i = 0; i < this.defaultFeatures.length; ++i) {
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(this.defaultFeatures[i]);
            }
            return buf.toString();
        }
    }
}

