/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.web.core.api.JspColoringData;
import org.netbeans.modules.web.core.syntax.JspUtils;
import org.netbeans.spi.editor.errorstripe.UpToDateStatus;
import org.netbeans.spi.editor.errorstripe.UpToDateStatusProvider;
import org.openide.loaders.DataObject;
import org.openide.util.WeakListeners;

final class JspUpToDateStatusProvider
extends UpToDateStatusProvider
implements DocumentListener,
PropertyChangeListener {
    private UpToDateStatus upToDate = UpToDateStatus.UP_TO_DATE_OK;

    public static JspUpToDateStatusProvider get(Document doc) {
        JspUpToDateStatusProvider provider = (JspUpToDateStatusProvider)doc.getProperty(JspUpToDateStatusProvider.class);
        if (provider == null) {
            provider = new JspUpToDateStatusProvider(doc);
            doc.putProperty(JspUpToDateStatusProvider.class, provider);
        }
        return provider;
    }

    private JspUpToDateStatusProvider(Document document) {
        document.addDocumentListener(this);
        DataObject documentDO = NbEditorUtilities.getDataObject((Document)document);
        if (documentDO != null && documentDO.isValid()) {
            JspColoringData jspcd = JspUtils.getJSPColoringData(documentDO.getPrimaryFile());
            if (jspcd != null) {
                jspcd.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)jspcd));
            } else {
                this.upToDate = UpToDateStatus.UP_TO_DATE_DIRTY;
                Logger.getAnonymousLogger().info("JspUtils.getJSPColoringData(document, " + documentDO.getPrimaryFile() + ") returned null!");
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Boolean newValue = (Boolean)evt.getNewValue();
        if ("parsingInProgress".equals(evt.getPropertyName()) && newValue.booleanValue()) {
            this.setUpToDate(UpToDateStatus.UP_TO_DATE_PROCESSING);
        }
        if ("parsingSuccessful".equals(evt.getPropertyName())) {
            this.setUpToDate(UpToDateStatus.UP_TO_DATE_OK);
        }
    }

    public synchronized UpToDateStatus getUpToDate() {
        return this.upToDate;
    }

    private void setUpToDate(UpToDateStatus upToDate) {
        UpToDateStatus oldStatus = this.upToDate;
        if (oldStatus.equals((Object)upToDate)) {
            return;
        }
        this.upToDate = upToDate;
        this.firePropertyChange("upToDate", oldStatus, upToDate);
    }

    @Override
    public synchronized void removeUpdate(DocumentEvent e) {
        this.setUpToDate(UpToDateStatus.UP_TO_DATE_DIRTY);
    }

    @Override
    public synchronized void insertUpdate(DocumentEvent e) {
        this.setUpToDate(UpToDateStatus.UP_TO_DATE_DIRTY);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }
}

