/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.core.lib;

import java.awt.Color;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public abstract class AbstractUtil {
    private ErrorManager packageErrorManager;
    private static final int DEBUG_SEVERITY = 1;

    public final String getString(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return NbBundle.getMessage(this.getClass(), (String)key);
    }

    public final String getString(String key, Object param) {
        if (key == null) {
            throw new NullPointerException();
        }
        return NbBundle.getMessage(this.getClass(), (String)key, (Object)param);
    }

    public final String getString(String key, Object param1, Object param2) {
        if (key == null) {
            throw new NullPointerException();
        }
        return NbBundle.getMessage(this.getClass(), (String)key, (Object)param1, (Object)param2);
    }

    public final char getChar(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return NbBundle.getMessage(this.getClass(), (String)key).charAt(0);
    }

    public final Color getColor(String key) {
        String raw = null;
        try {
            raw = this.getString(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(raw, ", \t");
        if (tokenizer.countTokens() < 3) {
            if (tokenizer.countTokens() == 1 && "null".equals(tokenizer.nextToken())) {
                return null;
            }
            throw new MissingResourceException("Invalid color format: " + raw, this.getClass().getName(), key);
        }
        String red = tokenizer.nextToken();
        String green = tokenizer.nextToken();
        String blue = tokenizer.nextToken();
        int r = Integer.parseInt(red);
        if (r < 0 || r > 255) {
            throw new MissingResourceException("Invalid color format: " + raw, this.getClass().getName(), key);
        }
        int g = Integer.parseInt(green);
        if (g < 0 || g > 255) {
            throw new MissingResourceException("Invalid color format: " + raw, this.getClass().getName(), key);
        }
        int b = Integer.parseInt(blue);
        if (b < 0 || b > 255) {
            throw new MissingResourceException("Invalid color format: " + raw, this.getClass().getName(), key);
        }
        return new Color(r, g, b);
    }

    public final boolean isLoggable() {
        return this.getErrorManager().isLoggable(1);
    }

    public final void debug(String message) {
        if (message == null) {
            return;
        }
        this.getErrorManager().log(1, message);
    }

    public final void debug(Throwable ex) {
        if (ex == null) {
            return;
        }
        this.getErrorManager().notify(1, ex);
    }

    public final void debug(String message, Throwable ex) {
        if (ex == null) {
            return;
        }
        if (message != null) {
            ex = this.getErrorManager().annotate(ex, 1, message, null, null, null);
        }
        this.debug(ex);
    }

    public final synchronized ErrorManager getErrorManager() {
        if (this.packageErrorManager == null) {
            String pack = "org.netbeans.modules.xml.core.lib";
            this.packageErrorManager = ErrorManager.getDefault().getInstance(pack);
        }
        return this.packageErrorManager;
    }
}

