/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.api.MemberInfo;
import org.netbeans.modules.refactoring.java.plugins.Bundle;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.plugins.MoveTransformer;
import org.netbeans.modules.refactoring.java.plugins.PullUpTransformer;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;
import org.netbeans.modules.refactoring.java.spi.ToPhaseException;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class PushDownTransformer
extends RefactoringVisitor {
    private final FileObject originFile;
    private final MemberInfo<ElementHandle<? extends Element>>[] members;
    private Problem problem;
    private boolean inSuperClass;
    private final Deque<Map<Tree, Tree>> translateQueue;

    public Problem getProblem() {
        return this.problem;
    }

    public PushDownTransformer(FileObject originFile, MemberInfo<ElementHandle<? extends Element>>[] members) {
        this.originFile = originFile;
        this.members = members;
        this.translateQueue = new LinkedList<Map<Tree, Tree>>();
    }

    @Override
    public void setWorkingCopy(WorkingCopy workingCopy) throws ToPhaseException {
        SourceUtils.forceSource((CompilationController)workingCopy, (FileObject)this.originFile);
        super.setWorkingCopy(workingCopy);
    }

    public Tree visitClass(ClassTree node, Element source) {
        GeneratorUtilities genUtils = GeneratorUtilities.get((WorkingCopy)this.workingCopy);
        TreePath classPath = this.getCurrentPath();
        ClassTree classTree = node;
        this.translateQueue.addLast(new HashMap());
        Element el = this.workingCopy.getTrees().getElement(this.getCurrentPath());
        this.inSuperClass = el.equals(source);
        Tree value = (Tree)super.visitClass(classTree, (Object)source);
        if (this.inSuperClass) {
            classTree = this.rewriteSuperClass(el, classTree, genUtils);
        } else {
            TypeMirror tm = el.asType();
            Types types = this.workingCopy.getTypes();
            Trees trees = this.workingCopy.getTrees();
            if (types.isSubtype(types.erasure(tm), types.erasure(source.asType()))) {
                classTree = this.rewriteSubClass(el, source, genUtils, trees, node);
            }
        }
        Map<Tree, Tree> original2Translated = this.translateQueue.pollLast();
        classTree = (ClassTree)this.workingCopy.getTreeUtilities().translate((Tree)classTree, original2Translated);
        if (!this.translateQueue.isEmpty()) {
            this.translateQueue.getLast().put(node, classTree);
        } else {
            this.rewrite(node, classTree);
        }
        return value;
    }

    public Tree visitMemberSelect(MemberSelectTree node, Element source) {
        final Element el = this.workingCopy.getTrees().getElement(this.getCurrentPath());
        if (el == null) {
            return (Tree)super.visitMemberSelect(node, (Object)source);
        }
        for (int i = 0; i < this.members.length; ++i) {
            Element member = this.members[i].getElementHandle().resolve((CompilationInfo)this.workingCopy);
            if (!el.equals(member)) continue;
            String isSuper = node.getExpression().toString();
            if (!isSuper.equals("super") && !isSuper.endsWith(".super")) break;
            Scope scope = this.workingCopy.getTrees().getScope(this.getCurrentPath());
            Iterable localMembersAndVars = this.workingCopy.getElementUtilities().getLocalMembersAndVars(scope, new ElementUtilities.ElementAcceptor(){
                private final Set<ElementKind> VARIABLE_KINDS = EnumSet.of(ElementKind.ENUM_CONSTANT, ElementKind.EXCEPTION_PARAMETER, ElementKind.FIELD, ElementKind.LOCAL_VARIABLE, ElementKind.PARAMETER);
                private final Set<ElementKind> METHOD_KINDS = EnumSet.of(ElementKind.METHOD, ElementKind.CONSTRUCTOR);

                public boolean accept(Element e, TypeMirror type) {
                    if (e == el) {
                        return false;
                    }
                    if (this.VARIABLE_KINDS.contains((Object)el.getKind())) {
                        return this.VARIABLE_KINDS.contains((Object)e.getKind()) && e.getSimpleName().contentEquals(el.getSimpleName());
                    }
                    return this.METHOD_KINDS.contains((Object)e.getKind()) && e.getSimpleName().contentEquals(el.getSimpleName());
                }
            });
            Object ident = node.getIdentifier().toString();
            if (localMembersAndVars.iterator().hasNext()) {
                ident = "this." + (String)ident;
            }
            TreePath enclosingMethod = JavaPluginUtils.findMethod(this.getCurrentPath());
            Element methodEl = this.workingCopy.getTrees().getElement(enclosingMethod);
            TypeElement enclosingTypeElement = this.workingCopy.getElementUtilities().enclosingTypeElement(methodEl);
            TypeMirror tm = enclosingTypeElement.asType();
            Types types = this.workingCopy.getTypes();
            if (!types.isSubtype(types.erasure(tm), types.erasure(source.asType()))) {
                while (enclosingTypeElement != null && !types.isSubtype(types.erasure(enclosingTypeElement.asType()), types.erasure(source.asType()))) {
                    enclosingTypeElement = this.workingCopy.getElementUtilities().enclosingTypeElement((Element)enclosingTypeElement);
                }
                if (enclosingTypeElement != null) {
                    ident = enclosingTypeElement.getSimpleName().toString() + "." + (String)ident;
                }
            }
            this.translateQueue.getLast().put(node, this.make.Identifier((CharSequence)ident));
            break;
        }
        return (Tree)super.visitMemberSelect(node, (Object)source);
    }

    public Tree visitIdentifier(IdentifierTree node, Element source) {
        Element el;
        if (this.inSuperClass && (el = this.workingCopy.getTrees().getElement(this.getCurrentPath())) != null) {
            for (int i = 0; i < this.members.length; ++i) {
                Element member;
                if (this.members[i].getGroup() == MemberInfo.Group.IMPLEMENTS || this.members[i].isMakeAbstract() || !el.equals(member = this.members[i].getElementHandle().resolve((CompilationInfo)this.workingCopy))) continue;
                this.problem = MoveTransformer.createProblem(this.problem, false, Bundle.ERR_PushDown_UsedInSuper(member.getSimpleName(), source.getSimpleName()));
            }
        }
        return (Tree)super.visitIdentifier(node, (Object)source);
    }

    public Tree visitMethod(MethodTree node, Element p) {
        Element el;
        if (this.inSuperClass && (el = this.workingCopy.getTrees().getElement(this.getCurrentPath())) != null) {
            for (int i = 0; i < this.members.length; ++i) {
                Element member;
                if (this.members[i].getGroup() == MemberInfo.Group.IMPLEMENTS || !el.equals(member = this.members[i].getElementHandle().resolve((CompilationInfo)this.workingCopy))) continue;
                return node;
            }
        }
        return (Tree)super.visitMethod(node, (Object)p);
    }

    private ClassTree rewriteSubClass(Element el, Element source, GeneratorUtilities genUtils, Trees trees, ClassTree tree) throws MissingResourceException {
        ClassTree njuClass = tree;
        boolean makeClassAbstract = false;
        for (int i = 0; i < this.members.length; ++i) {
            TreePath path;
            Element member = this.members[i].getElementHandle().resolve((CompilationInfo)this.workingCopy);
            if (this.members[i].getGroup() == MemberInfo.Group.IMPLEMENTS) {
                if (((TypeElement)el).getInterfaces().contains(member.asType())) {
                    this.problem = MoveTransformer.createProblem(this.problem, false, Bundle.ERR_PushDown_AlreadyExists(member.getSimpleName(), el.getSimpleName()));
                }
                njuClass = this.make.addClassImplementsClause(njuClass, (Tree)this.make.QualIdent(member));
                continue;
            }
            if (this.members[i].getGroup() == MemberInfo.Group.METHOD && member.getModifiers().contains((Object)Modifier.ABSTRACT) && el.getKind().isClass() && source.getKind().isInterface()) {
                if (RefactoringUtils.elementExistsIn((TypeElement)el, member, (CompilationInfo)this.workingCopy)) {
                    this.problem = MoveTransformer.createProblem(this.problem, false, Bundle.ERR_PushDown_AlreadyExists(member.getSimpleName(), el.getSimpleName()));
                }
                path = this.workingCopy.getTrees().getPath(member);
                MethodTree methodTree = (MethodTree)path.getLeaf();
                methodTree = (MethodTree)genUtils.importComments((Tree)methodTree, path.getCompilationUnit());
                ModifiersTree mods = RefactoringUtils.makeAbstract(this.make, methodTree.getModifiers());
                mods = this.make.addModifiersModifier(mods, Modifier.PUBLIC);
                MethodTree njuMethod = this.make.Method(mods, (CharSequence)methodTree.getName(), methodTree.getReturnType(), methodTree.getTypeParameters(), methodTree.getParameters(), methodTree.getThrows(), (BlockTree)null, null);
                genUtils.copyComments((Tree)methodTree, (Tree)njuMethod, true);
                genUtils.copyComments((Tree)methodTree, (Tree)njuMethod, false);
                njuClass = genUtils.insertClassMember(njuClass, (Tree)njuMethod);
                makeClassAbstract = true;
                continue;
            }
            if (RefactoringUtils.elementExistsIn((TypeElement)el, member, (CompilationInfo)this.workingCopy)) {
                this.problem = MoveTransformer.createProblem(this.problem, false, NbBundle.getMessage(PushDownTransformer.class, (String)"ERR_PushDown_AlreadyExists", (Object)member.getSimpleName(), (Object)el.getSimpleName()));
            }
            path = this.workingCopy.getTrees().getPath(member);
            Tree memberTree = path.getLeaf();
            memberTree = genUtils.importComments(memberTree, path.getCompilationUnit());
            List comments = this.workingCopy.getTreeUtilities().getComments(memberTree, true);
            if (comments.isEmpty()) {
                comments = this.workingCopy.getTreeUtilities().getComments(memberTree, false);
            }
            memberTree = genUtils.importFQNs(memberTree);
            if (this.members[i].isMakeAbstract() && memberTree.getKind() == Tree.Kind.METHOD && member.getModifiers().contains((Object)Modifier.PRIVATE)) {
                oldOne = (MethodTree)memberTree;
                MethodTree m = this.make.Method(this.make.addModifiersModifier(this.make.removeModifiersModifier(oldOne.getModifiers(), Modifier.PRIVATE), Modifier.PROTECTED), (CharSequence)oldOne.getName(), oldOne.getReturnType(), oldOne.getTypeParameters(), oldOne.getParameters(), oldOne.getThrows(), oldOne.getBody(), (ExpressionTree)oldOne.getDefaultValue());
                genUtils.copyComments(memberTree, (Tree)m, true);
                genUtils.copyComments(memberTree, (Tree)m, false);
                njuClass = genUtils.insertClassMember(njuClass, (Tree)m);
            } else if (memberTree.getKind() == Tree.Kind.METHOD) {
                oldOne = (MethodTree)memberTree;
                Tree returnType = oldOne.getReturnType();
                TreePath returnTypePath = new TreePath(path, returnType);
                Element returnEl = trees.getElement(returnTypePath);
                if (returnEl != null && returnEl.getKind() != ElementKind.TYPE_PARAMETER) {
                    returnType = this.make.QualIdent(returnEl);
                }
                ArrayList<ExpressionTree> aThrows = new ArrayList<ExpressionTree>(oldOne.getThrows().size());
                for (ExpressionTree expressionTree : oldOne.getThrows()) {
                    TreePath thrwPath = new TreePath(path, expressionTree);
                    Element thrwEl = trees.getElement(thrwPath);
                    if (thrwEl != null && thrwEl.getKind() != ElementKind.TYPE_PARAMETER) {
                        aThrows.add(this.make.QualIdent(thrwEl));
                        continue;
                    }
                    aThrows.add(expressionTree);
                }
                TreePath mpath = this.workingCopy.getTrees().getPath(member);
                ExecutableElement executableElement = this.workingCopy.getElementUtilities().getOverriddenMethod((ExecutableElement)member);
                MethodTree m = this.make.Method(executableElement != null && this.workingCopy.getElementUtilities().isMemberOf((Element)executableElement, (TypeElement)el) ? oldOne.getModifiers() : PullUpTransformer.removeAnnotations(this.workingCopy, this.make, oldOne.getModifiers(), mpath), (CharSequence)oldOne.getName(), returnType, oldOne.getTypeParameters(), oldOne.getParameters(), aThrows, oldOne.getBody(), (ExpressionTree)oldOne.getDefaultValue());
                genUtils.copyComments(memberTree, (Tree)m, true);
                genUtils.copyComments(memberTree, (Tree)m, false);
                njuClass = genUtils.insertClassMember(njuClass, (Tree)m);
            } else {
                njuClass = genUtils.insertClassMember(njuClass, memberTree);
            }
            makeClassAbstract |= member.getModifiers().contains((Object)Modifier.ABSTRACT);
        }
        if (makeClassAbstract && !njuClass.getModifiers().getFlags().contains((Object)Modifier.ABSTRACT) && njuClass.getKind() != Tree.Kind.INTERFACE) {
            njuClass = this.make.Class(RefactoringUtils.makeAbstract(this.make, njuClass.getModifiers()), (CharSequence)njuClass.getSimpleName(), njuClass.getTypeParameters(), njuClass.getExtendsClause(), njuClass.getImplementsClause(), njuClass.getPermitsClause(), njuClass.getMembers());
        }
        return njuClass;
    }

    private ClassTree rewriteSuperClass(Element el, ClassTree tree, GeneratorUtilities genUtils) {
        int i;
        boolean classIsAbstract = el.getKind().isInterface();
        ClassTree njuClass = tree;
        for (Tree tree2 : tree.getImplementsClause()) {
            Element currentInterface = this.workingCopy.getTrees().getElement(TreePath.getPath(this.getCurrentPath(), tree2));
            if (currentInterface == null) continue;
            for (i = 0; i < this.members.length; ++i) {
                if (this.members[i].getGroup() != MemberInfo.Group.IMPLEMENTS || !currentInterface.equals(this.members[i].getElementHandle().resolve((CompilationInfo)this.workingCopy))) continue;
                njuClass = this.make.removeClassImplementsClause(njuClass, tree2);
            }
        }
        for (Tree tree3 : njuClass.getMembers()) {
            Element current = this.workingCopy.getTrees().getElement(new TreePath(this.getCurrentPath(), tree3));
            for (i = 0; i < this.members.length; ++i) {
                if (this.members[i].getGroup() == MemberInfo.Group.IMPLEMENTS || !current.equals(this.members[i].getElementHandle().resolve((CompilationInfo)this.workingCopy))) continue;
                if (this.members[i].isMakeAbstract()) {
                    if (el.getKind().isClass()) {
                        if (!classIsAbstract) {
                            classIsAbstract = true;
                            EnumSet<Modifier> mod = EnumSet.of(Modifier.ABSTRACT);
                            mod.addAll(njuClass.getModifiers().getFlags());
                            ModifiersTree modifiers = this.make.Modifiers(mod);
                            this.translateQueue.getLast().put(njuClass.getModifiers(), modifiers);
                        }
                        MethodTree method = (MethodTree)tree3;
                        EnumSet<Modifier> mod = EnumSet.of(Modifier.ABSTRACT);
                        mod.addAll(method.getModifiers().getFlags());
                        if (mod.contains((Object)Modifier.PRIVATE)) {
                            mod.remove((Object)Modifier.PRIVATE);
                            mod.add(Modifier.PROTECTED);
                        }
                        MethodTree nju = this.make.Method(this.make.Modifiers(mod), (CharSequence)method.getName(), method.getReturnType(), method.getTypeParameters(), method.getParameters(), method.getThrows(), (BlockTree)null, (ExpressionTree)method.getDefaultValue());
                        genUtils.copyComments((Tree)method, (Tree)nju, true);
                        genUtils.copyComments((Tree)method, (Tree)nju, false);
                        this.translateQueue.getLast().put(method, nju);
                    }
                } else {
                    njuClass = this.make.removeClassMember(njuClass, tree3);
                }
                this.fixVisibility(current);
            }
        }
        return njuClass;
    }

    void fixVisibility(final Element el) {
        if (el.getKind() != ElementKind.METHOD) {
            return;
        }
        new ErrorAwareTreePathScanner(){

            public Object visitIdentifier(IdentifierTree node, Object p) {
                this.check();
                return super.visitIdentifier(node, p);
            }

            public Object visitMemberSelect(MemberSelectTree node, Object p) {
                this.check();
                return super.visitMemberSelect(node, p);
            }

            private void check() throws IllegalArgumentException {
                Element thisElement = PushDownTransformer.this.workingCopy.getTrees().getElement(this.getCurrentPath());
                if (thisElement != null && thisElement.getKind() != ElementKind.PACKAGE && PushDownTransformer.this.workingCopy.getElementUtilities().enclosingTypeElement(thisElement) == el.getEnclosingElement()) {
                    Tree tree = PushDownTransformer.this.workingCopy.getTrees().getTree(thisElement);
                    if (thisElement.getKind().isField() && tree != null) {
                        this.makeProtectedIfPrivate(((VariableTree)tree).getModifiers());
                    } else if (thisElement.getKind() == ElementKind.METHOD) {
                        this.makeProtectedIfPrivate(((MethodTree)tree).getModifiers());
                    } else if (thisElement.getKind().isClass() || thisElement.getKind().isInterface()) {
                        this.makeProtectedIfPrivate(((ClassTree)tree).getModifiers());
                    }
                }
            }

            private void makeProtectedIfPrivate(ModifiersTree modTree) {
                if (modTree.getFlags().contains((Object)Modifier.PRIVATE)) {
                    ModifiersTree newMods = PushDownTransformer.this.workingCopy.getTreeMaker().removeModifiersModifier(modTree, Modifier.PRIVATE);
                    newMods = PushDownTransformer.this.workingCopy.getTreeMaker().addModifiersModifier(newMods, Modifier.PROTECTED);
                    PushDownTransformer.this.rewrite(modTree, newMods);
                }
            }
        }.scan(this.workingCopy.getTrees().getPath(el), null);
    }
}

