/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.impl;

import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.project.Project;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.spi.HudsonLogger;
import org.netbeans.modules.hudson.spi.HudsonSCM;
import org.netbeans.modules.hudson.ui.impl.Bundle;
import org.netbeans.modules.hudson.ui.impl.HudsonLoggerHelper;
import org.netbeans.modules.hudson.ui.spi.ProjectHudsonProvider;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public class PlainLogger
implements HudsonLogger {
    private static final Logger LOG = Logger.getLogger(PlainLogger.class.getName());

    public HudsonLogger.HudsonLogSession createSession(final HudsonJob job) {
        return new HudsonLogger.HudsonLogSession(){
            final PlainLoggerLogic logic;
            {
                this.logic = new PlainLoggerLogic(job, job.getName());
            }

            public boolean handle(String line, OutputWriter stream) {
                OutputListener link = this.logic.findHyperlink(line);
                if (link != null) {
                    try {
                        stream.println(line, link);
                        return true;
                    }
                    catch (IOException x) {
                        LOG.log(Level.INFO, null, x);
                    }
                }
                stream.println(line);
                return true;
            }
        };
    }

    private static class URLHyperlink
    implements OutputListener {
        private final URL u;

        URLHyperlink(URL u) {
            this.u = u;
        }

        public void outputLineAction(OutputEvent ev) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(this.u);
        }

        public String toString() {
            return this.u.toString();
        }
    }

    private static class Hyperlink
    implements OutputListener {
        private static final RequestProcessor RP = new RequestProcessor(Hyperlink.class);
        private final HudsonJob job;
        private final String path;
        private final String message;
        private final int row;
        private final int col;

        public Hyperlink(HudsonJob job, String path, String message, int row, int col) {
            this.job = job;
            this.path = path;
            this.message = message;
            this.row = row;
            this.col = col;
        }

        public void outputLineAction(OutputEvent ev) {
            this.acted(true);
        }

        public void outputLineSelected(OutputEvent ev) {
            this.acted(false);
        }

        private void acted(final boolean force) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    FileObject f = null;
                    Project p = ProjectHudsonProvider.getDefault().findAssociatedProject(ProjectHudsonProvider.Association.forJob(job));
                    if (p != null) {
                        String localPath = null;
                        File localRoot = FileUtil.toFile((FileObject)p.getProjectDirectory());
                        if (localRoot != null) {
                            for (HudsonSCM scm : Lookup.getDefault().lookupAll(HudsonSCM.class)) {
                                localPath = scm.translateWorkspacePath(job, path, localRoot);
                                if (localPath == null) continue;
                                LOG.log(Level.FINE, "Translating remote path {0} to {1} using {2}", new Object[]{path, localPath, scm});
                                break;
                            }
                        }
                        if (localPath == null) {
                            LOG.fine("Falling back to guess that remote workspace is a project root");
                            localPath = path;
                        }
                        f = p.getProjectDirectory().getFileObject(localPath);
                        LOG.log(Level.FINE, "Tried to find local file in {0} at {1} using {2}", new Object[]{p, f, localPath});
                    }
                    if (f == null) {
                        StatusDisplayer.getDefault().setStatusText(Bundle.Hyperlinker_looking_for(path));
                        f = job.getRemoteWorkspace().findResource(path);
                        LOG.log(Level.FINE, "Tried to find remote file at {0} using {1}", new Object[]{f, path});
                    }
                    if (f == null) {
                        if (force) {
                            StatusDisplayer.getDefault().setStatusText(Bundle.Hyperlinker_not_found(path));
                            Toolkit.getDefaultToolkit().beep();
                        }
                        return;
                    }
                    StatusDisplayer.getDefault().setStatusText(message);
                    HudsonLoggerHelper.openAt(f, row, col, force);
                }
            });
        }

        public void outputLineCleared(OutputEvent ev) {
        }

        public String toString() {
            return this.path + ":" + this.row + ":" + this.col + ":" + this.message;
        }
    }

    static class PlainLoggerLogic {
        private static final Pattern REMOTE_URL = Pattern.compile("\\b(https?://[^\\s)>]+)");
        private final HudsonJob job;
        private final Pattern hyperlinkable;

        PlainLoggerLogic(HudsonJob job, String jobName) {
            this.job = job;
            String jobNameQ = Pattern.quote(jobName);
            this.hyperlinkable = Pattern.compile("\\s*(?:\\[.+\\] )?/.+?/(?:jobs/" + jobNameQ + "/workspace|workspace/" + jobNameQ + ")/([^:]+):(?:\\[?([0-9]+)[:,](?:([0-9]+)[]:])?)? (?:warning: )?(.+)");
        }

        OutputListener findHyperlink(String line) {
            try {
                Matcher m = this.hyperlinkable.matcher(line);
                if (m.matches()) {
                    String path = m.group(1);
                    int row = m.group(2) != null ? Integer.parseInt(m.group(2)) - 1 : -1;
                    int col = m.group(3) != null ? Integer.parseInt(m.group(3)) - 1 : -1;
                    String message = m.group(4);
                    return new Hyperlink(this.job, path, message, row, col);
                }
                m = REMOTE_URL.matcher(line);
                if (m.matches()) {
                    return new URLHyperlink(new URL(m.group()));
                }
            }
            catch (MalformedURLException x) {
                LOG.log(Level.FINE, null, x);
            }
            return null;
        }
    }
}

