/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors2;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.netbeans.modules.form.BeanPropertyEditor;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormDesignValue;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormPropertyContext;
import org.netbeans.modules.form.FormPropertyEditorManager;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.NamedPropertyEditor;
import org.netbeans.modules.form.ResourceSupport;
import org.netbeans.modules.form.ResourceValue;
import org.netbeans.modules.form.ResourceWrapperEditor;
import org.netbeans.modules.form.editors2.BorderDesignSupport;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.propertysheet.PropertySheetView;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.explorer.view.ListView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public final class BorderEditor
extends PropertyEditorSupport
implements FormAwareEditor,
XMLPropertyEditor,
NamedPropertyEditor,
BeanPropertyEditor {
    private static final String UNKNOWN_BORDER_BASE = "org/netbeans/modules/form/editors2/unknownBorder.gif";
    private static final String NO_BORDER_BASE = "org/netbeans/modules/form/editors2/nullBorder.gif";
    private static final FormProperty[] EMPTY_PROPERTIES = new FormProperty[0];
    private Object current = null;
    private FormPropertyContext propertyContext;
    private BorderDesignSupport borderSupport;
    private BorderPanel bPanel = null;
    private static final String XML_BORDER = "Border";
    private static final String ATTR_INFO = "info";
    private static final String PROP_NAME = "PropertyName";
    private static final String XML_PROPERTY = "Property";
    private static final String XML_PROPERTY_BEAN = "PropertyBean";
    private static final String ATTR_PROPERTY_NAME = "name";
    private static final String ATTR_BEAN_PROPERTY_TYPE = "type";
    private static final String ATTR_PROPERTY_VALUE = "value";
    private static final String ATTR_PROPERTY_RES_KEY = "resourceKey";
    private static final String ATTR_PROPERTY_NORES = "noResource";
    private static final String ID_BI_NULL_BORDER = "null";
    private static final String XML_TITLED_BORDER = "TitledBorder";
    private static final String ID_BI_TITLED = "org.netbeans.modules.form.compat2.border.TitledBorderInfo";
    private static final String ATTR_TITLE = "title";
    private static final String ATTR_TITLE_X = "titleX";
    private static final String ATTR_BORDER = "innerBorder";
    private static final String ATTR_JUSTIFICATION = "justification";
    private static final String ATTR_POSITION = "position";
    private static final String ATTR_FONT = "font";
    private static final String ATTR_TITLE_COLOR = "color";
    private static final String XML_ETCHED_BORDER = "EtchetBorder";
    private static final String ID_BI_ETCHED = "org.netbeans.modules.form.compat2.border.EtchedBorderInfo";
    private static final String ATTR_ETCH_TYPE = "bevelType";
    private static final String ATTR_HIGHLIGHT = "highlight";
    private static final String ATTR_SHADOW = "shadow";
    private static final String XML_LINE_BORDER = "LineBorder";
    private static final String ID_BI_LINE = "org.netbeans.modules.form.compat2.border.LineBorderInfo";
    private static final String ATTR_THICKNESS = "thickness";
    private static final String ATTR_LINE_COLOR = "color";
    private static final String ATTR_CORNERS = "roundedCorners";
    private static final String XML_EMPTY_BORDER = "EmptyBorder";
    private static final String ID_BI_EMPTY = "org.netbeans.modules.form.compat2.border.EmptyBorderInfo";
    private static final String ATTR_TOP = "top";
    private static final String ATTR_LEFT = "left";
    private static final String ATTR_RIGHT = "right";
    private static final String ATTR_BOTTOM = "bottom";
    private static final String XML_COMPOUND_BORDER_TYPO = "CompundBorder";
    private static final String XML_COMPOUND_BORDER = "CompoundBorder";
    private static final String ID_BI_COMPOUND = "org.netbeans.modules.form.compat2.border.CompoundBorderInfo";
    private static final String ATTR_OUTSIDE = "outside";
    private static final String ATTR_INSIDE = "inside";
    private static final String XML_BEVEL_BORDER = "BevelBorder";
    private static final String ID_BI_BEVEL = "org.netbeans.modules.form.compat2.border.BevelBorderInfo";
    private static final String ID_BI_SOFTBEVEL = "org.netbeans.modules.form.compat2.border.SoftBevelBorderInfo";
    private static final String ATTR_BEVEL_TYPE = "bevelType";
    private static final String ATTR_HIGHLIGHT_OUTER = "highlightOuter";
    private static final String ATTR_HIGHLIGHT_INNER = "highlightInner";
    private static final String ATTR_SHADOW_OUTER = "shadowOuter";
    private static final String ATTR_SHADOW_INNER = "shadowInner";
    private static final String XML_MATTE_COLOR_BORDER = "MatteColorBorder";
    private static final String XML_MATTE_ICON_BORDER = "MatteIconBorder";
    private static final String ID_BI_MATTECOLOR = "org.netbeans.modules.form.compat2.border.MatteColorBorderInfo";
    private static final String ID_BI_MATTEICON = "org.netbeans.modules.form.compat2.border.MatteIconBorderInfo";
    private static final String ATTR_MATTE_COLOR = "color";
    private static final String ATTR_MATTE_ICON = "icon";

    @Override
    public void setContext(FormModel model, FormProperty property) {
        this.propertyContext = new FormPropertyContext.SubProperty(property);
    }

    @Override
    public void updateFormVersionLevel() {
    }

    @Override
    public Object getValue() {
        return this.current;
    }

    @Override
    public void setValue(Object value) {
        if (this.current == value) {
            return;
        }
        this.current = value;
        this.borderSupport = null;
        if (value instanceof BorderDesignSupport) {
            this.borderSupport = (BorderDesignSupport)value;
        } else if (value != null) {
            assert (value instanceof Border);
            if (!(value instanceof UIResource)) {
                this.borderSupport = new BorderDesignSupport((Border)value);
            }
        }
        if (this.borderSupport != null) {
            this.borderSupport.setPropertyContext(this.propertyContext);
            if (this.bPanel != null) {
                this.bPanel.setValue(value);
            }
        }
    }

    @Override
    public String getAsText() {
        return null;
    }

    @Override
    public void setAsText(String string) {
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics g, Rectangle rectangle) {
        Object value = this.getValue();
        String valueText = value == null ? BorderEditor.getBundle().getString("LAB_NoBorder") : (this.borderSupport != null ? "[" + this.borderSupport.getDisplayName() + "]" : "[" + Utilities.getShortClassName(value.getClass()) + "]");
        FontMetrics fm = g.getFontMetrics();
        g.drawString(valueText, rectangle.x, rectangle.y + (rectangle.height - fm.getHeight()) / 2 + fm.getAscent());
    }

    @Override
    public String getJavaInitializationString() {
        Object value = this.getValue();
        if (value == null) {
            return ID_BI_NULL_BORDER;
        }
        if (this.borderSupport != null) {
            return this.borderSupport.getJavaInitializationString();
        }
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        if (this.bPanel == null) {
            this.bPanel = new BorderPanel();
        }
        this.bPanel.setValue(this.current);
        return this.bPanel;
    }

    @Override
    public String getDisplayName() {
        return BorderEditor.getBundle().getString("CTL_BorderEditor_DisplayName");
    }

    void updateBorder(Node node) {
        if (node instanceof NoBorderNode) {
            this.borderSupport = null;
            this.current = null;
        } else if (node instanceof UnknownBorderNode) {
            this.current = ((UnknownBorderNode)node).getBorder();
        } else {
            this.borderSupport = ((BorderNode)node).getBorderSupport();
            this.current = this.borderSupport;
        }
    }

    private static ResourceBundle getBundle() {
        return NbBundle.getBundle(BorderEditor.class);
    }

    public org.w3c.dom.Node storeToXML(Document doc) {
        Object value = this.getValue();
        if ((value instanceof BorderDesignSupport || value instanceof Border) && this.borderSupport != null) {
            org.w3c.dom.Node storedNode = null;
            Class borderClass = this.borderSupport.getBorderClass();
            if (borderClass.isAssignableFrom(TitledBorder.class)) {
                storedNode = this.storeTitledBorder(doc);
            } else if (borderClass.isAssignableFrom(EtchedBorder.class)) {
                storedNode = this.storeEtchedBorder(doc);
            } else if (borderClass.isAssignableFrom(LineBorder.class)) {
                storedNode = this.storeLineBorder(doc);
            } else if (borderClass.isAssignableFrom(EmptyBorder.class)) {
                storedNode = this.storeEmptyBorder(doc);
            } else if (borderClass.isAssignableFrom(CompoundBorder.class)) {
                storedNode = this.storeCompoundBorder(doc);
            } else if (SoftBevelBorder.class.isAssignableFrom(borderClass)) {
                storedNode = this.storeBevelBorder(doc, ID_BI_SOFTBEVEL);
            } else if (BevelBorder.class.isAssignableFrom(borderClass)) {
                storedNode = this.storeBevelBorder(doc, ID_BI_BEVEL);
            } else if (borderClass.isAssignableFrom(MatteBorder.class)) {
                storedNode = this.storeMatteBorder(doc);
            }
            return storedNode;
        }
        if (value == null) {
            return this.storeNullBorder(doc);
        }
        return null;
    }

    public void readFromXML(org.w3c.dom.Node element) throws IOException {
        if (!XML_BORDER.equals(element.getNodeName())) {
            IOException ex = new IOException("Missing \"Border\" XML element");
            ErrorManager.getDefault().annotate((Throwable)ex, BorderEditor.getBundle().getString("MSG_ERR_MissingMainElement"));
            throw ex;
        }
        NamedNodeMap attributes = element.getAttributes();
        String infoName = attributes.getNamedItem(ATTR_INFO).getNodeValue();
        if (ID_BI_NULL_BORDER.equals(infoName)) {
            return;
        }
        org.w3c.dom.Node readNode = null;
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 1) continue;
            readNode = children.item(i);
            break;
        }
        if (readNode == null) {
            IOException ex = new IOException("Missing border data");
            ErrorManager.getDefault().annotate((Throwable)ex, BorderEditor.getBundle().getString("MSG_ERR_MissingBorderData"));
            throw ex;
        }
        if (ID_BI_TITLED.equals(infoName)) {
            this.readTitledBorder(readNode);
        } else if (ID_BI_ETCHED.equals(infoName)) {
            this.readEtchedBorder(readNode);
        } else if (ID_BI_LINE.equals(infoName)) {
            this.readLineBorder(readNode);
        } else if (ID_BI_EMPTY.equals(infoName)) {
            this.readEmptyBorder(readNode);
        } else if (ID_BI_COMPOUND.equals(infoName)) {
            this.readCompoundBorder(readNode);
        } else if (ID_BI_SOFTBEVEL.equals(infoName)) {
            this.readBevelBorder(readNode, SoftBevelBorder.class);
        } else if (ID_BI_BEVEL.equals(infoName)) {
            this.readBevelBorder(readNode, BevelBorder.class);
        } else if (ID_BI_MATTECOLOR.equals(infoName) || ID_BI_MATTEICON.equals(infoName)) {
            this.readMatteBorder(readNode);
        } else if (ID_BI_NULL_BORDER.equals(infoName)) {
            this.borderSupport = null;
        }
        if (this.borderSupport != null) {
            this.borderSupport.getProperties();
        }
        this.current = this.borderSupport;
    }

    private Element createBorderInfoNode(Document doc, String name) {
        Element el = doc.createElement(XML_BORDER);
        el.setAttribute(ATTR_INFO, name);
        return el;
    }

    private static void writeProperty(String propName, FormProperty prop, Element el, Document doc) {
        PropertyEditor propEd;
        Object realValue;
        Object value;
        org.w3c.dom.Node valueNode = null;
        try {
            value = prop.getValue();
            realValue = prop.getRealValue();
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return;
        }
        boolean noResource = false;
        if (value instanceof ResourceValue) {
            String resourceKey = ((ResourceValue)value).getKey();
            if (resourceKey != null) {
                Element propElement = doc.createElement(XML_PROPERTY);
                propElement.setAttribute(ATTR_PROPERTY_NAME, propName);
                propElement.setAttribute(ATTR_PROPERTY_RES_KEY, resourceKey);
                el.appendChild(propElement);
                return;
            }
            boolean bl = noResource = ResourceSupport.isResourceableProperty(prop) && ResourceSupport.isExcludedProperty(prop);
        }
        if ((propEd = prop.getCurrentEditor()) instanceof ResourceWrapperEditor) {
            propEd = ((ResourceWrapperEditor)((Object)propEd)).getDelegatedPropertyEditor();
        }
        if (propEd instanceof BeanPropertyEditor) {
            propEd.setValue(value);
            BeanPropertyEditor bpe = (BeanPropertyEditor)((Object)propEd);
            if (bpe.valueIsBeanProperty()) {
                Element valueEl = doc.createElement(XML_PROPERTY_BEAN);
                valueEl.setAttribute(ATTR_BEAN_PROPERTY_TYPE, realValue.getClass().getName());
                for (Node.Property p : bpe.getProperties()) {
                    FormProperty subProp = (FormProperty)p;
                    if (!subProp.isChanged()) continue;
                    BorderEditor.writeProperty(subProp.getName(), subProp, valueEl, doc);
                }
                valueNode = valueEl;
            }
        }
        if (valueNode == null && propEd instanceof XMLPropertyEditor) {
            propEd.setValue(value);
            valueNode = ((XMLPropertyEditor)propEd).storeToXML(doc);
        }
        if (valueNode != null) {
            el.appendChild(valueNode);
            if (valueNode.getNodeType() == 1) {
                ((Element)valueNode).setAttribute(PROP_NAME, propName);
                if (noResource) {
                    ((Element)valueNode).setAttribute(ATTR_PROPERTY_NORES, "true");
                }
            }
        } else {
            Element propElement = doc.createElement(XML_PROPERTY);
            propElement.setAttribute(ATTR_PROPERTY_NAME, propName);
            propElement.setAttribute(ATTR_PROPERTY_VALUE, value.toString());
            el.appendChild(propElement);
        }
    }

    private Object readBorderProperty(String xmlPropName, String borderPropName, BorderDesignSupport bSupport, org.w3c.dom.Node element) throws IOException {
        String resourceKey = null;
        Element propElement = null;
        NodeList items = element.getChildNodes();
        for (int i = 0; i < items.getLength(); ++i) {
            if (items.item(i).getNodeType() != 1) continue;
            propElement = (Element)items.item(i);
            if (propElement.getNodeName().equals(XML_PROPERTY) && propElement.getAttribute(ATTR_PROPERTY_NAME).equals(xmlPropName)) {
                resourceKey = propElement.getAttribute(ATTR_PROPERTY_RES_KEY);
                break;
            }
            if (propElement.getAttribute(PROP_NAME).equals(xmlPropName)) break;
            propElement = null;
        }
        if (propElement != null) {
            FormProperty prop = (FormProperty)bSupport.getPropertyOfName(borderPropName);
            if (prop != null) {
                return this.readProperty(prop, resourceKey, propElement);
            }
            IOException ex = new IOException("Unknown property");
            ErrorManager.getDefault().annotate((Throwable)ex, MessageFormat.format(BorderEditor.getBundle().getString("FMT_ERR_UnknownProperty"), borderPropName, bSupport.getBorderClass().getName()));
            throw ex;
        }
        return null;
    }

    private Object readProperty(FormProperty prop, String resourceKey, Element propElement) throws IOException {
        Object value = null;
        IOException lastEx = null;
        boolean valueRead = false;
        if (resourceKey != null) {
            value = ResourceSupport.findResource(resourceKey, prop);
            try {
                prop.setValue(value);
                valueRead = true;
            }
            catch (Exception ex) {
                lastEx = new IOException();
                ErrorManager.getDefault().annotate((Throwable)lastEx, (Throwable)ex);
            }
        } else if (XML_PROPERTY_BEAN.equals(propElement.getNodeName())) {
            String valueTypeStr = propElement.getAttribute(ATTR_BEAN_PROPERTY_TYPE);
            Class valueType = null;
            BeanPropertyEditor beanPropertyEditor = null;
            try {
                valueType = FormUtils.loadClass(valueTypeStr, this.propertyContext.getFormModel());
                for (PropertyEditor prEd : FormPropertyEditorManager.getAllEditors(prop)) {
                    if (!(prEd instanceof BeanPropertyEditor)) continue;
                    if (prEd instanceof FormAwareEditor && this.propertyContext != null) {
                        ((FormAwareEditor)((Object)prEd)).setContext(this.propertyContext.getFormModel(), prop);
                    }
                    ((BeanPropertyEditor)((Object)prEd)).intializeFromType(valueType);
                    beanPropertyEditor = (BeanPropertyEditor)((Object)prEd);
                    break;
                }
            }
            catch (Exception ex) {
                lastEx = new IOException(ex);
            }
            catch (LinkageError ex) {
                lastEx = new IOException(ex);
            }
            if (beanPropertyEditor != null) {
                NodeList children = propElement.getChildNodes();
                Node.Property[] subProperties = beanPropertyEditor.getProperties();
                block13: for (int i = 0; i < children.getLength(); ++i) {
                    org.w3c.dom.Node subNode = children.item(i);
                    if (subNode == null || subNode.getNodeType() != 1) continue;
                    Element subElement = (Element)subNode;
                    String subPropName = subElement.getAttribute(XML_PROPERTY.equals(subNode.getNodeName()) ? ATTR_PROPERTY_NAME : PROP_NAME);
                    for (Node.Property p : subProperties) {
                        if (!p.getName().equals(subPropName)) continue;
                        if (!(p instanceof FormProperty)) continue block13;
                        this.readProperty((FormProperty)p, null, subElement);
                        continue block13;
                    }
                }
                try {
                    PropertyEditor prEd = (PropertyEditor)((Object)beanPropertyEditor);
                    value = prEd.getValue();
                    prop.setValue(value);
                    prop.setCurrentEditor(prEd);
                    if (Boolean.parseBoolean(propElement.getAttribute(ATTR_PROPERTY_NORES))) {
                        ResourceSupport.setExcludedProperty(prop, true);
                    }
                    valueRead = true;
                }
                catch (Exception ex) {
                    lastEx = new IOException();
                    ErrorManager.getDefault().annotate((Throwable)lastEx, (Throwable)ex);
                }
            }
        } else if (XML_PROPERTY.equals(propElement.getNodeName())) {
            try {
                String valueStr = propElement.getAttribute(ATTR_PROPERTY_VALUE);
                value = FormUtils.decodePrimitiveValue(valueStr, prop.getValueType());
                prop.setValue(value);
                if (Boolean.parseBoolean(propElement.getAttribute(ATTR_PROPERTY_NORES))) {
                    ResourceSupport.setExcludedProperty(prop, true);
                }
                valueRead = true;
            }
            catch (Exception ex) {
                lastEx = new IOException();
                ErrorManager.getDefault().annotate((Throwable)lastEx, (Throwable)ex);
            }
        } else {
            for (PropertyEditor prEd : FormPropertyEditorManager.getAllEditors(prop)) {
                if (!(prEd instanceof XMLPropertyEditor) && prEd instanceof ResourceWrapperEditor) {
                    prEd = ((ResourceWrapperEditor)((Object)prEd)).getDelegatedPropertyEditor();
                }
                if (!(prEd instanceof XMLPropertyEditor)) continue;
                try {
                    prop.getPropertyContext().initPropertyEditor(prEd, prop);
                    ((XMLPropertyEditor)prEd).readFromXML((org.w3c.dom.Node)propElement);
                    value = prEd.getValue();
                    prop.setValue(value);
                    prop.setCurrentEditor(prEd);
                    if (Boolean.parseBoolean(propElement.getAttribute(ATTR_PROPERTY_NORES))) {
                        ResourceSupport.setExcludedProperty(prop, true);
                    }
                    valueRead = true;
                    break;
                }
                catch (IOException ex) {
                    lastEx = ex;
                }
                catch (Exception ex) {
                    lastEx = new IOException();
                    ErrorManager.getDefault().annotate((Throwable)lastEx, (Throwable)ex);
                }
            }
        }
        if (!valueRead && lastEx != null) {
            ErrorManager.getDefault().annotate((Throwable)lastEx, MessageFormat.format(BorderEditor.getBundle().getString("FMT_ERR_CannotReadBorderProperty"), prop.getName()));
            throw lastEx;
        }
        return value;
    }

    private org.w3c.dom.Node storeNullBorder(Document doc) {
        try {
            return this.createBorderInfoNode(doc, ID_BI_NULL_BORDER);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private org.w3c.dom.Node storeTitledBorder(Document doc) {
        try {
            Element el = doc.createElement(XML_TITLED_BORDER);
            FormProperty prop = (FormProperty)this.borderSupport.getPropertyOfName("border");
            if (prop != null && prop.isChanged()) {
                BorderEditor.writeProperty(ATTR_BORDER, prop, el, doc);
            }
            if ((prop = (FormProperty)this.borderSupport.getPropertyOfName(ATTR_TITLE)) != null && prop.isChanged()) {
                Object realValue = prop.getRealValue();
                el.setAttribute(ATTR_TITLE, realValue instanceof String ? (String)realValue : "");
                Object value = prop.getValue();
                if (value instanceof FormDesignValue) {
                    BorderEditor.writeProperty(ATTR_TITLE_X, prop, el, doc);
                }
            }
            if ((prop = (FormProperty)this.borderSupport.getPropertyOfName("titleJustification")) != null && prop.isChanged()) {
                el.setAttribute(ATTR_JUSTIFICATION, prop.getRealValue().toString());
            }
            if ((prop = (FormProperty)this.borderSupport.getPropertyOfName("titlePosition")) != null && prop.isChanged()) {
                el.setAttribute(ATTR_POSITION, prop.getRealValue().toString());
            }
            if ((prop = (FormProperty)this.borderSupport.getPropertyOfName("titleFont")) != null && prop.isChanged()) {
                BorderEditor.writeProperty(ATTR_FONT, prop, el, doc);
            }
            if ((prop = (FormProperty)this.borderSupport.getPropertyOfName("titleColor")) != null && prop.isChanged()) {
                BorderEditor.writeProperty("color", prop, el, doc);
            }
            Element nod = this.createBorderInfoNode(doc, ID_BI_TITLED);
            nod.appendChild(el);
            return nod;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void readTitledBorder(org.w3c.dom.Node element) throws IOException {
        if (!XML_TITLED_BORDER.equals(element.getNodeName())) {
            throw new IOException("Invalid format: missing \"TitledBorder\" element.");
        }
        try {
            FormProperty prop;
            org.w3c.dom.Node node;
            NamedNodeMap attributes = element.getAttributes();
            this.borderSupport = new BorderDesignSupport(TitledBorder.class);
            this.borderSupport.setPropertyContext(this.propertyContext);
            this.readBorderProperty(ATTR_BORDER, "border", this.borderSupport, element);
            Object title = this.readBorderProperty(ATTR_TITLE_X, ATTR_TITLE, this.borderSupport, element);
            if (title == null && (node = attributes.getNamedItem(ATTR_TITLE)) != null && (prop = (FormProperty)this.borderSupport.getPropertyOfName(ATTR_TITLE)) != null) {
                prop.setValue(node.getNodeValue());
            }
            if ((node = attributes.getNamedItem(ATTR_JUSTIFICATION)) != null && (prop = (FormProperty)this.borderSupport.getPropertyOfName("titleJustification")) != null) {
                prop.setValue(Integer.valueOf(node.getNodeValue()));
            }
            if ((node = attributes.getNamedItem(ATTR_POSITION)) != null && (prop = (FormProperty)this.borderSupport.getPropertyOfName("titlePosition")) != null) {
                prop.setValue(Integer.valueOf(node.getNodeValue()));
            }
            this.readBorderProperty(ATTR_FONT, "titleFont", this.borderSupport, element);
            this.readBorderProperty("color", "titleColor", this.borderSupport, element);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            IOException ioex = new IOException();
            ErrorManager.getDefault().annotate((Throwable)ioex, (Throwable)ex);
            throw ioex;
        }
    }

    public org.w3c.dom.Node storeEtchedBorder(Document doc) {
        try {
            Element el = doc.createElement(XML_ETCHED_BORDER);
            FormProperty prop = (FormProperty)this.borderSupport.getPropertyOfName("etchType");
            if (prop != null && prop.isChanged()) {
                el.setAttribute("bevelType", prop.getRealValue().toString());
            }
            if ((prop = (FormProperty)this.borderSupport.getPropertyOfName("highlightColor")) != null && prop.isChanged()) {
                BorderEditor.writeProperty(ATTR_HIGHLIGHT, prop, el, doc);
            }
            if ((prop = (FormProperty)this.borderSupport.getPropertyOfName("shadowColor")) != null && prop.isChanged()) {
                BorderEditor.writeProperty(ATTR_SHADOW, prop, el, doc);
            }
            Element nod = this.createBorderInfoNode(doc, ID_BI_ETCHED);
            nod.appendChild(el);
            return nod;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void readEtchedBorder(org.w3c.dom.Node element) throws IOException {
        if (!XML_ETCHED_BORDER.equals(element.getNodeName())) {
            throw new IOException("Invalid format: missing \"EtchetBorder\" element.");
        }
        try {
            FormProperty prop;
            NamedNodeMap attributes = element.getAttributes();
            this.borderSupport = new BorderDesignSupport(EtchedBorder.class);
            this.borderSupport.setPropertyContext(this.propertyContext);
            org.w3c.dom.Node node = attributes.getNamedItem("bevelType");
            if (node != null && (prop = (FormProperty)this.borderSupport.getPropertyOfName("etchType")) != null) {
                prop.setValue(Integer.valueOf(node.getNodeValue()));
            }
            this.readBorderProperty(ATTR_HIGHLIGHT, "highlightColor", this.borderSupport, element);
            this.readBorderProperty(ATTR_SHADOW, "shadowColor", this.borderSupport, element);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            IOException ioex = new IOException();
            ErrorManager.getDefault().annotate((Throwable)ioex, (Throwable)ex);
            throw ioex;
        }
    }

    public org.w3c.dom.Node storeLineBorder(Document doc) {
        try {
            Element el = doc.createElement(XML_LINE_BORDER);
            FormProperty prop = (FormProperty)this.borderSupport.getPropertyOfName("lineColor");
            if (prop != null && prop.isChanged()) {
                BorderEditor.writeProperty("color", prop, el, doc);
            }
            if ((prop = (FormProperty)this.borderSupport.getPropertyOfName(ATTR_THICKNESS)) != null && prop.isChanged()) {
                el.setAttribute(ATTR_THICKNESS, prop.getRealValue().toString());
            }
            if ((prop = (FormProperty)this.borderSupport.getPropertyOfName(ATTR_CORNERS)) != null && prop.isChanged()) {
                el.setAttribute(ATTR_CORNERS, prop.getRealValue().toString());
            }
            Element nod = this.createBorderInfoNode(doc, ID_BI_LINE);
            nod.appendChild(el);
            return nod;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void readLineBorder(org.w3c.dom.Node element) throws IOException {
        if (!XML_LINE_BORDER.equals(element.getNodeName())) {
            throw new IOException("Invalid format: missing \"LineBorder\" element.");
        }
        try {
            FormProperty prop;
            NamedNodeMap attributes = element.getAttributes();
            this.borderSupport = new BorderDesignSupport(LineBorder.class);
            this.borderSupport.setPropertyContext(this.propertyContext);
            this.readBorderProperty("color", "lineColor", this.borderSupport, element);
            org.w3c.dom.Node node = attributes.getNamedItem(ATTR_THICKNESS);
            if (node != null && (prop = (FormProperty)this.borderSupport.getPropertyOfName(ATTR_THICKNESS)) != null) {
                prop.setValue(Integer.valueOf(node.getNodeValue()));
            }
            if ((node = attributes.getNamedItem(ATTR_CORNERS)) != null && (prop = (FormProperty)this.borderSupport.getPropertyOfName(ATTR_CORNERS)) != null) {
                prop.setValue(Boolean.valueOf(node.getNodeValue()));
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            IOException ioex = new IOException();
            ErrorManager.getDefault().annotate((Throwable)ioex, (Throwable)ex);
            throw ioex;
        }
    }

    public org.w3c.dom.Node storeEmptyBorder(Document doc) {
        try {
            Object value;
            Element el = doc.createElement(XML_EMPTY_BORDER);
            FormProperty prop = (FormProperty)this.borderSupport.getPropertyOfName("borderInsets");
            if (prop != null && prop.isChanged() && (value = prop.getRealValue()) instanceof Insets) {
                Insets insets = (Insets)value;
                el.setAttribute(ATTR_TOP, Integer.toString(insets.top));
                el.setAttribute(ATTR_LEFT, Integer.toString(insets.left));
                el.setAttribute(ATTR_BOTTOM, Integer.toString(insets.bottom));
                el.setAttribute(ATTR_RIGHT, Integer.toString(insets.right));
            }
            Element nod = this.createBorderInfoNode(doc, ID_BI_EMPTY);
            nod.appendChild(el);
            return nod;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void readEmptyBorder(org.w3c.dom.Node element) throws IOException {
        if (!XML_EMPTY_BORDER.equals(element.getNodeName())) {
            throw new IOException("Invalid format: missing \"EmptyBorder\" element.");
        }
        try {
            FormProperty prop;
            NamedNodeMap attributes = element.getAttributes();
            int top = 1;
            int left = 1;
            int bottom = 1;
            int right = 1;
            org.w3c.dom.Node node = attributes.getNamedItem(ATTR_TOP);
            if (node != null) {
                top = Integer.parseInt(node.getNodeValue());
            }
            if ((node = attributes.getNamedItem(ATTR_LEFT)) != null) {
                left = Integer.parseInt(node.getNodeValue());
            }
            if ((node = attributes.getNamedItem(ATTR_BOTTOM)) != null) {
                bottom = Integer.parseInt(node.getNodeValue());
            }
            if ((node = attributes.getNamedItem(ATTR_RIGHT)) != null) {
                right = Integer.parseInt(node.getNodeValue());
            }
            this.borderSupport = new BorderDesignSupport(EmptyBorder.class);
            this.borderSupport.setPropertyContext(this.propertyContext);
            if ((top != 1 || left != 1 || bottom != 1 || right != 1) && (prop = (FormProperty)this.borderSupport.getPropertyOfName("borderInsets")) != null) {
                prop.setValue(new Insets(top, left, bottom, right));
            }
        }
        catch (Exception ex) {
            IOException ioex = new IOException();
            ErrorManager.getDefault().annotate((Throwable)ioex, (Throwable)ex);
            throw ioex;
        }
    }

    private org.w3c.dom.Node storeCompoundBorder(Document doc) {
        try {
            Element el = doc.createElement(XML_COMPOUND_BORDER);
            FormProperty prop = (FormProperty)this.borderSupport.getPropertyOfName("outsideBorder");
            if (prop != null && prop.isChanged()) {
                BorderEditor.writeProperty(ATTR_OUTSIDE, prop, el, doc);
            }
            if ((prop = (FormProperty)this.borderSupport.getPropertyOfName("insideBorder")) != null && prop.isChanged()) {
                BorderEditor.writeProperty(ATTR_INSIDE, prop, el, doc);
            }
            Element nod = this.createBorderInfoNode(doc, ID_BI_COMPOUND);
            nod.appendChild(el);
            return nod;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void readCompoundBorder(org.w3c.dom.Node element) throws IOException {
        String nodeName = element.getNodeName();
        if (!XML_COMPOUND_BORDER.equals(nodeName) && !XML_COMPOUND_BORDER_TYPO.equals(nodeName)) {
            throw new IOException("Invalid format: missing \"CompoundBorder\" element.");
        }
        try {
            this.borderSupport = new BorderDesignSupport(CompoundBorder.class);
            this.borderSupport.setPropertyContext(this.propertyContext);
            this.readBorderProperty(ATTR_OUTSIDE, "outsideBorder", this.borderSupport, element);
            this.readBorderProperty(ATTR_INSIDE, "insideBorder", this.borderSupport, element);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            IOException ioex = new IOException();
            ErrorManager.getDefault().annotate((Throwable)ioex, (Throwable)ex);
            throw ioex;
        }
    }

    public org.w3c.dom.Node storeBevelBorder(Document doc, String infoId) {
        try {
            Element el = doc.createElement(XML_BEVEL_BORDER);
            FormProperty prop = (FormProperty)this.borderSupport.getPropertyOfName("bevelType");
            if (prop != null && prop.isChanged()) {
                el.setAttribute("bevelType", prop.getRealValue().toString());
            }
            if ((prop = (FormProperty)this.borderSupport.getPropertyOfName("highlightOuterColor")) != null && prop.isChanged()) {
                BorderEditor.writeProperty(ATTR_HIGHLIGHT_OUTER, prop, el, doc);
            }
            if ((prop = (FormProperty)this.borderSupport.getPropertyOfName("highlightInnerColor")) != null && prop.isChanged()) {
                BorderEditor.writeProperty(ATTR_HIGHLIGHT_INNER, prop, el, doc);
            }
            if ((prop = (FormProperty)this.borderSupport.getPropertyOfName("shadowOuterColor")) != null && prop.isChanged()) {
                BorderEditor.writeProperty(ATTR_SHADOW_OUTER, prop, el, doc);
            }
            if ((prop = (FormProperty)this.borderSupport.getPropertyOfName("shadowInnerColor")) != null && prop.isChanged()) {
                BorderEditor.writeProperty(ATTR_SHADOW_INNER, prop, el, doc);
            }
            Element nod = this.createBorderInfoNode(doc, infoId);
            nod.appendChild(el);
            return nod;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void readBevelBorder(org.w3c.dom.Node element, Class borderClass) throws IOException {
        if (!XML_BEVEL_BORDER.equals(element.getNodeName())) {
            throw new IOException("Invalid format: missing \"BevelBorder\" element.");
        }
        try {
            FormProperty prop;
            NamedNodeMap attributes = element.getAttributes();
            this.borderSupport = new BorderDesignSupport(borderClass);
            this.borderSupport.setPropertyContext(this.propertyContext);
            org.w3c.dom.Node node = attributes.getNamedItem("bevelType");
            if (node != null && (prop = (FormProperty)this.borderSupport.getPropertyOfName("bevelType")) != null) {
                prop.setValue(Integer.valueOf(node.getNodeValue()));
            }
            this.readBorderProperty(ATTR_HIGHLIGHT_OUTER, "highlightOuterColor", this.borderSupport, element);
            this.readBorderProperty(ATTR_HIGHLIGHT_INNER, "highlightInnerColor", this.borderSupport, element);
            this.readBorderProperty(ATTR_SHADOW_OUTER, "shadowOuterColor", this.borderSupport, element);
            this.readBorderProperty(ATTR_SHADOW_INNER, "shadowInnerColor", this.borderSupport, element);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            IOException ioex = new IOException();
            ErrorManager.getDefault().annotate((Throwable)ioex, (Throwable)ex);
            throw ioex;
        }
    }

    public org.w3c.dom.Node storeMatteBorder(Document doc) {
        try {
            Object value;
            String infoId;
            Element el;
            FormProperty prop = (FormProperty)this.borderSupport.getPropertyOfName("tileIcon");
            if (prop.isChanged()) {
                el = doc.createElement(XML_MATTE_ICON_BORDER);
                infoId = ID_BI_MATTEICON;
                BorderEditor.writeProperty(ATTR_MATTE_ICON, prop, el, doc);
            } else {
                el = doc.createElement(XML_MATTE_COLOR_BORDER);
                infoId = ID_BI_MATTECOLOR;
            }
            prop = (FormProperty)this.borderSupport.getPropertyOfName("matteColor");
            if (prop != null && prop.isChanged()) {
                BorderEditor.writeProperty("color", prop, el, doc);
            }
            if ((prop = (FormProperty)this.borderSupport.getPropertyOfName("borderInsets")) != null && prop.isChanged() && (value = prop.getRealValue()) instanceof Insets) {
                Insets insets = (Insets)value;
                el.setAttribute(ATTR_TOP, Integer.toString(insets.top));
                el.setAttribute(ATTR_LEFT, Integer.toString(insets.left));
                el.setAttribute(ATTR_BOTTOM, Integer.toString(insets.bottom));
                el.setAttribute(ATTR_RIGHT, Integer.toString(insets.right));
            }
            Element nod = this.createBorderInfoNode(doc, infoId);
            nod.appendChild(el);
            return nod;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void readMatteBorder(org.w3c.dom.Node element) throws IOException {
        if (!XML_MATTE_COLOR_BORDER.equals(element.getNodeName()) && !XML_MATTE_ICON_BORDER.equals(element.getNodeName())) {
            throw new IOException("Invalid format: missing \"MatteColorBorder\" or \"MatteIconBorder\" element.");
        }
        try {
            FormProperty prop;
            this.borderSupport = new BorderDesignSupport(MatteBorder.class);
            this.borderSupport.setPropertyContext(this.propertyContext);
            this.readBorderProperty(ATTR_MATTE_ICON, "tileIcon", this.borderSupport, element);
            this.readBorderProperty("color", "matteColor", this.borderSupport, element);
            NamedNodeMap attributes = element.getAttributes();
            int top = 1;
            int left = 1;
            int bottom = 1;
            int right = 1;
            org.w3c.dom.Node node = attributes.getNamedItem(ATTR_TOP);
            if (node != null) {
                top = Integer.parseInt(node.getNodeValue());
            }
            if ((node = attributes.getNamedItem(ATTR_LEFT)) != null) {
                left = Integer.parseInt(node.getNodeValue());
            }
            if ((node = attributes.getNamedItem(ATTR_BOTTOM)) != null) {
                bottom = Integer.parseInt(node.getNodeValue());
            }
            if ((node = attributes.getNamedItem(ATTR_RIGHT)) != null) {
                right = Integer.parseInt(node.getNodeValue());
            }
            if ((top != 1 || left != 1 || bottom != 1 || right != 1) && (prop = (FormProperty)this.borderSupport.getPropertyOfName("borderInsets")) != null) {
                prop.setValue(new Insets(top, left, bottom, right));
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            IOException ioex = new IOException();
            ErrorManager.getDefault().annotate((Throwable)ioex, (Throwable)ex);
            throw ioex;
        }
    }

    @Override
    public boolean valueIsBeanProperty() {
        return !this.isSupportedBorder();
    }

    private boolean isSupportedBorder() {
        Object value = this.getValue();
        if (value == null || value instanceof UIResource) {
            return true;
        }
        Class borderClass = this.borderSupport.getBorderClass();
        return borderClass.isAssignableFrom(TitledBorder.class) || borderClass.isAssignableFrom(EtchedBorder.class) || borderClass.isAssignableFrom(LineBorder.class) || borderClass.isAssignableFrom(EmptyBorder.class) || borderClass.isAssignableFrom(CompoundBorder.class) || SoftBevelBorder.class.isAssignableFrom(borderClass) || BevelBorder.class.isAssignableFrom(borderClass) || borderClass.isAssignableFrom(MatteBorder.class);
    }

    @Override
    public Node.Property[] getProperties() {
        Object value = this.getValue();
        if (value == null || value instanceof UIResource) {
            return EMPTY_PROPERTIES;
        }
        return this.borderSupport.getProperties();
    }

    @Override
    public void intializeFromType(Class type) throws Exception {
        this.borderSupport = new BorderDesignSupport(type);
        this.borderSupport.setPropertyContext(this.propertyContext);
        this.borderSupport.getProperties();
        this.current = this.borderSupport;
    }

    final class BorderPanel
    extends JPanel
    implements PropertyChangeListener,
    VetoableChangeListener,
    ExplorerManager.Provider {
        private ExplorerManager manager = new ExplorerManager();
        private Node selectNode = null;

        private BorderPanel() {
            this.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)this);
            this.getExplorerManager().addVetoableChangeListener((VetoableChangeListener)this);
            this.setLayout(new BorderLayout());
            this.setBorder(new EmptyBorder(5, 5, 5, 5));
            ResourceBundle bundle = BorderEditor.getBundle();
            ListView listView = new ListView();
            listView.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_AvailableBorders"));
            JLabel label = new JLabel();
            Mnemonics.setLocalizedText((JLabel)label, (String)bundle.getString("LAB_AvailableBorders"));
            label.setLabelFor((Component)listView);
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout(0, 2));
            panel.add((Component)label, "North");
            panel.add("Center", (Component)listView);
            PropertySheetView sheetView = new PropertySheetView();
            JSplitPane split = new JSplitPane(0);
            split.setTopComponent(panel);
            split.setBottomComponent((Component)sheetView);
            split.setUI(new BasicSplitPaneUI());
            split.setBorder(BorderFactory.createEmptyBorder());
            split.setDividerLocation(170);
            split.setContinuousLayout(true);
            this.add("Center", split);
            this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_BorderCustomEditor"));
        }

        @Override
        public void addNotify() {
            super.addNotify();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        BorderPanel.this.getExplorerManager().setSelectedNodes(new Node[]{BorderPanel.this.selectNode});
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            });
        }

        void setValue(Object border) {
            ArrayList<BorderNode> bordersList = new ArrayList<BorderNode>(10);
            this.selectNode = null;
            PaletteItem[] items = PaletteUtils.getAllItems();
            for (int i = 0; i < items.length; ++i) {
                BorderNode borderNode;
                PaletteItem paletteItem = items[i];
                if (!paletteItem.isBorder()) continue;
                BorderDesignSupport nodeBDS = null;
                try {
                    nodeBDS = new BorderDesignSupport(paletteItem.getComponentClass());
                }
                catch (Exception ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
                if (nodeBDS == null) continue;
                if (BorderEditor.this.borderSupport != null && BorderEditor.this.borderSupport.getBorderClass() == nodeBDS.getBorderClass()) {
                    try {
                        nodeBDS.setPropertyContext(BorderEditor.this.propertyContext);
                        FormUtils.copyProperties(BorderEditor.this.borderSupport.getProperties(), nodeBDS.getProperties(), 11);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        continue;
                    }
                    borderNode = new BorderNode(nodeBDS, paletteItem.getNode());
                    this.selectNode = borderNode;
                } else {
                    nodeBDS.setPropertyContext(BorderEditor.this.propertyContext);
                    borderNode = new BorderNode(nodeBDS, paletteItem.getNode());
                }
                bordersList.add(borderNode);
            }
            AbstractNode root = new AbstractNode((Children)new Children.Array());
            NoBorderNode noBorder = new NoBorderNode();
            if (border == null) {
                this.selectNode = noBorder;
            }
            root.getChildren().add(new Node[]{noBorder});
            if (this.selectNode == null && border instanceof BorderDesignSupport && border == BorderEditor.this.borderSupport) {
                try {
                    BorderDesignSupport bds = new BorderDesignSupport(BorderEditor.this.borderSupport, BorderEditor.this.propertyContext);
                    AbstractNode dummyPaletteNode = new AbstractNode(Children.LEAF);
                    dummyPaletteNode.setDisplayName(bds.getDisplayName());
                    dummyPaletteNode.setIconBaseWithExtension(BorderEditor.UNKNOWN_BORDER_BASE);
                    this.selectNode = new BorderNode(bds, (Node)dummyPaletteNode);
                    bordersList.add((BorderNode)this.selectNode);
                }
                catch (Exception ex) {
                    Logger.getLogger(BorderEditor.class.getName()).log(Level.INFO, "", ex);
                }
            }
            Node[] bordersArray = new Node[bordersList.size()];
            bordersList.toArray(bordersArray);
            Arrays.sort(bordersArray, new Comparator<Node>(){

                @Override
                public int compare(Node n1, Node n2) {
                    return n1.getDisplayName().compareTo(n2.getDisplayName());
                }
            });
            root.getChildren().add(bordersArray);
            if (this.selectNode == null) {
                UnknownBorderNode unknownBorder = new UnknownBorderNode(border);
                root.getChildren().add(new Node[]{unknownBorder});
                this.selectNode = unknownBorder;
            }
            this.getExplorerManager().setRootContext((Node)root);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Node[] nodes;
            if ("selectedNodes".equals(evt.getPropertyName()) && (nodes = (Node[])evt.getNewValue()).length == 1) {
                BorderEditor.this.updateBorder(nodes[0]);
            }
        }

        @Override
        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            Node[] nodes;
            if ("selectedNodes".equals(evt.getPropertyName()) && (nodes = (Node[])evt.getNewValue()).length != 1) {
                throw new PropertyVetoException("", evt);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(360, 440);
        }

        public ExplorerManager getExplorerManager() {
            return this.manager;
        }
    }

    static final class NoBorderNode
    extends AbstractNode {
        NoBorderNode() {
            super(Children.LEAF);
            this.setDisplayName(BorderEditor.getBundle().getString("LAB_NoBorder"));
            this.setIconBaseWithExtension(BorderEditor.NO_BORDER_BASE);
        }
    }

    static final class UnknownBorderNode
    extends AbstractNode {
        private Object border;

        UnknownBorderNode(Object border) {
            super(Children.LEAF);
            this.setBorder(border);
            this.setIconBaseWithExtension(BorderEditor.UNKNOWN_BORDER_BASE);
        }

        void setBorder(Object border) {
            String longName;
            int dot;
            this.border = border;
            if (border instanceof BorderDesignSupport) {
                border = ((BorderDesignSupport)border).getBorder();
            }
            String shortName = (dot = (longName = border.getClass().getName()).lastIndexOf(46)) < 0 ? longName : longName.substring(dot + 1);
            this.setDisplayName(new MessageFormat(BorderEditor.getBundle().getString("LAB_FMT_UnknownBorder")).format(new Object[]{longName, shortName}));
        }

        Object getBorder() {
            return this.border;
        }
    }

    final class BorderNode
    extends FilterNode
    implements PropertyChangeListener {
        private BorderDesignSupport nodeBorder;
        private Node.PropertySet[] properties;

        BorderNode(BorderDesignSupport bds, Node paletteItemNode) {
            super(paletteItemNode, FilterNode.Children.LEAF);
            this.nodeBorder = bds;
        }

        public Node.PropertySet[] getPropertySets() {
            if (this.properties == null) {
                Node.Property[] props = this.nodeBorder.getProperties();
                Sheet.Set propSet = Sheet.createPropertiesSet();
                propSet.put(props);
                for (int i = 0; i < props.length; ++i) {
                    if (!(props[i] instanceof FormProperty)) continue;
                    ((FormProperty)props[i]).addPropertyChangeListener(this);
                }
                this.properties = new Node.PropertySet[]{propSet};
            }
            return this.properties;
        }

        public BorderDesignSupport getBorderSupport() {
            return this.nodeBorder;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            BorderEditor.this.updateBorder((Node)this);
        }
    }
}

