/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnknownKeyException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedExactClassProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.CachedSetPropertyNode;
import com.oracle.truffle.js.nodes.access.IsArrayNode;
import com.oracle.truffle.js.nodes.access.IsJSDynamicObjectNode;
import com.oracle.truffle.js.nodes.access.JSTargetableNode;
import com.oracle.truffle.js.nodes.access.PropertyCacheNode;
import com.oracle.truffle.js.nodes.access.SuperPropertyReferenceNode;
import com.oracle.truffle.js.nodes.access.WriteElementNodeFactory;
import com.oracle.truffle.js.nodes.cast.JSToBigIntNode;
import com.oracle.truffle.js.nodes.cast.JSToDoubleNode;
import com.oracle.truffle.js.nodes.cast.JSToInt32Node;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToPropertyKeyNode;
import com.oracle.truffle.js.nodes.cast.ToArrayIndexNode;
import com.oracle.truffle.js.nodes.instrumentation.JSTaggedExecutionNode;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import com.oracle.truffle.js.nodes.interop.ExportValueNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.array.DynamicArray;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.SparseArray;
import com.oracle.truffle.js.runtime.array.TypedArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractConstantArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractContiguousDoubleArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractContiguousIntArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractContiguousJSObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractContiguousObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractDoubleArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractIntArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractJSObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractWritableArray;
import com.oracle.truffle.js.runtime.array.dyn.ContiguousIntArray;
import com.oracle.truffle.js.runtime.array.dyn.HolesDoubleArray;
import com.oracle.truffle.js.runtime.array.dyn.HolesIntArray;
import com.oracle.truffle.js.runtime.array.dyn.HolesJSObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.HolesObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.LazyRegexResultArray;
import com.oracle.truffle.js.runtime.array.dyn.LazyRegexResultIndicesArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSBigInt;
import com.oracle.truffle.js.runtime.builtins.JSBoolean;
import com.oracle.truffle.js.runtime.builtins.JSNumber;
import com.oracle.truffle.js.runtime.builtins.JSSlowArgumentsArray;
import com.oracle.truffle.js.runtime.builtins.JSSlowArray;
import com.oracle.truffle.js.runtime.builtins.JSString;
import com.oracle.truffle.js.runtime.builtins.JSSymbol;
import com.oracle.truffle.js.runtime.interop.JSInteropUtil;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.util.JSClassProfile;
import com.oracle.truffle.js.runtime.util.TRegexUtil;
import java.util.Set;

public class WriteElementNode
extends JSTargetableNode {
    @Node.Child
    protected JavaScriptNode targetNode;
    @Node.Child
    protected JavaScriptNode indexNode;
    @Node.Child
    private ToArrayIndexNode toArrayIndexNode;
    @Node.Child
    protected JavaScriptNode valueNode;
    @Node.Child
    private WriteElementTypeCacheNode typeCacheNode;
    final JSContext context;
    final boolean isStrict;
    final boolean writeOwn;
    @CompilerDirectives.CompilationFinal
    private byte indexState;
    private static final byte INDEX_INT = 1;
    private static final byte INDEX_OBJECT = 2;
    static final int BOUNDED_BY_TYPES = Integer.MAX_VALUE;

    @NeverDefault
    public static WriteElementNode create(JSContext context, boolean isStrict) {
        return WriteElementNode.create(null, null, null, context, isStrict, false);
    }

    @NeverDefault
    public static WriteElementNode create(JSContext context, boolean isStrict, boolean writeOwn) {
        return WriteElementNode.create(null, null, null, context, isStrict, writeOwn);
    }

    public static WriteElementNode create(JavaScriptNode targetNode, JavaScriptNode indexNode, JavaScriptNode valueNode, JSContext context, boolean isStrict) {
        return WriteElementNode.create(targetNode, indexNode, valueNode, context, isStrict, false);
    }

    private static WriteElementNode create(JavaScriptNode targetNode, JavaScriptNode indexNode, JavaScriptNode valueNode, JSContext context, boolean isStrict, boolean writeOwn) {
        return new WriteElementNode(targetNode, indexNode, valueNode, context, isStrict, writeOwn);
    }

    protected WriteElementNode(JavaScriptNode targetNode, JavaScriptNode indexNode, JavaScriptNode valueNode, JSContext context, boolean isStrict, boolean writeOwn) {
        assert (!(indexNode instanceof JSToPropertyKeyNode.JSToPropertyKeyWrapperNode));
        this.targetNode = targetNode;
        this.indexNode = indexNode;
        this.valueNode = valueNode;
        this.context = context;
        this.isStrict = isStrict;
        this.writeOwn = writeOwn;
    }

    protected final Object toArrayIndex(Object index) {
        if (this.toArrayIndexNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toArrayIndexNode = (ToArrayIndexNode)this.insert(ToArrayIndexNode.createNoStringToIndex());
        }
        return this.toArrayIndexNode.execute(index);
    }

    protected void requireObjectCoercible(Object target, int index) {
    }

    protected void requireObjectCoercible(Object target, Object index) {
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.WriteElementTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        if (this.materializationNeeded() && materializedTags.contains(JSTags.WriteElementTag.class)) {
            JavaScriptNode clonedValue;
            JavaScriptNode clonedTarget = this.targetNode == null || this.targetNode.hasSourceSection() ? this.targetNode : JSTaggedExecutionNode.createForInput(this.targetNode, this, materializedTags);
            JavaScriptNode clonedIndex = this.indexNode == null || this.indexNode.hasSourceSection() ? this.indexNode : JSTaggedExecutionNode.createForInput(this.indexNode, this, materializedTags);
            JavaScriptNode javaScriptNode = clonedValue = this.valueNode == null || this.valueNode.hasSourceSection() ? this.valueNode : JSTaggedExecutionNode.createForInput(this.valueNode, this, materializedTags);
            if (clonedTarget == this.targetNode && clonedIndex == this.indexNode && clonedValue == this.valueNode) {
                return this;
            }
            if (clonedTarget == this.targetNode) {
                clonedTarget = WriteElementNode.cloneUninitialized(this.targetNode, materializedTags);
            }
            if (clonedIndex == this.indexNode) {
                clonedIndex = WriteElementNode.cloneUninitialized(this.indexNode, materializedTags);
            }
            if (clonedValue == this.valueNode) {
                clonedValue = WriteElementNode.cloneUninitialized(this.valueNode, materializedTags);
            }
            WriteElementNode cloned = this.createMaterialized(clonedTarget, clonedIndex, clonedValue);
            WriteElementNode.transferSourceSectionAndTags(this, cloned);
            return cloned;
        }
        return this;
    }

    private boolean materializationNeeded() {
        return this.targetNode != null && !this.targetNode.hasSourceSection() || this.indexNode != null && !this.indexNode.hasSourceSection() || this.valueNode != null && !this.valueNode.hasSourceSection();
    }

    protected WriteElementNode createMaterialized(JavaScriptNode newTarget, JavaScriptNode newIndex, JavaScriptNode newValue) {
        return WriteElementNode.create(newTarget, newIndex, newValue, this.getContext(), this.isStrict(), this.writeOwn());
    }

    @Override
    public Object evaluateTarget(VirtualFrame frame) {
        return this.targetNode.execute(frame);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object target = this.evaluateTarget(frame);
        return this.executeWithTarget(frame, target, WriteElementNode.evaluateReceiver(this.targetNode, frame, target));
    }

    @Override
    public int executeInt(VirtualFrame frame) throws UnexpectedResultException {
        Object target = this.evaluateTarget(frame);
        return this.executeWithTargetInt(frame, target, WriteElementNode.evaluateReceiver(this.targetNode, frame, target));
    }

    @Override
    public double executeDouble(VirtualFrame frame) throws UnexpectedResultException {
        Object target = this.evaluateTarget(frame);
        return this.executeWithTargetDouble(frame, target, WriteElementNode.evaluateReceiver(this.targetNode, frame, target));
    }

    @Override
    public Object executeWithTarget(VirtualFrame frame, Object target) {
        return this.executeWithTarget(frame, target, target);
    }

    public Object executeWithTarget(VirtualFrame frame, Object target, Object receiver) {
        byte is = this.indexState;
        if (is == 0) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object index = this.indexNode.execute(frame);
            this.requireObjectCoercible(target, index);
            if (index instanceof Integer) {
                this.indexState = 1;
                return this.executeWithTargetAndIndex(frame, target, (Integer)index, receiver);
            }
            this.indexState = (byte)2;
            return this.executeWithTargetAndIndex(frame, target, this.toArrayIndex(index), receiver);
        }
        if (is == 1) {
            int index;
            try {
                index = this.indexNode.executeInt(frame);
            }
            catch (UnexpectedResultException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.indexState = (byte)2;
                this.requireObjectCoercible(target, e.getResult());
                return this.executeWithTargetAndIndex(frame, target, this.toArrayIndex(e.getResult()), receiver);
            }
            this.requireObjectCoercible(target, index);
            return this.executeWithTargetAndIndex(frame, target, index, receiver);
        }
        assert (is == 2);
        Object index = this.indexNode.execute(frame);
        this.requireObjectCoercible(target, index);
        return this.executeWithTargetAndIndex(frame, target, this.toArrayIndex(index), receiver);
    }

    public int executeWithTargetInt(VirtualFrame frame, Object target, Object receiver) throws UnexpectedResultException {
        byte is = this.indexState;
        if (is == 0) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object index = this.indexNode.execute(frame);
            this.requireObjectCoercible(target, index);
            if (index instanceof Integer) {
                this.indexState = 1;
                return this.executeWithTargetAndIndexInt(frame, target, (Integer)index, receiver);
            }
            this.indexState = (byte)2;
            return this.executeWithTargetAndIndexInt(frame, target, this.toArrayIndex(index), receiver);
        }
        if (is == 1) {
            int index;
            try {
                index = this.indexNode.executeInt(frame);
            }
            catch (UnexpectedResultException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.indexState = (byte)2;
                this.requireObjectCoercible(target, e.getResult());
                return this.executeWithTargetAndIndexInt(frame, target, this.toArrayIndex(e.getResult()), receiver);
            }
            this.requireObjectCoercible(target, index);
            return this.executeWithTargetAndIndexInt(frame, target, index, receiver);
        }
        assert (is == 2);
        Object index = this.indexNode.execute(frame);
        this.requireObjectCoercible(target, index);
        return this.executeWithTargetAndIndexInt(frame, target, this.toArrayIndex(index), receiver);
    }

    public double executeWithTargetDouble(VirtualFrame frame, Object target, Object receiver) throws UnexpectedResultException {
        byte is = this.indexState;
        if (is == 0) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object index = this.indexNode.execute(frame);
            this.requireObjectCoercible(target, index);
            if (index instanceof Integer) {
                this.indexState = 1;
                return this.executeWithTargetAndIndexDouble(frame, target, (Integer)index, receiver);
            }
            this.indexState = (byte)2;
            return this.executeWithTargetAndIndexDouble(frame, target, this.toArrayIndex(index), receiver);
        }
        if (is == 1) {
            int index;
            try {
                index = this.indexNode.executeInt(frame);
            }
            catch (UnexpectedResultException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.indexState = (byte)2;
                this.requireObjectCoercible(target, e.getResult());
                return this.executeWithTargetAndIndexDouble(frame, target, this.toArrayIndex(e.getResult()), receiver);
            }
            this.requireObjectCoercible(target, index);
            return this.executeWithTargetAndIndexDouble(frame, target, index, receiver);
        }
        assert (is == 2);
        Object index = this.indexNode.execute(frame);
        this.requireObjectCoercible(target, index);
        return this.executeWithTargetAndIndexDouble(frame, target, this.toArrayIndex(index), receiver);
    }

    protected Object executeWithTargetAndIndex(VirtualFrame frame, Object target, Object index, Object receiver) {
        Object value = this.valueNode.execute(frame);
        this.executeWithTargetAndIndexAndValue(target, index, value, receiver);
        return value;
    }

    protected Object executeWithTargetAndIndex(VirtualFrame frame, Object target, int index, Object receiver) {
        Object value = this.valueNode.execute(frame);
        this.executeWithTargetAndIndexAndValue(target, index, value, receiver);
        return value;
    }

    protected int executeWithTargetAndIndexInt(VirtualFrame frame, Object target, Object index, Object receiver) throws UnexpectedResultException {
        try {
            int value = this.valueNode.executeInt(frame);
            this.executeWithTargetAndIndexAndValue(target, index, (Object)value, receiver);
            return value;
        }
        catch (UnexpectedResultException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeWithTargetAndIndexAndValue(target, index, e.getResult(), receiver);
            throw e;
        }
    }

    protected int executeWithTargetAndIndexInt(VirtualFrame frame, Object target, int index, Object receiver) throws UnexpectedResultException {
        try {
            int value = this.valueNode.executeInt(frame);
            this.executeWithTargetAndIndexAndValue(target, index, (Object)value, receiver);
            return value;
        }
        catch (UnexpectedResultException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeWithTargetAndIndexAndValue(target, index, e.getResult(), receiver);
            throw e;
        }
    }

    protected double executeWithTargetAndIndexDouble(VirtualFrame frame, Object target, Object index, Object receiver) throws UnexpectedResultException {
        try {
            double value = this.valueNode.executeDouble(frame);
            this.executeWithTargetAndIndexAndValue(target, index, (Object)value, receiver);
            return value;
        }
        catch (UnexpectedResultException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeWithTargetAndIndexAndValue(target, index, e.getResult(), receiver);
            throw e;
        }
    }

    protected double executeWithTargetAndIndexDouble(VirtualFrame frame, Object target, int index, Object receiver) throws UnexpectedResultException {
        try {
            double value = this.valueNode.executeDouble(frame);
            this.executeWithTargetAndIndexAndValue(target, index, (Object)value, receiver);
            return value;
        }
        catch (UnexpectedResultException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeWithTargetAndIndexAndValue(target, index, e.getResult(), receiver);
            throw e;
        }
    }

    public final void executeWithTargetAndIndexAndValue(Object target, Object index, Object value) {
        this.executeWithTargetAndIndexAndValue(target, index, value, target);
    }

    public final void executeWithTargetAndIndexAndValue(Object target, int index, Object value) {
        this.executeWithTargetAndIndexAndValue(target, index, value, target);
    }

    public final void executeWithTargetAndIndexAndValue(Object target, long index, Object value) {
        this.executeWithTargetAndIndexAndValue(target, index, value, target);
    }

    public final void executeWithTargetAndIndexAndValue(Object target, Object index, Object value, Object receiver) {
        if (this.typeCacheNode == null) {
            this.initTypeCacheNode();
        }
        this.typeCacheNode.executeWithTargetAndIndexUnguarded(target, index, value, receiver, this);
    }

    public final void executeWithTargetAndIndexAndValue(Object target, int index, Object value, Object receiver) {
        if (this.typeCacheNode == null) {
            this.initTypeCacheNode();
        }
        this.typeCacheNode.executeWithTargetAndIndexUnguarded(target, index, value, receiver, this);
    }

    public final void executeWithTargetAndIndexAndValue(Object target, long index, Object value, Object receiver) {
        if (this.typeCacheNode == null) {
            this.initTypeCacheNode();
        }
        this.typeCacheNode.executeWithTargetAndIndexUnguarded(target, index, value, receiver, this);
    }

    private void initTypeCacheNode() {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.typeCacheNode = (WriteElementTypeCacheNode)this.insert(WriteElementNodeFactory.WriteElementTypeCacheDispatchNodeGen.create());
    }

    static ArrayWriteElementCacheNode makeArrayCacheNode(JSDynamicObject target, ScriptArray array) {
        if (JSSlowArray.isJSSlowArray(target) || JSSlowArgumentsArray.isJSSlowArgumentsObject(target)) {
            return new ExactArrayWriteElementCacheNode();
        }
        if (array.isLengthNotWritable() || !array.isExtensible()) {
            return new ExactArrayWriteElementCacheNode();
        }
        if (array instanceof LazyRegexResultArray) {
            return WriteElementNodeFactory.LazyRegexResultArrayWriteElementCacheNodeGen.create();
        }
        if (array instanceof LazyRegexResultIndicesArray) {
            return WriteElementNodeFactory.LazyRegexResultIndicesArrayWriteElementCacheNodeGen.create();
        }
        if (array instanceof AbstractConstantArray) {
            return WriteElementNodeFactory.ConstantArrayWriteElementCacheNodeGen.create();
        }
        if (array instanceof HolesIntArray) {
            return WriteElementNodeFactory.HolesIntArrayWriteElementCacheNodeGen.create();
        }
        if (array instanceof HolesDoubleArray) {
            return WriteElementNodeFactory.HolesDoubleArrayWriteElementCacheNodeGen.create();
        }
        if (array instanceof HolesJSObjectArray) {
            return WriteElementNodeFactory.HolesJSObjectArrayWriteElementCacheNodeGen.create();
        }
        if (array instanceof HolesObjectArray) {
            return WriteElementNodeFactory.HolesObjectArrayWriteElementCacheNodeGen.create();
        }
        if (array instanceof AbstractIntArray) {
            return WriteElementNodeFactory.IntArrayWriteElementCacheNodeGen.create();
        }
        if (array instanceof AbstractDoubleArray) {
            return WriteElementNodeFactory.DoubleArrayWriteElementCacheNodeGen.create();
        }
        if (array instanceof AbstractObjectArray) {
            return WriteElementNodeFactory.ObjectArrayWriteElementCacheNodeGen.create();
        }
        if (array instanceof AbstractJSObjectArray) {
            return WriteElementNodeFactory.JSObjectArrayWriteElementCacheNodeGen.create();
        }
        if (array instanceof AbstractWritableArray) {
            return WriteElementNodeFactory.WritableArrayWriteElementCacheNodeGen.create();
        }
        if (array instanceof TypedArray) {
            if (array instanceof TypedArray.TypedIntArray) {
                return WriteElementNodeFactory.TypedIntArrayWriteElementCacheNodeGen.create((TypedArray)array);
            }
            if (array instanceof TypedArray.TypedFloatArray) {
                return WriteElementNodeFactory.TypedFloatArrayWriteElementCacheNodeGen.create((TypedArray)array);
            }
            if (array instanceof TypedArray.TypedBigIntArray) {
                return WriteElementNodeFactory.TypedBigIntArrayWriteElementCacheNodeGen.create((TypedArray)array);
            }
            throw Errors.shouldNotReachHere();
        }
        return new ExactArrayWriteElementCacheNode();
    }

    @Override
    public JavaScriptNode getTarget() {
        return this.targetNode;
    }

    public JavaScriptNode getElement() {
        return this.indexNode;
    }

    public JavaScriptNode getValue() {
        return this.valueNode;
    }

    public JSContext getContext() {
        return this.context;
    }

    public boolean isStrict() {
        return this.isStrict;
    }

    public boolean writeOwn() {
        return this.writeOwn;
    }

    boolean isSuperProperty() {
        return this.targetNode instanceof SuperPropertyReferenceNode;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return WriteElementNode.create(WriteElementNode.cloneUninitialized(this.targetNode, materializedTags), WriteElementNode.cloneUninitialized(this.indexNode, materializedTags), WriteElementNode.cloneUninitialized(this.valueNode, materializedTags), this.getContext(), this.isStrict(), this.writeOwn());
    }

    @Override
    public boolean isResultAlwaysOfType(Class<?> clazz) {
        return this.valueNode.isResultAlwaysOfType(clazz);
    }

    @NeverDefault
    public static WriteElementNode createCachedInterop() {
        return WriteElementNode.create(JavaScriptLanguage.get(null).getJSContext(), true);
    }

    static abstract class WriteElementTypeCacheNode
    extends JavaScriptBaseNode {
        protected WriteElementTypeCacheNode() {
        }

        protected abstract void executeWithTargetAndIndexUnguarded(Object var1, Object var2, Object var3, Object var4, WriteElementNode var5);

        protected abstract void executeWithTargetAndIndexUnguarded(Object var1, long var2, Object var4, Object var5, WriteElementNode var6);
    }

    @ImportStatic(value={WriteElementNode.class})
    static abstract class WriteElementTypeCacheDispatchNode
    extends WriteElementTypeCacheNode {
        protected WriteElementTypeCacheDispatchNode() {
        }

        @Specialization(guards={"isObjectNode.executeBoolean(target)"}, limit="1")
        protected static void doJSObjectLongIndex(Object target, long index, Object value, Object receiver, WriteElementNode root, @Cached @Cached.Shared IsJSDynamicObjectNode isObjectNode, @Cached @Cached.Shared JSObjectWriteElementTypeCacheNode objectHandler) {
            objectHandler.executeWithTargetAndIndexUnguarded(target, index, value, receiver, root);
        }

        @Specialization(guards={"isObjectNode.executeBoolean(target)"}, limit="1", replaces={"doJSObjectLongIndex"})
        protected static void doJSObject(Object target, Object index, Object value, Object receiver, WriteElementNode root, @Cached @Cached.Shared IsJSDynamicObjectNode isObjectNode, @Cached @Cached.Shared JSObjectWriteElementTypeCacheNode objectHandler) {
            objectHandler.executeWithTargetAndIndexUnguarded(target, index, value, receiver, root);
        }

        @Specialization(guards={"otherHandler.guard(target)"}, limit="BOUNDED_BY_TYPES")
        protected static void doOther(Object target, Object index, Object value, Object receiver, WriteElementNode root, @Cached(value="makeHandler(target)") GuardedWriteElementTypeCacheNode otherHandler) {
            otherHandler.executeWithTargetAndIndexUnguarded(target, index, value, receiver, root);
        }

        protected static GuardedWriteElementTypeCacheNode makeHandler(Object target) {
            if (JSDynamicObject.isJSDynamicObject(target)) {
                throw Errors.shouldNotReachHere("JSDynamicObject");
            }
            if (Strings.isTString(target)) {
                return WriteElementNodeFactory.StringWriteElementTypeCacheNodeGen.create();
            }
            if (target instanceof Boolean) {
                return WriteElementNodeFactory.BooleanWriteElementTypeCacheNodeGen.create();
            }
            if (target instanceof Number) {
                return WriteElementNodeFactory.NumberWriteElementTypeCacheNodeGen.create(target.getClass());
            }
            if (target instanceof Symbol) {
                return WriteElementNodeFactory.SymbolWriteElementTypeCacheNodeGen.create();
            }
            if (target instanceof BigInt) {
                return WriteElementNodeFactory.BigIntWriteElementTypeCacheNodeGen.create();
            }
            assert (JSRuntime.isForeignObject(target)) : target.getClass();
            return WriteElementNodeFactory.ForeignObjectWriteElementTypeCacheNodeGen.create();
        }
    }

    private static class ExactArrayWriteElementCacheNode
    extends ArrayWriteElementCacheNode {
        ExactArrayWriteElementCacheNode() {
        }

        @Override
        protected boolean executeSetArray(JSDynamicObject target, ScriptArray array, long index, Object value, WriteElementNode root) {
            return false;
        }
    }

    static abstract class LazyRegexResultArrayWriteElementCacheNode
    extends RecursiveCachedArrayWriteElementCacheNode {
        @Node.Child
        private DynamicObjectLibrary lazyRegexResultNode = JSObjectUtil.createDispatched(JSAbstractArray.LAZY_REGEX_RESULT_ID);
        @Node.Child
        private DynamicObjectLibrary lazyRegexResultOriginalInputNode = JSObjectUtil.createDispatched(JSAbstractArray.LAZY_REGEX_ORIGINAL_INPUT_ID);
        @Node.Child
        private TruffleString.SubstringByteIndexNode substringNode = TruffleString.SubstringByteIndexNode.create();
        @Node.Child
        private TRegexUtil.InvokeGetGroupBoundariesMethodNode getStartNode = TRegexUtil.InvokeGetGroupBoundariesMethodNode.create();
        @Node.Child
        private TRegexUtil.InvokeGetGroupBoundariesMethodNode getEndNode = TRegexUtil.InvokeGetGroupBoundariesMethodNode.create();

        LazyRegexResultArrayWriteElementCacheNode() {
        }

        @Specialization
        protected boolean doLazyRegexResultArray(JSDynamicObject target, LazyRegexResultArray lazyRegexResultArray, long index, Object value, WriteElementNode root, @Cached InlinedConditionProfile inBoundsIf) {
            ScriptArray newArray = lazyRegexResultArray.createWritable(root.context, target, index, value, this.lazyRegexResultNode, this.lazyRegexResultOriginalInputNode, null, this.substringNode, this.getStartNode, this.getEndNode);
            if (inBoundsIf.profile((Node)this, index >= 0L && index < Integer.MAX_VALUE)) {
                return this.setArrayAndWrite(newArray, target, index, value, root);
            }
            JSAbstractArray.arraySetArrayType(target, SparseArray.makeSparseArray(target, newArray).setElement(target, index, value, root.isStrict));
            return true;
        }
    }

    static abstract class LazyRegexResultIndicesArrayWriteElementCacheNode
    extends RecursiveCachedArrayWriteElementCacheNode {
        @Node.Child
        private TRegexUtil.InvokeGetGroupBoundariesMethodNode getStartNode = TRegexUtil.InvokeGetGroupBoundariesMethodNode.create();
        @Node.Child
        private TRegexUtil.InvokeGetGroupBoundariesMethodNode getEndNode = TRegexUtil.InvokeGetGroupBoundariesMethodNode.create();

        LazyRegexResultIndicesArrayWriteElementCacheNode() {
        }

        @Specialization
        protected boolean doLazyRegexREsultIndicesArray(JSDynamicObject target, LazyRegexResultIndicesArray lazyRegexResultIndicesArray, long index, Object value, WriteElementNode root, @Cached InlinedConditionProfile inBoundsIf) {
            ScriptArray newArray = lazyRegexResultIndicesArray.createWritable(root.context, target, index, value, null, this.getStartNode, this.getEndNode);
            if (inBoundsIf.profile((Node)this, index >= 0L && index < Integer.MAX_VALUE)) {
                return this.setArrayAndWrite(newArray, target, index, value, root);
            }
            JSAbstractArray.arraySetArrayType(target, SparseArray.makeSparseArray(target, newArray).setElement(target, index, value, root.isStrict));
            return true;
        }
    }

    static abstract class ConstantArrayWriteElementCacheNode
    extends RecursiveCachedArrayWriteElementCacheNode {
        ConstantArrayWriteElementCacheNode() {
        }

        @Specialization
        protected boolean doConstantArray(JSDynamicObject target, AbstractConstantArray constantArray, long index, Object value, WriteElementNode root, @Cached InlinedBranchProfile intValueBranch, @Cached InlinedBranchProfile doubleValueBranch, @Cached InlinedBranchProfile jsObjectValueBranch, @Cached InlinedBranchProfile objectValueBranch, @Cached InlinedConditionProfile inBoundsIf, @Cached ScriptArray.CreateWritableProfileAccess createWritableProfile) {
            if (inBoundsIf.profile((Node)this, index >= 0L && index < Integer.MAX_VALUE)) {
                AbstractWritableArray newArray;
                if (value instanceof Integer) {
                    intValueBranch.enter((Node)this);
                    newArray = constantArray.createWriteableInt(target, index, (Integer)value, this, createWritableProfile);
                } else if (value instanceof Double) {
                    doubleValueBranch.enter((Node)this);
                    newArray = constantArray.createWriteableDouble(target, index, (Double)value, this, createWritableProfile);
                } else if (JSDynamicObject.isJSDynamicObject(value)) {
                    jsObjectValueBranch.enter((Node)this);
                    newArray = constantArray.createWriteableJSObject(target, index, (JSDynamicObject)((Object)value), this, createWritableProfile);
                } else {
                    objectValueBranch.enter((Node)this);
                    newArray = constantArray.createWriteableObject(target, index, value, this, createWritableProfile);
                }
                return this.setArrayAndWrite(newArray, target, index, value, root);
            }
            JSAbstractArray.arraySetArrayType(target, SparseArray.makeSparseArray(target, constantArray).setElement(target, index, value, root.isStrict));
            return true;
        }
    }

    static abstract class HolesIntArrayWriteElementCacheNode
    extends RecursiveCachedArrayWriteElementCacheNode {
        HolesIntArrayWriteElementCacheNode() {
        }

        @Specialization
        protected boolean doHolesIntArray(JSDynamicObject target, HolesIntArray holesIntArray, long index, Object value, WriteElementNode root, @Cached InlinedBranchProfile intValueBranch, @Cached InlinedBranchProfile doubleValueBranch, @Cached InlinedBranchProfile objectValueBranch, @Cached InlinedConditionProfile inBoundsFastIf, @Cached InlinedConditionProfile inBoundsIf, @Cached InlinedConditionProfile containsHolesIf, @Cached InlinedConditionProfile inBoundsFastHoleIf, @Cached InlinedConditionProfile supportedContainsHolesIf, @Cached InlinedConditionProfile supportedNotContainsHolesIf, @Cached InlinedConditionProfile hasExplicitHolesIf, @Cached InlinedBranchProfile needPrototypeBranch, @Cached AbstractWritableArray.SetSupportedProfileAccess setSupportedProfile) {
            if (value instanceof Integer) {
                intValueBranch.enter((Node)this);
                int intValue = (Integer)value;
                return this.executeWithIntValueInner(target, holesIntArray, index, intValue, root, inBoundsFastIf, inBoundsIf, containsHolesIf, inBoundsFastHoleIf, supportedContainsHolesIf, supportedNotContainsHolesIf, hasExplicitHolesIf, needPrototypeBranch, setSupportedProfile);
            }
            if (value instanceof Double) {
                doubleValueBranch.enter((Node)this);
                double doubleValue = (Double)value;
                return this.setArrayAndWrite(holesIntArray.toDouble(target, index, doubleValue), target, index, doubleValue, root);
            }
            objectValueBranch.enter((Node)this);
            return this.setArrayAndWrite(holesIntArray.toObject(target, index, value), target, index, value, root);
        }

        private boolean executeWithIntValueInner(JSDynamicObject target, HolesIntArray holesIntArray, long index, int intValue, WriteElementNode root, InlinedConditionProfile inBoundsFastIf, InlinedConditionProfile inBoundsIf, InlinedConditionProfile containsHolesIf, InlinedConditionProfile inBoundsFastHoleIf, InlinedConditionProfile supportedContainsHolesIf, InlinedConditionProfile supportedNotContainsHolesIf, InlinedConditionProfile hasExplicitHolesIf, InlinedBranchProfile needPrototypeBranch, AbstractWritableArray.SetSupportedProfileAccess setSupportedProfile) {
            DynamicArray toArrayType;
            if (HolesIntArrayWriteElementCacheNode.holesArrayNeedsSlowSet(target, holesIntArray, index, root)) {
                needPrototypeBranch.enter((Node)this);
                return false;
            }
            int iIndex = (int)index;
            boolean containsHoles = containsHolesIf.profile((Node)this, this.containsHoles(target, holesIntArray, index, hasExplicitHolesIf));
            if (containsHoles && inBoundsFastIf.profile((Node)this, holesIntArray.isInBoundsFast(target, index) && !HolesIntArray.isHoleValue(intValue))) {
                if (inBoundsFastHoleIf.profile((Node)this, holesIntArray.isHoleFast(target, iIndex))) {
                    holesIntArray.setInBoundsFastHole(target, iIndex, intValue);
                } else {
                    holesIntArray.setInBoundsFastNonHole(target, iIndex, intValue);
                }
                return true;
            }
            if (containsHoles && inBoundsIf.profile((Node)this, holesIntArray.isInBounds(target, iIndex) && !HolesIntArray.isHoleValue(intValue))) {
                holesIntArray.setInBounds(target, iIndex, intValue, this, setSupportedProfile);
                return true;
            }
            if (containsHoles && supportedContainsHolesIf.profile((Node)this, holesIntArray.isSupported(target, index) && !HolesIntArray.isHoleValue(intValue))) {
                holesIntArray.setSupported(target, iIndex, intValue, this, setSupportedProfile);
                return true;
            }
            if (!containsHoles && supportedNotContainsHolesIf.profile((Node)this, holesIntArray.isSupported(target, index))) {
                toArrayType = holesIntArray.toNonHoles(target, index, intValue);
            } else {
                assert (holesIntArray.isSparse(target, index) || HolesIntArray.isHoleValue(intValue));
                toArrayType = holesIntArray.toSparse(target, index, intValue);
            }
            return this.setArrayAndWrite(toArrayType, target, index, intValue, root);
        }

        private boolean containsHoles(JSDynamicObject target, HolesIntArray holesIntArray, long index, InlinedConditionProfile hasExplicitHolesIf) {
            return hasExplicitHolesIf.profile((Node)this, JSArray.arrayGetHoleCount(target) > 0) || !holesIntArray.isInBoundsFast(target, index);
        }
    }

    static abstract class HolesDoubleArrayWriteElementCacheNode
    extends RecursiveCachedArrayWriteElementCacheNode {
        HolesDoubleArrayWriteElementCacheNode() {
        }

        @Specialization
        protected boolean doHolesDoubleArray(JSDynamicObject target, HolesDoubleArray holesDoubleArray, long index, Object value, WriteElementNode root, @Cached InlinedBranchProfile intValueBranch, @Cached InlinedBranchProfile doubleValueBranch, @Cached InlinedBranchProfile objectValueBranch, @Cached InlinedConditionProfile inBoundsFastIf, @Cached InlinedConditionProfile inBoundsIf, @Cached InlinedConditionProfile containsHolesIf, @Cached InlinedConditionProfile inBoundsFastHoleIf, @Cached InlinedConditionProfile supportedContainsHolesIf, @Cached InlinedConditionProfile supportedNotContainsHolesIf, @Cached InlinedConditionProfile hasExplicitHolesIf, @Cached InlinedBranchProfile needPrototypeBranch, @Cached AbstractWritableArray.SetSupportedProfileAccess setSupportedProfile) {
            double doubleValue;
            if (value instanceof Double) {
                doubleValueBranch.enter((Node)this);
                doubleValue = (Double)value;
            } else if (value instanceof Integer) {
                intValueBranch.enter((Node)this);
                doubleValue = ((Integer)value).intValue();
            } else {
                objectValueBranch.enter((Node)this);
                return this.setArrayAndWrite(holesDoubleArray.toObject(target, index, value), target, index, value, root);
            }
            return this.executeWithDoubleValueInner(target, holesDoubleArray, index, doubleValue, root, inBoundsFastIf, inBoundsIf, containsHolesIf, inBoundsFastHoleIf, supportedContainsHolesIf, supportedNotContainsHolesIf, hasExplicitHolesIf, needPrototypeBranch, setSupportedProfile);
        }

        private boolean executeWithDoubleValueInner(JSDynamicObject target, HolesDoubleArray holesDoubleArray, long index, double doubleValue, WriteElementNode root, InlinedConditionProfile inBoundsFastIf, InlinedConditionProfile inBoundsIf, InlinedConditionProfile containsHolesIf, InlinedConditionProfile inBoundsFastHoleIf, InlinedConditionProfile supportedContainsHolesIf, InlinedConditionProfile supportedNotContainsHolesIf, InlinedConditionProfile hasExplicitHolesIf, InlinedBranchProfile needPrototypeBranch, AbstractWritableArray.SetSupportedProfileAccess setSupportedProfile) {
            DynamicArray toArrayType;
            if (HolesDoubleArrayWriteElementCacheNode.holesArrayNeedsSlowSet(target, holesDoubleArray, index, root)) {
                needPrototypeBranch.enter((Node)this);
                return false;
            }
            int iIndex = (int)index;
            boolean containsHoles = containsHolesIf.profile((Node)this, this.containsHoles(target, holesDoubleArray, index, hasExplicitHolesIf));
            if (containsHoles && inBoundsFastIf.profile((Node)this, holesDoubleArray.isInBoundsFast(target, index) && !HolesDoubleArray.isHoleValue(doubleValue))) {
                if (inBoundsFastHoleIf.profile((Node)this, holesDoubleArray.isHoleFast(target, iIndex))) {
                    holesDoubleArray.setInBoundsFastHole(target, iIndex, doubleValue);
                } else {
                    holesDoubleArray.setInBoundsFastNonHole(target, iIndex, doubleValue);
                }
                return true;
            }
            if (containsHoles && inBoundsIf.profile((Node)this, holesDoubleArray.isInBounds(target, iIndex) && !HolesDoubleArray.isHoleValue(doubleValue))) {
                holesDoubleArray.setInBounds(target, iIndex, doubleValue, this, setSupportedProfile);
                return true;
            }
            if (containsHoles && supportedContainsHolesIf.profile((Node)this, holesDoubleArray.isSupported(target, index) && !HolesDoubleArray.isHoleValue(doubleValue))) {
                holesDoubleArray.setSupported(target, iIndex, doubleValue, this, setSupportedProfile);
                return true;
            }
            if (!containsHoles && supportedNotContainsHolesIf.profile((Node)this, holesDoubleArray.isSupported(target, index))) {
                toArrayType = holesDoubleArray.toNonHoles(target, index, doubleValue);
            } else {
                assert (holesDoubleArray.isSparse(target, index) || HolesDoubleArray.isHoleValue(doubleValue));
                toArrayType = holesDoubleArray.toSparse(target, index, doubleValue);
            }
            return this.setArrayAndWrite(toArrayType, target, index, doubleValue, root);
        }

        private boolean containsHoles(JSDynamicObject target, HolesDoubleArray holesDoubleArray, long index, InlinedConditionProfile hasExplicitHolesIf) {
            return hasExplicitHolesIf.profile((Node)this, JSArray.arrayGetHoleCount(target) > 0) || !holesDoubleArray.isInBoundsFast(target, index);
        }
    }

    static abstract class HolesJSObjectArrayWriteElementCacheNode
    extends RecursiveCachedArrayWriteElementCacheNode {
        HolesJSObjectArrayWriteElementCacheNode() {
        }

        @Specialization
        protected boolean doJSObjectArray(JSDynamicObject target, HolesJSObjectArray holesArray, long index, Object value, WriteElementNode root, @Cached InlinedBranchProfile jsObjectValueBranch, @Cached InlinedBranchProfile objectValueBranch, @Cached InlinedConditionProfile inBoundsFastIf, @Cached InlinedConditionProfile inBoundsIf, @Cached InlinedConditionProfile containsHolesIf, @Cached InlinedConditionProfile inBoundsFastHoleIf, @Cached InlinedConditionProfile supportedContainsHolesIf, @Cached InlinedConditionProfile supportedNotContainsHolesIf, @Cached InlinedConditionProfile hasExplicitHolesIf, @Cached InlinedBranchProfile needPrototypeBranch, @Cached AbstractWritableArray.SetSupportedProfileAccess setSupportedProfile) {
            if (JSDynamicObject.isJSDynamicObject(value)) {
                jsObjectValueBranch.enter((Node)this);
                return this.executeWithJSObjectValueInner(target, holesArray, index, (JSDynamicObject)((Object)value), root, inBoundsFastIf, inBoundsIf, containsHolesIf, inBoundsFastHoleIf, supportedContainsHolesIf, supportedNotContainsHolesIf, hasExplicitHolesIf, needPrototypeBranch, setSupportedProfile);
            }
            objectValueBranch.enter((Node)this);
            return this.setArrayAndWrite(holesArray.toObject(target, index, value), target, index, value, root);
        }

        private boolean executeWithJSObjectValueInner(JSDynamicObject target, HolesJSObjectArray jsobjectArray, long index, JSDynamicObject value, WriteElementNode root, InlinedConditionProfile inBoundsFastIf, InlinedConditionProfile inBoundsIf, InlinedConditionProfile containsHolesIf, InlinedConditionProfile inBoundsFastHoleIf, InlinedConditionProfile supportedContainsHolesIf, InlinedConditionProfile supportedNotContainsHolesIf, InlinedConditionProfile hasExplicitHolesIf, InlinedBranchProfile needPrototypeBranch, AbstractWritableArray.SetSupportedProfileAccess setSupportedProfile) {
            DynamicArray toArrayType;
            if (HolesJSObjectArrayWriteElementCacheNode.holesArrayNeedsSlowSet(target, jsobjectArray, index, root)) {
                needPrototypeBranch.enter((Node)this);
                return false;
            }
            boolean containsHoles = containsHolesIf.profile((Node)this, this.containsHoles(target, jsobjectArray, index, hasExplicitHolesIf));
            if (containsHoles && inBoundsFastIf.profile((Node)this, jsobjectArray.isInBoundsFast(target, index))) {
                assert (!HolesJSObjectArray.isHoleValue(value));
                if (inBoundsFastHoleIf.profile((Node)this, jsobjectArray.isHoleFast(target, (int)index))) {
                    jsobjectArray.setInBoundsFastHole(target, (int)index, value);
                } else {
                    jsobjectArray.setInBoundsFastNonHole(target, (int)index, value);
                }
                return true;
            }
            if (containsHoles && inBoundsIf.profile((Node)this, jsobjectArray.isInBounds(target, (int)index))) {
                assert (!HolesJSObjectArray.isHoleValue(value));
                jsobjectArray.setInBounds(target, (int)index, value, this, setSupportedProfile);
                return true;
            }
            if (containsHoles && supportedContainsHolesIf.profile((Node)this, jsobjectArray.isSupported(target, index))) {
                assert (!HolesJSObjectArray.isHoleValue(value));
                jsobjectArray.setSupported(target, (int)index, value, this, setSupportedProfile);
                return true;
            }
            if (!containsHoles && supportedNotContainsHolesIf.profile((Node)this, jsobjectArray.isSupported(target, index))) {
                toArrayType = jsobjectArray.toNonHoles(target, index, (Object)value);
            } else {
                assert (jsobjectArray.isSparse(target, index));
                toArrayType = jsobjectArray.toSparse(target, index, (Object)value);
            }
            return this.setArrayAndWrite(toArrayType, target, index, (Object)value, root);
        }

        private boolean containsHoles(JSDynamicObject target, HolesJSObjectArray holesJSObjectArray, long index, InlinedConditionProfile hasExplicitHolesIf) {
            return hasExplicitHolesIf.profile((Node)this, JSArray.arrayGetHoleCount(target) > 0) || !holesJSObjectArray.isInBoundsFast(target, index);
        }
    }

    static abstract class HolesObjectArrayWriteElementCacheNode
    extends RecursiveCachedArrayWriteElementCacheNode {
        HolesObjectArrayWriteElementCacheNode() {
        }

        @Specialization
        protected boolean doHolesObjectArray(JSDynamicObject target, HolesObjectArray objectArray, long index, Object value, WriteElementNode root, @Cached InlinedConditionProfile inBoundsFastIf, @Cached InlinedConditionProfile inBoundsIf, @Cached InlinedConditionProfile inBoundsFastHoleIf, @Cached InlinedConditionProfile supportedIf, @Cached InlinedBranchProfile needPrototypeBranch, @Cached AbstractWritableArray.SetSupportedProfileAccess setSupportedProfile) {
            if (HolesObjectArrayWriteElementCacheNode.holesArrayNeedsSlowSet(target, objectArray, index, root)) {
                needPrototypeBranch.enter((Node)this);
                return false;
            }
            if (inBoundsFastIf.profile((Node)this, objectArray.isInBoundsFast(target, index))) {
                assert (!HolesObjectArray.isHoleValue(value));
                if (inBoundsFastHoleIf.profile((Node)this, objectArray.isHoleFast(target, (int)index))) {
                    objectArray.setInBoundsFastHole(target, (int)index, value);
                } else {
                    objectArray.setInBoundsFastNonHole(target, (int)index, value);
                }
                return true;
            }
            if (inBoundsIf.profile((Node)this, objectArray.isInBounds(target, (int)index))) {
                assert (!HolesObjectArray.isHoleValue(value));
                objectArray.setInBounds(target, (int)index, value, this, setSupportedProfile);
                return true;
            }
            if (supportedIf.profile((Node)this, objectArray.isSupported(target, index))) {
                assert (!HolesObjectArray.isHoleValue(value));
                objectArray.setSupported(target, (int)index, value, this, setSupportedProfile);
                return true;
            }
            assert (objectArray.isSparse(target, index));
            return this.setArrayAndWrite(objectArray.toSparse(target, index, value), target, index, value, root);
        }
    }

    static abstract class IntArrayWriteElementCacheNode
    extends RecursiveCachedArrayWriteElementCacheNode {
        IntArrayWriteElementCacheNode() {
        }

        @Specialization
        protected boolean doIntArray(JSDynamicObject target, AbstractIntArray intArray, long index, Object value, WriteElementNode root, @Cached InlinedBranchProfile intValueBranch, @Cached InlinedBranchProfile doubleValueBranch, @Cached InlinedBranchProfile objectValueBranch, @Cached InlinedConditionProfile inBoundsFastIf, @Cached InlinedConditionProfile inBoundsIf, @Cached InlinedConditionProfile supportedNonZeroIf, @Cached InlinedConditionProfile supportedZeroIf, @Cached InlinedConditionProfile supportedContiguousIf, @Cached InlinedConditionProfile supportedHolesIf, @Cached InlinedBranchProfile needPrototypeBranch, @Cached AbstractWritableArray.SetSupportedProfileAccess setSupportedProfile) {
            if (value instanceof Integer) {
                intValueBranch.enter((Node)this);
                return this.doIntArrayWithIntValue(target, intArray, index, (Integer)value, root, inBoundsFastIf, inBoundsIf, supportedNonZeroIf, supportedZeroIf, supportedContiguousIf, supportedHolesIf, needPrototypeBranch, setSupportedProfile);
            }
            if (value instanceof Double) {
                doubleValueBranch.enter((Node)this);
                double doubleValue = (Double)value;
                return this.setArrayAndWrite(intArray.toDouble(target, index, doubleValue), target, index, doubleValue, root);
            }
            objectValueBranch.enter((Node)this);
            return this.setArrayAndWrite(intArray.toObject(target, index, value), target, index, value, root);
        }

        private boolean doIntArrayWithIntValue(JSDynamicObject target, AbstractIntArray intArray, long index, int intValue, WriteElementNode root, @Cached InlinedConditionProfile inBoundsFastIf, @Cached InlinedConditionProfile inBoundsIf, @Cached InlinedConditionProfile supportedNonZeroIf, @Cached InlinedConditionProfile supportedZeroIf, @Cached InlinedConditionProfile supportedContiguousIf, @Cached InlinedConditionProfile supportedHolesIf, @Cached InlinedBranchProfile needPrototypeBranch, @Cached AbstractWritableArray.SetSupportedProfileAccess setSupportedProfile) {
            ScriptArray toArrayType;
            assert (!(intArray instanceof HolesIntArray));
            if (IntArrayWriteElementCacheNode.nonHolesArrayNeedsSlowSet(target, intArray, index, root)) {
                needPrototypeBranch.enter((Node)this);
                return false;
            }
            int iIndex = (int)index;
            if (inBoundsFastIf.profile((Node)this, intArray.isInBoundsFast(target, index) && !IntArrayWriteElementCacheNode.mightTransferToNonContiguous(intArray, target, index))) {
                intArray.setInBoundsFast(target, iIndex, intValue);
                return true;
            }
            if (inBoundsIf.profile((Node)this, intArray.isInBounds(target, iIndex) && !IntArrayWriteElementCacheNode.mightTransferToNonContiguous(intArray, target, index))) {
                intArray.setInBounds(target, iIndex, intValue, this, setSupportedProfile);
                return true;
            }
            if (supportedNonZeroIf.profile((Node)this, intArray.isSupported(target, index) && !IntArrayWriteElementCacheNode.mightTransferToNonContiguous(intArray, target, index))) {
                intArray.setSupported(target, iIndex, intValue, this, setSupportedProfile);
                return true;
            }
            if (supportedZeroIf.profile((Node)this, IntArrayWriteElementCacheNode.mightTransferToNonContiguous(intArray, target, index) && intArray.isSupported(target, index))) {
                toArrayType = intArray.toNonContiguous(target, iIndex, intValue, this, setSupportedProfile);
            } else if (supportedContiguousIf.profile((Node)this, !(intArray instanceof AbstractContiguousIntArray) && intArray.isSupportedContiguous(target, index))) {
                toArrayType = intArray.toContiguous(target, index, intValue);
            } else if (supportedHolesIf.profile((Node)this, intArray.isSupportedHoles(target, index))) {
                toArrayType = intArray.toHoles(target, index, intValue);
            } else {
                assert (intArray.isSparse(target, index));
                toArrayType = intArray.toSparse(target, index, intValue);
            }
            return this.setArrayAndWrite(toArrayType, target, index, intValue, root);
        }

        private static boolean mightTransferToNonContiguous(AbstractIntArray intArray, JSDynamicObject target, long index) {
            return intArray instanceof ContiguousIntArray && index == 0L && intArray.firstElementIndex(target) == 1L;
        }
    }

    static abstract class DoubleArrayWriteElementCacheNode
    extends RecursiveCachedArrayWriteElementCacheNode {
        DoubleArrayWriteElementCacheNode() {
        }

        @Specialization
        protected boolean doDoubleArray(JSDynamicObject target, AbstractDoubleArray doubleArray, long index, Object value, WriteElementNode root, @Cached InlinedBranchProfile intValueBranch, @Cached InlinedBranchProfile doubleValueBranch, @Cached InlinedBranchProfile objectValueBranch, @Cached InlinedConditionProfile inBoundsFastIf, @Cached InlinedConditionProfile inBoundsIf, @Cached InlinedConditionProfile supportedIf, @Cached InlinedConditionProfile supportedContiguousIf, @Cached InlinedConditionProfile supportedHolesIf, @Cached InlinedBranchProfile needPrototypeBranch, @Cached AbstractWritableArray.SetSupportedProfileAccess setSupportedProfile) {
            double doubleValue;
            if (value instanceof Double) {
                doubleValueBranch.enter((Node)this);
                doubleValue = (Double)value;
            } else if (value instanceof Integer) {
                intValueBranch.enter((Node)this);
                doubleValue = ((Integer)value).intValue();
            } else {
                objectValueBranch.enter((Node)this);
                return this.setArrayAndWrite(doubleArray.toObject(target, index, value), target, index, value, root);
            }
            return this.executeWithDoubleValueInner(target, doubleArray, index, doubleValue, root, inBoundsFastIf, inBoundsIf, supportedIf, supportedContiguousIf, supportedHolesIf, needPrototypeBranch, setSupportedProfile);
        }

        private boolean executeWithDoubleValueInner(JSDynamicObject target, AbstractDoubleArray doubleArray, long index, double doubleValue, WriteElementNode root, @Cached InlinedConditionProfile inBoundsFastIf, @Cached InlinedConditionProfile inBoundsIf, @Cached InlinedConditionProfile supportedIf, @Cached InlinedConditionProfile supportedContiguousIf, @Cached InlinedConditionProfile supportedHolesIf, @Cached InlinedBranchProfile needPrototypeBranch, @Cached AbstractWritableArray.SetSupportedProfileAccess setSupportedProfile) {
            DynamicArray toArrayType;
            assert (!(doubleArray instanceof HolesDoubleArray));
            if (DoubleArrayWriteElementCacheNode.nonHolesArrayNeedsSlowSet(target, doubleArray, index, root)) {
                needPrototypeBranch.enter((Node)this);
                return false;
            }
            int iIndex = (int)index;
            if (inBoundsFastIf.profile((Node)this, doubleArray.isInBoundsFast(target, index))) {
                doubleArray.setInBoundsFast(target, iIndex, doubleValue);
                return true;
            }
            if (inBoundsIf.profile((Node)this, doubleArray.isInBounds(target, iIndex))) {
                doubleArray.setInBounds(target, iIndex, doubleValue, this, setSupportedProfile);
                return true;
            }
            if (supportedIf.profile((Node)this, doubleArray.isSupported(target, index))) {
                doubleArray.setSupported(target, iIndex, doubleValue, this, setSupportedProfile);
                return true;
            }
            if (supportedContiguousIf.profile((Node)this, !(doubleArray instanceof AbstractContiguousDoubleArray) && doubleArray.isSupportedContiguous(target, index))) {
                toArrayType = doubleArray.toContiguous(target, index, doubleValue);
            } else if (supportedHolesIf.profile((Node)this, doubleArray.isSupportedHoles(target, index))) {
                toArrayType = doubleArray.toHoles(target, index, doubleValue);
            } else {
                assert (doubleArray.isSparse(target, index));
                toArrayType = doubleArray.toSparse(target, index, doubleValue);
            }
            return this.setArrayAndWrite(toArrayType, target, index, doubleValue, root);
        }
    }

    static abstract class ObjectArrayWriteElementCacheNode
    extends RecursiveCachedArrayWriteElementCacheNode {
        ObjectArrayWriteElementCacheNode() {
        }

        @Specialization
        protected boolean doObjectArray(JSDynamicObject target, AbstractObjectArray objectArray, long index, Object value, WriteElementNode root, @Cached InlinedConditionProfile inBoundsFastIf, @Cached InlinedConditionProfile inBoundsIf, @Cached InlinedConditionProfile supportedIf, @Cached InlinedConditionProfile supportedContiguousIf, @Cached InlinedConditionProfile supportedHolesIf, @Cached InlinedBranchProfile needPrototypeBranch, @Cached AbstractWritableArray.SetSupportedProfileAccess setSupportedProfile) {
            DynamicArray toArrayType;
            assert (!(objectArray instanceof HolesObjectArray));
            if (ObjectArrayWriteElementCacheNode.nonHolesArrayNeedsSlowSet(target, objectArray, index, root)) {
                needPrototypeBranch.enter((Node)this);
                return false;
            }
            int iIndex = (int)index;
            if (inBoundsFastIf.profile((Node)this, objectArray.isInBoundsFast(target, index))) {
                objectArray.setInBoundsFast(target, iIndex, value);
                return true;
            }
            if (inBoundsIf.profile((Node)this, objectArray.isInBounds(target, iIndex))) {
                objectArray.setInBounds(target, iIndex, value, this, setSupportedProfile);
                return true;
            }
            if (supportedIf.profile((Node)this, objectArray.isSupported(target, index))) {
                objectArray.setSupported(target, iIndex, value, this, setSupportedProfile);
                return true;
            }
            if (supportedContiguousIf.profile((Node)this, !(objectArray instanceof AbstractContiguousObjectArray) && objectArray.isSupportedContiguous(target, index))) {
                toArrayType = objectArray.toContiguous(target, index, value);
            } else if (supportedHolesIf.profile((Node)this, objectArray.isSupportedHoles(target, index))) {
                toArrayType = objectArray.toHoles(target, index, value);
            } else {
                assert (objectArray.isSparse(target, index));
                toArrayType = objectArray.toSparse(target, index, value);
            }
            return this.setArrayAndWrite(toArrayType, target, index, value, root);
        }
    }

    static abstract class JSObjectArrayWriteElementCacheNode
    extends RecursiveCachedArrayWriteElementCacheNode {
        JSObjectArrayWriteElementCacheNode() {
        }

        @Specialization
        protected boolean doJSObjectArray(JSDynamicObject target, AbstractJSObjectArray jsobjectArray, long index, Object value, WriteElementNode root, @Cached InlinedBranchProfile jsObjectValueBranch, @Cached InlinedBranchProfile objectValueBranch, @Cached InlinedConditionProfile inBoundsFastIf, @Cached InlinedConditionProfile inBoundsIf, @Cached InlinedConditionProfile supportedIf, @Cached InlinedConditionProfile supportedContiguousIf, @Cached InlinedConditionProfile supportedHolesIf, @Cached InlinedBranchProfile needPrototypeBranch, @Cached AbstractWritableArray.SetSupportedProfileAccess setSupportedProfile) {
            if (JSDynamicObject.isJSDynamicObject(value)) {
                jsObjectValueBranch.enter((Node)this);
                JSDynamicObject jsobjectValue = (JSDynamicObject)((Object)value);
                return this.executeWithJSObjectValueInner(target, jsobjectArray, index, jsobjectValue, root, inBoundsFastIf, inBoundsIf, supportedIf, supportedContiguousIf, supportedHolesIf, needPrototypeBranch, setSupportedProfile);
            }
            objectValueBranch.enter((Node)this);
            return this.setArrayAndWrite(jsobjectArray.toObject(target, index, value), target, index, value, root);
        }

        private boolean executeWithJSObjectValueInner(JSDynamicObject target, AbstractJSObjectArray jsobjectArray, long index, JSDynamicObject jsobjectValue, WriteElementNode root, InlinedConditionProfile inBoundsFastIf, InlinedConditionProfile inBoundsIf, InlinedConditionProfile supportedIf, InlinedConditionProfile supportedContiguousIf, InlinedConditionProfile supportedHolesIf, InlinedBranchProfile needPrototypeBranch, AbstractWritableArray.SetSupportedProfileAccess setSupportedProfile) {
            DynamicArray toArrayType;
            assert (!(jsobjectArray instanceof HolesJSObjectArray));
            int iIndex = (int)index;
            if (JSObjectArrayWriteElementCacheNode.nonHolesArrayNeedsSlowSet(target, jsobjectArray, index, root)) {
                needPrototypeBranch.enter((Node)this);
                return false;
            }
            if (inBoundsFastIf.profile((Node)this, jsobjectArray.isInBoundsFast(target, index))) {
                jsobjectArray.setInBoundsFast(target, iIndex, jsobjectValue);
                return true;
            }
            if (inBoundsIf.profile((Node)this, jsobjectArray.isInBounds(target, iIndex))) {
                jsobjectArray.setInBounds(target, iIndex, jsobjectValue, this, setSupportedProfile);
                return true;
            }
            if (supportedIf.profile((Node)this, jsobjectArray.isSupported(target, index))) {
                jsobjectArray.setSupported(target, iIndex, jsobjectValue, this, setSupportedProfile);
                return true;
            }
            if (supportedContiguousIf.profile((Node)this, !(jsobjectArray instanceof AbstractContiguousJSObjectArray) && jsobjectArray.isSupportedContiguous(target, index))) {
                toArrayType = jsobjectArray.toContiguous(target, index, (Object)jsobjectValue);
            } else if (supportedHolesIf.profile((Node)this, jsobjectArray.isSupportedHoles(target, index))) {
                toArrayType = jsobjectArray.toHoles(target, index, (Object)jsobjectValue);
            } else {
                assert (jsobjectArray.isSparse(target, index));
                toArrayType = jsobjectArray.toSparse(target, index, (Object)jsobjectValue);
            }
            return this.setArrayAndWrite(toArrayType, target, index, (Object)jsobjectValue, root);
        }
    }

    static abstract class WritableArrayWriteElementCacheNode
    extends ArrayWriteElementCacheNode {
        WritableArrayWriteElementCacheNode() {
        }

        @Specialization
        protected final boolean doWritableArray(JSDynamicObject target, AbstractWritableArray writableArray, long index, Object value, WriteElementNode root, @Cached InlinedConditionProfile inBoundsIf) {
            if (inBoundsIf.profile((Node)this, writableArray.isInBoundsFast(target, index))) {
                JSAbstractArray.arraySetArrayType(target, writableArray.setElement(target, index, value, root.isStrict));
                return true;
            }
            return false;
        }
    }

    static abstract class TypedIntArrayWriteElementCacheNode
    extends AbstractTypedArrayWriteElementCacheNode {
        TypedIntArrayWriteElementCacheNode(TypedArray arrayType) {
            super(arrayType);
        }

        @Specialization
        protected final boolean doTypedIntArrayIntValue(JSDynamicObject target, TypedArray.TypedIntArray typedArray, long index, int iValue, WriteElementNode root, @Cached @Cached.Shared InlinedConditionProfile inBoundsIf) {
            if (!JSArrayBufferView.hasDetachedBuffer(target, root.context) && inBoundsIf.profile((Node)this, typedArray.hasElement(target, index))) {
                typedArray.setInt(target, (int)index, iValue, this.interop);
            }
            return true;
        }

        protected static boolean isSpecial(TypedArray.TypedIntArray typedArray) {
            return typedArray instanceof TypedArray.AbstractUint32Array || typedArray instanceof TypedArray.AbstractUint8ClampedArray;
        }

        @Specialization(guards={"!isSpecial(typedArray)"}, replaces={"doTypedIntArrayIntValue"})
        protected final boolean doTypedIntArray(JSDynamicObject target, TypedArray.TypedIntArray typedArray, long index, Object value, WriteElementNode root, @Cached JSToInt32Node toIntNode, @Cached @Cached.Shared InlinedConditionProfile inBoundsIf) {
            int iValue = toIntNode.executeInt(value);
            return this.doTypedIntArrayIntValue(target, typedArray, index, iValue, root, inBoundsIf);
        }

        @Specialization(replaces={"doTypedIntArrayIntValue"})
        protected final boolean doTypedIntArray(JSDynamicObject target, TypedArray.AbstractUint32Array typedArray, long index, Object value, WriteElementNode root, @Cached JSToNumberNode toNumberNode, @Cached @Cached.Shared InlinedConditionProfile inBoundsIf) {
            int iValue = (int)JSRuntime.toUInt32(toNumberNode.executeNumber(value));
            return this.doTypedIntArrayIntValue(target, typedArray, index, iValue, root, inBoundsIf);
        }

        @Specialization(replaces={"doTypedIntArrayIntValue"})
        protected final boolean doTypedIntArray(JSDynamicObject target, TypedArray.AbstractUint8ClampedArray typedArray, long index, Object value, WriteElementNode root, @Cached JSToDoubleNode toDoubleNode, @Cached @Cached.Shared InlinedConditionProfile inBoundsIf) {
            double doubleValue = toDoubleNode.executeDouble(value);
            int iValue = TypedArray.Uint8ClampedArray.toInt(doubleValue);
            return this.doTypedIntArrayIntValue(target, typedArray, index, iValue, root, inBoundsIf);
        }
    }

    static abstract class TypedFloatArrayWriteElementCacheNode
    extends AbstractTypedArrayWriteElementCacheNode {
        TypedFloatArrayWriteElementCacheNode(TypedArray arrayType) {
            super(arrayType);
        }

        @Specialization
        protected boolean doTypedFloatArray(JSDynamicObject target, TypedArray.TypedFloatArray typedArray, long index, Object value, WriteElementNode root, @Cached InlinedConditionProfile inBoundsIf, @Cached JSToDoubleNode toDouble) {
            double dValue = toDouble.executeDouble(value);
            if (!JSArrayBufferView.hasDetachedBuffer(target, root.context) && inBoundsIf.profile((Node)this, typedArray.hasElement(target, index))) {
                typedArray.setDouble(target, (int)index, dValue, this.interop);
            }
            return true;
        }
    }

    static abstract class TypedBigIntArrayWriteElementCacheNode
    extends AbstractTypedArrayWriteElementCacheNode {
        @Node.Child
        private JSToBigIntNode toBigIntNode = JSToBigIntNode.create();

        TypedBigIntArrayWriteElementCacheNode(TypedArray arrayType) {
            super(arrayType);
        }

        @Specialization
        protected final boolean doBigIntArray(JSDynamicObject target, TypedArray.TypedBigIntArray typedArray, long index, Object value, WriteElementNode root, @Cached InlinedConditionProfile inBoundsIf) {
            BigInt biValue = this.toBigIntNode.executeBigInteger(value);
            if (!JSArrayBufferView.hasDetachedBuffer(target, root.context) && inBoundsIf.profile((Node)this, typedArray.hasElement(target, index))) {
                typedArray.setBigInt(target, (int)index, biValue, this.interop);
            }
            return true;
        }
    }

    static abstract class ForeignObjectWriteElementTypeCacheNode
    extends GuardedWriteElementTypeCacheNode {
        @Node.Child
        private InteropLibrary interop;
        @Node.Child
        private InteropLibrary keyInterop;
        @Node.Child
        private InteropLibrary setterInterop;
        @Node.Child
        private JSToPropertyKeyNode toPropertyKeyNode;
        @Node.Child
        private ExportValueNode exportValue = ExportValueNode.create();
        @Node.Child
        private ToArrayIndexNode toArrayIndexNode;

        ForeignObjectWriteElementTypeCacheNode() {
            this.interop = (InteropLibrary)InteropLibrary.getFactory().createDispatched(5);
            this.keyInterop = (InteropLibrary)InteropLibrary.getFactory().createDispatched(5);
        }

        @Specialization
        protected void doForeignObject(Object target, Object index, Object value, Object receiver, WriteElementNode root, @Cached InlinedExactClassProfile classProfile, @Cached InlinedBranchProfile errorBranch) {
            Object propertyKey;
            Object truffleObject = classProfile.profile((Node)this, target);
            if (this.interop.isNull(truffleObject)) {
                throw Errors.createTypeErrorCannotSetProperty(index, truffleObject, this, root.getContext());
            }
            Object exportedValue = this.exportValue.execute(value);
            boolean hasArrayElements = this.interop.hasArrayElements(truffleObject);
            if (hasArrayElements) {
                Object indexOrPropertyKey = this.toArrayIndex(index);
                if (indexOrPropertyKey instanceof Long) {
                    try {
                        this.interop.writeArrayElement(truffleObject, ((Long)indexOrPropertyKey).longValue(), exportedValue);
                        return;
                    }
                    catch (InvalidArrayIndexException | UnsupportedMessageException | UnsupportedTypeException e) {
                        if (root.isStrict) {
                            errorBranch.enter((Node)this);
                            throw Errors.createTypeErrorInteropException(truffleObject, (InteropException)e, "writeArrayElement", this);
                        }
                        return;
                    }
                }
                propertyKey = indexOrPropertyKey;
                assert (JSRuntime.isPropertyKey(propertyKey));
            } else {
                propertyKey = this.toPropertyKey(index);
            }
            if (root.context.getLanguageOptions().hasForeignHashProperties() && this.interop.hasHashEntries(truffleObject)) {
                try {
                    this.interop.writeHashEntry(truffleObject, propertyKey, exportedValue);
                    return;
                }
                catch (UnknownKeyException | UnsupportedMessageException | UnsupportedTypeException e) {
                    if (root.isStrict) {
                        errorBranch.enter((Node)this);
                        throw Errors.createTypeErrorInteropException(truffleObject, (InteropException)e, "writeHashEntry", this);
                    }
                    return;
                }
            }
            if (propertyKey instanceof Symbol) {
                return;
            }
            TruffleString stringKey = (TruffleString)propertyKey;
            if (hasArrayElements && Strings.equals(JSAbstractArray.LENGTH, stringKey)) {
                JSInteropUtil.setArraySize(truffleObject, value, root.isStrict, this.interop, this, null);
            }
            if (root.context.isOptionNashornCompatibilityMode() && this.tryInvokeSetter(truffleObject, stringKey, exportedValue, root.context)) {
                return;
            }
            try {
                String javaPropertyKey = Strings.toJavaString(stringKey);
                this.interop.writeMember(truffleObject, javaPropertyKey, exportedValue);
            }
            catch (UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException e) {
                if (root.isStrict) {
                    errorBranch.enter((Node)this);
                    throw Errors.createTypeErrorInteropException(truffleObject, (InteropException)e, "writeMember", this);
                }
                return;
            }
        }

        @Override
        public boolean guard(Object target) {
            return JSRuntime.isForeignObject(target);
        }

        private boolean tryInvokeSetter(Object thisObj, TruffleString key, Object value, JSContext context) {
            assert (context.isOptionNashornCompatibilityMode());
            TruffleLanguage.Env env = this.getRealm().getEnv();
            if (env.isHostObject(thisObj)) {
                TruffleString setterKey = PropertyCacheNode.getAccessorKey(Strings.SET, key);
                if (setterKey == null) {
                    return false;
                }
                if (this.setterInterop == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.setterInterop = (InteropLibrary)this.insert((Node)((InteropLibrary)InteropLibrary.getFactory().createDispatched(5)));
                }
                if (!this.setterInterop.isMemberInvocable(thisObj, Strings.toJavaString(setterKey))) {
                    return false;
                }
                try {
                    this.setterInterop.invokeMember(thisObj, Strings.toJavaString(setterKey), new Object[]{value});
                    return true;
                }
                catch (ArityException | UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException throwable) {
                    // empty catch block
                }
            }
            return false;
        }

        private Object toArrayIndex(Object index) {
            if (this.toArrayIndexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toArrayIndexNode = (ToArrayIndexNode)this.insert(ToArrayIndexNode.create());
            }
            return this.toArrayIndexNode.execute(index);
        }

        private Object toPropertyKey(Object index) {
            if (this.toPropertyKeyNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toPropertyKeyNode = (JSToPropertyKeyNode)this.insert(JSToPropertyKeyNode.create());
            }
            return this.toPropertyKeyNode.execute(index);
        }
    }

    static abstract class BigIntWriteElementTypeCacheNode
    extends ToPropertyKeyCachedWriteElementTypeCacheNode {
        BigIntWriteElementTypeCacheNode() {
        }

        @Specialization
        protected void doBigIntIntegerIndex(Object target, long index, Object value, Object receiver, WriteElementNode root) {
            BigInt bigInt = (BigInt)target;
            JSContext context = root.context;
            JSObject.setWithReceiver((JSDynamicObject)JSBigInt.create(context, this.getRealm(), bigInt), index, value, receiver, root.isStrict, this.classProfile, (Node)root);
        }

        @Specialization
        protected void doBigInt(Object target, Object index, Object value, Object receiver, WriteElementNode root, @Cached JSToPropertyKeyNode indexToPropertyKeyNode) {
            BigInt bigInt = (BigInt)target;
            JSContext context = root.context;
            JSObject.setWithReceiver((JSDynamicObject)JSBigInt.create(context, this.getRealm(), bigInt), indexToPropertyKeyNode.execute(index), value, receiver, root.isStrict, this.classProfile, (Node)root);
        }

        @Override
        public boolean guard(Object target) {
            return target instanceof BigInt;
        }
    }

    static abstract class SymbolWriteElementTypeCacheNode
    extends ToPropertyKeyCachedWriteElementTypeCacheNode {
        SymbolWriteElementTypeCacheNode() {
        }

        @Specialization
        protected void doSymbol(Object target, long index, Object value, Object receiver, WriteElementNode root) {
            if (root.isStrict) {
                throw Errors.createTypeError("cannot set element on Symbol in strict mode", (Node)this);
            }
            Symbol symbol = (Symbol)target;
            JSObject.setWithReceiver((JSDynamicObject)JSSymbol.create(root.context, this.getRealm(), symbol), index, value, receiver, root.isStrict, this.classProfile, (Node)root);
        }

        @Specialization
        protected void doSymbol(Object target, Object index, Object value, Object receiver, WriteElementNode root, @Cached JSToPropertyKeyNode indexToPropertyKeyNode) {
            if (root.isStrict) {
                throw Errors.createTypeError("cannot set element on Symbol in strict mode", (Node)this);
            }
            Symbol symbol = (Symbol)target;
            JSObject.setWithReceiver((JSDynamicObject)JSSymbol.create(root.context, this.getRealm(), symbol), indexToPropertyKeyNode.execute(index), value, receiver, root.isStrict, this.classProfile, (Node)root);
        }

        @Override
        public boolean guard(Object target) {
            return target instanceof Symbol;
        }
    }

    static abstract class BooleanWriteElementTypeCacheNode
    extends ToPropertyKeyCachedWriteElementTypeCacheNode {
        BooleanWriteElementTypeCacheNode() {
        }

        @Specialization
        protected void doBoolean(Object target, long index, Object value, Object receiver, WriteElementNode root) {
            Boolean bool = (Boolean)target;
            JSObject.setWithReceiver((JSDynamicObject)JSBoolean.create(root.context, this.getRealm(), bool), index, value, receiver, root.isStrict, this.classProfile, (Node)root);
        }

        @Specialization
        protected void doBoolean(Object target, Object index, Object value, Object receiver, WriteElementNode root, @Cached JSToPropertyKeyNode indexToPropertyKeyNode) {
            Boolean bool = (Boolean)target;
            JSObject.setWithReceiver((JSDynamicObject)JSBoolean.create(root.context, this.getRealm(), bool), indexToPropertyKeyNode.execute(index), value, receiver, root.isStrict, this.classProfile, (Node)root);
        }

        @Override
        public boolean guard(Object target) {
            return target instanceof Boolean;
        }
    }

    static abstract class NumberWriteElementTypeCacheNode
    extends ToPropertyKeyCachedWriteElementTypeCacheNode {
        private final Class<?> numberClass;

        NumberWriteElementTypeCacheNode(Class<?> numberClass) {
            this.numberClass = numberClass;
        }

        @Specialization
        protected void doNumber(Object target, long index, Object value, Object receiver, WriteElementNode root) {
            Number number = (Number)CompilerDirectives.castExact((Object)target, this.numberClass);
            JSObject.setWithReceiver((JSDynamicObject)JSNumber.create(root.context, this.getRealm(), number), index, value, receiver, root.isStrict, this.classProfile, (Node)root);
        }

        @Specialization
        protected void doNumber(Object target, Object index, Object value, Object receiver, WriteElementNode root, @Cached JSToPropertyKeyNode indexToPropertyKeyNode) {
            Number number = (Number)CompilerDirectives.castExact((Object)target, this.numberClass);
            JSObject.setWithReceiver((JSDynamicObject)JSNumber.create(root.context, this.getRealm(), number), indexToPropertyKeyNode.execute(index), value, receiver, root.isStrict, this.classProfile, (Node)root);
        }

        @Override
        public boolean guard(Object target) {
            return CompilerDirectives.isExact((Object)target, this.numberClass);
        }
    }

    static abstract class StringWriteElementTypeCacheNode
    extends ToPropertyKeyCachedWriteElementTypeCacheNode {
        StringWriteElementTypeCacheNode() {
        }

        @Specialization
        protected void doStringIntegerIndex(Object target, long index, Object value, Object receiver, WriteElementNode root, @Cached @Cached.Shared InlinedConditionProfile isImmutable) {
            TruffleString string = (TruffleString)target;
            if (isImmutable.profile((Node)this, index >= 0L && index < (long)Strings.length(string))) {
                if (root.isStrict) {
                    throw Errors.createTypeErrorNotWritableIndex(index, string, this);
                }
                return;
            }
            JSObject.setWithReceiver((JSDynamicObject)JSString.create(root.context, this.getRealm(), string), index, value, receiver, root.isStrict, this.classProfile, (Node)root);
        }

        @Specialization(replaces={"doStringIntegerIndex"})
        protected void doString(Object target, Object index, Object value, Object receiver, WriteElementNode root, @Cached @Cached.Shared InlinedConditionProfile isImmutable, @Cached @Cached.Exclusive InlinedConditionProfile isIndexProfile, @Cached(value="createNoToPropertyKey()") ToArrayIndexNode toArrayIndexNode, @Cached JSToPropertyKeyNode indexToPropertyKeyNode) {
            long longIndex;
            TruffleString string = (TruffleString)target;
            Object convertedIndex = toArrayIndexNode.execute(index);
            if (isIndexProfile.profile((Node)this, convertedIndex instanceof Long) && isImmutable.profile((Node)this, (longIndex = ((Long)convertedIndex).longValue()) >= 0L && longIndex < (long)Strings.length(string))) {
                if (root.isStrict) {
                    throw Errors.createTypeErrorNotWritableIndex(longIndex, string, this);
                }
                return;
            }
            JSObject.setWithReceiver((JSDynamicObject)JSString.create(root.context, this.getRealm(), string), indexToPropertyKeyNode.execute(index), value, receiver, root.isStrict, this.classProfile, (Node)root);
        }

        @Override
        public boolean guard(Object target) {
            return target instanceof TruffleString;
        }
    }

    private static abstract class ToPropertyKeyCachedWriteElementTypeCacheNode
    extends GuardedWriteElementTypeCacheNode {
        protected final JSClassProfile classProfile = JSClassProfile.create();

        ToPropertyKeyCachedWriteElementTypeCacheNode() {
        }
    }

    private static abstract class AbstractTypedArrayWriteElementCacheNode
    extends ArrayWriteElementCacheNode {
        @Node.Child
        protected InteropLibrary interop;

        AbstractTypedArrayWriteElementCacheNode(TypedArray arrayType) {
            this.interop = arrayType.isInterop() ? (InteropLibrary)InteropLibrary.getFactory().createDispatched(5) : InteropLibrary.getUncached();
        }
    }

    private static abstract class RecursiveCachedArrayWriteElementCacheNode
    extends ArrayWriteElementCacheNode {
        @Node.Child
        private ArrayWriteElementCacheDispatchNode recursiveWrite;

        RecursiveCachedArrayWriteElementCacheNode() {
        }

        protected final boolean setArrayAndWrite(ScriptArray newArray, JSDynamicObject target, long index, Object value, WriteElementNode root) {
            JSAbstractArray.arraySetArrayType(target, newArray);
            return this.executeRecursive(target, newArray, index, value, root);
        }

        protected static boolean nonHolesArrayNeedsSlowSet(JSDynamicObject target, AbstractWritableArray arrayType, long index, WriteElementNode root) {
            assert (!arrayType.isHolesType());
            return !root.writeOwn && !root.context.getArrayPrototypeNoElementsAssumption().isValid() && !arrayType.hasElement(target, index);
        }

        protected static boolean holesArrayNeedsSlowSet(JSDynamicObject target, AbstractWritableArray arrayType, long index, WriteElementNode root) {
            assert (arrayType.isHolesType());
            return (!root.writeOwn && !root.context.getArrayPrototypeNoElementsAssumption().isValid() || !root.context.getFastArrayAssumption().isValid() && JSSlowArray.isJSSlowArray(target) || !root.context.getFastArgumentsObjectAssumption().isValid() && JSSlowArgumentsArray.isJSSlowArgumentsObject(target)) && !arrayType.hasElement(target, index);
        }

        private boolean executeRecursive(JSDynamicObject targetObject, ScriptArray array, long index, Object value, WriteElementNode root) {
            if (this.recursiveWrite == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.recursiveWrite = (ArrayWriteElementCacheDispatchNode)this.insert(WriteElementNodeFactory.ArrayWriteElementCacheDispatchNodeGen.create());
            }
            return this.recursiveWrite.executeSetArray(null, targetObject, array, index, value, root);
        }
    }

    @GenerateInline
    @GenerateCached(value=true)
    @ImportStatic(value={WriteElementNode.class})
    static abstract class ArrayWriteElementCacheDispatchNode
    extends JavaScriptBaseNode {
        ArrayWriteElementCacheDispatchNode() {
        }

        protected abstract boolean executeSetArray(Node var1, JSDynamicObject var2, ScriptArray var3, long var4, Object var6, WriteElementNode var7);

        @Specialization(guards={"arrayType == cachedArrayType"}, limit="BOUNDED_BY_TYPES")
        protected static boolean doDispatch(JSDynamicObject target, ScriptArray arrayType, long index, Object value, WriteElementNode root, @Cached(value="arrayType") ScriptArray cachedArrayType, @Cached(value="makeHandler(target, cachedArrayType)") ArrayWriteElementCacheNode handler) {
            return handler.executeSetArray(target, cachedArrayType, index, value, root);
        }

        protected static ArrayWriteElementCacheNode makeHandler(JSDynamicObject target, ScriptArray arrayType) {
            return WriteElementNode.makeArrayCacheNode(target, arrayType);
        }
    }

    static abstract class ArrayWriteElementCacheNode
    extends JavaScriptBaseNode {
        ArrayWriteElementCacheNode() {
        }

        protected abstract boolean executeSetArray(JSDynamicObject var1, ScriptArray var2, long var3, Object var5, WriteElementNode var6);
    }

    static abstract class JSObjectWriteElementTypeCacheNode
    extends WriteElementTypeCacheNode {
        @Node.Child
        private IsArrayNode isArrayNode;
        @Node.Child
        private ToArrayIndexNode toArrayIndexNode;
        private final JSClassProfile jsclassProfile = JSClassProfile.create();
        @Node.Child
        private CachedSetPropertyNode setPropertyCachedNode;

        JSObjectWriteElementTypeCacheNode() {
            this.isArrayNode = IsArrayNode.createIsFastOrTypedArray();
        }

        @Specialization
        protected void doJSObjectIntegerIndex(Object target, long index, Object value, Object receiver, WriteElementNode root, @Cached @Cached.Shared InlinedConditionProfile arrayIf, @Cached @Cached.Shared InlinedConditionProfile intOrStringIndexIf, @Cached(inline=true) @Cached.Shared ArrayWriteElementCacheDispatchNode arrayDispatch) {
            JSDynamicObject targetObject = (JSDynamicObject)((Object)target);
            if (arrayIf.profile((Node)this, this.isArrayNode.execute((Object)targetObject))) {
                ScriptArray array = JSObject.getArray(targetObject);
                if (intOrStringIndexIf.profile((Node)this, JSRuntime.isArrayIndex(index))) {
                    if (!arrayDispatch.executeSetArray(this, targetObject, array, index, value, root)) {
                        this.setPropertyGenericEvaluatedIndex(targetObject, index, value, receiver, root);
                    }
                } else {
                    this.setPropertyGenericEvaluatedStringOrSymbol(targetObject, Strings.fromLong(index), value, receiver, root);
                }
            } else {
                this.setPropertyGeneric(targetObject, index, value, receiver, root);
            }
        }

        @Specialization
        protected void doJSObject(Object target, Object index, Object value, Object receiver, WriteElementNode root, @Cached @Cached.Shared InlinedConditionProfile arrayIf, @Cached @Cached.Shared InlinedConditionProfile intOrStringIndexIf, @Cached(inline=true) @Cached.Shared ArrayWriteElementCacheDispatchNode arrayDispatch) {
            JSDynamicObject targetObject = (JSDynamicObject)((Object)target);
            if (arrayIf.profile((Node)this, this.isArrayNode.execute((Object)targetObject))) {
                ScriptArray array = JSObject.getArray(targetObject);
                Object objIndex = this.toArrayIndex(index);
                if (intOrStringIndexIf.profile((Node)this, objIndex instanceof Long)) {
                    long longIndex = (Long)objIndex;
                    if (!arrayDispatch.executeSetArray(this, targetObject, array, longIndex, value, root)) {
                        this.setPropertyGenericEvaluatedIndex(targetObject, longIndex, value, receiver, root);
                    }
                } else {
                    this.setPropertyGenericEvaluatedStringOrSymbol(targetObject, objIndex, value, receiver, root);
                }
            } else {
                this.setPropertyGeneric(targetObject, index, value, receiver, root);
            }
        }

        private Object toArrayIndex(Object index) {
            ToArrayIndexNode toArrayIndex = this.toArrayIndexNode;
            if (toArrayIndex == null) {
                toArrayIndex = this.initToArrayIndexNode();
            }
            return toArrayIndex.execute(index);
        }

        private ToArrayIndexNode initToArrayIndexNode() {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toArrayIndexNode = (ToArrayIndexNode)this.insert(ToArrayIndexNode.create());
            return this.toArrayIndexNode;
        }

        private void setPropertyGenericEvaluatedIndex(JSDynamicObject targetObject, long index, Object value, Object receiver, WriteElementNode root) {
            JSObject.setWithReceiver(targetObject, index, value, receiver, root.isStrict, this.jsclassProfile, (Node)root);
        }

        private void setPropertyGenericEvaluatedStringOrSymbol(JSDynamicObject targetObject, Object key, Object value, Object receiver, WriteElementNode root) {
            JSObject.setWithReceiver(targetObject, key, value, receiver, root.isStrict, this.jsclassProfile, (Node)root);
        }

        private void setPropertyGeneric(JSDynamicObject targetObject, Object index, Object value, Object receiver, WriteElementNode root) {
            this.setCachedProperty(targetObject, index, value, receiver, root);
        }

        @HostCompilerDirectives.InliningCutoff
        private void setCachedProperty(JSDynamicObject targetObject, Object index, Object value, Object receiver, WriteElementNode root) {
            if (this.setPropertyCachedNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.setPropertyCachedNode = (CachedSetPropertyNode)this.insert(CachedSetPropertyNode.create(root.context, root.isStrict, root.writeOwn, root.isSuperProperty()));
            }
            this.setPropertyCachedNode.execute(targetObject, index, value, receiver);
        }
    }

    static abstract class GuardedWriteElementTypeCacheNode
    extends JavaScriptBaseNode {
        protected GuardedWriteElementTypeCacheNode() {
        }

        public abstract boolean guard(Object var1);

        protected abstract void executeWithTargetAndIndexUnguarded(Object var1, Object var2, Object var3, Object var4, WriteElementNode var5);
    }
}

