/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.builtin.visualizer.editable;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.List;
import javax.accessibility.Accessible;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.netbeans.modules.diff.builtin.visualizer.editable.Bundle;
import org.netbeans.modules.diff.builtin.visualizer.editable.DiffViewManager;
import org.netbeans.modules.diff.builtin.visualizer.editable.EditableDiffView;
import org.openide.awt.GraphicsUtils;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

class DiffSplitPaneDivider
extends BasicSplitPaneDivider
implements MouseMotionListener,
MouseListener,
Accessible {
    private final Icon insertAllIcon = ImageUtilities.loadIcon((String)"org/netbeans/modules/diff/builtin/visualizer/editable/move_all.png");
    private final Icon insertAllActiveIcon = ImageUtilities.loadIcon((String)"org/netbeans/modules/diff/builtin/visualizer/editable/move_all_active.png");
    private final int actionIconsHeight;
    private final int actionIconsWidth;
    private final Point POINT_ZERO;
    private final EditableDiffView master;
    private Point lastMousePosition = this.POINT_ZERO = new Point(0, 0);
    private DividerAction lastHotSpot = null;
    private List<DividerAction> hotspots = new ArrayList<DividerAction>(0);
    private DiffSplitDivider mydivider;
    private final Color fontColor;

    DiffSplitPaneDivider(BasicSplitPaneUI splitPaneUI, EditableDiffView master) {
        super(splitPaneUI);
        this.master = master;
        this.fontColor = new JLabel().getForeground();
        this.actionIconsHeight = this.insertAllIcon.getIconHeight();
        this.actionIconsWidth = this.insertAllIcon.getIconWidth();
        this.setBorder(null);
        this.setLayout(new BorderLayout());
        this.mydivider = new DiffSplitDivider();
        this.add(this.mydivider);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        DividerAction spot;
        if (!e.isPopupTrigger() && (spot = this.getHotspotAt(e.getPoint())) != null) {
            spot.actionPerformed(new ActionEvent(this, 1001, null));
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.lastMousePosition = this.POINT_ZERO;
        if (this.lastHotSpot != null) {
            this.mydivider.repaint(this.lastHotSpot.getRect());
        }
        this.lastHotSpot = null;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Point p;
        this.lastMousePosition = p = e.getPoint();
        DividerAction spot = this.getHotspotAt(p);
        if (this.lastHotSpot != spot) {
            this.mydivider.repaint(this.lastHotSpot == null ? spot.getRect() : this.lastHotSpot.getRect());
        }
        this.lastHotSpot = spot;
        this.setCursor(spot != null ? Cursor.getPredefinedCursor(12) : Cursor.getPredefinedCursor(11));
        if (spot != null) {
            ToolTipManager.sharedInstance().mouseMoved(new MouseEvent(this.mydivider, 0, 0L, 0, spot.getRect().x + 5, spot.getRect().y + 5, 0, false));
        } else {
            ToolTipManager.sharedInstance().mouseMoved(new MouseEvent(this.mydivider, 0, 0L, 0, 0, 0, 0, false));
            this.mydivider.repaint();
        }
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(BorderFactory.createEmptyBorder());
    }

    DiffSplitDivider getDivider() {
        return this.mydivider;
    }

    private DividerAction getHotspotAt(Point p) {
        for (DividerAction hotspot : this.hotspots) {
            if (!hotspot.getRect().contains(p)) continue;
            return hotspot;
        }
        return null;
    }

    private static abstract class DividerAction
    extends AbstractAction {
        private Rectangle rect;

        public DividerAction(String name, Rectangle rect) {
            super(name);
            this.rect = rect;
        }

        private Rectangle getRect() {
            return this.rect;
        }

        private void initRect(Rectangle rect) {
            this.rect = rect;
        }
    }

    private class DiffSplitDivider
    extends JPanel {
        private final DividerAction rollbackAction = new DividerAction(NbBundle.getMessage(DiffSplitDivider.class, (String)"TT_DiffPanel_MoveAll"), null){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiffSplitPaneDivider.this.master.rollback(null);
            }
        };
        private final DividerAction jumpToCurrentAction = new DividerAction(Bundle.TT_DiffPanel_JumpToCurrent(), null){

            @Override
            public void actionPerformed(ActionEvent e) {
                int diff = DiffSplitPaneDivider.this.master.getCurrentDifference();
                DiffSplitPaneDivider.this.master.setCurrentDifference(diff);
            }
        };

        public DiffSplitDivider() {
            this.setBackground(UIManager.getColor("SplitPane.background"));
            this.setOpaque(true);
            if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
                this.setBackground(UIManager.getColor("NbExplorerView.background"));
            }
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            Point p = event.getPoint();
            DividerAction spot = DiffSplitPaneDivider.this.getHotspotAt(p);
            return spot == null ? null : spot.getValue("Name").toString();
        }

        @Override
        protected void paintComponent(Graphics gr) {
            Graphics2D g = (Graphics2D)gr.create();
            Rectangle clip = g.getClipBounds();
            Stroke cs = g.getStroke();
            ArrayList<DividerAction> newActionIcons = new ArrayList<DividerAction>();
            g.setColor(this.getBackground());
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
            if (DiffSplitPaneDivider.this.master.getEditorPane1() == null) {
                g.dispose();
                return;
            }
            Rectangle rightView = DiffSplitPaneDivider.this.master.getEditorPane2().getScrollPane().getViewport().getViewRect();
            Rectangle leftView = DiffSplitPaneDivider.this.master.getEditorPane1().getScrollPane().getViewport().getViewRect();
            int editorsOffset = DiffSplitPaneDivider.this.master.getEditorPane2().getLocation().y + DiffSplitPaneDivider.this.master.getEditorPane2().getInsets().top;
            int rightOffset = -rightView.y + editorsOffset;
            int leftOffset = -leftView.y + editorsOffset;
            GraphicsUtils.configureDefaultRenderingHints((Graphics)g);
            int currDiff = DiffSplitPaneDivider.this.master.getCurrentDifference();
            String diffInfo = currDiff + 1 + "/" + DiffSplitPaneDivider.this.master.getDifferenceCount();
            int width = g.getFontMetrics().stringWidth(diffInfo);
            g.setColor(DiffSplitPaneDivider.this.fontColor);
            Rectangle hotSpot = new Rectangle((this.getWidth() - width) / 2, 0, width, g.getFontMetrics().getHeight());
            g.drawString(diffInfo, hotSpot.x, hotSpot.y + hotSpot.height);
            if (currDiff >= 0) {
                this.jumpToCurrentAction.initRect(hotSpot);
                newActionIcons.add(this.jumpToCurrentAction);
            }
            if (clip.y < editorsOffset) {
                g.setClip(clip.x, editorsOffset, clip.width, clip.height);
            }
            int rightY = this.getWidth() - 1;
            g.setColor(UIManager.getColor("controlShadow"));
            g.drawLine(0, clip.y, 0, clip.height);
            g.drawLine(rightY, clip.y, rightY, clip.height);
            int curDif = DiffSplitPaneDivider.this.master.getCurrentDifference();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            DiffViewManager.DecoratedDifference[] decoratedDiffs = DiffSplitPaneDivider.this.master.getManager().getDecorations();
            int idx = 0;
            boolean everythingEditable = true;
            for (DiffViewManager.DecoratedDifference dd : decoratedDiffs) {
                everythingEditable &= dd.canRollback();
                g.setColor(DiffSplitPaneDivider.this.master.getColor(dd.getDiff()));
                g.setStroke(curDif == idx++ ? DiffSplitPaneDivider.this.master.getBoldStroke() : cs);
                if (dd.getBottomLeft() == -1) {
                    this.paintMatcher(g, DiffSplitPaneDivider.this.master.getColor(dd.getDiff()), 0, rightY, dd.getTopLeft() + leftOffset, dd.getTopRight() + rightOffset, dd.getBottomRight() + rightOffset, dd.getTopLeft() + leftOffset);
                    continue;
                }
                if (dd.getBottomRight() == -1) {
                    this.paintMatcher(g, DiffSplitPaneDivider.this.master.getColor(dd.getDiff()), 0, rightY, dd.getTopLeft() + leftOffset, dd.getTopRight() + rightOffset, dd.getTopRight() + rightOffset, dd.getBottomLeft() + leftOffset);
                    continue;
                }
                this.paintMatcher(g, DiffSplitPaneDivider.this.master.getColor(dd.getDiff()), 0, rightY, dd.getTopLeft() + leftOffset, dd.getTopRight() + rightOffset, dd.getBottomRight() + rightOffset, dd.getBottomLeft() + leftOffset);
            }
            if (DiffSplitPaneDivider.this.master.isActionsEnabled() && everythingEditable) {
                hotSpot = new Rectangle((this.getWidth() - DiffSplitPaneDivider.this.actionIconsWidth) / 2, editorsOffset, DiffSplitPaneDivider.this.actionIconsWidth, DiffSplitPaneDivider.this.actionIconsHeight);
                if (hotSpot.contains(DiffSplitPaneDivider.this.lastMousePosition)) {
                    DiffSplitPaneDivider.this.insertAllActiveIcon.paintIcon(null, g, hotSpot.x, hotSpot.y);
                } else {
                    DiffSplitPaneDivider.this.insertAllIcon.paintIcon(null, g, hotSpot.x, hotSpot.y);
                }
                this.rollbackAction.initRect(hotSpot);
                newActionIcons.add(this.rollbackAction);
            }
            DiffSplitPaneDivider.this.hotspots = newActionIcons;
            g.dispose();
        }

        private void paintMatcher(Graphics2D g, Color fillClr, int leftX, int rightX, int upL, int upR, int doR, int doL) {
            int bottomY;
            int topY = Math.min(upL, upR);
            if (!g.hitClip(leftX, topY, rightX - leftX, (bottomY = Math.max(doL, doR)) - topY)) {
                return;
            }
            CubicCurve2D.Float upper = new CubicCurve2D.Float(leftX, upL, (float)(rightX - leftX) * 0.3f, upL, (float)(rightX - leftX) * 0.7f, upR, rightX, upR);
            CubicCurve2D.Float bottom = new CubicCurve2D.Float(rightX, doR, (float)(rightX - leftX) * 0.7f, doR, (float)(rightX - leftX) * 0.3f, doL, leftX, doL);
            GeneralPath path = new GeneralPath();
            path.append(upper, false);
            path.append(bottom, true);
            path.closePath();
            g.setColor(fillClr);
            g.fill(path);
            g.setColor(DiffSplitPaneDivider.this.master.getColorLines());
            g.draw(upper);
            g.draw(bottom);
        }
    }
}

