/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.nodes;

import java.awt.Component;
import java.awt.Image;
import java.io.File;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.swing.Action;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.javaee.wildfly.WildflyDeploymentManager;
import org.netbeans.modules.javaee.wildfly.customizer.Customizer;
import org.netbeans.modules.javaee.wildfly.customizer.CustomizerDataSupport;
import org.netbeans.modules.javaee.wildfly.ide.WildflyJ2eePlatformFactory;
import org.netbeans.modules.javaee.wildfly.nodes.actions.KillServerAction;
import org.netbeans.modules.javaee.wildfly.nodes.actions.OpenServerLogAction;
import org.netbeans.modules.javaee.wildfly.nodes.actions.ShowAdminToolAction;
import org.netbeans.modules.javaee.wildfly.nodes.actions.WildflyEditConfigAction;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class WildflyManagerNode
extends AbstractNode
implements Node.Cookie {
    private final Lookup lookup;
    private final boolean isWidlfy;
    private static final String ADMIN_URL_WILDFLY = "/console";
    private static final String HTTP_HEADER = "http://";

    public WildflyManagerNode(Children children, Lookup lookup) {
        super(children);
        this.lookup = lookup;
        this.isWidlfy = this.getDeploymentManager().getProperties().isWildfly();
        this.getCookieSet().add((Node.Cookie)this);
        this.getCookieSet().add((Node.Cookie)new EditCookieImpl(this.getDeploymentManager().getProperties().getServerProfile()));
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("j2eeplugins_property_sheet_server_node_jboss");
    }

    public boolean hasCustomizer() {
        return true;
    }

    public Component getCustomizer() {
        CustomizerDataSupport dataSup = new CustomizerDataSupport(this.getDeploymentManager().getProperties());
        return new Customizer((DeploymentManager)this.getDeploymentManager(), dataSup, new WildflyJ2eePlatformFactory().getJ2eePlatformImpl((DeploymentManager)this.getDeploymentManager()));
    }

    public String getAdminURL() {
        return HTTP_HEADER + this.getDeploymentManager().getHost() + ":" + this.getDeploymentManager().getPort() + ADMIN_URL_WILDFLY;
    }

    public Action[] getActions(boolean context) {
        Action[] newActions = new Action[]{null, SystemAction.get(ShowAdminToolAction.class), SystemAction.get(WildflyEditConfigAction.class), SystemAction.get(OpenServerLogAction.class), SystemAction.get(KillServerAction.class)};
        return newActions;
    }

    public Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set properties = sheet.get("properties");
        if (properties == null) {
            properties = Sheet.createPropertiesSet();
            sheet.put(properties);
        }
        final InstanceProperties ip = this.getDeploymentManager().getInstanceProperties();
        Object property = new PropertySupport.ReadWrite(NbBundle.getMessage(WildflyManagerNode.class, (String)"LBL_DISPLAY_NAME"), String.class, NbBundle.getMessage(WildflyManagerNode.class, (String)"LBL_DISPLAY_NAME"), NbBundle.getMessage(WildflyManagerNode.class, (String)"HINT_DISPLAY_NAME")){

            public Object getValue() {
                return ip.getProperty("displayName");
            }

            public void setValue(Object val) {
                ip.setProperty("displayName", (String)val);
            }
        };
        properties.put((Node.Property)property);
        property = new PropertySupport.ReadOnly(NbBundle.getMessage(WildflyManagerNode.class, (String)"LBL_SERVER_NAME"), String.class, NbBundle.getMessage(WildflyManagerNode.class, (String)"LBL_SERVER_NAME"), NbBundle.getMessage(WildflyManagerNode.class, (String)"HINT_SERVER_NAME")){

            public Object getValue() {
                return ip.getProperty("server");
            }
        };
        properties.put((Node.Property)property);
        property = new PropertySupport.ReadOnly(NbBundle.getMessage(WildflyManagerNode.class, (String)"LBL_SERVER_PATH"), String.class, NbBundle.getMessage(WildflyManagerNode.class, (String)"LBL_SERVER_PATH"), NbBundle.getMessage(WildflyManagerNode.class, (String)"HINT_SERVER_PATH")){

            public Object getValue() {
                return ip.getProperty("server-dir");
            }
        };
        properties.put((Node.Property)property);
        property = new PropertySupport.ReadOnly(NbBundle.getMessage(WildflyManagerNode.class, (String)"LBL_HOST"), String.class, NbBundle.getMessage(WildflyManagerNode.class, (String)"LBL_HOST"), NbBundle.getMessage(WildflyManagerNode.class, (String)"HINT_HOST")){

            public Object getValue() {
                return ip.getProperty("host");
            }
        };
        properties.put((Node.Property)property);
        property = new PropertySupport.ReadOnly(NbBundle.getMessage(WildflyManagerNode.class, (String)"LBL_PORT"), Integer.TYPE, NbBundle.getMessage(WildflyManagerNode.class, (String)"LBL_PORT"), NbBundle.getMessage(WildflyManagerNode.class, (String)"HINT_PORT")){

            public Object getValue() {
                return Integer.parseInt(ip.getProperty("port"));
            }
        };
        properties.put((Node.Property)property);
        property = new PropertySupport.ReadOnly(NbBundle.getMessage(WildflyManagerNode.class, (String)"LBL_PORT_OFFSET"), Integer.TYPE, NbBundle.getMessage(WildflyManagerNode.class, (String)"LBL_PORT_OFFSET"), NbBundle.getMessage(WildflyManagerNode.class, (String)"HINT_PORT_OFFSET")){

            public Object getValue() {
                return Integer.parseInt(ip.getProperty("port-offset"));
            }
        };
        properties.put((Node.Property)property);
        return sheet;
    }

    public Image getIcon(int type) {
        if (type == 1) {
            if (this.isWidlfy) {
                return ImageUtilities.loadImage((String)"org/netbeans/modules/javaee/wildfly/resources/wildfly.png");
            }
            return ImageUtilities.loadImage((String)"org/netbeans/modules/javaee/wildfly/resources/eap.gif");
        }
        return super.getIcon(type);
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public String getShortDescription() {
        InstanceProperties ip = InstanceProperties.getInstanceProperties((String)this.getDeploymentManager().getUrl());
        String host = ip.getProperty("host");
        int port = this.getHttpPort(ip);
        return HTTP_HEADER + host + ":" + port + "/";
    }

    private int getHttpPort(InstanceProperties ip) {
        String httpPort = ip.getProperty("port");
        String offSet = ip.getProperty("port-offset");
        int port = Integer.parseInt(httpPort);
        if (offSet != null) {
            port += Integer.parseInt(offSet);
        }
        return port;
    }

    public final WildflyDeploymentManager getDeploymentManager() {
        return (WildflyDeploymentManager)this.lookup.lookup(WildflyDeploymentManager.class);
    }

    public static class EditCookieImpl
    implements EditCookie {
        private final String configFile;

        private EditCookieImpl(String configFile) {
            this.configFile = configFile;
        }

        public void edit() {
            FileObject fo = FileUtil.toFileObject((File)new File(this.configFile));
            try {
                ((OpenCookie)DataObject.find((FileObject)fo).getLookup().lookup(OpenCookie.class)).open();
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

