/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.flexible.standard.nodes.intervalfn;

import java.util.Locale;
import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queries.intervals.Intervals;
import org.apache.lucene.queries.intervals.IntervalsSource;
import org.apache.lucene.queryparser.flexible.standard.nodes.intervalfn.IntervalFunction;

public class NotWithin
extends IntervalFunction {
    private final int positions;
    private final IntervalFunction minuend;
    private final IntervalFunction subtrahend;

    public NotWithin(IntervalFunction minuend, int positions, IntervalFunction subtrahend) {
        this.positions = positions;
        this.minuend = Objects.requireNonNull(minuend);
        this.subtrahend = Objects.requireNonNull(subtrahend);
    }

    @Override
    public IntervalsSource toIntervalSource(String field, Analyzer analyzer) {
        return Intervals.notWithin((IntervalsSource)this.minuend.toIntervalSource(field, analyzer), (int)this.positions, (IntervalsSource)this.subtrahend.toIntervalSource(field, analyzer));
    }

    @Override
    public String toString() {
        return String.format(Locale.ROOT, "fn:notWithin(%s %d %s)", this.minuend, this.positions, this.subtrahend);
    }
}

