/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.common;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.UIResource;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.apisupport.project.api.UIUtil;
import org.netbeans.modules.apisupport.project.spi.LayerUtil;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.ui.wizard.common.Bundle;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbCollections;
import org.openide.util.Utilities;

public class WizardUtils {
    private static final String SFS_VALID_PATH_RE = "(\\p{Alnum}|\\/|_)+";
    public static final String EMPTY_VALUE = Bundle.LBL_Empty();

    public static String keyToLogicalString(KeyStroke keyStroke) {
        String keyDesc = Utilities.keyToString((KeyStroke)keyStroke);
        int dash = keyDesc.indexOf(45);
        return dash == -1 ? keyDesc : keyDesc.substring(0, dash).replace('C', 'D').replace('A', 'O') + keyDesc.substring(dash);
    }

    public static String keyStrokeToString(KeyStroke keyStroke) {
        int modifiers = keyStroke.getModifiers();
        StringBuffer sb = new StringBuffer();
        if ((modifiers & 0x80) > 0) {
            sb.append("Ctrl+");
        }
        if ((modifiers & 0x200) > 0) {
            sb.append("Alt+");
        }
        if ((modifiers & 0x40) > 0) {
            sb.append("Shift+");
        }
        if ((modifiers & 0x100) > 0) {
            sb.append("Meta+");
        }
        if (keyStroke.getKeyCode() != 16 && keyStroke.getKeyCode() != 17 && keyStroke.getKeyCode() != 157 && keyStroke.getKeyCode() != 18 && keyStroke.getKeyCode() != 65406) {
            sb.append(Utilities.keyToString((KeyStroke)KeyStroke.getKeyStroke(keyStroke.getKeyCode(), 0)));
        }
        return sb.toString();
    }

    public static KeyStroke stringToKeyStroke(String keyStroke) {
        KeyStroke ks;
        int modifiers = 0;
        if (keyStroke.startsWith("Ctrl+")) {
            modifiers |= 0x80;
            keyStroke = keyStroke.substring(5);
        }
        if (keyStroke.startsWith("Alt+")) {
            modifiers |= 0x200;
            keyStroke = keyStroke.substring(4);
        }
        if (keyStroke.startsWith("Shift+")) {
            modifiers |= 0x40;
            keyStroke = keyStroke.substring(6);
        }
        if (keyStroke.startsWith("Meta+")) {
            modifiers |= 0x100;
            keyStroke = keyStroke.substring(5);
        }
        if ((ks = Utilities.stringToKey((String)keyStroke)) == null) {
            return null;
        }
        KeyStroke result = KeyStroke.getKeyStroke(ks.getKeyCode(), modifiers);
        return result;
    }

    public static KeyStroke[] stringToKeyStrokes(String keyStrokes) {
        String delim = " ";
        if (keyStrokes.length() == 0) {
            return new KeyStroke[0];
        }
        StringTokenizer st = new StringTokenizer(keyStrokes, delim);
        ArrayList<KeyStroke> result = new ArrayList<KeyStroke>();
        while (st.hasMoreTokens()) {
            String ks = st.nextToken().trim();
            KeyStroke keyStroke = WizardUtils.stringToKeyStroke(ks);
            if (keyStroke == null) {
                return null;
            }
            result.add(keyStroke);
        }
        return result.toArray(new KeyStroke[0]);
    }

    public static String keyStrokesToString(KeyStroke[] keyStrokes) {
        StringBuffer sb = new StringBuffer(WizardUtils.keyStrokeToString(keyStrokes[0]));
        int k = keyStrokes.length;
        for (int i = 1; i < k; ++i) {
            sb.append(' ').append(WizardUtils.keyStrokeToString(keyStrokes[i]));
        }
        String newShortcut = sb.toString();
        return newShortcut;
    }

    public static String keyStrokesToLogicalString(KeyStroke[] keyStrokes) {
        StringBuffer sb = new StringBuffer(WizardUtils.keyToLogicalString(keyStrokes[0]));
        int k = keyStrokes.length;
        for (int i = 1; i < k; ++i) {
            sb.append(' ').append(WizardUtils.keyToLogicalString(keyStrokes[i]));
        }
        String newShortcut = sb.toString();
        return newShortcut;
    }

    public static String getIconDimensionWarning(File icon, int expectedWidth, int expectedHeight) {
        Dimension real = new Dimension(WizardUtils.getIconDimension(icon));
        if (real.height == expectedHeight && real.width == expectedWidth) {
            return "";
        }
        return Bundle.MSG_WrongIconSize(real.width, real.height, expectedWidth, expectedHeight);
    }

    public static String getIconAlreadyExistsWarning(String filename) {
        return Bundle.MSG_IconAlreadyExists(filename);
    }

    public static String getNoIconSelectedWarning(int expectedWidth, int expectedHeight) {
        return Bundle.MSG_NoIconSelected(expectedWidth, expectedHeight);
    }

    public static boolean isValidIcon(File icon, int expectedWidth, int expectedHeight) {
        Dimension iconDimension = WizardUtils.getIconDimension(icon);
        return (double)expectedWidth == iconDimension.getWidth() && (double)expectedHeight == iconDimension.getHeight();
    }

    public static Dimension getIconDimension(File icon) {
        try {
            ImageIcon imc = new ImageIcon(Utilities.toURI((File)icon).toURL());
            return new Dimension(imc.getIconWidth(), imc.getIconHeight());
        }
        catch (MalformedURLException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
            return new Dimension(-1, -1);
        }
    }

    public static JFileChooser getIconFileChooser(String oldValue) {
        File fil;
        JFileChooser chooser = UIUtil.getIconFileChooser();
        String iconText = oldValue.trim();
        if (iconText.length() > 0 && (fil = new File(iconText)).exists()) {
            chooser.setSelectedFile(fil);
        }
        return chooser;
    }

    public static JComboBox createPackageComboBox(SourceGroup srcRoot) {
        JComboBox<String> packagesComboBox;
        if (srcRoot != null) {
            packagesComboBox = new JComboBox(PackageView.createListView((SourceGroup)srcRoot));
            packagesComboBox.setRenderer(PackageView.listRenderer());
        } else {
            packagesComboBox = new JComboBox<String>();
            packagesComboBox.addItem(Bundle.MSG_Missing_Source_Root());
            packagesComboBox.setEnabled(false);
        }
        return packagesComboBox;
    }

    public static boolean isValidPackageName(String str) {
        if (str.length() > 0 && str.charAt(0) == '.') {
            return false;
        }
        StringTokenizer tukac = new StringTokenizer(str, ".");
        while (tukac.hasMoreTokens()) {
            String token = tukac.nextToken();
            if ("".equals(token)) {
                return false;
            }
            if (Utilities.isJavaIdentifier((String)token)) continue;
            return false;
        }
        return true;
    }

    public static String generateTextAreaContent(String[] relPaths) {
        StringBuffer sb = new StringBuffer();
        if (relPaths.length > 0) {
            for (int i = 0; i < relPaths.length; ++i) {
                if (i > 0) {
                    sb.append('\n');
                }
                sb.append(relPaths[i]);
            }
        }
        return sb.toString();
    }

    public static boolean isValidSFSPath(String path) {
        return path.matches(SFS_VALID_PATH_RE);
    }

    public static ComboBoxModel createLayerPresenterComboModel(Project project, String sfsRoot) {
        return WizardUtils.createLayerPresenterComboModel(project, sfsRoot, Collections.emptyMap());
    }

    public static ComboBoxModel createLayerPresenterComboModel(Project project, String sfsRoot, Map<String, Object> excludeAttrs) {
        DefaultComboBoxModel<LayerItemPresenter> model = new DefaultComboBoxModel<LayerItemPresenter>();
        try {
            FileSystem sfs = ((NbModuleProvider)project.getLookup().lookup(NbModuleProvider.class)).getEffectiveSystemFilesystem();
            FileObject root = sfs.getRoot().getFileObject(sfsRoot);
            if (root != null) {
                TreeSet<LayerItemPresenter> presenters = new TreeSet<LayerItemPresenter>();
                for (FileObject subFolder : WizardUtils.getFolders(root, excludeAttrs)) {
                    presenters.add(new LayerItemPresenter(subFolder, root));
                }
                for (LayerItemPresenter presenter : presenters) {
                    model.addElement(presenter);
                }
            }
        }
        catch (IOException exc) {
            Logger.getLogger(UIUtil.class.getName()).log(Level.INFO, "Failed to create model of " + sfsRoot, exc);
        }
        return model;
    }

    public static String getSFSPath(JComboBox lpCombo, String supposedRoot) {
        String editorItemS;
        Object editorItem = lpCombo.getEditor().getItem();
        String path = null;
        if (editorItem instanceof LayerItemPresenter) {
            path = ((LayerItemPresenter)editorItem).getFullPath();
        } else if (editorItem instanceof String && (editorItemS = ((String)editorItem).trim()).length() > 0 && (path = WizardUtils.searchLIPCategoryCombo(lpCombo, editorItemS)) == null) {
            path = editorItemS.startsWith(supposedRoot) ? editorItemS : supposedRoot + '/' + editorItemS;
        }
        return path;
    }

    public static ListCellRenderer createProjectRenderer() {
        return new ProjectRenderer();
    }

    private static String searchLIPCategoryCombo(JComboBox lpCombo, String displayName) {
        String path = null;
        for (int i = 0; i < lpCombo.getItemCount(); ++i) {
            LayerItemPresenter presenter;
            Object item = lpCombo.getItemAt(i);
            if (!(item instanceof LayerItemPresenter) || !displayName.equals((presenter = (LayerItemPresenter)lpCombo.getItemAt(i)).getDisplayName())) continue;
            path = presenter.getFullPath();
            break;
        }
        return path;
    }

    private static Collection<FileObject> getFolders(FileObject root, Map<String, Object> excludeAttrs) {
        HashSet<FileObject> folders = new HashSet<FileObject>();
        block0: for (FileObject subFolder : NbCollections.iterable((Enumeration)root.getFolders(false))) {
            for (Map.Entry<String, Object> entry : excludeAttrs.entrySet()) {
                if (!entry.getValue().equals(subFolder.getAttribute(entry.getKey()))) continue;
                continue block0;
            }
            folders.add(subFolder);
            folders.addAll(WizardUtils.getFolders(subFolder, excludeAttrs));
        }
        return folders;
    }

    public static ComboBoxModel createComboEmptyModel() {
        return new DefaultComboBoxModel<Object>(new Object[]{EMPTY_VALUE});
    }

    private WizardUtils() {
    }

    public static class LayerItemPresenter
    implements Comparable<LayerItemPresenter> {
        private String displayName;
        private final FileObject item;
        private final FileObject root;
        private final boolean contentType;
        private static Logger LOGGER = Logger.getLogger(LayerItemPresenter.class.getName());

        public LayerItemPresenter(FileObject item, FileObject root, boolean contentType) {
            this.item = item;
            this.root = root;
            this.contentType = contentType;
        }

        public LayerItemPresenter(FileObject item, FileObject root) {
            this(item, root, false);
        }

        public FileObject getFileObject() {
            return this.item;
        }

        public String getFullPath() {
            return this.item.getPath();
        }

        public String getDisplayName() {
            if (this.displayName == null) {
                this.displayName = this.computeDisplayName();
                LOGGER.log(Level.FINE, "Computed display name '" + this.displayName + "'");
            }
            return this.displayName;
        }

        public String toString() {
            return this.getDisplayName();
        }

        @Override
        public int compareTo(LayerItemPresenter o) {
            int res = Collator.getInstance().compare(this.getDisplayName(), o.getDisplayName());
            if (res != 0) {
                return res;
            }
            return this.getFullPath().compareTo(o.getFullPath());
        }

        private String computeDisplayName() {
            FileObject displayItem = this.contentType ? this.item.getParent() : this.item;
            String displaySeparator = this.contentType ? "/" : " | ";
            Stack<String> s = new Stack<String>();
            s.push(LayerUtil.getAnnotatedName((FileObject)displayItem));
            FileObject parent = displayItem.getParent();
            while (!this.root.getPath().equals(parent.getPath())) {
                s.push(LayerUtil.getAnnotatedName((FileObject)parent));
                parent = parent.getParent();
            }
            StringBuffer sb = new StringBuffer();
            sb.append((String)s.pop());
            while (!s.empty()) {
                sb.append(displaySeparator).append((String)s.pop());
            }
            return sb.toString();
        }
    }

    private static class ProjectRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public ProjectRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            String text = null;
            if (!(value instanceof Project)) {
                text = value.toString();
            } else {
                ProjectInformation pi = ProjectUtils.getInformation((Project)((Project)value));
                text = pi.getDisplayName();
                this.setIcon(pi.getIcon());
            }
            this.setText(text);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }
}

