/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.hints.rules;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ExpressionTree;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.websvc.editor.hints.common.ProblemContext;
import org.netbeans.modules.websvc.editor.hints.common.Utilities;
import org.netbeans.modules.websvc.editor.hints.fixes.RemoveAnnotationArgument;
import org.netbeans.modules.websvc.editor.hints.rules.AbstractWebServiceRule;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class InterfaceEndpointInterface
extends AbstractWebServiceRule {
    @Override
    public ErrorDescription[] apply(TypeElement subject, ProblemContext ctx) {
        if (subject.getKind() == ElementKind.INTERFACE) {
            AnnotationMirror annEntity = Utilities.findAnnotation(subject, "javax.jws.WebService");
            AnnotationTree annotationTree = (AnnotationTree)ctx.getCompilationInfo().getTrees().getTree(subject, annEntity);
            if (Utilities.getAnnotationAttrValue(annEntity, "endpointInterface") != null) {
                String label = NbBundle.getMessage(InterfaceEndpointInterface.class, (String)"MSG_IF_SEINotAllowed");
                RemoveAnnotationArgument fix = new RemoveAnnotationArgument(ctx.getFileObject(), subject, annEntity, "endpointInterface");
                ExpressionTree problemTree = Utilities.getAnnotationArgumentTree(annotationTree, "endpointInterface");
                ctx.setElementToAnnotate(problemTree);
                ErrorDescription problem = InterfaceEndpointInterface.createProblem((Element)subject, ctx, label, fix);
                ctx.setElementToAnnotate(null);
                return new ErrorDescription[]{problem};
            }
        }
        return null;
    }
}

